/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.bo.StaffSelectAddBO;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStaffPo;
import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCacheServiceRpc;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.po.CouponQuotaDetailPO;
import com.bizvane.couponfacade.models.po.CouponQuotaDetailPOExample;
import com.bizvane.couponfacade.models.po.CouponQuotaPO;
import com.bizvane.couponfacade.models.po.CouponQuotaPOExample;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDifferentBrandReqVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDifferentBrandRespVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDifferentBrandSaveVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDifferentBrandUpdateReqVO;
import com.bizvane.couponfacade.models.vo.CouponQuoteDifferentBrandDetailRespVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponfacade.models.vo.StaffCouponQuotaDifferentBrandDetailReqVO;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.utils.ExportExcelUtil;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.common.utils.ResponseUtil;
import com.bizvane.couponservice.common.utils.StreamingExportExcelUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.mappers.CouponQuotaDetailPOMapper;
import com.bizvane.couponservice.mappers.CouponQuotaPOMapper;
import com.bizvane.couponservice.rpc.CenterStageStaffRpc;
import com.bizvane.couponservice.service.CouponDifindustryService;
import com.bizvane.couponservice.service.CouponQuotaDifferentBrandService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Service
public class CouponQuotaDifferentBrandServiceImpl
implements CouponQuotaDifferentBrandService {
    private static final Logger log = LoggerFactory.getLogger(CouponQuotaDifferentBrandServiceImpl.class);
    @Autowired
    private SysCacheServiceRpc sysCacheServiceRpc;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPoMapper;
    @Autowired
    private CouponQuotaPOMapper couponQuotaPOMapper;
    @Autowired
    private CouponManualPOMapper couponManualPOMapper;
    @Autowired
    private CouponQuotaDetailPOMapper couponQuotaDetailPoMapper;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CenterStageStaffRpc centerStageStaffRpc;
    @Autowired
    private CouponDifindustryService couponDifindustryService;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Long> saveOrUpdate(CouponQuotaDifferentBrandSaveVO po, SysAccountPo accountPo) {
        log.info("enter CouponQuotaDifferentBrandService add method {}", (Object)JSONObject.toJSONString((Object)po));
        Long sysCompanyId = po.getSysCompanyId();
        Long sysBrandId = po.getSysBrandId();
        Long couponQuotaId = po.getCouponQuotaId();
        Long couponDefinitionId = po.getCouponDefinitionId();
        Long couponManualId = po.getCouponManualId();
        Integer memberAverage = po.getMemberAverage();
        this.dealGuide(po);
        List sysStaffIdList = po.getSysStaffIds();
        ResponseData listResponseData = this.staffServiceRpc.getByStaffIds(sysStaffIdList, sysCompanyId);
        log.info("listResponseData: {}", (Object)JacksonUtil.bean2Json((Object)listResponseData));
        List staffVoList = null;
        if (listResponseData == null || listResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || !CollectionUtils.isNotEmpty((Collection)((Collection)listResponseData.getData()))) {
            return ResponseUtil.error((String)"\u9009\u62e9\u5bfc\u8d2d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        staffVoList = (List)listResponseData.getData();
        String collect = staffVoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getStaffCode())).map(SysStaffPo::getStaffCode).collect(Collectors.joining(","));
        ResponseData getStoreNamesMap = this.staffServiceRpc.getStoreNamesByStaffCodes(collect, accountPo.getSysCompanyId());
        log.info("getStoreNamesMap: {}", (Object)JacksonUtil.bean2Json((Object)getStoreNamesMap));
        if (getStoreNamesMap == null) {
            log.info("staffServiceRpc#getStoreNamesByStaffCodes response is null");
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u67e5\u8be2\u5458\u5de5\u6240\u5c5e\u5e97\u94fa\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (getStoreNamesMap.getCode() != SysResponseEnum.SUCCESS.getCode() || getStoreNamesMap.getData() == null) {
            log.info("staffServiceRpc#getStoreNamesByStaffCodes response:{}", (Object)JSONObject.toJSONString((Object)getStoreNamesMap));
            return new ResponseData(getStoreNamesMap.getCode(), getStoreNamesMap.getMessage());
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPoWithBlobs = this.couponDefinitionPoMapper.selectByPrimaryKey(couponDefinitionId);
        log.info("save couponDefinitionPoWithBlobs: {}", (Object)JacksonUtil.bean2Json((Object)couponDefinitionPoWithBlobs));
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(couponManualId);
        log.info("couponManualPO: {}", (Object)JacksonUtil.bean2Json((Object)couponManualPO));
        Integer remainNum = couponManualPO.getMemberCount() - couponManualPO.getSuccessCount();
        Integer memberCount = staffVoList.size();
        Integer totalNum = memberCount * memberAverage;
        if (remainNum < totalNum) {
            return ResponseUtil.error((String)"\u5f02\u4e1a\u5238\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
        }
        if (po.getGetCouponSwitch() == null) {
            po.setGetCouponSwitch(Boolean.valueOf(true));
        }
        if (Boolean.FALSE.equals(po.getGetCouponSwitch())) {
            po.setGetCouponDayCount(null);
        }
        po.setSysCompanyId(accountPo.getSysCompanyId());
        po.setSysBrandId(accountPo.getBrandId());
        po.setCouponBrandId(couponManualPO.getSysBrandId());
        po.setBatchNo(couponManualPO.getBatchNum());
        po.setCreateUserId(accountPo.getSysAccountId());
        po.setCreateUserName(accountPo.getName());
        po.setCreateDate(TimeUtils.getNowTime());
        po.setState(Boolean.valueOf(true));
        po.setValid(Boolean.valueOf(true));
        po.setSendCount(Integer.valueOf(0));
        po.setQuotaType(Integer.valueOf(1));
        po.setCouponName(couponDefinitionPoWithBlobs.getCouponName());
        po.setMemberCount(memberCount);
        po.setTotalNumber(Integer.valueOf(po.getMemberCount() * po.getMemberAverage()));
        HashMap<String, Integer> zhangshuMap = new HashMap<String, Integer>();
        ResponseData responseData = new ResponseData();
        if (couponQuotaId != null) {
            this.couponQuotaPOMapper.updateByPrimaryKeySelective((CouponQuotaPO)po);
            CouponQuotaDetailPOExample quotaDetailPOExample = new CouponQuotaDetailPOExample();
            quotaDetailPOExample.createCriteria().andCouponQuotaIdEqualTo(po.getCouponQuotaId());
            List existCouponQuotaDetailList = this.couponQuotaDetailPoMapper.selectByExample(quotaDetailPOExample);
            log.info("existCouponQuotaDetailList: {}", (Object)JacksonUtil.list2Json((List)existCouponQuotaDetailList));
            Iterator iterator = existCouponQuotaDetailList.iterator();
            while (iterator.hasNext()) {
                CouponQuotaDetailPO couponQuotaDetailPO = (CouponQuotaDetailPO)iterator.next();
                Integer totalNumber = couponQuotaDetailPO.getTotalNumber();
                Integer unuseNumber = couponQuotaDetailPO.getUnuseNumber();
                Integer useNumber = totalNumber - unuseNumber;
                zhangshuMap.put(couponQuotaDetailPO.getStaffCode(), useNumber);
            }
            CouponQuotaDetailPOExample example = new CouponQuotaDetailPOExample();
            example.createCriteria().andCouponQuotaIdEqualTo(po.getCouponQuotaId());
            this.couponQuotaDetailPoMapper.deleteByExample(example);
        } else {
            this.couponQuotaPOMapper.insertSelective((CouponQuotaPO)po);
        }
        ArrayList couponQuotaDetailPOList = Lists.newArrayList();
        for (StaffVo staffVo2 : staffVoList) {
            CouponQuotaDetailPO couponQuotaDetailPo = this.getCouponQuotaDetailPO(po, accountPo, couponDefinitionPoWithBlobs);
            couponQuotaDetailPo.setStaffCode(staffVo2.getStaffCode());
            couponQuotaDetailPo.setStaffName(staffVo2.getStaffName());
            couponQuotaDetailPo.setSysStaffId(staffVo2.getSysStaffId());
            couponQuotaDetailPo.setStoreName((String)((Map)getStoreNamesMap.getData()).get(staffVo2.getStaffCode()));
            if (zhangshuMap.get(staffVo2.getStaffCode()) != null) {
                Integer zhangshu = po.getMemberAverage() - (Integer)zhangshuMap.get(staffVo2.getStaffCode());
                if (zhangshu > 0) {
                    couponQuotaDetailPo.setUnuseNumber(zhangshu);
                } else {
                    couponQuotaDetailPo.setUnuseNumber(Integer.valueOf(0));
                }
            } else {
                couponQuotaDetailPo.setUnuseNumber(po.getMemberAverage());
            }
            couponQuotaDetailPOList.add(couponQuotaDetailPo);
        }
        this.couponQuotaDetailPoMapper.batchInsert((List)couponQuotaDetailPOList);
        CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
        couponDefinitionVO.setSysCompanyId(sysCompanyId);
        couponDefinitionVO.setSysBrandId(sysBrandId);
        couponDefinitionVO.setManualId(couponManualId);
        List sendCouponSimpleRequestVOList = staffVoList.stream().map(staffVo -> {
            SendCouponSimpleRequestVO sendCouponSimpleRequestVO = new SendCouponSimpleRequestVO();
            sendCouponSimpleRequestVO.setSendGuideId(staffVo.getSysStaffId());
            sendCouponSimpleRequestVO.setSendCouponQuantity(memberAverage);
            sendCouponSimpleRequestVO.setCouponQuotaId(po.getCouponQuotaId());
            return sendCouponSimpleRequestVO;
        }).collect(Collectors.toList());
        couponDefinitionVO.setSendCouponSimpleRequestVOS(sendCouponSimpleRequestVOList);
        couponDefinitionVO.setCouponQuotaId(po.getCouponQuotaId());
        ResponseData reduceDifindustryCouponQuantityData = this.couponDifindustryService.reduceDifindustryCouponQuantity(couponDefinitionVO);
        log.info("reduceDifindustryCouponQuantityData: {}", (Object)JacksonUtil.bean2Json((Object)reduceDifindustryCouponQuantityData));
        if (reduceDifindustryCouponQuantityData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.info("reduceDifindustryCouponQuantityData \u5f02\u4e1a\u5238\u914d\u989d\u4e0d\u8db3");
            throw new BizException("\u5f02\u4e1a\u5238\u914d\u989d\u4e0d\u8db3");
        }
        responseData.setData((Object)po.getCouponQuotaId());
        return responseData;
    }

    public ResponseData<PageInfo<CouponQuotaDifferentBrandRespVO>> getCouponQuotaDifferentBrandList(CouponQuotaDifferentBrandReqVO reqVO) {
        java.util.Date date;
        Long sysCompanyId = reqVO.getSysCompanyId();
        Long sysBrandId = reqVO.getSysBrandId();
        String quotaTopicOrCouponName = reqVO.getQuotaTopicOrCouponName();
        String couponName = reqVO.getCouponName();
        String quotaTopic = reqVO.getQuotaTopic();
        String batchNo = reqVO.getBatchNo();
        Long couponBrandId = reqVO.getCouponBrandId();
        String startDateStart = reqVO.getStartDateStart();
        String startDateEnd = reqVO.getStartDateEnd();
        String endDateStart = reqVO.getEndDateStart();
        String endDateEnd = reqVO.getEndDateEnd();
        String createDateStart = reqVO.getCreateDateStart();
        String createDateEnd = reqVO.getCreateDateEnd();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        CouponQuotaPOExample poExample = new CouponQuotaPOExample();
        CouponQuotaPOExample.Criteria criteria = poExample.createCriteria();
        if (sysCompanyId != null) {
            criteria.andSysCompanyIdEqualTo(sysCompanyId);
        }
        if (sysBrandId != null) {
            criteria.andSysBrandIdEqualTo(sysBrandId);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{couponName})) {
            criteria.andCouponNameEqualTo(couponName);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{quotaTopic})) {
            criteria.andQuotaTopicEqualTo(quotaTopic);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{batchNo})) {
            criteria.andBatchNoEqualTo(batchNo);
        }
        if (couponBrandId != null) {
            criteria.andCouponBrandIdEqualTo(couponBrandId);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{startDateStart})) {
            date = Date.from(LocalDateTime.parse(startDateStart, dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant());
            criteria.andStartDateGreaterThanOrEqualTo(date);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{startDateEnd})) {
            date = Date.from(LocalDateTime.parse(startDateEnd, dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant());
            criteria.andStartDateLessThanOrEqualTo(date);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{endDateStart})) {
            date = Date.from(LocalDateTime.parse(endDateStart, dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant());
            criteria.andEndDateGreaterThanOrEqualTo(date);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{endDateEnd})) {
            date = Date.from(LocalDateTime.parse(endDateEnd, dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant());
            criteria.andEndDateLessThanOrEqualTo(date);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{createDateStart})) {
            date = Date.from(LocalDateTime.parse(createDateStart, dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant());
            criteria.andCreateDateGreaterThanOrEqualTo(date);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{createDateEnd})) {
            date = Date.from(LocalDateTime.parse(createDateEnd, dateTimeFormatter).atZone(ZoneId.systemDefault()).toInstant());
            criteria.andCreateDateLessThanOrEqualTo(date);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{quotaTopicOrCouponName})) {
            String value = "%" + quotaTopicOrCouponName + "%";
            criteria.andQuotaTopicOrCouponNameLike(value);
        }
        criteria.andQuotaTypeEqualTo(Integer.valueOf(1));
        poExample.setOrderByClause("state desc, create_date desc");
        PageHelper.startPage((int)reqVO.getPageNo(), (int)reqVO.getPageSize());
        List quotaDifferentBrandPOList = this.couponQuotaPOMapper.selectByExample(poExample);
        PageInfo pageInfo = new PageInfo(quotaDifferentBrandPOList);
        log.info("pageInfo: {}", (Object)JacksonUtil.bean2Json((Object)pageInfo));
        List couponQuotaDifferentBrandReqVOList = quotaDifferentBrandPOList.stream().map(po -> {
            CouponQuotaDifferentBrandRespVO respVO = new CouponQuotaDifferentBrandRespVO();
            respVO.setBatchNo(po.getBatchNo());
            respVO.setQuotaTopic(po.getQuotaTopic());
            respVO.setCouponName(po.getCouponName());
            respVO.setCouponQuotaId(po.getCouponQuotaId());
            respVO.setCouponDefinitionId(po.getCouponDefinitionId());
            respVO.setMemberCount(po.getMemberCount());
            respVO.setMemberAverage(po.getMemberAverage());
            respVO.setSendCount(po.getSendCount());
            respVO.setTotalNumber(po.getTotalNumber());
            respVO.setState(Integer.valueOf(Boolean.TRUE.equals(po.getState()) ? 1 : 0));
            respVO.setStartDate(po.getStartDate().toInstant().atZone(ZoneId.systemDefault()).format(dateTimeFormatter));
            respVO.setEndDate(po.getEndDate().toInstant().atZone(ZoneId.systemDefault()).format(dateTimeFormatter));
            respVO.setCreateDate(po.getCreateDate().toInstant().atZone(ZoneId.systemDefault()).format(dateTimeFormatter));
            respVO.setGetCouponDayCount(po.getGetCouponDayCount());
            respVO.setGetCouponEndTime(po.getGetCouponEndTime());
            respVO.setGetCouponSwitch(po.getGetCouponSwitch());
            if (po.getCouponBrandId() != null) {
                ResponseData brandPoResponseData = this.brandServiceRpc.getBrandByID(po.getCouponBrandId());
                log.info("brandPoResponseData: {}", (Object)JacksonUtil.bean2Json((Object)brandPoResponseData));
                if (brandPoResponseData != null && brandPoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && brandPoResponseData.getData() != null) {
                    respVO.setCouponBrandName(((SysBrandPo)brandPoResponseData.getData()).getBrandName());
                }
            }
            return respVO;
        }).collect(Collectors.toList());
        pageInfo.setList(null);
        PageInfo resultPage = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)resultPage);
        resultPage.setList(couponQuotaDifferentBrandReqVOList);
        return ResponseUtil.success((Object)resultPage);
    }

    public ResponseData<CouponQuoteDifferentBrandDetailRespVO> getCouponQuotaDifferentBrandDetail(Long couponQuotaId) {
        CouponQuoteDifferentBrandDetailRespVO respVO = new CouponQuoteDifferentBrandDetailRespVO();
        CouponQuotaPO couponQuotaDifferentBrandPO = this.couponQuotaPOMapper.selectByPrimaryKey(couponQuotaId);
        log.info("couponQuotaDifferentBrandPO: {}", (Object)JacksonUtil.bean2Json((Object)couponQuotaDifferentBrandPO));
        BeanUtils.copyProperties((Object)couponQuotaDifferentBrandPO, (Object)respVO);
        Long couponDefinitionId = couponQuotaDifferentBrandPO.getCouponDefinitionId();
        CouponDefinitionPOWithBLOBs couponDefinitionPoWithBlobs = this.couponDefinitionPoMapper.selectByPrimaryKey(couponDefinitionId);
        log.info("detail couponDefinitionPoWithBlobs: {}", (Object)JacksonUtil.bean2Json((Object)couponDefinitionPoWithBlobs));
        respVO.setCouponDefinitionPOWithBLOBs(couponDefinitionPoWithBlobs);
        CouponQuotaDetailPOExample detailPOExample = new CouponQuotaDetailPOExample();
        detailPOExample.createCriteria().andCouponQuotaDetailIdEqualTo(couponQuotaId);
        List couponQuotaDetailPOList = this.couponQuotaDetailPoMapper.selectByExample(detailPOExample);
        log.info("couponQuotaDetailPOList: {}", (Object)JacksonUtil.list2Json((List)couponQuotaDetailPOList));
        List sysStaffIdList = couponQuotaDetailPOList.stream().map(po -> po.getSysStaffId()).collect(Collectors.toList());
        Map staffMap = couponQuotaDetailPOList.stream().collect(Collectors.toMap(CouponQuotaDetailPO::getSysStaffId, Function.identity(), (o1, o2) -> o1));
        respVO.setStaffMap(staffMap);
        StaffSelectAddBO staffSelectAddBO = new StaffSelectAddBO();
        staffSelectAddBO.setList(sysStaffIdList);
        ResponseData selectedStaffKeyResponseData = this.centerStageStaffRpc.selectAdd(staffSelectAddBO);
        log.info("selectedStaffKeyResponseData: {}", (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)selectedStaffKeyResponseData));
        if (selectedStaffKeyResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(CharSequence)selectedStaffKeyResponseData.getData()})) {
            String selectedStaffKey = (String)selectedStaffKeyResponseData.getData();
            respVO.setSelectedStaffKey(selectedStaffKey);
            ResponseData confirmData = this.centerStageStaffRpc.confirm(selectedStaffKey);
            log.info("confirmData: {}", (Object)com.bizvane.utils.jacksonutils.JacksonUtil.bean2Json((Object)confirmData));
        }
        ResponseData brandPoResponseData = this.brandServiceRpc.getBrandByID(couponQuotaDifferentBrandPO.getCouponBrandId());
        log.info("brandPoResponseData: {}", (Object)JacksonUtil.bean2Json((Object)brandPoResponseData));
        respVO.setCouponBrandName(((SysBrandPo)brandPoResponseData.getData()).getBrandName());
        return ResponseUtil.success((Object)respVO);
    }

    public ResponseData<PageInfo<CouponQuotaDetailPO>> getStaffCouponQuotaDifferentBrandDetail(StaffCouponQuotaDifferentBrandDetailReqVO reqVO) {
        PageHelper.startPage((int)reqVO.getPageNo(), (int)reqVO.getPageSize());
        List couponQuotaDetailPOList = this.listCouponQuotaDetailPO(reqVO, null, null);
        PageInfo pageInfo = new PageInfo(couponQuotaDetailPOList);
        log.info("pageInfo: {}", (Object)JacksonUtil.bean2Json((Object)pageInfo));
        return ResponseUtil.success((Object)pageInfo);
    }

    public List<CouponQuotaDetailPO> listCouponQuotaDetailPO(StaffCouponQuotaDifferentBrandDetailReqVO reqVO, Long limit, Long to) {
        Long couponQuotaId = reqVO.getCouponQuotaId();
        String storeOrStaffName = reqVO.getStoreOrStaffName();
        CouponQuotaDetailPOExample poExample = new CouponQuotaDetailPOExample();
        CouponQuotaDetailPOExample.Criteria criteria = poExample.createCriteria();
        criteria.andCouponQuotaIdEqualTo(couponQuotaId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{storeOrStaffName})) {
            criteria.andStoreOrStaffNameLike("%" + storeOrStaffName + "%");
        }
        List couponQuotaDetailPOList = this.couponQuotaDetailPoMapper.selectByExample(poExample);
        return couponQuotaDetailPOList;
    }

    public ResponseData<Boolean> exportStaffQuotaDetailList(StaffCouponQuotaDifferentBrandDetailReqVO vo, SysAccountPo accountPo) {
        log.info("CouponQuotaDifferentBrandServiceImpl-exportStaffQuotaDetailList-info,request:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        vo.setPageNo(Integer.valueOf(1));
        vo.setPageSize(Integer.valueOf(1));
        ResponseData pageInfoRes = this.getStaffCouponQuotaDifferentBrandDetail(vo);
        if (pageInfoRes == null || pageInfoRes.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            throw new BizException(SysResponseEnum.FAILED.getCode(), "\u67e5\u8be2\u5f02\u4e1a\u5238\u5206\u914d\u660e\u7ec6\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (pageInfoRes.getData() == null || CollectionUtils.isEmpty((Collection)((PageInfo)pageInfoRes.getData()).getList())) {
            throw new BizException(SysResponseEnum.FAILED.getCode(), "\u67e5\u8be2\u5f02\u4e1a\u5238\u5206\u914d\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u5f02\u4e1a\u5238\u5206\u914d\u660e\u7ec6\u53ef\u4f9b\u5bfc\u51fa");
        }
        if (((PageInfo)pageInfoRes.getData()).getTotal() > 500000L) {
            throw new BizException(SysResponseEnum.FAILED.getCode(), "\u5bfc\u51fa\u7ed3\u679c\u6761\u6570\u5927\u4e8e500000\uff0c\u8bf7\u6dfb\u52a0\u7b5b\u9009\u6761\u4ef6\u540e\u91cd\u65b0\u5bfc\u51fa");
        }
        try {
            long count = ((PageInfo)pageInfoRes.getData()).getTotal();
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(count + "\u6761");
            fileTaskPo.setTaskName("\u5f02\u4e1a\u5238\u5206\u914d\u660e\u7ec6\u5bfc\u51fa");
            if (accountPo != null) {
                fileTaskPo.setSysBrandId(accountPo.getBrandId());
                fileTaskPo.setCreateUserId(accountPo.getSysAccountId());
                fileTaskPo.setCreateUserName(accountPo.getName());
            }
            fileTaskPo.setCreateDate(new java.util.Date());
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.TRUE);
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(count));
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = ReflectionUtils.findMethod(this.getClass(), (String)"listCouponQuotaDetailPO", (Class[])new Class[]{StaffCouponQuotaDifferentBrandDetailReqVO.class, Long.class, Long.class});
                    exportExcelUtil.read("couponQuotaDifferentBrandServiceImpl", method, (model, row) -> {
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u59d3\u540d");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u7f16\u53f7");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u6240\u5c5e\u5e97\u94fa");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u914d\u989d\u603b\u6570");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u5269\u4f59\u914d\u989d");
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue(model.getStaffName());
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue(model.getStaffCode());
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue(model.getStoreName());
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue((double)model.getTotalNumber().intValue());
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue((double)model.getUnuseNumber().intValue());
                        }
                    }, new Object[]{vo});
                }
                catch (Exception e) {
                    log.info("CouponQuotaDifferentBrandServiceImpl-exportStaffQuotaDetailList-info, thread exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }).start();
            new Thread(() -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)("\u5f02\u4e1a\u5238\u5206\u914d\u660e\u7ec6" + format.format(new java.util.Date())));
            }).start();
        }
        catch (Exception e) {
            log.info("CouponQuotaDifferentBrandServiceImpl-exportStaffQuotaDetailList-info, export exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setData((Object)Boolean.TRUE);
        return responseData;
    }

    public ResponseData<String> updateStatus(CouponQuotaDifferentBrandUpdateReqVO reqVO, SysAccountPo accountPo) {
        log.info("updateStatus reqVo: {}, accountPo: {}", (Object)JacksonUtil.bean2Json((Object)reqVO), (Object)JacksonUtil.bean2Json((Object)accountPo));
        Long couponQuotaId = reqVO.getCouponQuotaId();
        Boolean status = reqVO.getState();
        CouponQuotaPO couponPO = this.couponQuotaPOMapper.selectByPrimaryKey(couponQuotaId);
        log.info("couponPO: {}", (Object)JacksonUtil.bean2Json((Object)couponPO));
        if (status != null && status.booleanValue() && !couponPO.getState().booleanValue()) {
            return ResponseUtil.error((String)"\u5df2\u5173\u95ed\u4e0d\u80fd\u5f00\u542f");
        }
        CouponQuotaPO couponQuotaDifferentBrandPO = new CouponQuotaPO();
        BeanUtils.copyProperties((Object)reqVO, (Object)couponQuotaDifferentBrandPO);
        couponQuotaDifferentBrandPO.setModifiedUserId(accountPo.getSysAccountId());
        couponQuotaDifferentBrandPO.setModifiedUserName(accountPo.getName());
        couponQuotaDifferentBrandPO.setModifiedDate(TimeUtils.getNowTime());
        int i = this.couponQuotaPOMapper.updateByPrimaryKeySelective(couponQuotaDifferentBrandPO);
        log.info("update: {}", (Object)i);
        this.releaseDifindustryCouponQuantity(couponQuotaId);
        return ResponseUtil.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    public void releaseDifindustryCouponQuantity(Long couponQuotaId) {
        CouponQuotaPO couponPO = this.couponQuotaPOMapper.selectByPrimaryKey(couponQuotaId);
        log.info("couponPO: {}", (Object)JacksonUtil.bean2Json((Object)couponPO));
        if (couponPO.getQuotaType() != 1) {
            log.info("\u975e\u5f02\u4e1a\u5238\uff0c\u4e0d\u652f\u6301\u91ca\u653e\u5f02\u4e1a\u5238\u6c60: {}", (Object)JacksonUtil.bean2Json((Object)couponPO));
            return;
        }
        CouponQuotaDetailPOExample poExample = new CouponQuotaDetailPOExample();
        CouponQuotaDetailPOExample.Criteria criteria = poExample.createCriteria();
        criteria.andCouponQuotaIdEqualTo(couponQuotaId);
        List couponQuotaDetailPOList = this.couponQuotaDetailPoMapper.selectByExample(poExample);
        log.info("couponQuotaDetailPOList: {}", (Object)JacksonUtil.list2Json((List)couponQuotaDetailPOList));
        List sysStaffIdList = couponQuotaDetailPOList.stream().map(po -> po.getSysStaffId()).collect(Collectors.toList());
        CouponQuotaDetailPO record = new CouponQuotaDetailPO();
        record.setValid(Boolean.valueOf(false));
        this.couponQuotaDetailPoMapper.updateByExampleSelective(record, poExample);
        SendCouponSimpleRequestVO sendCouponSimpleRequestVO = new SendCouponSimpleRequestVO();
        sendCouponSimpleRequestVO.setCompanyId(couponPO.getSysCompanyId());
        sendCouponSimpleRequestVO.setBrandId(couponPO.getSysBrandId());
        sendCouponSimpleRequestVO.setSendGuideIdList(sysStaffIdList);
        sendCouponSimpleRequestVO.setManualId(couponPO.getCouponManualId());
        sendCouponSimpleRequestVO.setCouponQuotaId(couponQuotaId);
        ResponseData stringResponseData = this.couponDifindustryService.releaseDifindustryCouponQuantity(sendCouponSimpleRequestVO);
        log.info("stringResponseData: {}", (Object)JacksonUtil.bean2Json((Object)stringResponseData));
    }

    private CouponQuotaDetailPO getCouponQuotaDetailPO(CouponQuotaDifferentBrandSaveVO po, SysAccountPo accountPo, CouponDefinitionPOWithBLOBs couponDefinitionPoWithBlobs) {
        CouponQuotaDetailPO couponQuotaDetailPo = new CouponQuotaDetailPO();
        couponQuotaDetailPo.setSysCompanyId(accountPo.getSysCompanyId());
        couponQuotaDetailPo.setSysBrandId(accountPo.getBrandId());
        couponQuotaDetailPo.setCreateUserId(accountPo.getSysAccountId());
        couponQuotaDetailPo.setCreateUserName(accountPo.getName());
        couponQuotaDetailPo.setCreateDate(TimeUtils.getNowTime());
        couponQuotaDetailPo.setModifiedUserId(accountPo.getSysAccountId());
        couponQuotaDetailPo.setModifiedUserName(accountPo.getName());
        couponQuotaDetailPo.setModifiedDate(TimeUtils.getNowTime());
        couponQuotaDetailPo.setCouponQuotaId(po.getCouponQuotaId());
        couponQuotaDetailPo.setQuotaTopic(po.getQuotaTopic());
        couponQuotaDetailPo.setTotalNumber(po.getMemberAverage());
        couponQuotaDetailPo.setUnuseNumber(po.getMemberAverage());
        couponQuotaDetailPo.setCouponDefinitionCode(couponDefinitionPoWithBlobs.getCouponDefinitionCode());
        couponQuotaDetailPo.setCouponDefinitionId(po.getCouponDefinitionId());
        couponQuotaDetailPo.setPreferentialType(couponDefinitionPoWithBlobs.getPreferentialType());
        couponQuotaDetailPo.setCouponName(couponDefinitionPoWithBlobs.getCouponName());
        couponQuotaDetailPo.setMoney(couponDefinitionPoWithBlobs.getMoney());
        couponQuotaDetailPo.setDiscount(couponDefinitionPoWithBlobs.getDiscount());
        couponQuotaDetailPo.setInfo(couponDefinitionPoWithBlobs.getInfo());
        couponQuotaDetailPo.setStartDateStart(po.getStartDate());
        couponQuotaDetailPo.setStartDateEnd(po.getEndDate());
        couponQuotaDetailPo.setValidDateStart(couponDefinitionPoWithBlobs.getValidDateStart());
        couponQuotaDetailPo.setValidDateEnd(couponDefinitionPoWithBlobs.getValidDateEnd());
        couponQuotaDetailPo.setValidType(couponDefinitionPoWithBlobs.getValidType());
        couponQuotaDetailPo.setValidDay(couponDefinitionPoWithBlobs.getValidDay());
        couponQuotaDetailPo.setMinConsume(couponDefinitionPoWithBlobs.getMinConsume());
        couponQuotaDetailPo.setValid(Boolean.valueOf(true));
        return couponQuotaDetailPo;
    }

    private void dealGuide(CouponQuotaDifferentBrandSaveVO couponQuotaVO) {
        String selectedStaffKey = couponQuotaVO.getSelectedStaffKey();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{selectedStaffKey})) {
            List selectEdIdList = (List)this.sysCacheServiceRpc.getSelectEdIdList(selectedStaffKey).getData();
            log.info("selectedStaffKey: {}, selectEdIdList: {}", (Object)selectedStaffKey, (Object)JacksonUtil.list2Json((List)selectEdIdList));
            couponQuotaVO.setSysStaffIds(selectEdIdList);
        }
    }
}

