/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponDifindustrySendDetailPO;
import com.bizvane.couponfacade.models.po.CouponQuotaDetailPO;
import com.bizvane.couponfacade.models.po.CouponQuotaDetailPOExample;
import com.bizvane.couponfacade.models.po.CouponQuotaSendDetailPO;
import com.bizvane.couponfacade.models.po.CouponQuotaSendDetailPOExample;
import com.bizvane.couponfacade.models.vo.CouponDifindustryVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDetailRespVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDetailVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaSendDetailAppletVo;
import com.bizvane.couponfacade.models.vo.CouponQuotaSendDetailVO;
import com.bizvane.couponfacade.models.vo.CouponStatusEntitySuccessVO;
import com.bizvane.couponfacade.models.vo.SendCouponQuotaBatchRequestVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.common.utils.ResponseUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponDifindustrySendDetailPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.CouponQuotaDetailPOMapper;
import com.bizvane.couponservice.mappers.CouponQuotaSendDetailPOMapper;
import com.bizvane.couponservice.service.CouponQuotaDetailService;
import com.bizvane.members.facade.models.bo.CompanyMemberInfoBo;
import com.bizvane.members.facade.models.query.CouponMemberPo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.redis.canal.dto.StaffCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponQuotaDetailServiceImpl
implements CouponQuotaDetailService {
    private static Logger logger = LoggerFactory.getLogger(CouponQuotaDetailServiceImpl.class);
    @Autowired
    private CouponQuotaDetailPOMapper couponQuotaDetailPoMapper;
    @Autowired
    private CouponQuotaSendDetailPOMapper couponQuotaSendDetailPoMapper;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPoMapper;
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    @Autowired
    private CouponDifindustrySendDetailPOMapper couponDifindustrySendDetailPOMapper;

    public ResponseData<PageInfo<CouponQuotaDetailPO>> getCouponQuotaListDetail(CouponQuotaDetailVO vo, SysAccountPo accountPo, PageFormUtil pageForm) {
        logger.info("enter CouponEntityServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        vo.setSysBrandId(accountPo.getBrandId());
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize(), (boolean)true);
        List entityVOList = this.couponQuotaDetailPoMapper.findCouponQuotaDetailPoByConditions(vo);
        PageInfo pageInfo = new PageInfo(entityVOList);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<CouponQuotaDetailPO> getCouponQuotaListDetail(CouponQuotaDetailVO vo) {
        logger.info("enter CouponEntityServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        List entityVOList = this.couponQuotaDetailPoMapper.findCouponQuotaDetailPoByConditions(vo);
        responseData.setData(entityVOList.get(0));
        return responseData;
    }

    public ResponseData<PageInfo<CouponQuotaDetailRespVO>> getCouponQuotaListForStaff(CouponQuotaDetailVO vo, SysAccountPo accountPo, PageFormUtil pageForm) {
        logger.info("enter getCouponQuotaListForStaff getList method");
        ResponseData responseData = new ResponseData();
        vo.setSysBrandId(accountPo.getBrandId());
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize(), (boolean)true);
        List entityVOList = this.couponQuotaDetailPoMapper.getCouponQuotaListForStaff(vo);
        PageInfo pageInfo = new PageInfo(entityVOList);
        logger.info("pageInfo: {}", (Object)JacksonUtil.bean2Json((Object)pageInfo));
        if (CollectionUtils.isNotEmpty((Collection)entityVOList)) {
            SysBrandVo sysBrandVo;
            String memberCenterAppId = "";
            ResponseData brandResponse = this.brandServiceRpc.getBrandId(vo.getSysBrandId());
            if (brandResponse != null && brandResponse.getCode() == SysResponseEnum.SUCCESS.getCode() && brandResponse.getData() != null && (sysBrandVo = (SysBrandVo)brandResponse.getData()).getMemberCenter() != null) {
                memberCenterAppId = sysBrandVo.getMemberCenter().getAppid();
            }
            Set couponDefinitionIdList = entityVOList.stream().map(CouponQuotaDetailPO::getCouponDefinitionId).collect(Collectors.toSet());
            CouponDefinitionPOExample couponDefinitionPOExample = new CouponDefinitionPOExample();
            couponDefinitionPOExample.createCriteria().andCouponDefinitionIdIn((List)Lists.newArrayList(couponDefinitionIdList));
            List couponDefListByIds = this.couponDefinitionPoMapper.selectByExampleWithBLOBs(couponDefinitionPOExample);
            logger.info("couponDefListByIds: {}", (Object)JacksonUtil.list2Json((List)couponDefListByIds));
            Map couponIdMap = couponDefListByIds.stream().collect(Collectors.toMap(CouponDefinitionPO::getCouponDefinitionId, Function.identity()));
            String finalMemberCenterAppId = memberCenterAppId;
            entityVOList.stream().forEach(entity -> {
                entity.setMemberCenterAppId(finalMemberCenterAppId);
                Long couponBrandId = entity.getCouponBrandId();
                if (couponBrandId != null) {
                    ResponseData brandByID = this.brandServiceRpc.getBrandByID(couponBrandId);
                    entity.setCouponBrandName(((SysBrandPo)brandByID.getData()).getBrandName());
                }
                entity.setCouponDefinitionPO((CouponDefinitionPOWithBLOBs)couponIdMap.get(entity.getCouponDefinitionId()));
            });
        }
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<String> batchRpc(SendCouponQuotaBatchRequestVO vo) {
        ResponseData responseData = new ResponseData();
        CouponQuotaSendDetailPO couponQuotaSendDetailPo = new CouponQuotaSendDetailPO();
        int unuseNumberend = 0;
        CouponQuotaDetailPOExample example = new CouponQuotaDetailPOExample();
        example.createCriteria().andStaffCodeEqualTo(vo.getStaffCode()).andCouponQuotaIdEqualTo(vo.getCouponQuotaId()).andCouponDefinitionIdEqualTo(vo.getCouponDefinitionId());
        List couponQuotaDetaillist = this.couponQuotaDetailPoMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)couponQuotaDetaillist)) {
            int unuseNumber = ((CouponQuotaDetailPO)couponQuotaDetaillist.get(0)).getUnuseNumber();
            int memberNum = Integer.valueOf(vo.getMemberNum());
            if (memberNum > unuseNumber) {
                responseData.setCode(100);
                responseData.setMessage("\u5269\u4f59\u6570\u91cf\u4e0d\u591f\uff01");
                return responseData;
            }
            unuseNumberend = unuseNumber - memberNum;
        }
        couponQuotaSendDetailPo.setStaffCode(vo.getStaffCode());
        couponQuotaSendDetailPo.setStaffName(vo.getStaffName());
        couponQuotaSendDetailPo.setSysCompanyId(vo.getSysCompanyId());
        couponQuotaSendDetailPo.setSysBrandId(vo.getSysBrandId());
        couponQuotaSendDetailPo.setCouponQuotaDetailId(((CouponQuotaDetailPO)couponQuotaDetaillist.get(0)).getCouponQuotaDetailId());
        couponQuotaSendDetailPo.setMemberCodeList(vo.getMemberCodeStr());
        couponQuotaSendDetailPo.setMemberNameList(vo.getMemberNameStr());
        couponQuotaSendDetailPo.setMemberNum(vo.getMemberNum());
        CouponDefinitionPOWithBLOBs couponDefinitionPoWithBlobs = this.couponDefinitionPoMapper.selectByPrimaryKey(vo.getCouponDefinitionId());
        if (couponDefinitionPoWithBlobs == null) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        if (Boolean.FALSE.equals(couponDefinitionPoWithBlobs.getStatus())) {
            logger.info("\u5238\u5b9a\u4e49\u88ab\u505c\u7528,\u4e0d\u5141\u8bb8\u53d1\u5238,\u5238\u5b9a\u4e49id={}", (Object)couponDefinitionPoWithBlobs.getCouponDefinitionId());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_ALREADY_DEACTIVATE.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_ALREADY_DEACTIVATE.getMessage());
            return responseData;
        }
        couponQuotaSendDetailPo.setCouponDefinitionCode(couponDefinitionPoWithBlobs.getCouponDefinitionCode());
        couponQuotaSendDetailPo.setCouponDefinitionId(couponDefinitionPoWithBlobs.getCouponDefinitionId());
        couponQuotaSendDetailPo.setPreferentialType(couponDefinitionPoWithBlobs.getPreferentialType());
        couponQuotaSendDetailPo.setCouponName(couponDefinitionPoWithBlobs.getCouponName());
        couponQuotaSendDetailPo.setMoney(couponDefinitionPoWithBlobs.getMoney());
        couponQuotaSendDetailPo.setDiscount(couponDefinitionPoWithBlobs.getDiscount());
        couponQuotaSendDetailPo.setInfo(couponDefinitionPoWithBlobs.getInfo());
        couponQuotaSendDetailPo.setValidDateStart(couponDefinitionPoWithBlobs.getValidDateStart());
        couponQuotaSendDetailPo.setValidDateEnd(couponDefinitionPoWithBlobs.getValidDateEnd());
        couponQuotaSendDetailPo.setCreateDate(TimeUtils.getNowTime());
        couponQuotaSendDetailPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        couponQuotaSendDetailPo.setValidDay(couponDefinitionPoWithBlobs.getValidDay());
        couponQuotaSendDetailPo.setValidType(couponDefinitionPoWithBlobs.getValidType());
        couponQuotaSendDetailPo.setMinConsume(couponDefinitionPoWithBlobs.getMinConsume());
        CouponQuotaDetailPO couponQuotaDetailPo = new CouponQuotaDetailPO();
        couponQuotaDetailPo.setUnuseNumber(Integer.valueOf(unuseNumberend));
        this.couponQuotaDetailPoMapper.updateByExampleSelective(couponQuotaDetailPo, example);
        int data = this.couponQuotaSendDetailPoMapper.insertSelective(couponQuotaSendDetailPo);
        responseData.setData((Object)(couponQuotaSendDetailPo.getCouponQuotaSendDetailId() + ""));
        return responseData;
    }

    public ResponseData<PageInfo<CouponQuotaSendDetailPO>> getSendCouponQuotaListDetail(CouponQuotaDetailVO vo, SysAccountPo accountPo, PageFormUtil pageForm) {
        logger.info("enter CouponEntityServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        vo.setSysBrandId(accountPo.getBrandId());
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize(), (boolean)true);
        CouponQuotaSendDetailPOExample example = new CouponQuotaSendDetailPOExample();
        example.createCriteria().andSysBrandIdEqualTo(vo.getSysBrandId()).andStaffCodeEqualTo(vo.getStaffCode()).andSendStatusNotEqualTo(Integer.valueOf(1));
        List entityVOList = this.couponQuotaSendDetailPoMapper.selectByExample(example);
        PageInfo pageInfo = new PageInfo(entityVOList);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<PageInfo<CouponEntityVO>> getList(CouponEntityVO entityParam, SysAccountPo accountPo, PageFormUtil pageForm) {
        logger.info("enter CouponEntityServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        entityParam.setSysBrandId(accountPo.getBrandId());
        CouponStatusEntitySuccessVO successVO = new CouponStatusEntitySuccessVO();
        successVO.setCouponStatusUnused(SystemConstants.COUPON_STATUS_UNUSED);
        successVO.setCouponStatusOverdue(SystemConstants.COUPON_STATUS_OVERDUE);
        successVO.setCouponStatusUsed(SystemConstants.COUPON_STATUS_USED);
        entityParam.setListType("102");
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        logger.info("\u4f01\u4e1a\u5fae\u4fe1\u5386\u53f2\u67e5\u8be2\u65f6\u95f4\u54272--" + System.currentTimeMillis() + JSONObject.toJSONString((Object)entityParam));
        CouponMemberPo couponMember = new CouponMemberPo();
        if (entityParam.getBaseSearchValue() != null && !"".equals(entityParam.getBaseSearchValue())) {
            couponMember.setConditions(entityParam.getBaseSearchValue());
            couponMember.setBrandId(accountPo.getBrandId());
            ResponseData getMemberInfoByCodeList = this.memberInfoApiService.getCompanyWxMemberInfo(couponMember);
            if (getMemberInfoByCodeList.getData() != null) {
                for (CompanyMemberInfoBo memberInfoModel : (List)getMemberInfoByCodeList.getData()) {
                    entityParam.setMemberCode(memberInfoModel.getMemberCode());
                    entityParam.setBaseSearchValue("");
                }
            }
        }
        entityParam.setFingType("ASC");
        entityParam.setCreateUserName(entityParam.getStaffcode());
        List entityVOList = this.couponEntityPoMapper.findCouponEntityByConditions(entityParam, successVO);
        ArrayList<String> memberCodeList = new ArrayList<String>();
        for (CouponEntityVO entityVO : entityVOList) {
            entityVO.setModifiedUserName("2");
            memberCodeList.add(entityVO.getMemberCode());
        }
        CouponMemberPo couponMemberPo = new CouponMemberPo();
        couponMemberPo.setMemberCodeList(memberCodeList);
        couponMemberPo.setBrandId(accountPo.getBrandId());
        logger.info("\u4f01\u4e1a\u5fae\u4fe1\u5386\u53f2\u67e5\u8be2\u65f6\u95f4\u54273--" + System.currentTimeMillis() + JSONObject.toJSONString((Object)couponMemberPo));
        ResponseData getMemberInfoByCodeList = null;
        if (memberCodeList != null && memberCodeList.size() > 0) {
            getMemberInfoByCodeList = this.memberInfoApiService.getCompanyWxMemberInfo(couponMemberPo);
            logger.info("\u4f01\u4e1a\u5fae\u4fe1\u5386\u53f2\u67e5\u8be2\u65f6\u95f4\u54274.1--" + System.currentTimeMillis() + JSONObject.toJSONString((Object)getMemberInfoByCodeList));
        }
        logger.info("\u4f01\u4e1a\u5fae\u4fe1\u5386\u53f2\u67e5\u8be2\u65f6\u95f4\u54274.2--" + System.currentTimeMillis());
        HashMap<String, CompanyMemberInfoBo> map = new HashMap<String, CompanyMemberInfoBo>();
        if (getMemberInfoByCodeList != null && getMemberInfoByCodeList.getData() != null) {
            for (CompanyMemberInfoBo memberInfoModel : (List)getMemberInfoByCodeList.getData()) {
                map.put(memberInfoModel.getMemberCode(), memberInfoModel);
            }
        }
        for (CouponEntityVO couponEntityVO : entityVOList) {
            CompanyMemberInfoBo memberNamePojoNew = (CompanyMemberInfoBo)map.get(couponEntityVO.getMemberCode());
            if (memberNamePojoNew == null) continue;
            couponEntityVO.setCardNo(memberNamePojoNew.getCardNo());
            couponEntityVO.setMemberName(memberNamePojoNew.getName());
            couponEntityVO.setExternalUserId(memberNamePojoNew.getExternalUserId());
            couponEntityVO.setHeadPortraits(memberNamePojoNew.getHeadPortraits());
            couponEntityVO.setMemberComment(memberNamePojoNew.getMemberComment());
            couponEntityVO.setName(memberNamePojoNew.getName());
            couponEntityVO.setPhone(memberNamePojoNew.getPhone());
        }
        for (CouponEntityVO couponEntityVO : entityVOList) {
            if (!"20".equals(couponEntityVO.getCouponStatus().toString())) continue;
            try {
                Date currentTime = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String validDateEnd = formatter.format(couponEntityVO.getValidDateEnd());
                String validDate = formatter.format(currentTime);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date oDate = sdf.parse(validDateEnd);
                Date fDate = sdf.parse(validDate);
                long days = (oDate.getTime() - fDate.getTime()) / 86400000L;
                couponEntityVO.setDateDue(String.valueOf(days + 1L) + "\u5929\u540e\u5230\u671f");
            }
            catch (ParseException e) {
                logger.error("\u5f02\u5e38", (Throwable)e);
            }
        }
        PageInfo pageInfo = new PageInfo(entityVOList);
        responseData.setData((Object)pageInfo);
        logger.info("\u4f01\u4e1a\u5fae\u4fe1\u5386\u53f2\u67e5\u8be2\u65f6\u95f4\u54275--" + System.currentTimeMillis() + JSONObject.toJSONString((Object)responseData));
        return responseData;
    }

    public ResponseData<PageInfo<CouponEntityVO>> getDifferentBrandList(CouponEntityVO entityParam, PageFormUtil pageForm) {
        logger.info("getDifferentBrandList: entityParam: {}", (Object)JacksonUtil.bean2Json((Object)entityParam));
        String staffCode = entityParam.getStaffcode();
        Long sysCompanyId = entityParam.getSysCompanyId();
        Long sysBrandId = entityParam.getSysBrandId();
        String baseSearchValue = entityParam.getBaseSearchValue();
        CouponDifindustryVO couponDifindustryVO = new CouponDifindustryVO();
        couponDifindustryVO.setSysCompanyId(sysCompanyId);
        couponDifindustryVO.setSysBrandId(sysBrandId);
        couponDifindustryVO.setBaseSearchValue(baseSearchValue);
        StaffCacheDto staffCache = this.iRedisCacheService.getStaffCache(sysCompanyId, staffCode);
        logger.info("staffCache: {}", (Object)JacksonUtil.bean2Json((Object)staffCache));
        if (staffCache == null) {
            return ResponseUtil.error((String)"\u5bfc\u8d2d\u4fe1\u606f\u4e3a\u7a7a");
        }
        couponDifindustryVO.setSendGuideId(staffCache.getStaffId());
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        List differentBrandList = this.couponDifindustrySendDetailPOMapper.getDifferentBrandList(couponDifindustryVO);
        logger.info("differentBrandList: {}", (Object)JacksonUtil.list2Json((List)differentBrandList));
        PageInfo pageInfo = new PageInfo(differentBrandList);
        differentBrandList = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)differentBrandList)) {
            PageInfo couponEntityVOPageInfo = new PageInfo();
            couponEntityVOPageInfo.setList((List)Lists.newArrayList());
            return ResponseUtil.success((Object)couponEntityVOPageInfo);
        }
        List memberCodeList = differentBrandList.stream().map(coupon -> coupon.getSendMemberCode()).collect(Collectors.toList());
        CouponMemberPo couponMemberPo = new CouponMemberPo();
        couponMemberPo.setMemberCodeList(memberCodeList);
        couponMemberPo.setBrandId(sysBrandId);
        Map<Object, Object> memberMap = new HashMap();
        if (CollectionUtils.isNotEmpty(memberCodeList)) {
            ResponseData getMemberInfoByCodeList = this.memberInfoApiService.getCompanyWxMemberInfo(couponMemberPo);
            logger.info("getMemberInfoByCodeList: {}", (Object)JacksonUtil.bean2Json((Object)getMemberInfoByCodeList));
            memberMap = ((List)getMemberInfoByCodeList.getData()).stream().collect(Collectors.toMap(CompanyMemberInfoBo::getMemberCode, Function.identity(), (o1, o2) -> o1));
        }
        ArrayList resultList = Lists.newArrayList();
        for (CouponDifindustrySendDetailPO couponEntityVO : differentBrandList) {
            CouponEntityVO entityVO = new CouponEntityVO();
            entityVO.setModifiedUserName("3");
            CompanyMemberInfoBo memberNamePojoNew = (CompanyMemberInfoBo)memberMap.get(couponEntityVO.getSendMemberCode());
            if (memberNamePojoNew != null) {
                entityVO.setCardNo(memberNamePojoNew.getCardNo());
                entityVO.setMemberCode(memberNamePojoNew.getMemberCode());
                entityVO.setMemberName(memberNamePojoNew.getName());
                entityVO.setExternalUserId(memberNamePojoNew.getExternalUserId());
                entityVO.setHeadPortraits(memberNamePojoNew.getHeadPortraits());
                entityVO.setMemberComment(memberNamePojoNew.getMemberComment());
                entityVO.setName(memberNamePojoNew.getName());
                entityVO.setPhone(memberNamePojoNew.getPhone());
            }
            entityVO.setDifferentBrand(Integer.valueOf(1));
            Long currSendBrandId = couponEntityVO.getSourceBrandId();
            if (currSendBrandId != null) {
                ResponseData rpcBrandByID = this.brandServiceRpc.getBrandByID(currSendBrandId);
                logger.info("rpcBrandByID: {}", (Object)JacksonUtil.bean2Json((Object)rpcBrandByID));
                entityVO.setCouponBrandName(((SysBrandPo)rpcBrandByID.getData()).getBrandName());
            }
            Long couponDefinitionId = Long.valueOf(couponEntityVO.getCouponDefinitionId());
            CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPoMapper.selectByPrimaryKey(couponDefinitionId);
            logger.info("couponDefinitionPOWithBLOBs: {}", (Object)JacksonUtil.bean2Json((Object)couponDefinitionPOWithBLOBs));
            entityVO.setCouponName(couponDefinitionPOWithBLOBs.getCouponName());
            entityVO.setPreferentialType(couponDefinitionPOWithBLOBs.getPreferentialType());
            entityVO.setMoney(couponDefinitionPOWithBLOBs.getMoney());
            entityVO.setDiscount(couponDefinitionPOWithBLOBs.getDiscount());
            entityVO.setCreateDate(couponEntityVO.getCreateDate());
            try {
                Date currentTime = new Date();
                if (currentTime.after(couponEntityVO.getValidDateEnd())) {
                    entityVO.setDateDue("\u5df2\u8fc7\u671f");
                } else {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    String validDateEnd = formatter.format(couponEntityVO.getValidDateEnd());
                    String validDate = formatter.format(currentTime);
                    Date oDate = formatter.parse(validDateEnd);
                    Date fDate = formatter.parse(validDate);
                    long days = (oDate.getTime() - fDate.getTime()) / 86400000L;
                    entityVO.setDateDue(String.valueOf(days + 1L) + "\u5929\u540e\u5230\u671f");
                }
            }
            catch (ParseException e) {
                logger.error("\u5f02\u5e38: {}", (Throwable)e);
            }
            resultList.add(entityVO);
        }
        PageInfo resultPage = new PageInfo();
        pageInfo.setList(null);
        BeanUtils.copyProperties((Object)pageInfo, (Object)resultPage);
        resultPage.setList((List)resultList);
        ResponseData responseData = new ResponseData();
        responseData.setData((Object)resultPage);
        return responseData;
    }

    public ResponseData<CouponQuotaSendDetailVO> getCouponQuotaSendDetailById(Long couponQuotaSendDetailId) {
        ResponseData responseData = new ResponseData();
        CouponQuotaSendDetailPO po = this.couponQuotaSendDetailPoMapper.selectByPrimaryKey(couponQuotaSendDetailId);
        logger.info("po: {}", (Object)JacksonUtil.bean2Json((Object)po));
        CouponQuotaSendDetailVO couponQuotaSendDetailVO = (CouponQuotaSendDetailVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)po), CouponQuotaSendDetailVO.class);
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPoMapper.selectByPrimaryKey(po.getCouponDefinitionId());
        logger.info("couponDefinitionPOWithBLOBs: {}", (Object)JacksonUtil.bean2Json((Object)couponDefinitionPOWithBLOBs));
        couponQuotaSendDetailVO.setCouponDefinitionPO(couponDefinitionPOWithBLOBs);
        responseData.setData((Object)couponQuotaSendDetailVO);
        return responseData;
    }

    public ResponseData<CouponQuotaSendDetailAppletVo> getCouponQuotaSendDetailAppletVoById(Long couponQuotaSendDetailId) {
        CouponQuotaSendDetailAppletVo couponQuotaSendDetailAppletVo = this.couponQuotaSendDetailPoMapper.getCouponQuotaSendDetailAppletVoById(couponQuotaSendDetailId);
        return new ResponseData((Object)couponQuotaSendDetailAppletVo);
    }
}

