/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.messagefacade.interfaces.WeChatAppletSubscribeMessageServiceFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.messagefacade.models.vo.SubscribeMessageVO;
import com.bizvane.messagefacade.models.vo.subscribe.CouponExpireMessageVO;
import com.bizvane.messagefacade.models.vo.subscribe.CouponReceiveMessageVO;
import com.bizvane.messagefacade.models.vo.subscribe.CouponUseMessageVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponMessageComponentServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CouponMessageComponentServiceImpl.class);
    @Autowired
    private WeChatAppletSubscribeMessageServiceFeign weChatAppletSubscribeMessageServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    public ResponseData<String> couponReceive(CouponMessageVO couponMessageVO, CouponDefinitionPO definitionPo, Date validDateStart, Date validDateEnd) {
        log.info("CouponMessageComponentServiceImpl#couponReceive#couponMessageVO:{},definitionPo:{},validDateStart:{},validDateEnd:{}", new Object[]{JSON.toJSONString((Object)couponMessageVO), JSON.toJSONString((Object)definitionPo), validDateStart, validDateEnd});
        try {
            CouponReceiveMessageVO couponReceiveMessageVO = new CouponReceiveMessageVO();
            BeanUtils.copyProperties((Object)couponMessageVO, (Object)couponReceiveMessageVO);
            couponReceiveMessageVO.setFIELD_MEMBER_CARD_NO(this.getMemberCardNoByMemberCode(couponMessageVO.getMemberCode()));
            couponReceiveMessageVO.setFIELD_COUPON_NAME(couponMessageVO.getCouponName());
            couponReceiveMessageVO.setFIELD_COUPON_DISCOUNT(StringUtils.isBlank((String)couponMessageVO.getDenomination()) ? new BigDecimal(0) : new BigDecimal(couponMessageVO.getDenomination()));
            couponReceiveMessageVO.setFIELD_COUPON_VALID_DATE(null != couponMessageVO.getValidDateEnd() ? couponMessageVO.getValidDateEnd() : validDateEnd);
            couponReceiveMessageVO.setFIELD_COUPON_EXPLAIN(definitionPo.getInfo());
            couponReceiveMessageVO.setFIELD_TEXT(couponMessageVO.getCouponCode());
            couponReceiveMessageVO.setValidDateStart(null != couponMessageVO.getValidDateStart() ? couponMessageVO.getValidDateStart() : validDateStart);
            couponReceiveMessageVO.setValidDateEnd(null != couponMessageVO.getValidDateEnd() ? couponMessageVO.getValidDateEnd() : validDateEnd);
            log.info("CouponMessageComponentServiceImpl#couponReceive#couponReceiveMessageVO:{}", (Object)JSON.toJSONString((Object)couponReceiveMessageVO));
            SubscribeMessageVO couponReceiveMessageVOSubscribeMessageVO = new SubscribeMessageVO();
            couponReceiveMessageVOSubscribeMessageVO.setMessageInfo((Object)couponReceiveMessageVO);
            log.info("weChatAppletSubscribeMessageServiceFeign#couponReceive#param:{}", (Object)JSON.toJSONString((Object)couponReceiveMessageVOSubscribeMessageVO));
            ResponseData responseData = this.weChatAppletSubscribeMessageServiceFeign.couponReceive(couponReceiveMessageVOSubscribeMessageVO);
            log.info("weChatAppletSubscribeMessageServiceFeign#couponReceive#result:{}", (Object)JSON.toJSONString((Object)responseData));
            return responseData;
        }
        catch (Exception e) {
            log.info("couponReceive e:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData();
        }
    }

    public ResponseData<String> couponExpire(CouponMessageVO couponMessageVO, CouponDefinitionPOWithBLOBs definitionPo) {
        log.info("CouponMessageComponentServiceImpl#couponExpire#couponMessageVO:{},definitionPo:{}", (Object)JSON.toJSONString((Object)couponMessageVO), (Object)JSON.toJSONString((Object)definitionPo));
        try {
            CouponExpireMessageVO couponExpireMessageVO = new CouponExpireMessageVO();
            BeanUtils.copyProperties((Object)couponMessageVO, (Object)couponExpireMessageVO);
            couponExpireMessageVO.setFIELD_MEMBER_CARD_NO(this.getMemberCardNoByMemberCode(couponMessageVO.getMemberCode()));
            couponExpireMessageVO.setFIELD_COUPON_NAME(couponMessageVO.getCouponName());
            couponExpireMessageVO.setFIELD_COUPON_DISCOUNT(StringUtils.isBlank((String)couponMessageVO.getDenomination()) ? new BigDecimal(0) : new BigDecimal(couponMessageVO.getDenomination()));
            couponExpireMessageVO.setFIELD_COUPON_VALID_DATE(couponMessageVO.getValidDateEnd());
            couponExpireMessageVO.setFIELD_COUPON_EXPLAIN(definitionPo.getInfo());
            couponExpireMessageVO.setFIELD_TEXT(couponMessageVO.getCouponCode());
            log.info("CouponMessageComponentServiceImpl#couponExpire#couponExpireMessageVO:{}", (Object)JSON.toJSONString((Object)couponExpireMessageVO));
            SubscribeMessageVO couponExpireMessageVOSubscribeMessageVO = new SubscribeMessageVO();
            couponExpireMessageVOSubscribeMessageVO.setMessageInfo((Object)couponExpireMessageVO);
            log.info("weChatAppletSubscribeMessageServiceFeign#couponExpire#param:{}", (Object)JSON.toJSONString((Object)couponExpireMessageVOSubscribeMessageVO));
            ResponseData responseData = this.weChatAppletSubscribeMessageServiceFeign.couponExpire(couponExpireMessageVOSubscribeMessageVO);
            log.info("weChatAppletSubscribeMessageServiceFeign#couponExpire#result:{}", (Object)JSON.toJSONString((Object)responseData));
            return responseData;
        }
        catch (Exception e) {
            log.info("couponExpire e:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData();
        }
    }

    public ResponseData<String> couponUse(CouponMessageVO couponMessageVO, CouponDefinitionPOWithBLOBs definitionPo, CouponEntityPO couponEntityPo, Date useTime) {
        log.info("CouponMessageComponentServiceImpl#couponUse#couponMessageVO:{},definitionPo:{},couponEntityPo:{}", new Object[]{JSON.toJSONString((Object)couponMessageVO), JSON.toJSONString((Object)definitionPo), JSON.toJSONString((Object)couponEntityPo)});
        try {
            CouponUseMessageVO couponUseMessageVO = new CouponUseMessageVO();
            BeanUtils.copyProperties((Object)couponMessageVO, (Object)couponUseMessageVO);
            couponUseMessageVO.setFIELD_MEMBER_CARD_NO(this.getMemberCardNoByMemberCode(couponMessageVO.getMemberCode()));
            couponUseMessageVO.setFIELD_COUPON_NAME(couponMessageVO.getCouponName());
            couponUseMessageVO.setFIELD_COUPON_DISCOUNT(StringUtils.isBlank((String)couponMessageVO.getDenomination()) ? new BigDecimal(0) : new BigDecimal(couponMessageVO.getDenomination()));
            couponUseMessageVO.setFIELD_COUPON_VALID_DATE(null != couponMessageVO.getValidDateEnd() ? couponMessageVO.getValidDateEnd() : couponEntityPo.getValidDateEnd());
            couponUseMessageVO.setFIELD_COUPON_EXPLAIN(definitionPo.getInfo());
            couponUseMessageVO.setFIELD_COUPON_USE_TIME(null != couponEntityPo.getUseTime() ? couponEntityPo.getUseTime() : useTime);
            couponUseMessageVO.setFIELD_TEXT(couponMessageVO.getCouponCode());
            log.info("CouponMessageComponentServiceImpl#couponUse#couponUseMessageVO:{}", (Object)JSON.toJSONString((Object)couponUseMessageVO));
            SubscribeMessageVO couponUseMessageVOSubscribeMessageVO = new SubscribeMessageVO();
            couponUseMessageVOSubscribeMessageVO.setMessageInfo((Object)couponUseMessageVO);
            log.info("weChatAppletSubscribeMessageServiceFeign#couponUse#param:{}", (Object)JSON.toJSONString((Object)couponUseMessageVOSubscribeMessageVO));
            ResponseData responseData = this.weChatAppletSubscribeMessageServiceFeign.couponUse(couponUseMessageVOSubscribeMessageVO);
            log.info("weChatAppletSubscribeMessageServiceFeign#couponUse#result:{}", (Object)JSON.toJSONString((Object)responseData));
            return responseData;
        }
        catch (Exception e) {
            log.info("couponUse e:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData();
        }
    }

    private String getMemberCardNoByMemberCode(String memberCode) {
        log.info("getMemberCardNoByMemberCode#memberCode:{}", (Object)memberCode);
        if (StringUtils.isNotBlank((String)memberCode)) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            log.info("getMemberCardNoByMemberCode#singleMemberModel:{}", (Object)JSON.toJSONString((Object)singleMemberModel));
            if (singleMemberModel != null && singleMemberModel.getData() != null) {
                return ((MemberInfoModel)singleMemberModel.getData()).getCardNo();
            }
        }
        return memberCode;
    }
}

