/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.bo.UrCreateCheckBo;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCheckConfigPo;
import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.models.vo.SysCheckConfigVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCheckConfigServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCheckServiceRpc;
import com.bizvane.couponfacade.enums.CouponEnum;
import com.bizvane.couponfacade.enums.CouponManualConditionEnum;
import com.bizvane.couponfacade.enums.CouponManualTaskStatusEnum;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.bo.CouponCodeWithPwd;
import com.bizvane.couponfacade.models.bo.PreGeneratedEmpCouponCreateBO;
import com.bizvane.couponfacade.models.bo.SendCouponDifindustryBo;
import com.bizvane.couponfacade.models.bo.SendCouponFailContinueBO;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionCodePO;
import com.bizvane.couponfacade.models.po.CouponDefinitionCodePOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.po.CouponManualPOExample;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponDifindustryVO;
import com.bizvane.couponfacade.models.vo.CouponManualVO;
import com.bizvane.couponfacade.models.vo.CouponSendCheckRequestVO;
import com.bizvane.couponfacade.models.vo.EmpCouponTaskCreateVO;
import com.bizvane.couponfacade.models.vo.ModifyPreCouponTaskVO;
import com.bizvane.couponfacade.models.vo.PreGeneratedCouponAlipayTaskCreateVO;
import com.bizvane.couponfacade.models.vo.PreGeneratedCouponTaskCreateVO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.thread.CacheThreadFactory;
import com.bizvane.couponservice.common.thread.ThreadPool;
import com.bizvane.couponservice.common.utils.BusinessCodeUtil;
import com.bizvane.couponservice.common.utils.CommonExportExcelUtil;
import com.bizvane.couponservice.common.utils.DigitalJudgmentUtil;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.common.utils.JobUtil;
import com.bizvane.couponservice.common.utils.ObjectConvertUtils;
import com.bizvane.couponservice.common.utils.QiNiuConfig;
import com.bizvane.couponservice.common.utils.RedisLock;
import com.bizvane.couponservice.common.utils.SpringContextUtil;
import com.bizvane.couponservice.common.utils.UrRequestUtil;
import com.bizvane.couponservice.mappers.CouponBatchSendRecordPOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionCodePOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.rocketmq.MQSendCouponService;
import com.bizvane.couponservice.service.CouponDifindustryQuantityRecordService;
import com.bizvane.couponservice.service.CouponDifindustryService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.couponservice.service.impl.CouponManualServiceImpl;
import com.bizvane.members.facade.enums.DirectionEnum;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.Order;
import com.bizvane.members.facade.es.vo.SearchRangRequest;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberGroupApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.mktcenterservice.models.bo.ActivityGiftbagBO;
import com.bizvane.mktcenterservice.models.po.MktGiftBagPO;
import com.bizvane.mktcenterservice.rpc.SendCouponServiceRpc;
import com.bizvane.trace.service.ProvisionalTraceService;
import com.bizvane.trace.service.TraceService;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

@Service
public class CouponManualServiceImpl
implements CouponManualService {
    private static final Logger logger = LoggerFactory.getLogger(CouponManualServiceImpl.class);
    private static final int MIN_LENGH = 0;
    private static final int MAX_ROW = 50000;
    private static final String OBSOLETE_SEND_COUPON_TASK_VALUE = "&";
    @Autowired
    private StringRedisTemplate rs;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CouponManualPOMapper couponManualPOMapper;
    @Autowired
    private SysCheckServiceRpc sysCheckServiceRpc;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponDefinitionCodePOMapper couponDefinitionCodePOMapper;
    @Autowired
    private SysCheckConfigServiceRpc sysCheckConfigServiceRpc;
    @Autowired
    private JobUtil jobUtil;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private SendCouponService sendCouponService;
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private MemberGroupApiService memberGroupApiService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private TraceService traceService;
    @Autowired
    private SendCouponServiceRpc sendCouponServiceRpc;
    @Autowired
    private ProvisionalTraceService provisionalTraceService;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private RedisTemplate<Object, Object> redis;
    @Autowired
    private CouponDifindustryService couponDifindustryService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    public CouponDifindustryQuantityRecordService couponDifindustryQuantityRecordService;
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    @Autowired
    private CouponBatchSendRecordPOMapper couponBatchSendRecordPOMapper;
    @Autowired
    private MQSendCouponService mqSendCouponService;
    @Autowired
    private UrRequestUtil urRequestUtil;

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponManualVO>> getList(CouponManualVO vo, Long sysBrandId, PageFormUtil pageForm) {
        logger.info("enter CouponManualServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        List list = this.couponManualPOMapper.findCouponManualListByConditions(vo, sysBrandId);
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(list);
        if (list != null) {
            list.forEach(t -> {
                if (t.getCouponDefinitionId().contains("_")) {
                    t.setIsDifdustrySendCoupon(Byte.valueOf((byte)1));
                }
                if (Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()).equals(t.getCouponType())) {
                    t.setMemberNum(t.getMemberCount());
                }
            });
        }
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<CouponCodeWithPwd> getCouponCodeWithPwd(Long couponDefinitionId, Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        int i = 0;
        while (i == 0) {
            logger.info("enter CouponManualServiceImpl getCouponCode method" + couponDefinitionId + " sysBrandId" + sysBrandId);
            CouponDefinitionCodePOExample couponExample = new CouponDefinitionCodePOExample();
            CouponDefinitionCodePOExample.Criteria criteria = couponExample.createCriteria();
            criteria.andCouponDefinitionIdEqualTo(couponDefinitionId);
            criteria.andSysBrandIdEqualTo(sysBrandId);
            criteria.andStatusEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
            List couponDefinitionCodePOList = this.couponDefinitionCodePOMapper.selectByExampleCode(couponExample);
            if (CollectionUtils.isEmpty((Collection)couponDefinitionCodePOList)) {
                logger.info("enter CouponManualServiceImpl getCouponCode methodNOtcode \u6ca1\u6709\u5238\u53f7\u4e86" + couponDefinitionId + " sysBrandId" + sysBrandId);
                responseData.setCode(1);
                responseData.setMessage("\u6ca1\u6709\u5238\u53f7\u4e86");
                return responseData;
            }
            int x = (int)(Math.random() * (double)couponDefinitionCodePOList.size());
            criteria.andCouponDefinitionCodeIdEqualTo(((CouponDefinitionCodePO)couponDefinitionCodePOList.get(x)).getCouponDefinitionCodeId());
            CouponDefinitionCodePO couponDefinitionCodeVO = new CouponDefinitionCodePO();
            couponDefinitionCodeVO.setStatus(SystemConstants.TABLE_VALID_INVALID);
            i = this.couponDefinitionCodePOMapper.updateByExampleSelective(couponDefinitionCodeVO, couponExample);
            logger.info("enter getCouponCode getCouponCode method out\uff1a" + couponDefinitionId + " sysBrandId\uff1a" + sysBrandId);
            logger.info("\u66f4\u65b0\u5377\u53f7\u8868\u8bb0\u5f55\u6570\uff1a{}", (Object)i);
            try {
                if (i > 0) {
                    this.couponDefinitionCodePOMapper.updateReremainingCount(i, couponDefinitionId, sysBrandId);
                }
            }
            catch (Exception e) {
                logger.warn("GetCouponCodeWithPwd updateReremainingCount error !");
            }
            logger.info("enter updateReremainingCount method out\uff1a" + couponDefinitionId + " sysBrandId\uff1a" + sysBrandId);
            CouponCodeWithPwd couponCodeWithPwd = CouponCodeWithPwd.builder().couponCode(((CouponDefinitionCodePO)couponDefinitionCodePOList.get(x)).getCouponCode()).usePwd(((CouponDefinitionCodePO)couponDefinitionCodePOList.get(x)).getUsePassword()).build();
            responseData.setData((Object)couponCodeWithPwd);
        }
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponManualVO>> getListRpc(CouponManualVO vo, PageFormUtil pageForm) {
        logger.info("enter CouponManualServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        if (null == vo.getSysBrandId()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        List list = this.couponManualPOMapper.findCouponManualListByConditions(vo, vo.getSysBrandId());
        list.forEach(t -> {
            if (Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()).equals(t.getCouponType())) {
                t.setFailCount(null);
                t.setSyncFailCount(null);
            }
        });
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public void addSendCouponBatchJob(SendCouponBatchRequestVO requestVO) {
        this.updateTaskStatus(requestVO.getBusinessId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_CHECK_PASS.getCode().byteValue()));
        this.jobUtil.addSendCouponBatchJob(requestVO);
    }

    public ResponseData<Integer> changeTask(CouponManualPO po) {
        logger.info("enter CouponManualServiceImpl changeTask method");
        ResponseData responseData = new ResponseData();
        if (null == po.getCouponManualId()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MANUAL_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == po.getTaskStatus()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.CHECK_STATUS_NOT_NULL.getMessage());
            return responseData;
        }
        po.setModifiedDate(TimeUtils.getNowTime());
        int count = this.couponManualPOMapper.updateByPrimaryKeySelective(po);
        responseData.setData((Object)count);
        return responseData;
    }

    public ResponseData<Integer> suspendTask(Long couponManualId) {
        logger.info("enter CouponManualServiceImpl suspendTask method");
        ResponseData responseData = new ResponseData();
        if (null == couponManualId) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MANUAL_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponManualPO manualPO = new CouponManualPO();
        manualPO.setCouponManualId(couponManualId);
        manualPO.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_CANCEL.getCode().byteValue()));
        manualPO.setModifiedDate(TimeUtils.getNowTime());
        int count = this.couponManualPOMapper.updateByPrimaryKeySelective(manualPO);
        responseData.setData((Object)count);
        return responseData;
    }

    public ResponseData<String> changeCheckStatus(CouponSendCheckRequestVO param, SysAccountPO sysAccountPo) {
        logger.info("enter CouponManualServiceImpl changeCheckStatus method:param:{}", (Object)param);
        ResponseData responseData = new ResponseData();
        if (null == param.getCouponManualId()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MANUAL_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == param.getTaskStatus()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.TASK_STATUS_NOT_NULL.getMessage());
            return responseData;
        }
        try {
            String verification = (String)this.redisTemplate.opsForValue().get((Object)("coupon:biz:online:changeCheckStatus:CHECK_SEND_COUPON_AUDIT_" + param.getCouponManualId()));
            if (StringUtils.isNotEmpty((CharSequence)verification)) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u5f53\u524d\u53d1\u5238\u4efb\u52a1\u5df2\u5ba1\u6838");
                return responseData;
            }
            this.redisTemplate.opsForValue().set((Object)("coupon:biz:online:changeCheckStatus:CHECK_SEND_COUPON_AUDIT_" + param.getCouponManualId()), (Object)"1", 1L, TimeUnit.MINUTES);
            logger.info("get lock success");
            CouponManualPO manualPO = this.couponManualPOMapper.selectByPrimaryKey(param.getCouponManualId());
            logger.info("changeCheckStatus manualPO:{}", (Object)JacksonUtil.bean2Json((Object)manualPO));
            if (manualPO.getTaskStatus() != 10) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u5f53\u524d\u53d1\u5238\u4efb\u52a1\u5df2\u5ba1\u6838");
                return responseData;
            }
            SysCheckPo checkPo = new SysCheckPo();
            checkPo.setModifiedDate(new Date());
            checkPo.setModifiedUserId(sysAccountPo.getSysAccountId());
            checkPo.setModifiedUserName(sysAccountPo.getName());
            checkPo.setBusinessId(param.getCouponManualId());
            checkPo.setFunctionCode("C0001");
            checkPo.setRemark(param.getRemark());
            if (CouponManualTaskStatusEnum.TASK_STATUS_CHECK_PASS.getCode().byteValue() == param.getTaskStatus().byteValue()) {
                checkPo.setCheckStatus(SystemConstants.CHECK_STATUS_CHECKED);
            }
            if (CouponManualTaskStatusEnum.TASK_STATUS_CHECK_UNPASS.getCode().byteValue() == param.getTaskStatus().byteValue()) {
                checkPo.setCheckStatus(SystemConstants.CHECK_STATUS_REJECTED);
            }
            ResponseData checkResult = this.sysCheckServiceRpc.updateCheck(checkPo);
            if (SysResponseEnum.SUCCESS.getCode() != checkResult.getCode()) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(checkResult.getMessage());
                return responseData;
            }
            CouponManualPO po = new CouponManualPO();
            po.setCouponManualId(param.getCouponManualId());
            po.setTaskStatus(param.getTaskStatus());
            po.setReviewUserId(sysAccountPo.getSysAccountId());
            po.setReviewUserName(sysAccountPo.getName());
            this.updateByCouponManualId(po);
            if (this.sendCouponMqService.isObsolete(param.getCouponManualId())) {
                logger.info("\u4efb\u52a1\u505c\u6b62 by id : {}", (Object)param.getCouponManualId());
                return new ResponseData();
            }
            if (CouponManualTaskStatusEnum.TASK_STATUS_CHECK_PASS.getCode().byteValue() == param.getTaskStatus().byteValue()) {
                CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(param.getCouponManualId());
                String ids = couponManualPO.getCouponDefinitionId();
                logger.info("changeCheckStatus couponDefId:{}", (Object)ids);
                ArrayList<String> idList = new ArrayList<String>();
                if (StringUtils.isNotBlank((CharSequence)ids)) {
                    if (ids.contains(",")) {
                        Collections.addAll(idList, ids.split(","));
                    } else {
                        idList.add(ids);
                    }
                }
                ArrayList<CouponDefinitionPOWithBLOBs> definitionPOList = new ArrayList<CouponDefinitionPOWithBLOBs>();
                ArrayList<SendCouponDifindustryBo> sendCouponDifindustryBoList = new ArrayList<SendCouponDifindustryBo>();
                logger.info("changeCheckStatus idList:{}", (Object)JacksonUtil.list2Json(idList));
                for (String id : idList) {
                    boolean numeric = DigitalJudgmentUtil.isNumeric((String)id);
                    if (numeric) {
                        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(id)));
                        if (null == definitionPO) continue;
                        definitionPOList.add(definitionPO);
                        continue;
                    }
                    String[] split = id.split("_");
                    String bandId = split[0];
                    String menualId = split[1];
                    CouponManualPO couponManua = this.couponManualPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(menualId)));
                    if (couponManua == null || !Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()).equals(couponManua.getCouponType())) continue;
                    CouponDefinitionPOWithBLOBs definitionPOSource = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponManua.getCouponDefinitionId())));
                    SendCouponDifindustryBo sendCouponDifindustryBo = new SendCouponDifindustryBo();
                    sendCouponDifindustryBo.setBatchNum(couponManua.getBatchNum());
                    sendCouponDifindustryBo.setSysCompanyId(sysAccountPo.getSysCompanyId());
                    sendCouponDifindustryBo.setSysBrandId(sysAccountPo.getBrandId());
                    sendCouponDifindustryBo.setSourceBusinessId(couponManua.getCouponManualId());
                    sendCouponDifindustryBo.setSourceBusinessType(String.valueOf(couponManua.getCouponType()));
                    sendCouponDifindustryBo.setSourceBrandId(couponManua.getSysBrandId());
                    sendCouponDifindustryBo.setCouponDefinitionPOWithBLOBs(definitionPOSource);
                    sendCouponDifindustryBoList.add(sendCouponDifindustryBo);
                }
                SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
                requestVO.setCouponDefinitionIds(couponManualPO.getCouponDefinitionId());
                requestVO.setSendType(couponManualPO.getSendType());
                requestVO.setSendTime(couponManualPO.getSendTime());
                requestVO.setBusinessId(couponManualPO.getCouponManualId());
                requestVO.setBusinessName(couponManualPO.getTaskName());
                requestVO.setBusinessType(SendTypeEnum.SEND_COUPON_BATCH.getCode());
                requestVO.setCouponManualId(couponManualPO.getCouponManualId());
                requestVO.setSysCompanyId(couponManualPO.getSysCompanyId());
                requestVO.setSysBrandId(sysAccountPo.getBrandId());
                requestVO.setCreateUserId(couponManualPO.getCreateUserId());
                requestVO.setCreateUserName(couponManualPO.getCreateUserName());
                requestVO.setCouponType(couponManualPO.getCouponType());
                ResponseData brandResponse = this.brandServiceRpc.getBrandId(sysAccountPo.getBrandId());
                if (brandResponse != null && SysResponseEnum.SUCCESS.getCode() == brandResponse.getCode()) {
                    SysBrandVo data = (SysBrandVo)brandResponse.getData();
                    requestVO.setSysBrandCode(data.getBrandCode());
                }
                logger.info("CouponManualService requestVo : {}", (Object)JacksonUtil.bean2Json((Object)requestVO));
                CouponManualPO resultPO = this.getTaskCouponType(param.getCouponManualId());
                Integer type = Integer.valueOf(SendTypeEnum.SEND_COUPON_STANDARD.getCode());
                if (type.equals(resultPO.getCouponType())) {
                    CacheThreadFactory.cacheThread().execute(() -> {
                        if (!definitionPOList.isEmpty()) {
                            this.sendNewCouponBySendType(definitionPOList, requestVO);
                        }
                        if (!sendCouponDifindustryBoList.isEmpty()) {
                            this.couponDifindustryService.sendDifindustryCouponBySendType(sendCouponDifindustryBoList, requestVO);
                        }
                    });
                } else {
                    if (resultPO.getMemberCount() != null) {
                        requestVO.setTotalNumber(resultPO.getMemberCount());
                    }
                    CacheThreadFactory.cacheThread().execute(() -> {
                        try {
                            this.sendPreCouponOrEmpCoupon((CouponDefinitionPOWithBLOBs)definitionPOList.get(0), requestVO);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    });
                }
            }
        }
        catch (NumberFormatException e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
            logger.info("error message:{}", (Object)e.getMessage());
        }
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo> findResult(CouponManualVO vo, PageFormUtil pageForm, SysAccountPo accountPo) {
        logger.info("enter CouponManualServiceImpl findResult method");
        ResponseData responseData = new ResponseData();
        vo.setSysBrandId(accountPo.getBrandId());
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        List po = this.couponManualPOMapper.findResult(vo);
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(po);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<CouponManualVO> findTotal(CouponManualVO vo, SysAccountPo accountPo) {
        logger.info("enter CouponManualServiceImpl findTotal method");
        ResponseData responseData = new ResponseData();
        CouponManualVO manualVO = this.couponManualPOMapper.findTotal(vo, accountPo.getBrandId());
        responseData.setData((Object)manualVO);
        return responseData;
    }

    public ResponseData<CouponDetailResponseVO> findById(Long couponManualId) {
        logger.info("enter CouponManualServiceImpl findById method");
        ResponseData responseData = new ResponseData();
        CouponDetailResponseVO detailVO = new CouponDetailResponseVO();
        if (null == couponManualId) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MANUAL_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponManualPO manualPO = this.couponManualPOMapper.selectByPrimaryKey(couponManualId);
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(manualPO.getCouponDefinitionId())));
        CouponManualVO couponManualVO = new CouponManualVO();
        BeanUtils.copyProperties((Object)manualPO, (Object)couponManualVO);
        detailVO.setCouponDefinitionPO((CouponDefinitionPO)definitionPO);
        detailVO.setCouponManualPO(couponManualVO);
        responseData.setData((Object)detailVO);
        return responseData;
    }

    public ResponseData<String> changeManualTask(CouponManualVO param, MembersInfoSearchVo memberInfo, SysAccountPo accountPo) throws Exception {
        logger.info("enter CouponManualServiceImpl changeManualTask method");
        ResponseData responseData = new ResponseData();
        if (null == param.getCouponManualId()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MANUAL_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == param.getCouponDefinitionId()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_DEFINITION_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)param.getMemberCodeList())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MEMBER_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        if (null == param.getSendType()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_SEND_TYPE_NOT_NULL.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(param.getCouponDefinitionId()));
        if (null == definitionPO) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_NOT_EXIST.getMessage());
            return responseData;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponManualPO manualUpdate = new CouponManualPO();
        manualUpdate.setCouponManualId(param.getCouponManualId());
        if (CouponEnum.COUPON_MANUAL_SEND_TYPE_NOW.getCode().equals(param.getSendType() + "")) {
            manualUpdate.setSendTime(TimeUtils.getNowTime());
        } else {
            manualUpdate.setSendTime(dateFormat.parse(param.getSendTimeStr()));
        }
        manualUpdate.setSysCompanyId(definitionPO.getSysCompanyId());
        manualUpdate.setSysBrandId(definitionPO.getSysBrandId());
        manualUpdate.setBrandCode(definitionPO.getBrandCode());
        manualUpdate.setTaskName(param.getTaskName());
        manualUpdate.setCouponDefinitionId(param.getCouponDefinitionId());
        manualUpdate.setCouponDefinitionName(definitionPO.getCouponName());
        manualUpdate.setSendType(param.getSendType());
        manualUpdate.setDiscountMoney(definitionPO.getMoney());
        manualUpdate.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        memberInfo.setBrandId(accountPo.getBrandId());
        manualUpdate.setMemberCondition(JSONObject.toJSONString((Object)memberInfo));
        manualUpdate.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_CHECK_WAIT.getCode().byteValue()));
        manualUpdate.setMemberCount(param.getTotalNumber());
        manualUpdate.setModifiedDate(TimeUtils.getNowTime());
        manualUpdate.setModifiedUserId(accountPo.getSysAccountId());
        manualUpdate.setModifiedUserName(accountPo.getName());
        this.couponManualPOMapper.updateByPrimaryKeySelective(manualUpdate);
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(param.getCouponManualId());
        SysCheckPo checkPo = new SysCheckPo();
        checkPo.setSysCheckId(param.getSysCheckId());
        checkPo.setSysBrandId(couponManualPO.getSysBrandId());
        checkPo.setFunctionCode("C0001");
        checkPo.setBusinessType(Integer.valueOf(Integer.parseInt(SendTypeEnum.SEND_COUPON_BATCH.getCode())));
        checkPo.setBusinessId(couponManualPO.getCouponManualId());
        checkPo.setBusinessCode(couponManualPO.getCouponManualId() + "");
        checkPo.setBusinessName(couponManualPO.getTaskName());
        checkPo.setBizName(couponManualPO.getCouponDefinitionName());
        checkPo.setCheckStatus(SystemConstants.CHECK_STATUS_WAIT);
        checkPo.setCreateDate(TimeUtils.getNowTime());
        checkPo.setCreateUserId(accountPo.getSysAccountId());
        checkPo.setCreateUserName(accountPo.getName());
        checkPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        this.sysCheckServiceRpc.updateCheck(checkPo);
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<MemberInfoModel>> findManualMembers(Long couponManualId, String name, String phone, PageFormUtil pageForm) {
        ResponseData responseData = new ResponseData();
        CouponManualPO manualPO = this.couponManualPOMapper.selectByPrimaryKey(couponManualId);
        ResponseData memberInfoResult = this.memberInfoApiService.getMemberInfoByMembersCode(pageForm.getPageNumber(), pageForm.getPageSize(), name, phone, manualPO.getMemberCodeList());
        return memberInfoResult;
    }

    public void updateTaskStatus(Long couponManualId, Byte taskStatus) {
        CouponManualPO updateManual = new CouponManualPO();
        updateManual.setCouponManualId(couponManualId);
        updateManual.setTaskStatus(taskStatus);
        this.couponManualPOMapper.updateByPrimaryKeySelective(updateManual);
    }

    public void updateByCouponManualId(CouponManualPO couponManualId) {
        this.couponManualPOMapper.updateByPrimaryKeySelective(couponManualId);
    }

    public void updateTaskStatusCheckId(Long couponManualId, Byte taskStatus, Long checkId) {
        CouponManualPO updateManual = new CouponManualPO();
        updateManual.setCouponManualId(couponManualId);
        updateManual.setTaskStatus(taskStatus);
        updateManual.setSysCheckId(checkId);
        this.couponManualPOMapper.updateByPrimaryKeySelective(updateManual);
    }

    private CouponManualPO getTaskCouponType(Long couponManualId) {
        return this.couponManualPOMapper.selectCouponTypeById(couponManualId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void findAndUpdateTaskStatus(int total, int points, Long couponManualId) {
        this.couponManualPOMapper.updateCouponManualSuccessCount(points, couponManualId);
        CouponManualPO manualPO = this.couponManualPOMapper.selectByPrimaryKey(couponManualId);
        CouponManualPO updateManual = new CouponManualPO();
        updateManual.setCouponManualId(couponManualId);
        if (manualPO.getMemberCount() <= manualPO.getSuccessCount()) {
            updateManual.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SEND_SUCCESS.getCode().byteValue()));
        } else if (manualPO.getFailCount() > 0 && manualPO.getFailCount() + manualPO.getSuccessCount() >= manualPO.getMemberCount()) {
            updateManual.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_PART_FAIL.getCode().byteValue()));
        } else {
            updateManual.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SENDING.getCode().byteValue()));
        }
        this.couponManualPOMapper.updateByPrimaryKeySelective(updateManual);
    }

    public ResponseData<JSONObject> analyzeExcel(String key) throws Exception {
        String link = key.toLowerCase().startsWith("http") ? key : this.qiNiuConfig.getDomain() + "/" + key;
        int count = this.downloadEmpIdsExcelGetIdsCount(link);
        JSONObject data = new JSONObject();
        data.put("link", (Object)link);
        data.put("empcount", (Object)count);
        return new ResponseData((Object)data);
    }

    public List<String> downloadEmpIdsExcel(String link) throws Exception {
        ResponseEntity result = this.restTemplate.postForEntity(link, null, Resource.class, new Object[0]);
        if (!result.getStatusCode().equals((Object)HttpStatus.OK)) {
            logger.error(result.toString());
            throw new BizException(200, "ExcelServiceImpl download empids excel fail !");
        }
        Resource body = (Resource)result.getBody();
        Assert.notNull((Object)body, (String)"ExcelServiceImpl download get result body is null !");
        InputStream inputStream = body.getInputStream();
        return this.analyzeExcel(inputStream);
    }

    public int downloadEmpIdsExcelGetIdsCount(String link) throws Exception {
        ResponseEntity result = this.restTemplate.postForEntity(link, null, Resource.class, new Object[0]);
        if (!result.getStatusCode().equals((Object)HttpStatus.OK)) {
            logger.error(result.toString());
            throw new BizException(200, "ExcelServiceImpl download empids excel fail !");
        }
        Resource body = (Resource)result.getBody();
        Assert.notNull((Object)body, (String)"ExcelServiceImpl download get result body is null !");
        InputStream inputStream = body.getInputStream();
        return this.analyzeExcelGetEmpIdsCount(inputStream);
    }

    public ResponseData createPreGeneratedCoupon(PreGeneratedCouponTaskCreateVO vo, SysAccountPO sysAccountPo) throws Exception {
        PreGeneratedEmpCouponCreateBO bo = PreGeneratedEmpCouponCreateBO.builder().couponDefinitionId(vo.getCouponDefinitionId()).taskName(vo.getTaskName()).totalNumber(vo.getTotalNumber()).sysAccountPO(sysAccountPo).build();
        return this.createPreGeneratedCouponOrEmpCoupon(bo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ResponseData<Long> createAlipayPreGeneratedCoupon(PreGeneratedCouponAlipayTaskCreateVO vo) {
        String redisKey = "createAlipayPreGeneratedCoupon:id:" + vo.getMktActivityAlipayVoucherRecordId();
        String value = (String)this.rs.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return new ResponseData("\u5df2\u521b\u5efa\u5bf9\u5e94\u652f\u4ed8\u5b9d\u5546\u5bb6\u5238\u6d3b\u52a8", (Object)Long.valueOf(value));
        }
        ResponseData alipayPreGeneratedCouponOrEmpCoupon = null;
        try {
            alipayPreGeneratedCouponOrEmpCoupon = this.createAlipayPreGeneratedCouponOrEmpCoupon(vo);
            if (alipayPreGeneratedCouponOrEmpCoupon != null && alipayPreGeneratedCouponOrEmpCoupon.getData() != null) {
                this.rs.opsForValue().set((Object)redisKey, (Object)((Long)alipayPreGeneratedCouponOrEmpCoupon.getData()).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            logger.info("createAlipayPreGeneratedCoupon.redisKey:{}", (Object)value);
        }
        return alipayPreGeneratedCouponOrEmpCoupon;
    }

    private ResponseData createPreGeneratedCouponOrEmpCoupon(PreGeneratedEmpCouponCreateBO bo) throws Exception {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(bo.getCouponDefinitionId());
        if (definitionPO == null) {
            responseData.setMessage(SysResponseEnum.COUPON_DEFINITION_NOT_EXSIT.getMessage());
            return responseData;
        }
        if (SystemConstants.VALID_TYPE__INTERVAL.equals(definitionPO.getValidType())) {
            Date endDate = definitionPO.getValidDateEnd();
            Date today = new Date();
            logger.info("createPreGeneratedCoupon endDate:{},today:{}", (Object)endDate, (Object)today);
            if (today.getTime() > endDate.getTime()) {
                responseData.setMessage(SysResponseEnum.COUPON_EXPIRED.getMessage());
                return responseData;
            }
        }
        CacheThreadFactory.cacheThread().execute(() -> {
            CouponManualPO couponManualPO = new CouponManualPO();
            couponManualPO.setSendTime(TimeUtils.getNowTime());
            couponManualPO.setSysCompanyId(definitionPO.getSysCompanyId());
            couponManualPO.setSysBrandId(definitionPO.getSysBrandId());
            couponManualPO.setBrandCode(definitionPO.getBrandCode());
            couponManualPO.setTaskName(bo.getTaskName());
            couponManualPO.setCouponDefinitionId(String.valueOf(bo.getCouponDefinitionId()));
            couponManualPO.setCouponDefinitionName(definitionPO.getCouponName());
            couponManualPO.setSendType(Byte.valueOf(bo.getSendType() != null ? bo.getSendType() : Byte.parseByte(CouponEnum.COUPON_MANUAL_SEND_TYPE_NOW.getCode())));
            couponManualPO.setSendTime(bo.getSendTime());
            couponManualPO.setCreateDate(TimeUtils.getNowTime());
            couponManualPO.setCreateUserId(bo.getSysAccountPO().getSysAccountId());
            couponManualPO.setCreateUserName(bo.getSysAccountPO().getName());
            couponManualPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
            couponManualPO.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_NEW.getCode().byteValue()));
            couponManualPO.setOrganizationCode(bo.getSysAccountPO().getOnlineOrgCode());
            couponManualPO.setCouponType(bo.getCouponType());
            couponManualPO.setEmpowerBrandId(bo.getEmpowerBrandId());
            couponManualPO.setBatchNum(bo.getBatchNum());
            String sysCheck = "";
            if (StringUtils.isNotBlank((CharSequence)bo.getLink())) {
                couponManualPO.setMemberCondition(bo.getLink());
                couponManualPO.setCouponType(Integer.valueOf(SendTypeEnum.SEND_COUPON_STAFF.getCode()));
                couponManualPO.setSingleEmpBindNum(bo.getSingleBindNumber());
                List ids = null;
                try {
                    ids = ((CouponManualServiceImpl)SpringContextUtil.getBean(CouponManualServiceImpl.class)).downloadEmpIdsExcel(bo.getLink());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return;
                }
                couponManualPO.setMemberCount(Integer.valueOf(ids.size() * bo.getSingleBindNumber()));
                couponManualPO.setMemberNum(Integer.valueOf(ids.size()));
                sysCheck = "C0001";
            } else if (couponManualPO.getCouponType() != null && couponManualPO.getCouponType().equals(Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()))) {
                sysCheck = "C0001";
                couponManualPO.setMemberCount(bo.getTotalNumber());
                couponManualPO.setSuccessCount(Integer.valueOf(0));
                couponManualPO.setMemberNum(Integer.valueOf(0));
            } else {
                sysCheck = "C0001";
                couponManualPO.setCouponType(Integer.valueOf(SendTypeEnum.SEND_COUPON_PRE.getCode()));
                couponManualPO.setMemberCount(bo.getTotalNumber());
            }
            Integer sendCouponNum = couponManualPO.getMemberCount();
            Boolean ifconfig = false;
            Boolean isOffLineCheck = false;
            ResponseData checkConfigListAll = this.sysCheckConfigServiceRpc.getCheckConfigListAll(bo.getSysAccountPO().getBrandId());
            if (CollectionUtils.isNotEmpty((Collection)((Collection)checkConfigListAll.getData()))) {
                StringBuilder reviewUserNameBuilder = new StringBuilder("");
                for (SysCheckConfigVo sysCheckConfigVo : (List)checkConfigListAll.getData()) {
                    if (!sysCheckConfigVo.getFunctionCode().equals(sysCheck)) continue;
                    if (sysCheckConfigVo.getCouponNum() == null) {
                        ifconfig = true;
                    } else if (sendCouponNum == null) {
                        ifconfig = true;
                    } else if (sysCheckConfigVo.getCouponNum().compareTo((long)sendCouponNum) < 0) {
                        ifconfig = true;
                    }
                    if (Integer.valueOf(1).equals(sysCheckConfigVo.getCheckType())) {
                        isOffLineCheck = true;
                    }
                    reviewUserNameBuilder.append(sysCheckConfigVo.getName()).append(",");
                }
                String reviewUserName = reviewUserNameBuilder.toString();
                if (reviewUserName.endsWith(",")) {
                    reviewUserName = reviewUserName.substring(0, reviewUserName.length() - 1);
                }
                couponManualPO.setReviewUserName(reviewUserName);
            }
            this.couponManualPOMapper.insertSelective(couponManualPO);
            if (!ifconfig.booleanValue()) {
                try {
                    SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
                    requestVO.setCouponDefinitionIds(couponManualPO.getCouponDefinitionId());
                    requestVO.setSendTime(couponManualPO.getSendTime());
                    requestVO.setBusinessName(couponManualPO.getTaskName());
                    requestVO.setBusinessId(couponManualPO.getCouponManualId());
                    requestVO.setBusinessType(SendTypeEnum.SEND_COUPON_BATCH.getCode());
                    requestVO.setCreateUserId(bo.getSysAccountPO().getSysAccountId());
                    requestVO.setCreateUserName(bo.getSysAccountPO().getName());
                    requestVO.setCouponType(couponManualPO.getCouponType());
                    requestVO.setSendType(couponManualPO.getSendType());
                    requestVO.setSendTime(couponManualPO.getSendTime());
                    if (bo.getTotalNumber() != null) {
                        requestVO.setTotalNumber(bo.getTotalNumber());
                    }
                    this.sendPreCouponOrEmpCoupon(definitionPO, requestVO);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                SysCheckPo checkPo = new SysCheckPo();
                checkPo.setSysBrandId(couponManualPO.getSysBrandId());
                checkPo.setFunctionCode(sysCheck);
                checkPo.setBusinessType(Integer.valueOf(Integer.parseInt(SendTypeEnum.SEND_COUPON_BATCH.getCode())));
                checkPo.setBusinessId(couponManualPO.getCouponManualId());
                checkPo.setBusinessCode(couponManualPO.getCouponManualId() + "");
                checkPo.setBusinessName(couponManualPO.getTaskName());
                checkPo.setBizName(couponManualPO.getCouponDefinitionName());
                checkPo.setCheckStatus(SystemConstants.CHECK_STATUS_WAIT);
                checkPo.setCreateDate(TimeUtils.getNowTime());
                checkPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
                checkPo.setCreateUserId(bo.getSysAccountPO().getSysAccountId());
                checkPo.setCreateUserName(bo.getSysAccountPO().getName());
                if (isOffLineCheck.booleanValue()) {
                    checkPo.setCheckType(Integer.valueOf(1));
                }
                ResponseData addCheckRes = this.sysCheckServiceRpc.addCheck(checkPo);
                logger.info("sysCheckServiceRpc.addCheck addCheckRes:{}", (Object)JacksonUtil.bean2Json((Object)addCheckRes));
                if (isOffLineCheck.booleanValue() && addCheckRes != null && addCheckRes.getData() != null) {
                    UrCreateCheckBo urCreateCheckBo = new UrCreateCheckBo();
                    urCreateCheckBo.setActivityCode(String.valueOf(couponManualPO.getCouponManualId()));
                    urCreateCheckBo.setActivityName(couponManualPO.getTaskName());
                    urCreateCheckBo.setActivityType("\u53d1\u5238\u4efb\u52a1-\u624b\u52a8\u53d1\u5238");
                    urCreateCheckBo.setCouponName(couponManualPO.getCouponDefinitionName());
                    urCreateCheckBo.setCouponNum(sendCouponNum);
                    urCreateCheckBo.setCheckId((Long)addCheckRes.getData());
                    urCreateCheckBo.setCreateUserId(bo.getSysAccountPO().getSysAccountId());
                    String url = "urlType=5&couponManualId=" + couponManualPO.getCouponManualId();
                    urCreateCheckBo.setTaskUrl(url);
                    Boolean responseFlag = this.urRequestUtil.postRequest(urCreateCheckBo);
                    logger.info("urRequestUtil.postRequest responseFlag:{}", (Object)responseFlag);
                }
                this.updateTaskStatusCheckId(couponManualPO.getCouponManualId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_CHECK_WAIT.getCode().byteValue()), (Long)addCheckRes.getData());
            }
        });
        return new ResponseData();
    }

    private ResponseData<Long> createAlipayPreGeneratedCouponOrEmpCoupon(PreGeneratedCouponAlipayTaskCreateVO bo) throws Exception {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(bo.getCouponDefinitionId());
        if (definitionPO == null) {
            responseData.setMessage(SysResponseEnum.COUPON_DEFINITION_NOT_EXSIT.getMessage());
            return responseData;
        }
        if (Boolean.FALSE.equals(definitionPO.getStatus())) {
            logger.info("\u5238\u5b9a\u4e49\u88ab\u505c\u7528,\u4e0d\u5141\u8bb8\u53d1\u5238,\u5238\u5b9a\u4e49id={}", (Object)definitionPO.getCouponDefinitionId());
            responseData.setCode(SysResponseEnum.COUPON_ALREADY_DEACTIVATE.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_ALREADY_DEACTIVATE.getMessage());
            return responseData;
        }
        if (SystemConstants.VALID_TYPE__INTERVAL.equals(definitionPO.getValidType())) {
            Date endDate = definitionPO.getValidDateEnd();
            Date today = new Date();
            logger.info("createAlipayPreGeneratedCouponOrEmpCoupon endDate:{},today:{}", (Object)endDate, (Object)today);
            if (today.getTime() > endDate.getTime()) {
                responseData.setMessage(SysResponseEnum.COUPON_EXPIRED.getMessage());
                return responseData;
            }
        }
        CouponManualPO couponManualPO = new CouponManualPO();
        couponManualPO.setSendTime(TimeUtils.getNowTime());
        couponManualPO.setSysCompanyId(definitionPO.getSysCompanyId());
        couponManualPO.setSysBrandId(definitionPO.getSysBrandId());
        couponManualPO.setBrandCode(definitionPO.getBrandCode());
        couponManualPO.setTaskName(bo.getTaskName());
        couponManualPO.setCouponDefinitionId(String.valueOf(bo.getCouponDefinitionId()));
        couponManualPO.setCouponDefinitionName(definitionPO.getCouponName());
        couponManualPO.setSendType(Byte.valueOf(Byte.parseByte(CouponEnum.COUPON_MANUAL_SEND_TYPE_NOW.getCode())));
        couponManualPO.setRemark(bo.getMktActivityId() + "");
        couponManualPO.setCreateDate(TimeUtils.getNowTime());
        couponManualPO.setCreateUserId(bo.getSysAccountPO().getSysAccountId());
        couponManualPO.setCreateUserName(bo.getSysAccountPO().getName());
        couponManualPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        couponManualPO.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_NEW.getCode().byteValue()));
        couponManualPO.setOrganizationCode(bo.getSysAccountPO().getOnlineOrgCode());
        couponManualPO.setCouponType(Integer.valueOf(SendTypeEnum.SEND_ALIPAY_VOUCHER.getCode()));
        couponManualPO.setMemberCount(bo.getTotalNumber());
        this.couponManualPOMapper.insertSelective(couponManualPO);
        CacheThreadFactory.cacheThread().execute(() -> {
            SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
            requestVO.setCouponDefinitionIds(couponManualPO.getCouponDefinitionId());
            requestVO.setSendType(couponManualPO.getSendType());
            requestVO.setSendTime(couponManualPO.getSendTime());
            requestVO.setBusinessName(couponManualPO.getTaskName());
            requestVO.setBusinessId(couponManualPO.getCouponManualId());
            requestVO.setBusinessType(SendTypeEnum.SEND_ALIPAY_VOUCHER.getCode());
            requestVO.setCreateUserId(bo.getSysAccountPO().getSysAccountId());
            requestVO.setCreateUserName(bo.getSysAccountPO().getName());
            requestVO.setCouponType(couponManualPO.getCouponType());
            requestVO.setMktActivityId(bo.getMktActivityId());
            if (bo.getTotalNumber() != null) {
                requestVO.setTotalNumber(bo.getTotalNumber());
            }
            try {
                TimeUnit.SECONDS.sleep(5L);
                logger.info("\u652f\u4ed8\u5b9d\u5546\u5bb6\u5238\u5ef6\u8fdf5s\u5f00\u59cb\u53d1\u653e");
                this.sendPreCouponOrEmpCoupon(definitionPO, requestVO);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u521b\u5efa\u652f\u4ed8\u5b9d\u5546\u5bb6\u5238\u53d1\u5238\u6d3b\u52a8\u6210\u529f");
        responseData.setData((Object)couponManualPO.getCouponManualId());
        return responseData;
    }

    private void sendPreCouponOrEmpCoupon(CouponDefinitionPOWithBLOBs definitionPO, SendCouponBatchRequestVO requestVO) throws Exception {
        if (SendTypeEnum.SEND_COUPON_STAFF.getCode().equals(requestVO.getCouponType() + "") && CouponEnum.COUPON_MANUAL_SEND_TYPE_SOMEDAY.getCode().equals(requestVO.getSendType() + "") && requestVO.getSendTime() != null && requestVO.getSendTime().after(new Date())) {
            logger.info("sendPreCouponOrEmpCoupon \u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u53d1\u5238");
            this.addSendCouponBatchJob(requestVO);
            return;
        }
        logger.info("sendPreCouponOrEmpCoupon \u6279\u6b21\u53f7\u751f\u6210");
        CouponBatchSendRecordPO batchPO = this.sendCouponService.saveNewCouponBatchRecord(definitionPO.getSysCompanyId(), definitionPO.getSysBrandId(), definitionPO.getBrandCode(), requestVO.getCouponDefinitionIds(), requestVO);
        requestVO.setBatchSendCode(batchPO.getBatchSendCode());
        requestVO.setBatchSendCodeDetail(Long.valueOf(BusinessCodeUtil.getCouponBatchSendCodelong()));
        definitionPO.setBatchSendCodeDetail(requestVO.getBatchSendCodeDetail());
        this.sendCouponService.saveNewCouponBatchRecordDetail(definitionPO.getSysCompanyId(), definitionPO.getSysBrandId(), definitionPO.getBrandCode(), definitionPO, requestVO);
        Integer couponType = requestVO.getCouponType();
        if (Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()).equals(couponType)) {
            Integer totalNumber = requestVO.getTotalNumber();
            CouponManualPO manualPO = this.couponManualPOMapper.selectByPrimaryKey(requestVO.getBusinessId());
            CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
            BeanUtils.copyProperties((Object)definitionPO, (Object)couponDefinitionVO);
            couponDefinitionVO.setBatchNum(manualPO.getBatchNum());
            couponDefinitionVO.setSysBrandId(manualPO.getEmpowerBrandId());
            couponDefinitionVO.setSourceBrandId(manualPO.getSysBrandId());
            couponDefinitionVO.setTotalQuantiy(totalNumber);
            couponDefinitionVO.setManualId(manualPO.getCouponManualId());
            this.couponDifindustryService.createCouponPool(couponDefinitionVO);
            return;
        }
        if (SystemConstants.USE_CHANNEL_ONLINE.equals(definitionPO.getUseChannel())) {
            this.updateTaskStatus(requestVO.getBusinessId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SENDING.getCode().byteValue()));
        } else {
            this.updateTaskStatus(requestVO.getBusinessId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SYNCING.getCode().byteValue()));
        }
        this.sendCouponMqService.sendPreCouponOrEmpCouponMq(definitionPO, requestVO, batchPO);
    }

    public ResponseData createEmpCoupon(EmpCouponTaskCreateVO vo, SysAccountPO sysAccountPo) throws Exception {
        PreGeneratedEmpCouponCreateBO bo = PreGeneratedEmpCouponCreateBO.builder().couponDefinitionId(vo.getCouponDefinitionId()).taskName(vo.getTaskName()).singleBindNumber(vo.getSingleBindNumber()).link(vo.getLink()).sysAccountPO(sysAccountPo).sendType(Byte.valueOf(vo.getSendType() != null ? vo.getSendType() : (byte)1)).sendTime(CouponEnum.COUPON_MANUAL_SEND_TYPE_SOMEDAY.getCode().equals(vo.getSendType() + "") && StringUtils.isNotBlank((CharSequence)vo.getSendTimeStr()) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(vo.getSendTimeStr()) : TimeUtils.getNowTime()).build();
        return this.createPreGeneratedCouponOrEmpCoupon(bo);
    }

    public ResponseData modifyPreGeneratedCouponTask(ModifyPreCouponTaskVO vo, SysAccountPO sysAccountPo) {
        SysCheckPo rpo = new SysCheckPo();
        rpo.setFunctionCode("C0001");
        rpo.setBusinessId(vo.getCouponManualId());
        if (vo.getClose() != null && vo.getClose().booleanValue()) {
            logger.info("modifyPreGeneratedCouponTask \u4efb\u52a1\u5f00\u59cb\u4f5c\u5e9f\uff0cid : {}", (Object)vo.getCouponManualId());
            int count = this.obsoleteTask(vo.getCouponManualId(), sysAccountPo);
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u4f5c\u5e9f\u4efb\u52a1\u64cd\u4f5c\u5931\u8d25");
            CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(vo.getCouponManualId());
            if (couponManualPO.getTaskStatus() != 10) {
                this.rs.opsForValue().set((Object)("OBSOLETE_SEND_COUPON_TASK_ID_" + vo.getCouponManualId()), (Object)OBSOLETE_SEND_COUPON_TASK_VALUE);
            }
            rpo.setValid(Boolean.valueOf(false));
        } else {
            CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(vo.getCouponManualId());
            Assert.isTrue((CouponManualTaskStatusEnum.TASK_STATUS_CHECK_WAIT.getCode().intValue() == couponManualPO.getTaskStatus().byteValue() ? 1 : 0) != 0, (String)"\u4efb\u52a1\u5df2\u7ecf\u7ecf\u8fc7\u5ba1\u6838\uff0c\u4e0d\u80fd\u4fee\u6539\u76f8\u5173\u4fe1\u606f");
            couponManualPO = new CouponManualPO();
            couponManualPO.setCouponManualId(vo.getCouponManualId());
            if (StringUtils.isNotBlank((CharSequence)vo.getTaskName())) {
                couponManualPO.setTaskName(vo.getTaskName());
            }
            couponManualPO.setMemberCount(vo.getTotalNumber());
            couponManualPO.setModifiedDate(new Date());
            couponManualPO.setModifiedUserName(sysAccountPo.getName());
            int count = this.couponManualPOMapper.updateByPrimaryKeySelective(couponManualPO);
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u4efb\u52a1\u64cd\u4f5c\u5931\u8d25");
            rpo.setBusinessName(vo.getTaskName());
        }
        this.sysCheckServiceRpc.updateCheckName(rpo);
        return new ResponseData();
    }

    public ResponseData modifyEmpCouponTask(Long couponManualId, SysAccountPO sysAccountPo) {
        int count = this.obsoleteTask(couponManualId, sysAccountPo);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u4f5c\u5e9f\u4efb\u52a1\u64cd\u4f5c\u5931\u8d25");
        this.rs.opsForValue().set((Object)("OBSOLETE_SEND_COUPON_TASK_ID_" + couponManualId), (Object)OBSOLETE_SEND_COUPON_TASK_VALUE);
        return new ResponseData();
    }

    public ResponseData<CouponDetailResponseVO> getCouponManualDetailById(Long couponManualId) {
        CouponDetailResponseVO data;
        CouponManualVO couponManualPO;
        ResponseData responseData = this.findNewById(couponManualId);
        if (responseData.getCode() == 0 && responseData.getData() != null && StringUtils.isNotEmpty((CharSequence)(couponManualPO = (data = (CouponDetailResponseVO)responseData.getData()).getCouponManualPO()).getMemberCondition())) {
            JSONObject jsonObject = JSONObject.parseObject((String)couponManualPO.getMemberCondition());
            jsonObject.remove((Object)"brandId");
            couponManualPO.setMemberCondition(jsonObject.toString());
        }
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public CouponManualPO getCouponManualPoById(Long couponManualid) {
        return this.couponManualPOMapper.selectByPrimaryKey(couponManualid);
    }

    public ResponseData<Boolean> getIsDefinitionCode(CouponDefinitionPOWithBLOBs couponDefinitionPo) {
        ResponseData responseData = new ResponseData();
        logger.info("enter CouponManualServiceImpl getIsDefinitionCode method params\uff1a{}", (Object)JacksonUtil.bean2Json((Object)couponDefinitionPo));
        CouponDefinitionCodePOExample couponExample = new CouponDefinitionCodePOExample();
        CouponDefinitionCodePOExample.Criteria criteria = couponExample.createCriteria();
        criteria.andCouponDefinitionIdEqualTo(couponDefinitionPo.getCouponDefinitionId());
        criteria.andSysBrandIdEqualTo(couponDefinitionPo.getSysBrandId());
        List allCouponDefinitionCodePOList = this.couponDefinitionCodePOMapper.selectByExampleCode(couponExample);
        if (CollectionUtils.isEmpty((Collection)allCouponDefinitionCodePOList)) {
            logger.info("enter CouponManualServiceImpl getIsDefinitionCode all \u6ca1\u6709\u5238\u53f7,\u4e0d\u505a\u6821\u9a8c:" + couponDefinitionPo.getCouponDefinitionId() + " sysBrandId" + couponDefinitionPo.getSysBrandId());
            responseData.setData((Object)true);
            return responseData;
        }
        criteria.andStatusEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List couponDefinitionCodePOList = this.couponDefinitionCodePOMapper.selectByExampleCode(couponExample);
        if (CollectionUtils.isEmpty((Collection)couponDefinitionCodePOList)) {
            logger.info("enter CouponManualServiceImpl getIsDefinitionCode methodNOtcode \u6ca1\u6709\u5238\u53f7\u4e86" + couponDefinitionPo.getCouponDefinitionId() + " sysBrandId" + couponDefinitionPo.getSysBrandId());
            responseData.setData((Object)false);
            responseData.setMessage("\u6ca1\u6709\u5238\u53f7\u4e86");
            return responseData;
        }
        responseData.setData((Object)true);
        return responseData;
    }

    public void updateMqMbrMemberId(Long couponManualId, Long mqMbrMemberId, int mqState) {
        CouponManualPO updateManual = new CouponManualPO();
        updateManual.setCouponManualId(couponManualId);
        if (mqMbrMemberId != null) {
            updateManual.setMqMbrMemberId(mqMbrMemberId);
        }
        updateManual.setMqState(Integer.valueOf(mqState));
        this.couponManualPOMapper.updateByPrimaryKeySelective(updateManual);
    }

    public void updateMqCouponJson(Long couponManualId, String mqCouponJson) {
        CouponManualPO updateManual = new CouponManualPO();
        updateManual.setCouponManualId(couponManualId);
        updateManual.setMqCouponJson(mqCouponJson);
        this.couponManualPOMapper.updateByPrimaryKeySelective(updateManual);
    }

    public ResponseData createDifIndustryCoupon(PreGeneratedCouponTaskCreateVO vo, SysAccountPO sysAccountPo) throws Exception {
        PreGeneratedEmpCouponCreateBO bo = new PreGeneratedEmpCouponCreateBO();
        BeanUtils.copyProperties((Object)vo, (Object)bo);
        bo.setCouponType(Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()));
        PageHelper.startPage((int)1, (int)1, (boolean)false);
        CouponManualPOExample example = new CouponManualPOExample();
        CouponManualPOExample.Criteria criteria = example.createCriteria();
        criteria.andValidEqualTo(Boolean.valueOf(true));
        criteria.andSysCompanyIdEqualTo(sysAccountPo.getSysCompanyId());
        criteria.andSysBrandIdEqualTo(sysAccountPo.getBrandId());
        criteria.andCouponTypeEqualTo(Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()));
        example.setOrderByClause("create_date DESC");
        List list = this.couponManualPOMapper.selectByExample(example);
        String batchNum = null;
        if (list != null && list.size() > 0) {
            CouponManualPO couponManualPO = (CouponManualPO)list.get(0);
            int anInt = Integer.parseInt(couponManualPO.getBatchNum());
            batchNum = String.valueOf(anInt + 1);
        } else {
            batchNum = String.valueOf(1000001);
        }
        bo.setBatchNum(batchNum);
        bo.setSysAccountPO(sysAccountPo);
        ResponseData responseData = this.createPreGeneratedCouponOrEmpCoupon(bo);
        return responseData;
    }

    public ResponseData<PageInfo<CouponDefinitionVO>> selectCouponDifindustryPage(CouponManualVO vo, SysAccountPO sysAccountPo) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        vo.setCouponType(Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()));
        vo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        vo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        vo.setEmpowerBrandId(sysAccountPo.getBrandId());
        vo.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SEND_SUCCESS.getCode().byteValue()));
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List list = this.couponManualPOMapper.selectCouponDifindustryPage(vo);
        if (list != null && list.size() > 0) {
            List data;
            List longList = list.stream().map(CouponDefinitionPO::getSysBrandId).collect(Collectors.toList());
            SysBrandVo sysBrandVo = new SysBrandVo();
            sysBrandVo.setSysCompanyId(sysAccountPo.getSysCompanyId());
            sysBrandVo.setSysBrandIdList(longList);
            ResponseData barndListByBrandIds = this.brandServiceRpc.getBarndListByBrandIds(sysBrandVo);
            if (barndListByBrandIds != null && SysResponseEnum.SUCCESS.getCode() == barndListByBrandIds.getCode() && (data = (List)barndListByBrandIds.getData()) != null && !data.isEmpty()) {
                Map modelMap = data.stream().collect(Collectors.toMap(SysBrandPo::getSysBrandId, Function.identity(), (a, b) -> a));
                list.forEach(t -> {
                    if (modelMap != null && modelMap.containsKey(t.getSysBrandId())) {
                        SysBrandPo SysBrandPo2 = (SysBrandPo)modelMap.get(t.getSysBrandId());
                        t.setSourceBrandName(SysBrandPo2.getBrandName());
                    }
                });
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        responseData.setData((Object)pageInfo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<List<CouponDifindustryVO>> getDifindustryCouponSourceBrand(CouponManualVO vo) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        CouponManualPOExample example = new CouponManualPOExample();
        CouponManualPOExample.Criteria criteria = example.createCriteria();
        criteria.andCouponManualIdIn(vo.getCouponManualIdList());
        criteria.andValidEqualTo(SystemConstants.VALID);
        criteria.andSysCompanyIdEqualTo(vo.getSysCompanyId());
        criteria.andCouponTypeEqualTo(Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()));
        List list = this.couponManualPOMapper.selectByExample(example);
        Map brandPoMap = null;
        List collectList = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List data;
            List longList = list.stream().map(CouponManualPO::getSysBrandId).collect(Collectors.toList());
            SysBrandVo sysBrandVo = new SysBrandVo();
            sysBrandVo.setSysCompanyId(vo.getSysCompanyId());
            sysBrandVo.setSysBrandIdList(longList);
            ResponseData barndListByBrandIds = this.brandServiceRpc.getBarndListByBrandIds(sysBrandVo);
            if (barndListByBrandIds != null && SysResponseEnum.SUCCESS.getCode() == barndListByBrandIds.getCode() && (data = (List)barndListByBrandIds.getData()) != null && !data.isEmpty()) {
                brandPoMap = data.stream().collect(Collectors.toMap(SysBrandPo::getSysBrandId, Function.identity(), (a, b) -> a));
            }
            Map finalBrandPoMap = brandPoMap;
            collectList = list.stream().map(t -> {
                CouponDifindustryVO couponDifindustryVO = new CouponDifindustryVO();
                couponDifindustryVO.setCouponManualId(t.getCouponManualId());
                if (finalBrandPoMap != null && finalBrandPoMap.containsKey(t.getSysBrandId())) {
                    couponDifindustryVO.setSourceBrandId(t.getSysBrandId());
                    couponDifindustryVO.setSourceBrandName(((SysBrandPo)finalBrandPoMap.get(t.getSysBrandId())).getBrandName());
                }
                return couponDifindustryVO;
            }).collect(Collectors.toList());
        }
        responseData.setData(collectList);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<String> sendStaffCoupon(CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs, SendCouponBatchRequestVO requestVO) {
        try {
            this.sendPreCouponOrEmpCoupon(couponDefinitionPOWithBLOBs, requestVO);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u5458\u5de5\u5238\u5f02\u5e38\uff1a{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u53d1\u9001\u5458\u5de5\u5238\u5f02\u5e38:" + e.getMessage());
        }
        return new ResponseData();
    }

    private int obsoleteTask(Long couponManualId, SysAccountPO sysAccountPO) {
        CouponManualPO manualPO = new CouponManualPO();
        manualPO.setCouponManualId(couponManualId);
        manualPO.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_CANCEL.getCode().byteValue()));
        manualPO.setModifiedDate(TimeUtils.getNowTime());
        manualPO.setModifiedUserId(sysAccountPO.getSysAccountId());
        manualPO.setModifiedUserName(sysAccountPO.getName());
        return this.couponManualPOMapper.updateByPrimaryKeySelective(manualPO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCouponManualCount(String useStoreId, Long manualId, BigDecimal profitMoney, BigDecimal discountMoney) {
        CouponManualPO manualPO = this.couponManualPOMapper.selectByPrimaryKey(manualId);
        Integer cancelCount = manualPO.getCancelCount() == null ? 0 : manualPO.getCancelCount() + 1;
        if (profitMoney != null) {
            profitMoney = (manualPO.getProfitMoney() == null ? BigDecimal.ZERO : manualPO.getProfitMoney()).add(profitMoney);
        }
        if (discountMoney != null) {
            BigDecimal bigDecimal = discountMoney = manualPO.getDiscountMoney() == null ? BigDecimal.ZERO : manualPO.getDiscountMoney().add(discountMoney);
        }
        if (StringUtils.isNotEmpty((CharSequence)useStoreId)) {
            JSONObject useStores = new JSONObject();
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{manualPO.getStoreids()})) {
                useStores = JSONObject.parseObject((String)manualPO.getStoreids());
            }
            useStores.put(useStoreId, (Object)useStoreId);
            manualPO.setStoreids(useStores.toString());
        }
        manualPO.setCancelCount(cancelCount);
        manualPO.setProfitMoney(profitMoney);
        manualPO.setDiscountMoney(discountMoney);
        this.couponManualPOMapper.updateByPrimaryKeySelective(manualPO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> addNewTask(CouponManualVO param, MembersInfoSearchVo memberInfo, SysAccountPO accountPo) throws Exception {
        logger.info("enter CouponManualServiceImpl addTask method:CouponManualVO:{},MembersInfoSearchVo:{}", (Object)JSONObject.toJSONString((Object)param), (Object)JSONObject.toJSONString((Object)memberInfo));
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)param.getTaskName())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.TASK_NAME_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)param.getCouponDefinitionIds()) && param.getMktGiftBagId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u9009\u62e9\u5238\u6216\u793c\u5305");
            return responseData;
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCouponDefinitionIds()) && param.getCouponDefinitionIds().contains(",") && param.getCouponDefinitionIds().split(",").length > 20) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_DEFINITION_ID_LIST_MORE_20.getMessage());
            return responseData;
        }
        if (null == param.getSendType()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_SEND_TYPE_NOT_NULL.getMessage());
            return responseData;
        }
        if (CouponEnum.COUPON_MANUAL_SEND_TYPE_SOMEDAY.getCode().equals(param.getSendType() + "") && StringUtils.isBlank((CharSequence)param.getSendTimeStr())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.SEND_TIME_NOT_NULL.getMessage());
            return responseData;
        }
        if (param.getTotalNumber() == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.MEMBER_IS_NULL.getMessage());
            return responseData;
        }
        ArrayList<CouponDefinitionPOWithBLOBs> definitionPOList = new ArrayList<CouponDefinitionPOWithBLOBs>();
        ArrayList<SendCouponDifindustryBo> sendCouponDifindustryBoList = new ArrayList<SendCouponDifindustryBo>();
        StringBuffer definitionIdStr = new StringBuffer();
        StringBuffer definitionNameStr = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)param.getCouponDefinitionIds())) {
            definitionIdStr.append(param.getCouponDefinitionIds());
            String[] idArray = param.getCouponDefinitionIds().split(",");
            Date date = new Date();
            for (int i = 0; i < idArray.length; ++i) {
                String id = idArray[i];
                boolean numeric = DigitalJudgmentUtil.isNumeric((String)id);
                if (numeric) {
                    Date validDateEnd;
                    CouponDefinitionPOWithBLOBs definitionPOSource = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(idArray[i])));
                    if (definitionPOSource == null) {
                        responseData.setCode(SysResponseEnum.FAILED.getCode());
                        responseData.setMessage(SysResponseEnum.COUPON_NOT_EXIST.getMessage());
                        return responseData;
                    }
                    if (SystemConstants.VALID_TYPE__INTERVAL.equals(definitionPOSource.getValidType()) && (validDateEnd = definitionPOSource.getValidDateEnd()).getTime() < date.getTime()) {
                        responseData.setCode(SysResponseEnum.FAILED.getCode());
                        responseData.setMessage(SysResponseEnum.COUPON_EXPIRED.getMessage());
                        return responseData;
                    }
                    definitionPOList.add(definitionPOSource);
                    definitionNameStr.append(definitionPOSource.getCouponName()).append("\u3001");
                    continue;
                }
                String[] split = id.split("_");
                String bandId = split[0];
                String menualId = split[1];
                CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(menualId)));
                if (couponManualPO != null && Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()).equals(couponManualPO.getCouponType())) {
                    Date validDateEnd;
                    CouponDefinitionPOWithBLOBs definitionPOSource = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponManualPO.getCouponDefinitionId())));
                    if (SystemConstants.VALID_TYPE__INTERVAL.equals(definitionPOSource.getValidType()) && (validDateEnd = definitionPOSource.getValidDateEnd()).getTime() < date.getTime()) {
                        responseData.setCode(SysResponseEnum.FAILED.getCode());
                        responseData.setMessage(SysResponseEnum.COUPON_DIF_INDUSTRY_EXPIRED.getMessage());
                        return responseData;
                    }
                    SendCouponDifindustryBo sendCouponDifindustryBo = new SendCouponDifindustryBo();
                    sendCouponDifindustryBo.setBatchNum(couponManualPO.getBatchNum());
                    sendCouponDifindustryBo.setSysCompanyId(accountPo.getSysCompanyId());
                    sendCouponDifindustryBo.setSysBrandId(accountPo.getBrandId());
                    sendCouponDifindustryBo.setSourceBusinessId(couponManualPO.getCouponManualId());
                    sendCouponDifindustryBo.setSourceBusinessType(String.valueOf(couponManualPO.getCouponType()));
                    sendCouponDifindustryBo.setSourceBrandId(couponManualPO.getSysBrandId());
                    sendCouponDifindustryBo.setCouponDefinitionPOWithBLOBs(definitionPOSource);
                    sendCouponDifindustryBoList.add(sendCouponDifindustryBo);
                    definitionNameStr.append(definitionPOSource.getCouponName()).append("\u3001");
                    continue;
                }
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.COUPON_DIF_INDUSTRY_NOT_EXISTS.getMessage());
                return responseData;
            }
            definitionNameStr.deleteCharAt(definitionNameStr.length() - 1);
        }
        if (param.getMktGiftBagId() != null) {
            if (definitionIdStr.length() > 0) {
                definitionIdStr.append(",");
                definitionNameStr.append("\u3001");
            }
            MktGiftBagPO mktGiftBagPO = new MktGiftBagPO();
            mktGiftBagPO.setMktGiftBagId(param.getMktGiftBagId());
            mktGiftBagPO.setSysBrandId(accountPo.getBrandId());
            mktGiftBagPO.setSysCompanyId(accountPo.getSysCompanyId());
            ResponseData activityGiftbagBOResponseData = this.sendCouponServiceRpc.selectGiftBagDetailForCounpon(mktGiftBagPO);
            if (activityGiftbagBOResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && activityGiftbagBOResponseData.getData() != null) {
                ActivityGiftbagBO data = (ActivityGiftbagBO)activityGiftbagBOResponseData.getData();
                StringBuilder bagDefIds = new StringBuilder();
                if (data.getCouponDefinitionPOList().size() > 0) {
                    for (int i = 0; i < data.getCouponDefinitionPOList().size(); ++i) {
                        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = (CouponDefinitionPOWithBLOBs)data.getCouponDefinitionPOList().get(i);
                        CouponDefinitionPOWithBLOBs definitionPO = new CouponDefinitionPOWithBLOBs();
                        CouponDefinitionPOWithBLOBs definitionPOSource = this.couponDefinitionPOMapper.selectByPrimaryKey(couponDefinitionPOWithBLOBs.getCouponDefinitionId());
                        if (definitionPOSource == null) continue;
                        BeanUtils.copyProperties((Object)definitionPOSource, (Object)definitionPO);
                        if (SystemConstants.VALID_TYPE__INTERVAL.equals(definitionPO.getValidType())) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            Date endDate = format.parse(format.format(definitionPO.getValidDateEnd()));
                            Date today = format.parse(format.format(new Date()));
                            logger.info("bbbbbbbbbbbbbbbbbbbbbbbbbbbb endDate:{},today:{}", (Object)JSONObject.toJSONString((Object)endDate), (Object)JSONObject.toJSONString((Object)today));
                            if (endDate.getTime() < today.getTime()) continue;
                        }
                        definitionIdStr.append(definitionPOSource.getCouponDefinitionId()).append(",");
                        definitionPOList.add(definitionPO);
                    }
                }
                if (definitionIdStr.length() > 0) {
                    definitionIdStr.deleteCharAt(definitionIdStr.length() - 1);
                }
                definitionNameStr.append(data.getMktGiftBagPO().getMktGiftBagName());
            } else {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u793c\u5305\u67e5\u8be2\u5931\u8d25");
                return responseData;
            }
        }
        if (StringUtils.isBlank((CharSequence)definitionIdStr)) {
            responseData.setCode(SysResponseEnum.COUPON_EXPIRED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_EXPIRED.getMessage());
            return responseData;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponManualPO couponManualPO = new CouponManualPO();
        couponManualPO.setCouponType(Integer.valueOf(Integer.parseInt(SendTypeEnum.SEND_COUPON_STANDARD.getCode())));
        couponManualPO.setCouponDefinitionId(definitionIdStr.toString());
        couponManualPO.setCouponDefinitionName(definitionNameStr.toString());
        if (CouponEnum.COUPON_MANUAL_SEND_TYPE_NOW.getCode().equals(param.getSendType() + "")) {
            couponManualPO.setSendTime(TimeUtils.getNowTime());
        } else {
            couponManualPO.setSendTime(dateFormat.parse(param.getSendTimeStr()));
        }
        couponManualPO.setSysCompanyId(accountPo.getSysCompanyId());
        couponManualPO.setSysBrandId(accountPo.getBrandId());
        couponManualPO.setTaskName(param.getTaskName());
        couponManualPO.setMemberConditionType(param.getMemberConditionType());
        couponManualPO.setSendType(param.getSendType());
        couponManualPO.setCreateDate(TimeUtils.getNowTime());
        couponManualPO.setCreateUserId(accountPo.getSysAccountId());
        couponManualPO.setCreateUserName(accountPo.getName());
        couponManualPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        memberInfo.setBrandId(accountPo.getBrandId());
        memberInfo.setOnlineOrgCode(accountPo.getOnlineOrgCode());
        couponManualPO.setMemberCondition(JSONObject.toJSONString((Object)memberInfo));
        couponManualPO.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_NEW.getCode().byteValue()));
        couponManualPO.setMemberNum(param.getTotalNumber());
        if (param.getMktGiftBagId() != null) {
            couponManualPO.setMktGiftBagId(param.getMktGiftBagId());
        }
        Integer sendCouponNum = definitionPOList.size() * param.getTotalNumber();
        sendCouponNum = sendCouponNum + sendCouponDifindustryBoList.size() * param.getTotalNumber();
        ResponseData checkConfigListAll = this.sysCheckConfigServiceRpc.getCheckConfigListAll(accountPo.getBrandId());
        Integer couponNum = 0;
        Boolean isOffLineCheck = false;
        if (CollectionUtils.isNotEmpty((Collection)((Collection)checkConfigListAll.getData()))) {
            StringBuilder reviewUserNameBuilder = new StringBuilder("");
            for (SysCheckConfigVo sysCheckConfigVo : (List)checkConfigListAll.getData()) {
                if (!sysCheckConfigVo.getFunctionCode().equals("C0001")) continue;
                couponNum = sysCheckConfigVo.getCouponNum() != null ? sysCheckConfigVo.getCouponNum().intValue() : 0;
                if (sendCouponNum <= couponNum) continue;
                reviewUserNameBuilder.append(sysCheckConfigVo.getName()).append(",");
                couponManualPO.setReviewUserId(sysCheckConfigVo.getSysCheckConfigId());
                if (null == sysCheckConfigVo.getCheckType() || 1 != sysCheckConfigVo.getCheckType()) continue;
                isOffLineCheck = true;
            }
            String reviewUserName = reviewUserNameBuilder.toString();
            if (reviewUserName.endsWith(",")) {
                reviewUserName = reviewUserName.substring(0, reviewUserName.length() - 1);
            }
            couponManualPO.setReviewUserName(reviewUserName);
        }
        couponManualPO.setRemark("\u4efb\u52a1\u521b\u5efatrace:" + this.traceService.trace());
        couponManualPO.setOrganizationCode(accountPo.getOnlineOrgCode());
        this.couponManualPOMapper.insertSelective(couponManualPO);
        SysCheckConfigPo checkConfigPO = new SysCheckConfigPo();
        checkConfigPO.setSysBrandId(accountPo.getBrandId());
        checkConfigPO.setFunctionCode("C0001");
        ResponseData checkConfigResult = this.sysCheckConfigServiceRpc.ifCheckConfig(checkConfigPO);
        if (SysResponseEnum.SUCCESS.getCode() != checkConfigResult.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(checkConfigResult.getMessage());
            return responseData;
        }
        SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
        requestVO.setCouponDefinitionIds(couponManualPO.getCouponDefinitionId());
        requestVO.setSendType(couponManualPO.getSendType());
        requestVO.setSendTime(couponManualPO.getSendTime());
        requestVO.setBusinessName(couponManualPO.getTaskName());
        requestVO.setBusinessId(couponManualPO.getCouponManualId());
        requestVO.setBusinessType(SendTypeEnum.SEND_COUPON_BATCH.getCode());
        requestVO.setCreateUserId(accountPo.getSysAccountId());
        requestVO.setCreateUserName(accountPo.getName());
        requestVO.setSysBrandId(accountPo.getBrandId());
        requestVO.setSysCompanyId(accountPo.getSysCompanyId());
        requestVO.setCouponManualId(couponManualPO.getCouponManualId());
        requestVO.setCouponType(couponManualPO.getCouponType());
        ResponseData brandResponse = this.brandServiceRpc.getBrandId(accountPo.getBrandId());
        if (brandResponse != null && SysResponseEnum.SUCCESS.getCode() == brandResponse.getCode()) {
            SysBrandVo data = (SysBrandVo)brandResponse.getData();
            requestVO.setSysBrandCode(data.getBrandCode());
        }
        if (SystemConstants.CHECK_UNNEED.equals(checkConfigResult.getData()) || sendCouponNum <= couponNum) {
            1 runnable = new /* Unavailable Anonymous Inner Class!! */;
            ThreadPool.run((Runnable)runnable);
        } else {
            SysCheckPo checkPo = new SysCheckPo();
            checkPo.setSysBrandId(couponManualPO.getSysBrandId());
            checkPo.setFunctionCode("C0001");
            checkPo.setBusinessType(Integer.valueOf(Integer.parseInt(SendTypeEnum.SEND_COUPON_BATCH.getCode())));
            checkPo.setBusinessId(couponManualPO.getCouponManualId());
            checkPo.setBusinessCode(couponManualPO.getCouponManualId() + "");
            checkPo.setBusinessName(couponManualPO.getTaskName());
            checkPo.setBizName(couponManualPO.getCouponDefinitionName());
            checkPo.setCheckStatus(SystemConstants.CHECK_STATUS_WAIT);
            checkPo.setCreateDate(TimeUtils.getNowTime());
            checkPo.setCreateUserId(accountPo.getSysAccountId());
            checkPo.setCreateUserName(accountPo.getName());
            checkPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
            if (isOffLineCheck.booleanValue()) {
                checkPo.setCheckType(Integer.valueOf(1));
            }
            ResponseData checkData = this.sysCheckServiceRpc.addCheck(checkPo);
            if (isOffLineCheck.booleanValue() && null != checkData && 0 == checkData.getCode()) {
                UrCreateCheckBo bo = new UrCreateCheckBo();
                bo.setActivityCode(String.valueOf(couponManualPO.getCouponManualId()));
                bo.setActivityName(couponManualPO.getTaskName());
                bo.setActivityType("\u53d1\u5238\u4efb\u52a1-\u624b\u52a8\u53d1\u5238");
                bo.setCouponName(couponManualPO.getCouponDefinitionName());
                bo.setCouponNum(sendCouponNum);
                bo.setCheckId((Long)checkData.getData());
                bo.setCreateUserId(accountPo.getSysAccountId());
                String url = "urlType=5&couponManualId=" + couponManualPO.getCouponManualId();
                bo.setTaskUrl(url);
                Boolean bl = this.urRequestUtil.postRequest(bo);
            }
            this.updateTaskStatus(couponManualPO.getCouponManualId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_CHECK_WAIT.getCode().byteValue()));
        }
        return responseData;
    }

    private ResponseData<String> sendNewCouponBySendType(List<CouponDefinitionPOWithBLOBs> definitionPOList, SendCouponBatchRequestVO requestVO) {
        ResponseData responseData = new ResponseData();
        if (CouponEnum.COUPON_MANUAL_SEND_TYPE_NOW.getCode().equals(requestVO.getSendType() + "") || this.checkSendDateBeforeNow(requestVO)) {
            ObjectConvertUtils.sort(definitionPOList);
            this.sendNewCouponByUseChannel(definitionPOList, requestVO);
        } else if (CouponEnum.COUPON_MANUAL_SEND_TYPE_SOMEDAY.getCode().equals(requestVO.getSendType() + "")) {
            this.addSendCouponBatchJob(requestVO);
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.SEND_TYPE_NOT_EXISTS.getMessage());
            return responseData;
        }
        return responseData;
    }

    private boolean checkSendDateBeforeNow(SendCouponBatchRequestVO requestVO) {
        return requestVO.getSendTime() != null && requestVO.getSendTime().before(new Date());
    }

    public ResponseData<String> sendNewCouponByUseChannel(List<CouponDefinitionPOWithBLOBs> definitionPoList, SendCouponBatchRequestVO param) {
        ResponseData responseData = new ResponseData();
        CouponBatchSendRecordPO batchPO = this.sendCouponService.saveNewCouponBatchRecord(definitionPoList.get(0).getSysCompanyId(), definitionPoList.get(0).getSysBrandId(), definitionPoList.get(0).getBrandCode(), param.getCouponDefinitionIds(), param);
        ArrayList<SendCouponBatchRequestVO> requestVOList = new ArrayList<SendCouponBatchRequestVO>();
        for (int i = 0; i < definitionPoList.size(); ++i) {
            CouponDefinitionPOWithBLOBs po = definitionPoList.get(i);
            SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
            BeanUtils.copyProperties((Object)param, (Object)requestVO);
            requestVO.setBatchSendCode(batchPO.getBatchSendCode());
            requestVO.setCouponDefinitionId(po.getCouponDefinitionId());
            requestVO.setBatchSendCodeDetail(Long.valueOf(BusinessCodeUtil.getCouponBatchSendCodelong()));
            po.setBatchSendCodeDetail(requestVO.getBatchSendCodeDetail());
            this.sendCouponService.saveNewCouponBatchRecordDetail(definitionPoList.get(0).getSysCompanyId(), definitionPoList.get(0).getSysBrandId(), definitionPoList.get(0).getBrandCode(), po, requestVO);
            if (SystemConstants.USE_CHANNEL_ONLINE.equals(po.getUseChannel())) {
                this.updateTaskStatus(requestVO.getBusinessId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SENDING.getCode().byteValue()));
            } else {
                this.updateTaskStatus(requestVO.getBusinessId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SYNCING.getCode().byteValue()));
            }
            if (i == definitionPoList.size() - 1) {
                requestVO.setIsSendLastCoupon(Byte.valueOf((byte)1));
            }
            requestVOList.add(requestVO);
        }
        this.sendCouponFailContinue(new SendCouponFailContinueBO(param.getBusinessId(), definitionPoList, requestVOList, batchPO));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @Async
    public void sendCouponFailContinue(SendCouponFailContinueBO bo) {
        Long couponManualId = bo.getCouponManualId();
        logger.info("\u5f02\u6b65\u6267\u884c\u53d1\u5238\u4efb\u52a1:" + couponManualId);
        if (!this.redisLock.setNx("coupon:biz:sendCouponFailContinue:couponManualId_" + couponManualId, 60L)) {
            return;
        }
        CouponManualPO manualPO = ((CouponManualServiceImpl)SpringContextUtil.getBean(CouponManualServiceImpl.class)).getCouponManualPoById(couponManualId);
        if (manualPO == null || !Integer.valueOf(0).equals(manualPO.getMqState())) {
            logger.info("\u53d1\u5238\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u4e0d\u518d\u6267\u884c");
            return;
        }
        this.updateMqCouponJson(couponManualId, JSONObject.toJSONString((Object)bo));
        int couponAvg = bo.getDefinitionPOList().size();
        Long mbrMemberId = manualPO.getMqMbrMemberId();
        MembersInfoSearchVo searchVo = (MembersInfoSearchVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)manualPO.getMemberCondition()), MembersInfoSearchVo.class);
        searchVo.setPageNumber(SystemConstants.SEARCH_MEMBERS_PAGE_NUMBER);
        searchVo.setPageSize(SystemConstants.SEARCH_MEMBERS_PAGE_SIZE_TEM);
        searchVo.setSysCompanyId(manualPO.getSysCompanyId());
        logger.info("sendCouponBatchOfflineNow advancedSearch ent\uff1a" + JSONObject.toJSONString((Object)searchVo));
        ResponseData esFirstResult = this.membersAdvancedSearchApiService.advancedSearch(searchVo);
        int totalNumber = Integer.parseInt(((com.bizvane.utils.responseinfo.PageInfo)esFirstResult.getData()).getTotal() + "");
        this.updateMemberCount(couponManualId, Integer.valueOf(couponAvg * totalNumber));
        for (int i = 0; i < bo.getDefinitionPOList().size(); ++i) {
            SendCouponBatchRequestVO requestVo = (SendCouponBatchRequestVO)bo.getRequestVOList().get(i);
            requestVo.setTotalNumber(Integer.valueOf(totalNumber));
            requestVo.setCouponManualId(couponManualId);
            CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)bo.getDefinitionPOList().get(i);
            CouponBatchSendRecordPO batchPo = bo.getBatchPO();
            String key = "coupon:mqConsumer:offLine:sum:" + definitionPo.getCouponDefinitionId() + "::" + requestVo.getBatchSendCodeDetail();
            if (!this.redisLock.setNx(key, 604800L)) continue;
            CouponBatchSendRecordPO batchSendRequest = new CouponBatchSendRecordPO();
            batchSendRequest.setSendNum(Integer.valueOf(totalNumber));
            batchSendRequest.setCouponBatchSendRecordId(batchPo.getCouponBatchSendRecordId());
            this.couponBatchSendRecordPOMapper.updateSendNum(Integer.valueOf(totalNumber), batchPo.getCouponBatchSendRecordId());
        }
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order();
        order.setDirection(DirectionEnum.ASC);
        order.setProperty("mbrMemberId");
        orderList.add(order);
        searchVo.setOrders(orderList);
        String redisKey = "coupon:sendCoupon:sum:" + couponManualId;
        while (true) {
            ArrayList<SearchRangRequest> searchRangRequestList = new ArrayList<SearchRangRequest>();
            SearchRangRequest searchRangRequest = new SearchRangRequest();
            searchRangRequest.setMin(String.valueOf(mbrMemberId));
            searchRangRequestList.add(searchRangRequest);
            searchVo.setMbrMemberIdRanges(searchRangRequestList);
            ResponseData esResult = this.membersAdvancedSearchApiService.advancedSimpleSearch(searchVo);
            if (SysResponseEnum.SUCCESS.getCode() != esResult.getCode()) {
                throw new RuntimeException();
            }
            List dataList = ((com.bizvane.utils.responseinfo.PageInfo)esResult.getData()).getList();
            if (!CollectionUtils.isNotEmpty((Collection)dataList)) break;
            for (MemberInfoSimpleVO member : dataList) {
                for (int i = 0; i < bo.getDefinitionPOList().size(); ++i) {
                    SendCouponBatchRequestVO requestVo = (SendCouponBatchRequestVO)bo.getRequestVOList().get(i);
                    requestVo.setTotalNumber(Integer.valueOf(totalNumber));
                    requestVo.setCouponManualId(manualPO.getCouponManualId());
                    CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)bo.getDefinitionPOList().get(i);
                    CouponBatchSendRecordPO batchPo = bo.getBatchPO();
                    ArrayList<MemberInfoSimpleVO> memberListManual = new ArrayList<MemberInfoSimpleVO>();
                    memberListManual.add(member);
                    requestVo.setMemberListManual(memberListManual);
                    this.mqSendCouponService.sendCoupon(definitionPo, requestVo, batchPo, totalNumber);
                    this.updateMqMbrMemberId(Long.valueOf(Long.parseLong(batchPo.getBizCode())), ((MemberInfoSimpleVO)((com.bizvane.utils.responseinfo.PageInfo)esResult.getData()).getList().get(((com.bizvane.utils.responseinfo.PageInfo)esResult.getData()).getList().size() - 1)).getMbrMemberId(), 1);
                    if (this.redis.opsForValue().get((Object)redisKey) == null) {
                        this.redis.opsForValue().set((Object)redisKey, (Object)1, 7L, TimeUnit.DAYS);
                        continue;
                    }
                    this.redis.opsForValue().increment((Object)redisKey, 1L);
                }
            }
            mbrMemberId = ((MemberInfoSimpleVO)dataList.get(dataList.size() - 1)).getMbrMemberId();
        }
        logger.info("\u53d1\u5238\u5b8c\u6210");
        Integer sum = (Integer)this.redis.opsForValue().get((Object)redisKey);
        this.updateMemberCount(couponManualId, sum);
        this.updateMqMbrMemberId(couponManualId, Long.valueOf(0L), 2);
        this.updateMqCouponJson(couponManualId, "");
    }

    private void updateMemberCount(Long couponManualId, Integer memberCount) {
        CouponManualPO record = new CouponManualPO();
        record.setCouponManualId(couponManualId);
        record.setMemberCount(memberCount);
        record.setModifiedDate(new Date());
        this.couponManualPOMapper.updateByPrimaryKeySelective(record);
    }

    public boolean isManualTaskInvalid(Long manualId) {
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(manualId);
        return CouponManualTaskStatusEnum.TASK_STATUS_CANCEL.getCode().byteValue() == couponManualPO.getTaskStatus().byteValue();
    }

    public ResponseData<String> changeNewManualTask(CouponManualVO param, SysAccountPo accountPo) throws Exception {
        logger.info("enter CouponManualServiceImpl changeNewManualTask method");
        ResponseData responseData = new ResponseData();
        if (null == param.getCouponManualId()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MANUAL_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isEmpty((CharSequence)param.getCouponDefinitionIds()) && param.getMktGiftBagId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_DEFINITION_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCouponDefinitionIds()) && param.getCouponDefinitionIds().contains(",") && param.getCouponDefinitionIds().split(",").length > 20) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_DEFINITION_ID_LIST_MORE_20.getMessage());
            return responseData;
        }
        if (null == param.getSendType()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_SEND_TYPE_NOT_NULL.getMessage());
            return responseData;
        }
        ArrayList<CouponDefinitionPOWithBLOBs> definitionPOList = new ArrayList<CouponDefinitionPOWithBLOBs>();
        String definitionIdStr = "";
        String definitionNameStr = "";
        if (StringUtils.isNotBlank((CharSequence)param.getCouponDefinitionIds())) {
            if (param.getCouponDefinitionIds().contains(",")) {
                String[] idArray = param.getCouponDefinitionIds().split(",");
                for (int i = 0; i < idArray.length; ++i) {
                    CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(idArray[i])));
                    if (definitionPO == null) continue;
                    if (SystemConstants.VALID_TYPE__INTERVAL.equals(definitionPO.getValidType())) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        Date endDate = format.parse(format.format(definitionPO.getValidDateEnd()));
                        Date today = format.parse(format.format(new Date()));
                        logger.info("bbbbbbbbbbbbbbbbbbbbbbbbbbbb endDate:{},today:{}", (Object)JSONObject.toJSONString((Object)endDate), (Object)JSONObject.toJSONString((Object)today));
                        if (endDate.getTime() < today.getTime()) continue;
                    }
                    definitionPOList.add(definitionPO);
                    if (i != idArray.length - 1) {
                        definitionIdStr = definitionIdStr + idArray[i] + ",";
                        definitionNameStr = definitionNameStr + definitionPO.getCouponName() + "\u3001";
                        continue;
                    }
                    definitionIdStr = definitionIdStr + idArray[i];
                    definitionNameStr = definitionNameStr + definitionPO.getCouponName();
                }
            } else {
                CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(param.getCouponDefinitionIds())));
                if (definitionPO != null) {
                    if (SystemConstants.VALID_TYPE__INTERVAL.equals(definitionPO.getValidType())) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        Date endDate = format.parse(format.format(definitionPO.getValidDateEnd()));
                        Date today = format.parse(format.format(new Date()));
                        logger.info("bbbbbbbbbbbbbbbbbbbbbbbbbbbb endDate:{},today:{}", (Object)JSONObject.toJSONString((Object)endDate), (Object)JSONObject.toJSONString((Object)today));
                        if (endDate.getTime() < today.getTime()) {
                            responseData.setCode(SysResponseEnum.FAILED.getCode());
                            responseData.setMessage(SysResponseEnum.COUPON_EXPIRED.getMessage());
                            return responseData;
                        }
                    }
                } else {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage(SysResponseEnum.COUPON_NOT_EXIST.getMessage());
                    return responseData;
                }
                definitionIdStr = definitionIdStr + param.getCouponDefinitionIds();
                definitionNameStr = definitionNameStr + definitionPO.getCouponName();
                definitionPOList.add(definitionPO);
            }
        }
        if (param.getMktGiftBagId() != null) {
            MktGiftBagPO mktGiftBagPO = new MktGiftBagPO();
            mktGiftBagPO.setMktGiftBagId(param.getMktGiftBagId());
            mktGiftBagPO.setSysBrandId(accountPo.getBrandId());
            mktGiftBagPO.setSysCompanyId(accountPo.getSysCompanyId());
            ResponseData activityGiftbagBOResponseData = this.sendCouponServiceRpc.selectGiftBagDetailForCounpon(mktGiftBagPO);
            if (activityGiftbagBOResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() && activityGiftbagBOResponseData.getData() != null) {
                StringBuilder bagCouponDefIds = new StringBuilder();
                ActivityGiftbagBO activityGiftbagBO = (ActivityGiftbagBO)activityGiftbagBOResponseData.getData();
                List couponDefinitionPOList = activityGiftbagBO.getCouponDefinitionPOList();
                if (CollectionUtils.isNotEmpty((Collection)couponDefinitionPOList)) {
                    for (int i = 0; i < couponDefinitionPOList.size(); ++i) {
                        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = (CouponDefinitionPOWithBLOBs)couponDefinitionPOList.get(i);
                        if (SystemConstants.VALID_TYPE__INTERVAL.equals(couponDefinitionPOWithBLOBs.getValidType()) && couponDefinitionPOWithBLOBs.getValidDateEnd() != null && couponDefinitionPOWithBLOBs.getValidDateEnd().before(new Date())) {
                            logger.info("\u5238\u5305\u4e2d\u5238\u5df2\u8fc7\u671f,\u5238id:{}", (Object)couponDefinitionPOWithBLOBs.getCouponDefinitionId());
                            continue;
                        }
                        bagCouponDefIds.append(couponDefinitionPOWithBLOBs.getCouponDefinitionId()).append(",");
                    }
                }
                if (bagCouponDefIds.length() > 0) {
                    bagCouponDefIds.deleteCharAt(bagCouponDefIds.length() - 1);
                }
                if (definitionIdStr.length() > 0) {
                    definitionIdStr = definitionIdStr + "," + bagCouponDefIds.toString();
                    definitionNameStr = definitionNameStr + "\u3001" + activityGiftbagBO.getMktGiftBagPO().getMktGiftBagName();
                }
            } else {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u793c\u5305\u67e5\u8be2\u5931\u8d25");
                return responseData;
            }
        }
        if (StringUtils.isBlank((CharSequence)definitionIdStr)) {
            responseData.setCode(SysResponseEnum.COUPON_EXPIRED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_EXPIRED.getMessage());
            return responseData;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponManualPO manualUpdate = new CouponManualPO();
        manualUpdate.setCouponManualId(param.getCouponManualId());
        if (CouponEnum.COUPON_MANUAL_SEND_TYPE_NOW.getCode().equals(param.getSendType() + "")) {
            manualUpdate.setSendTime(TimeUtils.getNowTime());
        } else {
            manualUpdate.setSendTime(dateFormat.parse(param.getSendTimeStr()));
        }
        manualUpdate.setTaskName(param.getTaskName());
        manualUpdate.setCouponDefinitionId(definitionIdStr);
        manualUpdate.setCouponDefinitionName(definitionNameStr);
        manualUpdate.setSendType(param.getSendType());
        manualUpdate.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        MembersInfoSearchVo searchVo = param.getSearchVo();
        searchVo.setBrandId(accountPo.getBrandId());
        searchVo.setOnlineOrgCode(accountPo.getOnlineOrgCode());
        manualUpdate.setMemberCondition(JSONObject.toJSONString((Object)searchVo));
        manualUpdate.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_CHECK_WAIT.getCode().byteValue()));
        manualUpdate.setMemberCount(param.getTotalNumber());
        manualUpdate.setModifiedDate(TimeUtils.getNowTime());
        manualUpdate.setModifiedUserId(accountPo.getSysAccountId());
        manualUpdate.setModifiedUserName(accountPo.getName());
        manualUpdate.setMktGiftBagId(param.getMktGiftBagId());
        this.couponManualPOMapper.updateCouponManualTask(manualUpdate);
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(param.getCouponManualId());
        SysCheckPo checkPo = new SysCheckPo();
        checkPo.setSysCheckId(param.getSysCheckId());
        checkPo.setSysBrandId(couponManualPO.getSysBrandId());
        checkPo.setFunctionCode("C0001");
        checkPo.setBusinessType(Integer.valueOf(Integer.parseInt(SendTypeEnum.SEND_COUPON_BATCH.getCode())));
        checkPo.setBusinessId(couponManualPO.getCouponManualId());
        checkPo.setBusinessCode(couponManualPO.getCouponManualId() + "");
        checkPo.setBusinessName(couponManualPO.getTaskName());
        checkPo.setBizName(couponManualPO.getCouponDefinitionName());
        checkPo.setCheckStatus(SystemConstants.CHECK_STATUS_WAIT);
        checkPo.setCreateDate(TimeUtils.getNowTime());
        checkPo.setCreateUserId(accountPo.getSysAccountId());
        checkPo.setCreateUserName(accountPo.getName());
        checkPo.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        this.sysCheckServiceRpc.updateCheck(checkPo);
        return responseData;
    }

    public ResponseData<CouponDetailResponseVO> findNewById(Long couponManualId) {
        MbrGroupModel groupInfo;
        MembersInfoSearchVo membersInfoSearchVo;
        logger.info("enter CouponManualServiceImpl findById method");
        ResponseData responseData = new ResponseData();
        CouponDetailResponseVO detailVO = new CouponDetailResponseVO();
        if (null == couponManualId) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MANUAL_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponManualPO manualPO = this.couponManualPOMapper.selectByPrimaryKey(couponManualId);
        if (manualPO == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        CouponManualVO couponManualVO = new CouponManualVO();
        BeanUtils.copyProperties((Object)manualPO, (Object)couponManualVO);
        if (couponManualVO.getMemberConditionType() != null && CouponManualConditionEnum.MANUAL_GROUP_GROUP.getCode().equals(couponManualVO.getMemberConditionType()) && (membersInfoSearchVo = (MembersInfoSearchVo)JSONObject.parseObject((String)manualPO.getMemberCondition(), MembersInfoSearchVo.class)) != null && StringUtils.isNotBlank((CharSequence)membersInfoSearchVo.getChildMbrGroupDefIdsStr()) && (groupInfo = (MbrGroupModel)this.memberGroupApiService.queryGroupInfo(Long.valueOf(membersInfoSearchVo.getChildMbrGroupDefIdsStr())).getData()) != null) {
            couponManualVO.setMbrGroupModel(groupInfo);
        }
        if (Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()).equals(couponManualVO.getCouponType())) {
            ResponseData brandVoResponseData = this.brandServiceRpc.getBrandId(couponManualVO.getEmpowerBrandId());
            if (brandVoResponseData != null && SysResponseEnum.SUCCESS.getCode() == brandVoResponseData.getCode()) {
                SysBrandVo data = (SysBrandVo)brandVoResponseData.getData();
                couponManualVO.setEmpowerBrandName(data.getBrandName());
            }
            Byte taskStatus = manualPO.getTaskStatus();
            if (CouponManualTaskStatusEnum.TASK_STATUS_NEW.getCode().byteValue() == taskStatus.byteValue() || CouponManualTaskStatusEnum.TASK_STATUS_CHECK_WAIT.getCode().byteValue() == taskStatus.byteValue()) {
                couponManualVO.setMemberCount(Integer.valueOf(0));
                couponManualVO.setSuccessCount(Integer.valueOf(0));
                couponManualVO.setFailCount(Integer.valueOf(0));
            } else if (CouponManualTaskStatusEnum.TASK_STATUS_SENDING.getCode().byteValue() == taskStatus.byteValue()) {
                couponManualVO.setSuccessCount(couponManualVO.getMemberNum());
                couponManualVO.setFailCount(Integer.valueOf(0));
            } else {
                couponManualVO.setSuccessCount(couponManualVO.getMemberNum());
                couponManualVO.setFailCount(Integer.valueOf(couponManualVO.getMemberCount() - couponManualVO.getSuccessCount()));
            }
        }
        HashMap<Long, Integer> giftBagCouponDefIdToNumMap = new HashMap<Long, Integer>();
        if (manualPO.getMktGiftBagId() != null) {
            MktGiftBagPO mktGiftBagPO = new MktGiftBagPO();
            mktGiftBagPO.setMktGiftBagId(manualPO.getMktGiftBagId());
            mktGiftBagPO.setSysBrandId(manualPO.getSysBrandId());
            mktGiftBagPO.setSysCompanyId(manualPO.getSysCompanyId());
            ResponseData activityGiftbagBOResponseData = this.sendCouponServiceRpc.selectGiftBagDetailForCounpon(mktGiftBagPO);
            if (activityGiftbagBOResponseData.getData() != null) {
                ActivityGiftbagBO data = (ActivityGiftbagBO)activityGiftbagBOResponseData.getData();
                detailVO.setActivityGiftbagBO(data);
                data.getCouponDefinitionPOList().stream().forEach(couponDefinitionPOWithBLOBs -> {
                    Integer couponDefNum = (Integer)giftBagCouponDefIdToNumMap.get(couponDefinitionPOWithBLOBs.getCouponDefinitionId());
                    giftBagCouponDefIdToNumMap.put(couponDefinitionPOWithBLOBs.getCouponDefinitionId(), couponDefNum != null ? couponDefNum + 1 : 1);
                });
            }
            logger.info("\u793c\u5305\u5238\u4e0e\u6570\u91cfgiftBagCouponDefIdToNumMap:{}", (Object)JacksonUtil.bean2Json(giftBagCouponDefIdToNumMap));
        }
        ArrayList<CouponDefinitionVO> definitionPOList = new ArrayList<CouponDefinitionVO>();
        if (StringUtils.isNotBlank((CharSequence)manualPO.getCouponDefinitionId())) {
            String definitionIds = manualPO.getCouponDefinitionId();
            ArrayList<Long> idList = new ArrayList<Long>();
            ArrayList<Long> manualIdList = new ArrayList<Long>();
            for (String id : definitionIds.split(",")) {
                boolean numeric = DigitalJudgmentUtil.isNumeric((String)id);
                if (numeric) {
                    Long couponDefId = Long.valueOf(id);
                    if (giftBagCouponDefIdToNumMap != null && giftBagCouponDefIdToNumMap.containsKey(couponDefId)) {
                        Integer couponDefNum = (Integer)giftBagCouponDefIdToNumMap.get(couponDefId);
                        if (couponDefNum == 1) {
                            logger.info("\u793c\u5305\u5238\u4e0e\u6570\u91cfgiftBagCouponDefIdToNumMap,\u79fb\u9664key,key\u4e3a{}", (Object)couponDefId);
                            giftBagCouponDefIdToNumMap.remove(couponDefId);
                            continue;
                        }
                        logger.info("\u793c\u5305\u5238\u4e0e\u6570\u91cfgiftBagCouponDefIdToNumMap,\u6570\u91cf\u51cf1,key\u4e3a{}", (Object)couponDefId);
                        giftBagCouponDefIdToNumMap.put(couponDefId, couponDefNum - 1);
                        continue;
                    }
                    idList.add(couponDefId);
                    continue;
                }
                String[] split = id.split("_");
                String bandId = split[0];
                String menualId = split[1];
                manualIdList.add(Long.valueOf(menualId));
            }
            if (!manualIdList.isEmpty()) {
                couponManualVO.setIsDifdustrySendCoupon(Byte.valueOf((byte)1));
                Byte taskStatus = couponManualVO.getTaskStatus();
                if (CouponManualTaskStatusEnum.TASK_STATUS_PART_FAIL.getCode().byteValue() == taskStatus.byteValue()) {
                    couponManualVO.setTaskStatus(Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SEND_SUCCESS.getCode().byteValue()));
                }
                CouponManualPOExample example = new CouponManualPOExample();
                CouponManualPOExample.Criteria criteria = example.createCriteria();
                criteria.andCouponManualIdIn(manualIdList);
                criteria.andCouponTypeEqualTo(Integer.valueOf(SendTypeEnum.SEND_COUPON_DIF.getCode()));
                List couponManualPOS = this.couponManualPOMapper.selectByExample(example);
                if (couponManualPOS != null && !couponManualPOS.isEmpty()) {
                    Map modelMap = null;
                    Map<Long, Long> ManualMap = couponManualPOS.stream().collect(Collectors.toMap(CouponManualPO::getCouponManualId, t -> Long.valueOf(t.getCouponDefinitionId())));
                    List collect = couponManualPOS.stream().map(t -> Long.parseLong(t.getCouponDefinitionId())).collect(Collectors.toList());
                    if (!collect.isEmpty()) {
                        CouponDefinitionPOExample poExample = new CouponDefinitionPOExample();
                        CouponDefinitionPOExample.Criteria poCriteria = poExample.createCriteria();
                        poCriteria.andCouponDefinitionIdIn(collect);
                        List list = this.couponDefinitionPOMapper.selectByExample(poExample);
                        if (list != null && !list.isEmpty()) {
                            List data;
                            List longList = list.stream().map(CouponDefinitionPO::getSysBrandId).collect(Collectors.toList());
                            SysBrandVo sysBrandVo = new SysBrandVo();
                            sysBrandVo.setSysCompanyId(manualPO.getSysCompanyId());
                            sysBrandVo.setSysBrandIdList(longList);
                            ResponseData barndListByBrandIds = this.brandServiceRpc.getBarndListByBrandIds(sysBrandVo);
                            if (barndListByBrandIds != null && SysResponseEnum.SUCCESS.getCode() == barndListByBrandIds.getCode() && (data = (List)barndListByBrandIds.getData()) != null && !data.isEmpty()) {
                                modelMap = data.stream().collect(Collectors.toMap(SysBrandPo::getSysBrandId, Function.identity(), (a, b) -> a));
                            }
                        }
                        Map finalModelMap = modelMap;
                        Map definitionVOMap = list.stream().map(t -> {
                            CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
                            BeanUtils.copyProperties((Object)t, (Object)couponDefinitionVO);
                            couponDefinitionVO.setIsDifindustryCoupon(Byte.valueOf((byte)1));
                            if (finalModelMap != null && finalModelMap.containsKey(t.getSysBrandId())) {
                                SysBrandPo sysBrandPo = (SysBrandPo)finalModelMap.get(t.getSysBrandId());
                                couponDefinitionVO.setSourceBrandId(t.getSysBrandId());
                                couponDefinitionVO.setSourceBrandName(sysBrandPo.getBrandName());
                            }
                            return couponDefinitionVO;
                        }).collect(Collectors.toMap(CouponDefinitionPO::getCouponDefinitionId, Function.identity()));
                        for (CouponManualPO bean : couponManualPOS) {
                            Long id;
                            if (!ManualMap.containsKey(bean.getCouponManualId()) || !definitionVOMap.containsKey(id = ManualMap.get(bean.getCouponManualId()))) continue;
                            CouponDefinitionVO couponDefinitionVO = (CouponDefinitionVO)definitionVOMap.get(id);
                            definitionPOList.add(couponDefinitionVO);
                        }
                    }
                }
            }
            if (!idList.isEmpty()) {
                CouponDefinitionPOExample example = new CouponDefinitionPOExample();
                CouponDefinitionPOExample.Criteria criteria = example.createCriteria();
                criteria.andCouponDefinitionIdIn(idList);
                List list = this.couponDefinitionPOMapper.selectByExample(example);
                Map collectMap = null;
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    collectMap = list.stream().collect(Collectors.toMap(CouponDefinitionPO::getCouponDefinitionId, Function.identity()));
                }
                for (Long id : idList) {
                    if (collectMap == null || !collectMap.containsKey(id)) continue;
                    CouponDefinitionPO t2 = (CouponDefinitionPO)collectMap.get(id);
                    CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
                    BeanUtils.copyProperties((Object)t2, (Object)couponDefinitionVO);
                    definitionPOList.add(couponDefinitionVO);
                }
            }
        }
        detailVO.setCouponDefinitionPOList(definitionPOList);
        detailVO.setCouponManualPO(couponManualVO);
        responseData.setData((Object)detailVO);
        return responseData;
    }

    private List<String> analyzeExcel(InputStream inputStream) throws Exception {
        CommonExportExcelUtil ceu = new CommonExportExcelUtil(inputStream);
        int lastRowNum = ceu.getLastRowNum();
        Assert.isTrue((lastRowNum <= 50000 ? 1 : 0) != 0, (String)"\u60a8\u4e00\u6b21\u6700\u591a\u53ea\u80fd\u7ed1\u5b9a5W\u4e2a\u5458\u5de5\uff01");
        Assert.isTrue((lastRowNum > 0 ? 1 : 0) != 0, (String)"\u60a8\u4e00\u6b21\u6700\u5c11\u7ed1\u5b9a\u4e00\u4e2a\u5458\u5de5\uff01");
        LinkedList<String> newList = new LinkedList<String>();
        ceu.read(1, 0, lastRowNum, 0, arr -> {
            if (StringUtils.isNotBlank((CharSequence)((String)arr[0]))) {
                newList.add((String)arr[0]);
            }
        });
        Assert.isTrue((newList.size() > 0 ? 1 : 0) != 0, (String)"\u60a8\u4e00\u6b21\u6700\u5c11\u7ed1\u5b9a\u4e00\u4e2a\u5458\u5de5\uff01");
        return newList;
    }

    private int analyzeExcelGetEmpIdsCount(InputStream inputStream) throws Exception {
        CommonExportExcelUtil ceu = new CommonExportExcelUtil(inputStream);
        int lastRowNum = ceu.getLastRowNum();
        Assert.isTrue((lastRowNum <= 50000 ? 1 : 0) != 0, (String)"\u60a8\u4e00\u6b21\u6700\u591a\u53ea\u80fd\u7ed1\u5b9a5W\u4e2a\u5458\u5de5\uff01");
        Assert.isTrue((lastRowNum > 0 ? 1 : 0) != 0, (String)"\u60a8\u4e00\u6b21\u6700\u5c11\u7ed1\u5b9a\u4e00\u4e2a\u5458\u5de5\uff01");
        return lastRowNum;
    }

    static /* synthetic */ ProvisionalTraceService access$000(CouponManualServiceImpl x0) {
        return x0.provisionalTraceService;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ CouponDifindustryService access$200(CouponManualServiceImpl x0) {
        return x0.couponDifindustryService;
    }

    static /* synthetic */ ResponseData access$300(CouponManualServiceImpl x0, List x1, SendCouponBatchRequestVO x2) {
        return x0.sendNewCouponBySendType(x1, x2);
    }
}

