/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.enums.CouponEnum;
import com.bizvane.couponfacade.enums.CouponManualTaskStatusEnum;
import com.bizvane.couponfacade.enums.CouponSendTypeEnum;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.bo.CouponCodeWithPwd;
import com.bizvane.couponfacade.models.bo.SendCouponDifindustryBo;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponDifindustrySendDetailPO;
import com.bizvane.couponfacade.models.po.CouponDifindustrySendDetailPOExample;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.po.CouponManualPOExample;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponDifindustryVO;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponManualVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListRequestVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListResponseVO;
import com.bizvane.couponfacade.models.vo.SendCouponAsyncSimpleRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.BusinessCodeUtil;
import com.bizvane.couponservice.common.utils.CouponException;
import com.bizvane.couponservice.common.utils.JobUtil;
import com.bizvane.couponservice.common.utils.RedisLock;
import com.bizvane.couponservice.mappers.CouponBatchSendRecordPOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponDifindustrySendDetailPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.rocketmq.MQSendCouponService;
import com.bizvane.couponservice.rocketmq.rocketutils.RocketMQProducerService;
import com.bizvane.couponservice.rocketmq.rocketutils.TopicEnum;
import com.bizvane.couponservice.service.CouponDifindustryQuantityRecordService;
import com.bizvane.couponservice.service.CouponDifindustryService;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.members.facade.enums.DirectionEnum;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.Order;
import com.bizvane.members.facade.es.vo.SearchRangRequest;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.CompanyMemberInfoBo;
import com.bizvane.members.facade.models.bo.GetMemberDeductionInfo;
import com.bizvane.members.facade.models.query.CouponMemberPo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.members.facade.vo.MemberInfoApiModel;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.wechatfacade.interfaces.WxMiniprgmServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponDifindustryServiceImpl
implements CouponDifindustryService {
    private static final Logger log = LoggerFactory.getLogger(CouponDifindustryServiceImpl.class);
    @Autowired
    @Lazy
    private SendCouponService sendCouponService;
    @Autowired
    @Lazy
    private CouponManualService couponManualService;
    @Autowired
    private MQSendCouponService mqSendCouponService;
    @Autowired
    @Lazy
    private CouponDifindustryQuantityRecordService couponDifindustryQuantityRecordService;
    @Autowired
    private RocketMQProducerService rocketMQProducerService;
    @Autowired
    private CouponBatchSendRecordPOMapper couponBatchSendRecordPOMapper;
    @Autowired
    private CouponManualPOMapper couponManualPOMapper;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private CouponDifindustrySendDetailPOMapper couponDifindustrySendDetailPOMapper;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private JobUtil jobUtil;
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private WxMiniprgmServiceFeign wxMiniprgmServiceFeign;
    @Autowired
    private CouponEntityService couponEntityService;

    public ResponseData<String> sendDifindustryCouponBySendType(List<SendCouponDifindustryBo> definitionPOList, SendCouponBatchRequestVO requestVO) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        if (CouponEnum.COUPON_MANUAL_SEND_TYPE_NOW.getCode().equals(requestVO.getSendType() + "") || this.checkSendDateBeforeNow(requestVO)) {
            this.sendDifindustryCouponByUseChannel(definitionPOList, requestVO);
        } else if (CouponEnum.COUPON_MANUAL_SEND_TYPE_SOMEDAY.getCode().equals(String.valueOf(requestVO.getSendType()))) {
            if (SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(requestVO.getBusinessType())) {
                this.couponManualService.updateTaskStatus(requestVO.getBusinessId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_CHECK_PASS.getCode().byteValue()));
            }
            this.jobUtil.addSendCouponBatchJob(requestVO);
        } else {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SEND_TYPE_NOT_EXISTS.getMessage());
        }
        return responseData;
    }

    private boolean checkSendDateBeforeNow(SendCouponBatchRequestVO requestVO) {
        return requestVO.getSendTime() != null && requestVO.getSendTime().before(new Date());
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> sendDifindustryCouponByUseChannel(List<SendCouponDifindustryBo> sendCouponDifindustryBoList, SendCouponBatchRequestVO param) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        Collections.sort(sendCouponDifindustryBoList, new /* Unavailable Anonymous Inner Class!! */);
        Long sysCompanyId = param.getSysCompanyId();
        Long brandId = param.getSysBrandId();
        String brandCode = param.getSysBrandCode();
        String ids = sendCouponDifindustryBoList.stream().map(t -> {
            Long couponDefinitionId = t.getCouponDefinitionPOWithBLOBs().getCouponDefinitionId();
            return String.valueOf(couponDefinitionId);
        }).collect(Collectors.joining(","));
        CouponBatchSendRecordPO couponBatchSendRecordPO = this.sendCouponService.saveNewCouponBatchRecord(sysCompanyId, brandId, brandCode, ids, param);
        for (int i = 0; i < sendCouponDifindustryBoList.size(); ++i) {
            SendCouponDifindustryBo obj = sendCouponDifindustryBoList.get(i);
            CouponDefinitionPOWithBLOBs t2 = obj.getCouponDefinitionPOWithBLOBs();
            SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
            BeanUtils.copyProperties((Object)param, (Object)requestVO);
            requestVO.setBatchSendCode(couponBatchSendRecordPO.getBatchSendCode());
            requestVO.setCouponDefinitionId(t2.getCouponDefinitionId());
            requestVO.setBatchSendCodeDetail(Long.valueOf(BusinessCodeUtil.getCouponBatchSendCodelong()));
            t2.setBatchSendCodeDetail(requestVO.getBatchSendCodeDetail());
            this.sendCouponService.saveNewCouponBatchRecordDetail(sysCompanyId, brandId, brandCode, t2, requestVO);
            if (i == sendCouponDifindustryBoList.size() - 1) {
                requestVO.setIsSendLastCoupon(Byte.valueOf((byte)1));
            }
            obj.setRequestVO(requestVO);
        }
        if (SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(param.getBusinessType())) {
            this.couponManualService.updateTaskStatus(param.getBusinessId(), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SENDING.getCode().byteValue()));
        }
        Long businessId = param.getBusinessId();
        this.sendDifindustryCouponContinue(businessId, sendCouponDifindustryBoList, couponBatchSendRecordPO);
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @Async
    public ResponseData<String> createCouponPool(CouponDefinitionVO couponDefinitionVO) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        Long manualId = couponDefinitionVO.getManualId();
        this.couponManualService.updateTaskStatus(manualId, Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SENDING.getCode().byteValue()));
        Integer totalQuantiy = couponDefinitionVO.getTotalQuantiy();
        int phrSize = 1000;
        try {
            while (totalQuantiy > 0) {
                int surplusSize = totalQuantiy - phrSize;
                int size = surplusSize >= phrSize || surplusSize == 0 ? phrSize : totalQuantiy;
                try {
                    this.addBatch(couponDefinitionVO, Integer.valueOf(size));
                }
                catch (Exception e) {
                    break;
                }
                totalQuantiy = totalQuantiy - phrSize;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.couponManualService.updateTaskStatus(manualId, Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_SEND_SUCCESS.getCode().byteValue()));
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public void addBatch(CouponDefinitionVO couponDefinitionVO, Integer size) {
        ArrayList<CouponDifindustrySendDetailPO> list = new ArrayList<CouponDifindustrySendDetailPO>();
        Integer totalQuantiy = couponDefinitionVO.getTotalQuantiy();
        Long sysCompanyId = couponDefinitionVO.getSysCompanyId();
        Long sourceBrandId = couponDefinitionVO.getSourceBrandId();
        Long sysBrandId = couponDefinitionVO.getSysBrandId();
        Long couponDefinitionId = couponDefinitionVO.getCouponDefinitionId();
        Long manualId = couponDefinitionVO.getManualId();
        String batchNum = couponDefinitionVO.getBatchNum();
        Date now = new Date();
        for (int i = 0; i < size; ++i) {
            CouponDifindustrySendDetailPO couponDifindustrySendDetailPO = new CouponDifindustrySendDetailPO();
            couponDifindustrySendDetailPO.setSysCompanyId(sysCompanyId);
            couponDifindustrySendDetailPO.setSysBrandId(sysBrandId);
            couponDifindustrySendDetailPO.setSourceBrandId(sourceBrandId);
            couponDifindustrySendDetailPO.setBatchNum(batchNum);
            couponDifindustrySendDetailPO.setSendStatus(SystemConstants.COUPON_DIFINDUSTRY_CREATE_POOL);
            couponDifindustrySendDetailPO.setValid(SystemConstants.VALID);
            couponDifindustrySendDetailPO.setCreateDate(now);
            couponDifindustrySendDetailPO.setSendMemberCode("1");
            couponDifindustrySendDetailPO.setCouponDefinitionId(String.valueOf(couponDefinitionId));
            couponDifindustrySendDetailPO.setCouponManualId(manualId);
            couponDifindustrySendDetailPO.setSendGuideId(SystemConstants.DEFAULT_POOL_SEND_GUIDEID);
            String couponCode = null;
            String usePassword = null;
            if (couponDefinitionVO.getCouponDefinitionType().equals((byte)2)) {
                ResponseData couponCodeWithPwdResponseData = this.couponManualService.getCouponCodeWithPwd(couponDefinitionVO.getCouponDefinitionId(), couponDefinitionVO.getSysBrandId());
                if (couponCodeWithPwdResponseData.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode()) {
                    CouponCodeWithPwd data = (CouponCodeWithPwd)couponCodeWithPwdResponseData.getData();
                    couponCode = data.getCouponCode();
                    usePassword = data.getUsePwd();
                } else {
                    log.info("enter SendCouponServiceImpl saveEntityList method \u6ca1\u6709\u5238\u53f7\u4e86,\u9ed8\u8ba4\u7ed9\u4e2a\u5047\u7684\u5238\u53f7");
                    couponCode = BusinessCodeUtil.getCouponCodeFalseCode();
                }
            } else {
                couponCode = BusinessCodeUtil.getCouponCodeForSysCompany((Long)couponDefinitionVO.getSysCompanyId(), (String)couponDefinitionVO.getErpCouponDefinitionCode());
            }
            couponDifindustrySendDetailPO.setCouponCode(couponCode);
            couponDifindustrySendDetailPO.setRemark(usePassword);
            list.add(couponDifindustrySendDetailPO);
        }
        this.couponDifindustrySendDetailPOMapper.insertBatch(list);
        CouponManualPO po = new CouponManualPO();
        po.setMemberNum(Integer.valueOf(list.size()));
        po.setCouponManualId(manualId);
        this.couponManualPOMapper.updateCouponCount(po);
    }

    public ResponseData<SendCouponBatchRequestVO> consumeMqSendCoupon(SendCouponDifindustryBo sendCouponDifindustryBo, CouponBatchSendRecordPO batchPo) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        SendCouponBatchRequestVO requestVO = sendCouponDifindustryBo.getRequestVO();
        CouponDefinitionPOWithBLOBs definitionPo = sendCouponDifindustryBo.getCouponDefinitionPOWithBLOBs();
        Long sysCompanyId = batchPo.getSysCompanyId();
        Long sysBrandId = batchPo.getSysBrandId();
        String batchNum = sendCouponDifindustryBo.getBatchNum();
        Long sourceBrandId = sendCouponDifindustryBo.getSourceBrandId();
        Long sourceBusinessId = sendCouponDifindustryBo.getSourceBusinessId();
        String sourceBusinessType = sendCouponDifindustryBo.getSourceBusinessType();
        List memberList = requestVO.getMemberListManual();
        List phoneList = memberList.stream().map(MemberInfoSimpleVO::getPhone).collect(Collectors.toList());
        MemberInfoModel searchModel = MemberInfoModel.builder().phone((String)phoneList.get(0)).brandId(sourceBrandId).build();
        MemberInfoModel memberInfoThis = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(searchModel).getData();
        Map collectMap = null;
        List memberListManual = null;
        if (memberInfoThis != null) {
            ArrayList<MemberInfoSimpleVO> list = new ArrayList<MemberInfoSimpleVO>();
            MemberInfoSimpleVO memberTemp = new MemberInfoSimpleVO();
            BeanUtils.copyProperties((Object)memberInfoThis, (Object)memberTemp);
            list.add(memberTemp);
            collectMap = list.stream().collect(Collectors.toMap(MemberInfoSimpleVO::getPhone, Function.identity(), (a, b) -> b));
            memberListManual = list.stream().map(t -> {
                MemberInfoSimpleVO memberInfoSimpleVO = new MemberInfoSimpleVO();
                BeanUtils.copyProperties((Object)t, (Object)memberInfoSimpleVO);
                return memberInfoSimpleVO;
            }).collect(Collectors.toList());
        }
        Map finalCollectMap = collectMap;
        ArrayList<CouponEntityPO> entityPOList = new ArrayList<CouponEntityPO>();
        ArrayList<CouponDifindustrySendDetailPO> sendDetailPOList = new ArrayList<CouponDifindustrySendDetailPO>();
        ArrayList<CouponDifindustrySendDetailPO> insertSendDetailPOList = new ArrayList<CouponDifindustrySendDetailPO>();
        HashMap<Integer, CouponEntityPO> indexMap = new HashMap<Integer, CouponEntityPO>();
        Date nowDate = new Date();
        for (int i = 0; i < memberList.size(); ++i) {
            String couponEntityStr;
            MemberInfoSimpleVO t2 = (MemberInfoSimpleVO)memberList.get(i);
            CouponEntityPO entityPO = new CouponEntityPO();
            entityPO.setSysCompanyId(definitionPo.getSysCompanyId());
            entityPO.setSysBrandId(definitionPo.getSysBrandId());
            entityPO.setSendBrandId(sysBrandId);
            entityPO.setBatchNum(batchNum);
            entityPO.setBrandCode(definitionPo.getBrandCode());
            entityPO.setCouponDefinitionId(definitionPo.getCouponDefinitionId() + "");
            entityPO.setCouponBatchSendRecordId(batchPo.getCouponBatchSendRecordId() != null ? batchPo.getCouponBatchSendRecordId() : definitionPo.getCouponDefinitionId());
            entityPO.setCouponName(definitionPo.getCouponName());
            entityPO.setMoney(definitionPo.getMoney());
            entityPO.setDiscount(definitionPo.getDiscount());
            entityPO.setImg(definitionPo.getImg());
            entityPO.setInfo(definitionPo.getInfo());
            entityPO.setBindStatus(SystemConstants.COUPON_BIND_STATUS_UNBIND);
            Calendar calendar = Calendar.getInstance();
            if (definitionPo.getValidType().equals(SystemConstants.VALID_TYPE__SOMEDAY)) {
                calendar.add(5, definitionPo.getValidDay());
                calendar.set(11, 23);
                calendar.set(13, 59);
                calendar.set(12, 59);
                calendar.set(14, 59);
                entityPO.setValidDateStart(TimeUtils.getNowTime());
                entityPO.setValidDateEnd(calendar.getTime());
            } else if (SystemConstants.VALID_TYPE_DELAY.equals(definitionPo.getValidType())) {
                ZoneId zoneId = ZoneId.systemDefault();
                LocalDate startDate = LocalDate.now().plusDays(definitionPo.getDelayDay().intValue());
                LocalDateTime validDateStart = startDate.atTime(0, 0, 0);
                ZonedDateTime startTime = validDateStart.atZone(zoneId);
                LocalDate endDate = startDate.plusDays((long)definitionPo.getDelayValidDay().intValue() - 1L);
                LocalDateTime validEndDate = endDate.atTime(23, 59, 59);
                ZonedDateTime endTime = validEndDate.atZone(zoneId);
                entityPO.setValidDateStart(Date.from(startTime.toInstant()));
                entityPO.setValidDateEnd(Date.from(endTime.toInstant()));
            } else {
                entityPO.setValidDateStart(definitionPo.getValidDateStart());
                calendar.setTime(definitionPo.getValidDateEnd());
                calendar.set(11, 23);
                calendar.set(13, 59);
                calendar.set(12, 59);
                calendar.set(14, 59);
                entityPO.setValidDateEnd(calendar.getTime());
            }
            entityPO.setIsLock(SystemConstants.COUPON_STATUS_CHANGE_IS_UNLOCK);
            entityPO.setSendType(SendTypeEnum.SEND_COUPON_DIF.getCode());
            entityPO.setSendBusinessId(requestVO.getBusinessId());
            entityPO.setIsUse(SystemConstants.COUPON_USE_UNUSED);
            entityPO.setCouponStatus(SystemConstants.COUPON_STATUS_UNUSED);
            entityPO.setInfo(definitionPo.getInfo());
            entityPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
            entityPO.setPreferentialType(definitionPo.getPreferentialType());
            entityPO.setCreateDate(TimeUtils.getNowTime());
            entityPO.setModifiedDate(TimeUtils.getNowTime());
            entityPO.setCreateUserId(requestVO.getCreateUserId());
            entityPO.setCreateUserName(requestVO.getCreateUserName());
            entityPO.setBusinessName(requestVO.getBusinessName());
            entityPO.setTransferSend(definitionPo.getTransferSend());
            entityPO.setTransferCouponDefinitionId(definitionPo.getTransferCouponDefinitionId());
            entityPO.setTransferInfo(definitionPo.getTransferInfo());
            CouponDifindustrySendDetailPO couponDifindustrySendDetail = new CouponDifindustrySendDetailPO();
            BeanUtils.copyProperties((Object)entityPO, (Object)couponDifindustrySendDetail);
            couponDifindustrySendDetail.setSendMemberCode(t2.getMemberCode());
            couponDifindustrySendDetail.setBusinessType(requestVO.getBusinessType());
            couponDifindustrySendDetail.setBusinessId(requestVO.getBusinessId());
            couponDifindustrySendDetail.setSysBrandId(sysBrandId);
            couponDifindustrySendDetail.setSourceBrandId(sourceBrandId);
            Boolean isSave = true;
            if (null == finalCollectMap || !finalCollectMap.containsKey(t2.getPhone())) {
                couponDifindustrySendDetail.setSendStatus(SystemConstants.COUPON_DIFINDUSTRY_SEND_SUCCESS);
                couponDifindustrySendDetail.setMemberCode("1");
                couponDifindustrySendDetail.setSendFailReason("5");
                couponEntityStr = JSONObject.toJSONString((Object)entityPO);
                entityPO.setMemberCode(couponDifindustrySendDetail.getMemberCode());
                couponDifindustrySendDetail.setCouponEntityJson(couponEntityStr);
            } else {
                MemberInfoSimpleVO memberInfoSimpleVO = (MemberInfoSimpleVO)finalCollectMap.get(t2.getPhone());
                entityPO.setMemberCode(memberInfoSimpleVO.getMemberCode());
                couponDifindustrySendDetail.setMemberCode(memberInfoSimpleVO.getMemberCode());
            }
            if (sendCouponDifindustryBo.getIsDeductionQuantity() == 1) {
                ResponseData quantityRecord = this.couponDifindustryQuantityRecordService.addOrUpdateCouponDifindustryQuantityRecord(sourceBusinessId, t2.getMemberCode());
                log.info("quantityRecord:", com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSON((Object)quantityRecord));
                if (quantityRecord == null || com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != quantityRecord.getCode()) {
                    couponDifindustrySendDetail.setSendStatus(SystemConstants.COUPON_DIFINDUSTRY_SEND_FAILE);
                    couponDifindustrySendDetail.setSendFailReason("4");
                    isSave = false;
                    insertSendDetailPOList.add(couponDifindustrySendDetail);
                    continue;
                }
                CouponDifindustrySendDetailPO data = (CouponDifindustrySendDetailPO)((List)quantityRecord.getData()).get(0);
                entityPO.setCouponCode(data.getCouponCode());
                entityPO.setUsePassword(data.getRemark());
                couponDifindustrySendDetail.setCouponDifindustrySendDetailId(data.getCouponDifindustrySendDetailId());
            } else {
                CouponDifindustrySendDetailPO data = this.couponDifindustrySendDetailPOMapper.selectByPrimaryKey(sendCouponDifindustryBo.getCouponDifindustrySendDetailId());
                entityPO.setCouponCode(data.getCouponCode());
                entityPO.setUsePassword(data.getRemark());
                couponDifindustrySendDetail.setCouponDifindustrySendDetailId(data.getCouponDifindustrySendDetailId());
            }
            if (nowDate.after(entityPO.getValidDateEnd())) {
                entityPO.setCouponStatus(SystemConstants.COUPON_STATUS_OVERDUE);
                couponDifindustrySendDetail.setSendStatus(SystemConstants.COUPON_DIFINDUSTRY_SEND_FAILE);
                couponDifindustrySendDetail.setSendFailReason("6");
                isSave = false;
            }
            couponEntityStr = JSONObject.toJSONString((Object)entityPO);
            couponDifindustrySendDetail.setCouponEntityJson(couponEntityStr);
            sendDetailPOList.add(couponDifindustrySendDetail);
            if (!isSave.booleanValue()) continue;
            couponDifindustrySendDetail.setSendStatus(SystemConstants.COUPON_DIFINDUSTRY_SEND_SUCCESS);
            entityPOList.add(entityPO);
            indexMap.put(i, entityPO);
        }
        StringBuffer key = new StringBuffer("coupon:mqConsumer:difindustry:create:");
        key.append(requestVO.getBusinessId()).append(":").append(requestVO.getBusinessType());
        key.append(":").append(sysBrandId).append(":").append(definitionPo.getCouponDefinitionId());
        key.append(":").append(requestVO.getBatchSendCodeDetail()).append(":").append(((MemberInfoSimpleVO)requestVO.getMemberListManual().get(0)).getMemberCode());
        key.append(":").append(sourceBusinessId).append(":").append(sendCouponDifindustryBo.getGuid());
        if (this.redisTemplate.opsForValue().get((Object)key.toString()) != null) {
            log.error("\u5f02\u4e1a\u5238\u91cd\u590d\u53d1\u653e2:" + key.toString());
            return responseData;
        }
        if (!this.redisLock.setNx(key.toString(), 259200L)) {
            log.error("\u5f02\u4e1a\u5238\u91cd\u590d\u53d1\u653e:" + key.toString());
            throw new BizException(-1, "\u5238\u91cd\u590d\u53d1\u653e");
        }
        if (!entityPOList.isEmpty()) {
            this.couponEntityPOMapper.insertBatch(entityPOList);
        }
        Integer sucessCount = 0;
        if (!sendDetailPOList.isEmpty()) {
            for (int i = 0; i < sendDetailPOList.size(); ++i) {
                if (!indexMap.containsKey(i)) continue;
                CouponEntityPO couponEntityPO = (CouponEntityPO)indexMap.get(i);
                ((CouponDifindustrySendDetailPO)sendDetailPOList.get(i)).setCouponEntityId(couponEntityPO.getCouponEntityId());
            }
            this.couponDifindustrySendDetailPOMapper.updateBatch(sendDetailPOList);
            Long count = sendDetailPOList.stream().filter(t -> SystemConstants.COUPON_DIFINDUSTRY_SEND_SUCCESS.equals(t.getSendStatus())).count();
            sucessCount = count.intValue();
        }
        if (!insertSendDetailPOList.isEmpty()) {
            this.couponDifindustrySendDetailPOMapper.insertBatch(insertSendDetailPOList);
        }
        Integer totalNumber = memberList.size();
        Integer failCount = totalNumber - sucessCount;
        SendCouponBatchRequestVO sendCouponBatchRequestVO = new SendCouponBatchRequestVO();
        sendCouponBatchRequestVO.setTotalNumber(totalNumber);
        sendCouponBatchRequestVO.setSucessCount(sucessCount);
        sendCouponBatchRequestVO.setFailCount(failCount);
        sendCouponBatchRequestVO.setRedisKey(key.toString());
        sendCouponBatchRequestVO.setEntityPOList(entityPOList);
        sendCouponBatchRequestVO.setMemberListManual(memberListManual);
        responseData.setData((Object)sendCouponBatchRequestVO);
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<PageInfo<CouponDifindustryVO>> selectDetailPage(CouponDifindustryVO vo, SysAccountPO sysAccountPo) {
        GetMemberDeductionInfo data;
        ResponseData memberInfoByCardNo;
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        vo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        vo.setSysBrandId(sysAccountPo.getBrandId());
        ArrayList BusinessTypeList = new ArrayList();
        if (vo.getTypeList() != null && !vo.getTypeList().isEmpty()) {
            for (Integer key : vo.getTypeList()) {
                CouponSendTypeEnum[] values;
                for (CouponSendTypeEnum value : values = CouponSendTypeEnum.values()) {
                    if (!value.getCode().equals(key)) continue;
                    BusinessTypeList.addAll(value.getDetailTypes());
                }
            }
            vo.setBusinessTypeList(BusinessTypeList);
        }
        if (StringUtil.isNotBlank((CharSequence)vo.getSendCardNo()) && (memberInfoByCardNo = this.memberInfoApiService.getMemberInfoByCardNo(vo.getSendCardNo(), sysAccountPo.getBrandId())) != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == memberInfoByCardNo.getCode() && (data = (GetMemberDeductionInfo)memberInfoByCardNo.getData()) != null) {
            vo.setSendMemberCode(data.getMemberCode());
        }
        if (StringUtil.isNotBlank((CharSequence)vo.getSendMenberPhone())) {
            MemberInfoModel data2;
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setPhone(vo.getSendMenberPhone());
            memberInfoModel.setBrandId(sysAccountPo.getBrandId());
            memberInfoModel.setSysCompanyId(sysAccountPo.getSysCompanyId());
            ResponseData memberModel = this.memberInfoApiService.getMemberModel(memberInfoModel);
            if (memberModel != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == memberModel.getCode() && (data2 = (MemberInfoModel)memberModel.getData()) != null) {
                vo.setSendMemberCode(data2.getMemberCode());
            }
        }
        vo.setValid(SystemConstants.VALID);
        vo.setSendStautsList(Arrays.asList(SystemConstants.COUPON_DIFINDUSTRY_SEND_SUCCESS, SystemConstants.COUPON_DIFINDUSTRY_SEND_FAILE));
        vo.setNotSendMemberCode("1");
        List list = this.couponDifindustrySendDetailPOMapper.selectDetailPage(vo);
        PageInfo pageInfo = new PageInfo(list);
        if (list != null && list.size() > 0) {
            List data3;
            List collect = list.stream().map(CouponDifindustrySendDetailPO::getSendMemberCode).collect(Collectors.toList());
            if (collect != null && !collect.isEmpty()) {
                List data4;
                CouponMemberPo couponMemberPo = new CouponMemberPo();
                couponMemberPo.setBrandId(sysAccountPo.getBrandId());
                couponMemberPo.setSysCompanyId(sysAccountPo.getSysCompanyId());
                couponMemberPo.setMemberCodeList(collect);
                ResponseData memberInfoByCodeList = this.memberInfoApiService.getMemberInfoByCodeList(couponMemberPo);
                if (memberInfoByCodeList != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == memberInfoByCodeList.getCode() && (data4 = (List)memberInfoByCodeList.getData()) != null && !data4.isEmpty()) {
                    Map modelMap = data4.stream().collect(Collectors.toMap(MemberInfoModel::getMemberCode, Function.identity(), (a, b) -> a));
                    list.forEach(t -> {
                        if (modelMap != null && modelMap.containsKey(t.getSendMemberCode())) {
                            MemberInfoModel memberInfoModel = (MemberInfoModel)modelMap.get(t.getSendMemberCode());
                            t.setSendMenberPhone(memberInfoModel.getPhone());
                        }
                    });
                }
            }
            List longList = list.stream().map(CouponDifindustrySendDetailPO::getSourceBrandId).collect(Collectors.toList());
            SysBrandVo sysBrandVo = new SysBrandVo();
            sysBrandVo.setSysCompanyId(sysAccountPo.getSysCompanyId());
            sysBrandVo.setSysBrandIdList(longList);
            ResponseData barndListByBrandIds = this.brandServiceRpc.getBarndListByBrandIds(sysBrandVo);
            if (barndListByBrandIds != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == barndListByBrandIds.getCode() && (data3 = (List)barndListByBrandIds.getData()) != null && !data3.isEmpty()) {
                Map modelMap = data3.stream().collect(Collectors.toMap(SysBrandPo::getSysBrandId, Function.identity(), (a, b) -> a));
                list.forEach(t -> {
                    if (modelMap != null && modelMap.containsKey(t.getSourceBrandId())) {
                        SysBrandPo SysBrandPo2 = (SysBrandPo)modelMap.get(t.getSourceBrandId());
                        t.setSourceBrandName(SysBrandPo2.getBrandName());
                    }
                });
            }
            if (this.couponEntityService.getMemberDataDesensitizeByAccountConfig(sysAccountPo.getSysAccountId()).booleanValue()) {
                for (CouponDifindustryVO resetVo : list) {
                    resetVo.setSendCardNo(DesensitizeUtil.encrypt((String)resetVo.getSendCardNo()));
                    resetVo.setSendMenberPhone(DesensitizeUtil.encrypt((String)resetVo.getSendMenberPhone()));
                }
            }
        }
        responseData.setData((Object)pageInfo);
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<PageInfo<CouponDefinitionVO>> selectCouponDifindustryPage(CouponManualVO vo, SysAccountPO sysAccountPo) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        responseData = this.couponManualService.selectCouponDifindustryPage(vo, sysAccountPo);
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> registerSendDifindustryCoupon(CouponListByMemberCodeRequestVO vo) {
        log.info("\u5f00\u59cb\u8c03\u7528registerSendDifindustryCoupon param:{}" + JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage(), (Object)false);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(vo.getMemberCode());
        memberInfoModel.setBrandId(vo.getSysBrandId());
        memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
        ResponseData otherBrandMember = this.memberInfoApiService.getOtherBrandMember(memberInfoModel);
        log.info("\u8c03\u7528memberInfoApiService.getOtherBrandMember \u7ed3\u679c:" + JacksonUtil.bean2Json((Object)otherBrandMember));
        if (otherBrandMember == null || com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != otherBrandMember.getCode() || otherBrandMember.getData() == null || ((List)otherBrandMember.getData()).isEmpty()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            log.info("\u8c03\u7528registerSendDifindustryCoupon \u6ca1\u6709\u67e5\u8be2\u5230\u540c\u624b\u673a\u53f7\u5176\u4ed6\u54c1\u724c\u7684\u4f1a\u5458");
            return responseData;
        }
        List data = (List)otherBrandMember.getData();
        List collect = data.stream().map(MemberInfoModel::getMemberCode).collect(Collectors.toList());
        CouponDifindustrySendDetailPOExample example = new CouponDifindustrySendDetailPOExample();
        CouponDifindustrySendDetailPOExample.Criteria criteria = example.createCriteria();
        criteria.andSendMemberCodeIn(collect);
        criteria.andSysCompanyIdEqualTo(vo.getSysCompanyId());
        criteria.andSourceBrandIdEqualTo(vo.getSysBrandId());
        criteria.andValidEqualTo(SystemConstants.VALID);
        criteria.andSendStatusEqualTo(SystemConstants.COUPON_DIFINDUSTRY_SEND_SUCCESS);
        criteria.andSendFailReasonEqualTo("5");
        List list = this.couponDifindustrySendDetailPOMapper.selectByExampleWithBLOBs(example);
        log.info("\u8c03\u7528registerSendDifindustryCoupon\u65b9\u6cd5 \u9700\u8981\u540c\u6b65\u5f02\u4e1a\u5238:" + JacksonUtil.bean2Json((Object)list));
        if (list != null && !list.isEmpty()) {
            int i;
            Date nowDate = new Date();
            Map entityPOMap = null;
            List entityIds = list.stream().filter(t -> t.getCouponEntityId() != null).map(CouponDifindustrySendDetailPO::getCouponEntityId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(entityIds)) {
                CouponEntityPOExample entityPOExample = new CouponEntityPOExample();
                CouponEntityPOExample.Criteria poExampleCriteria = entityPOExample.createCriteria();
                poExampleCriteria.andCouponEntityIdIn(entityIds);
                poExampleCriteria.andValidEqualTo(Boolean.valueOf(true));
                List couponEntityPOList = this.couponEntityPOMapper.selectByExample(entityPOExample);
                if (CollectionUtils.isNotEmpty((Collection)couponEntityPOList)) {
                    entityPOMap = couponEntityPOList.stream().collect(Collectors.toMap(CouponEntityPO::getCouponEntityId, Function.identity(), (a, b) -> b));
                }
            }
            ArrayList<CouponEntityPO> insertEntityPOList = new ArrayList<CouponEntityPO>();
            ArrayList<CouponEntityPO> updateEntityPOList = new ArrayList<CouponEntityPO>();
            HashMap syncOfflineMap = new HashMap();
            HashMap syncOnlineMap = new HashMap();
            HashMap<Integer, CouponEntityPO> indexMap = new HashMap<Integer, CouponEntityPO>();
            for (i = 0; i < list.size(); ++i) {
                List<CouponEntityPO> entityPOList;
                CouponDifindustrySendDetailPO been = (CouponDifindustrySendDetailPO)list.get(i);
                String couponEntityJson = been.getCouponEntityJson();
                JSONObject jsonObject = JSONObject.parseObject((String)couponEntityJson);
                CouponEntityPO entityPO = (CouponEntityPO)JSONObject.toJavaObject((JSON)jsonObject, CouponEntityPO.class);
                entityPO.setMemberCode(vo.getMemberCode());
                if (nowDate.after(entityPO.getValidDateEnd())) {
                    entityPO.setCouponStatus(SystemConstants.COUPON_STATUS_OVERDUE);
                }
                been.setSendStatus(SystemConstants.COUPON_DIFINDUSTRY_SEND_SUCCESS);
                been.setSendFailReason(null);
                been.setMemberCode(vo.getMemberCode());
                indexMap.put(i, entityPO);
                if (null != entityPOMap && entityPOMap.containsKey(been.getCouponEntityId())) {
                    List<CouponEntityPO> entityPOList2;
                    CouponEntityPO coupon = (CouponEntityPO)entityPOMap.get(been.getCouponEntityId());
                    if (coupon.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) continue;
                    CouponEntityPO couponEntityPO = new CouponEntityPO();
                    couponEntityPO.setCouponEntityId(been.getCouponEntityId());
                    couponEntityPO.setMemberCode(vo.getMemberCode());
                    updateEntityPOList.add(couponEntityPO);
                    if (syncOnlineMap.containsKey(entityPO.getCouponDefinitionId())) {
                        entityPOList2 = (List)syncOnlineMap.get(entityPO.getCouponDefinitionId());
                        entityPOList2.add(entityPO);
                        continue;
                    }
                    entityPOList2 = new ArrayList<CouponEntityPO>();
                    entityPOList2.add(entityPO);
                    syncOnlineMap.put(entityPO.getCouponDefinitionId(), entityPOList2);
                    continue;
                }
                insertEntityPOList.add(entityPO);
                if (syncOfflineMap.containsKey(entityPO.getCouponDefinitionId())) {
                    entityPOList = (List)syncOfflineMap.get(entityPO.getCouponDefinitionId());
                    entityPOList.add(entityPO);
                    continue;
                }
                entityPOList = new ArrayList<CouponEntityPO>();
                entityPOList.add(entityPO);
                syncOfflineMap.put(entityPO.getCouponDefinitionId(), entityPOList);
            }
            if (!insertEntityPOList.isEmpty()) {
                this.couponEntityPOMapper.insertBatch(insertEntityPOList);
                for (i = 0; i < list.size(); ++i) {
                    if (!indexMap.containsKey(i)) continue;
                    CouponEntityPO couponEntityPO = (CouponEntityPO)indexMap.get(i);
                    ((CouponDifindustrySendDetailPO)list.get(i)).setCouponEntityId(couponEntityPO.getCouponEntityId());
                }
                this.registerSendDifindustryCouponSendMessage(syncOfflineMap, Boolean.valueOf(true), memberInfoModel);
            }
            if (!updateEntityPOList.isEmpty()) {
                this.couponEntityPOMapper.updateBatchByPrimaryKey(updateEntityPOList);
                this.registerSendDifindustryCouponSendMessage(syncOnlineMap, Boolean.valueOf(false), memberInfoModel);
            }
            this.couponDifindustrySendDetailPOMapper.updateBatch(list);
        }
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)true);
        log.info("\u7ed3\u675f\u8c03\u7528registerSendDifindustryCoupon \u53d1\u5f02\u4e1a\u5238\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> asyncBatchSendCounpon(List<SendCouponAsyncSimpleRequestVO> list) throws CouponException {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        if (list != null && !list.isEmpty()) {
            Map collectmap = null;
            List collect = list.stream().map(SendCouponAsyncSimpleRequestVO::getManualId).collect(Collectors.toList());
            List<Object> couponIdList = new ArrayList();
            if (collect != null && !collect.isEmpty()) {
                CouponManualPOExample example = new CouponManualPOExample();
                CouponManualPOExample.Criteria criteria = example.createCriteria();
                criteria.andCouponManualIdIn(collect);
                List couponManualPOS = this.couponManualPOMapper.selectByExample(example);
                collectmap = couponManualPOS.stream().collect(Collectors.toMap(CouponManualPO::getCouponManualId, Function.identity(), (a, b) -> a));
                couponIdList = couponManualPOS.stream().map(t -> Long.valueOf(t.getCouponDefinitionId())).collect(Collectors.toList());
            }
            HashMap<Integer, Long> LongMap = new HashMap<Integer, Long>();
            for (int i = 0; i < list.size(); ++i) {
                SendCouponAsyncSimpleRequestVO vo = list.get(i);
                if (collectmap == null || !collectmap.containsKey(vo.getManualId())) {
                    throw new CouponException(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
                }
                CouponDefinitionVO recordPO = new CouponDefinitionVO();
                recordPO.setManualId(vo.getManualId());
                recordPO.setTotalQuantiy(Integer.valueOf(1));
                recordPO.setSendGuideId(vo.getSendGuideId());
                recordPO.setCouponQuotaId(vo.getCouponQuotaId());
                recordPO.setMemberCode(vo.getMemberCode());
                ResponseData quantityRecord = this.couponDifindustryQuantityRecordService.addOrUpdateCouponDifindustryQuantityRecord(recordPO);
                if (SysResponseEnum.FAILED.getCode() == quantityRecord.getCode()) {
                    throw new CouponException("\u8d85\u51fa\u5151\u6362\u5377\u6570\u91cf\u9650\u5236");
                }
                CouponDifindustrySendDetailPO data = (CouponDifindustrySendDetailPO)((List)quantityRecord.getData()).get(0);
                LongMap.put(i, data.getCouponDifindustrySendDetailId());
            }
            CouponDefinitionPOExample example = new CouponDefinitionPOExample();
            CouponDefinitionPOExample.Criteria criteria = example.createCriteria();
            criteria.andCouponDefinitionIdIn(couponIdList);
            List couponDefinitionPOS = this.couponDefinitionPOMapper.selectByExample(example);
            Map<Long, CouponDefinitionPOWithBLOBs> couponMap = couponDefinitionPOS.stream().collect(Collectors.toMap(CouponDefinitionPO::getCouponDefinitionId, t -> {
                CouponDefinitionPOWithBLOBs coupon = new CouponDefinitionPOWithBLOBs();
                BeanUtils.copyProperties((Object)t, (Object)coupon);
                return coupon;
            }));
            for (int i = 0; i < list.size(); ++i) {
                SendCouponAsyncSimpleRequestVO vo = list.get(i);
                Byte isDeductionQuantity = LongMap.containsKey(i) ? (byte)0 : 1;
                this.setSendCouponByMq(vo, collectmap, couponMap, isDeductionQuantity, (Long)LongMap.get(i));
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            }
        }
        return responseData;
    }

    public ResponseData<CouponDefinitionPO> findBycouponDifindustrySendDetailId(Long couponDifindustrySendDetailId) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        CouponDifindustrySendDetailPO couponDifindustrySendDetailPO = this.couponDifindustrySendDetailPOMapper.selectByPrimaryKey(couponDifindustrySendDetailId);
        if (couponDifindustrySendDetailPO != null) {
            String couponDefinitionId = couponDifindustrySendDetailPO.getCouponDefinitionId();
            Long id = Long.valueOf(couponDefinitionId);
            CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(id);
            CouponDefinitionPO couponDefinitionPO = new CouponDefinitionPO();
            BeanUtils.copyProperties((Object)couponDefinitionPOWithBLOBs, (Object)couponDefinitionPO);
            couponDefinitionPO.setValidDateStart(couponDifindustrySendDetailPO.getValidDateStart());
            couponDefinitionPO.setValidDateEnd(couponDifindustrySendDetailPO.getValidDateEnd());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)couponDefinitionPO);
        }
        return responseData;
    }

    public ResponseData<CouponDetailResponseVO> findCouponByDifindustrySendDetailId(Long couponDifindustrySendDetailId) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        CouponDifindustrySendDetailPO couponDifindustrySendDetailPO = this.couponDifindustrySendDetailPOMapper.selectByPrimaryKey(couponDifindustrySendDetailId);
        if (couponDifindustrySendDetailPO != null) {
            CouponDetailResponseVO vo = new CouponDetailResponseVO();
            String couponDefinitionId = couponDifindustrySendDetailPO.getCouponDefinitionId();
            Long id = Long.valueOf(couponDefinitionId);
            CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(id);
            CouponDefinitionPO couponDefinitionPO = new CouponDefinitionPO();
            BeanUtils.copyProperties((Object)couponDefinitionPOWithBLOBs, (Object)couponDefinitionPO);
            couponDefinitionPO.setValidDateStart(couponDifindustrySendDetailPO.getValidDateStart());
            couponDefinitionPO.setValidDateEnd(couponDifindustrySendDetailPO.getValidDateEnd());
            if (couponDifindustrySendDetailPO.getCouponEntityId() != null) {
                Long couponEntityId = couponDifindustrySendDetailPO.getCouponEntityId();
                CouponEntityPO couponEntityPO = this.couponEntityPOMapper.selectByPrimaryKey(couponEntityId);
                vo.setCouponEntityPO(couponEntityPO);
            }
            vo.setCouponDefinitionPO(couponDefinitionPO);
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)vo);
        }
        return responseData;
    }

    public ResponseData<String> asyncSimpleSendDifindustryCoupon(SendCouponAsyncSimpleRequestVO vo) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(vo.getManualId());
        if (couponManualPO == null) {
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        HashMap<Long, CouponManualPO> collectmap = new HashMap<Long, CouponManualPO>();
        collectmap.put(vo.getManualId(), couponManualPO);
        Long couponId = Long.valueOf(couponManualPO.getCouponDefinitionId());
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(couponId);
        if (couponDefinitionPOWithBLOBs == null) {
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        if (Boolean.FALSE.equals(couponDefinitionPOWithBLOBs.getStatus())) {
            log.info("\u5238\u5b9a\u4e49\u88ab\u505c\u7528,\u4e0d\u5141\u8bb8\u53d1\u5238,\u5238\u5b9a\u4e49id={}", (Object)couponDefinitionPOWithBLOBs.getCouponDefinitionId());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_ALREADY_DEACTIVATE.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_ALREADY_DEACTIVATE.getMessage());
            return responseData;
        }
        HashMap<Long, CouponDefinitionPOWithBLOBs> couponMap = new HashMap<Long, CouponDefinitionPOWithBLOBs>();
        couponMap.put(couponId, couponDefinitionPOWithBLOBs);
        this.setSendCouponByMq(vo, collectmap, couponMap, Byte.valueOf((byte)1), null);
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<List<CouponDifindustryVO>> getDifindustryAnalysisByBusinessIdList(CouponDifindustryVO vo) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        vo.setValid(SystemConstants.VALID);
        List list = this.couponDifindustrySendDetailPOMapper.getDifindustryAnalysisByBusinessIdList(vo);
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)list);
        return responseData;
    }

    public ResponseData<PageInfo<CouponSendMemberListResponseVO>> findCouponSendMemberList(CouponSendMemberListRequestVO param) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        List memberCodeList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)param.getName()) || StringUtils.isNotEmpty((CharSequence)param.getCardNo())) {
            MemberInfoApiModel memberInfoApiModel = new MemberInfoApiModel();
            memberInfoApiModel.setName(param.getName());
            memberInfoApiModel.setCardNo(param.getCardNo());
            memberInfoApiModel.setBrandId(param.getBrandId());
            memberInfoApiModel.setSysCompanyId(param.getSysCompanyId());
            memberInfoApiModel.setPageNumber(Integer.valueOf(0));
            memberInfoApiModel.setPageSize(Integer.valueOf(1000));
            while (true) {
                memberInfoApiModel.setPageNumber(Integer.valueOf(memberInfoApiModel.getPageNumber() + 1));
                ResponseData apiServiceMemberInfo = this.memberInfoApiService.getMemberInfo(memberInfoApiModel);
                if (apiServiceMemberInfo == null || com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != apiServiceMemberInfo.getCode() || apiServiceMemberInfo.getData() == null || ((com.bizvane.utils.responseinfo.PageInfo)apiServiceMemberInfo.getData()).getList() == null || ((com.bizvane.utils.responseinfo.PageInfo)apiServiceMemberInfo.getData()).getList().isEmpty()) break;
                List memberList = ((com.bizvane.utils.responseinfo.PageInfo)apiServiceMemberInfo.getData()).getList();
                List collect = memberList.stream().map(MemberInfoModel::getMemberCode).collect(Collectors.toList());
                memberCodeList.addAll(collect);
            }
            if (CollectionUtils.isEmpty(memberCodeList)) {
                PageInfo pageInfo = new PageInfo(new ArrayList());
                responseData.setData((Object)pageInfo);
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
        }
        CouponDifindustrySendDetailPOExample example = new CouponDifindustrySendDetailPOExample();
        CouponDifindustrySendDetailPOExample.Criteria criteria = example.createCriteria();
        criteria.andValidEqualTo(SystemConstants.VALID);
        criteria.andSysCompanyIdEqualTo(param.getSysCompanyId());
        criteria.andSysBrandIdEqualTo(param.getBrandId());
        criteria.andBusinessIdEqualTo(param.getSendBusinessId());
        criteria.andBusinessTypeEqualTo(param.getSendType());
        if (CollectionUtils.isNotEmpty(memberCodeList)) {
            criteria.andSendMemberCodeIn(memberCodeList);
        }
        criteria.andSendMemberCodeNotEqualTo("1");
        example.setOrderByClause("create_date DESC");
        PageHelper.startPage((int)param.getPageNumber(), (int)param.getPageSize());
        List list = this.couponDifindustrySendDetailPOMapper.selectByExample(example);
        PageInfo pageInfoList = new PageInfo(list);
        List<Object> responseList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map collectMap = null;
            memberCodeList = list.stream().map(CouponDifindustrySendDetailPO::getSendMemberCode).collect(Collectors.toList());
            CouponMemberPo couponMemberPo = new CouponMemberPo();
            couponMemberPo.setMemberCodeList(memberCodeList);
            couponMemberPo.setBrandId(param.getBrandId());
            ResponseData memberListResult = this.memberInfoApiService.getCompanyWxMemberInfo(couponMemberPo);
            if (memberListResult != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == memberListResult.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)memberListResult.getData()))) {
                List memberList = (List)memberListResult.getData();
                collectMap = memberList.stream().collect(Collectors.toMap(CompanyMemberInfoBo::getMemberCode, Function.identity(), (a, b) -> b));
            }
            Map finalCollectMap = collectMap;
            responseList = list.stream().map(t -> {
                CouponSendMemberListResponseVO vo = new CouponSendMemberListResponseVO();
                vo.setSendDate(t.getCreateDate());
                if (finalCollectMap != null && finalCollectMap.containsKey(t.getSendMemberCode())) {
                    CompanyMemberInfoBo member = (CompanyMemberInfoBo)finalCollectMap.get(t.getSendMemberCode());
                    vo.setCardNo(member.getCardNo());
                    vo.setMemberName(member.getName());
                    vo.setLevelName(member.getLevelName());
                }
                return vo;
            }).collect(Collectors.toList());
        }
        PageInfo pageInfo = new PageInfo(responseList);
        pageInfo.setPageNum(pageInfoList.getPageNum());
        pageInfo.setPageSize(pageInfoList.getPageSize());
        pageInfo.setSize(pageInfoList.getSize());
        pageInfo.setPages(pageInfoList.getPages());
        pageInfo.setPrePage(pageInfoList.getPrePage());
        pageInfo.setNextPage(pageInfoList.getNextPage());
        pageInfo.setTotal(pageInfoList.getTotal());
        responseData.setData((Object)pageInfo);
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<PageInfo<CouponEntityAndDefinitionVO>> getOtherBrandDifindustryCoupon(CouponListByMemberCodeRequestVO vo) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(vo.getMemberCode());
        memberInfoModel.setBrandId(vo.getSysBrandId());
        memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
        ResponseData otherBrandMember = this.memberInfoApiService.getOtherBrandMember(memberInfoModel);
        if (otherBrandMember != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == otherBrandMember.getCode() && otherBrandMember.getData() != null && !((List)otherBrandMember.getData()).isEmpty()) {
            List data = (List)otherBrandMember.getData();
            vo.setMemberCodeList(data);
        }
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        vo.setSendStatus(SystemConstants.COUPON_DIFINDUSTRY_SEND_SUCCESS);
        vo.setSendType(SendTypeEnum.SEND_COUPON_DIF.getCode());
        vo.setSendFailReason("5");
        vo.setCouponStatusList(Arrays.asList(SystemConstants.COUPON_STATUS_UNUSED, SystemConstants.COUPON_STATUS_OVERDUE, SystemConstants.COUPON_STATUS_USED));
        String defaultMemberCode = "1";
        List list = this.couponDifindustrySendDetailPOMapper.getOtherBrandDifindustryCoupon(vo, defaultMemberCode);
        PageInfo pageInfo = null;
        if (list != null && !list.isEmpty()) {
            pageInfo = new PageInfo(list);
            List collect = list.stream().map(CouponEntityAndDefinitionVO::getSysBrandId).distinct().collect(Collectors.toList());
            ResponseData appByBrandList = this.wxMiniprgmServiceFeign.getPersionAppByBrandList(collect);
            if (appByBrandList != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == appByBrandList.getCode()) {
                List publicPOS = (List)appByBrandList.getData();
                Map collectMap = publicPOS.stream().collect(Collectors.toMap(WxPublicPO::getSysBrandId, Function.identity(), (a, b) -> a));
                for (CouponEntityAndDefinitionVO been : list) {
                    if (collectMap == null || !collectMap.containsKey(been.getSysBrandId())) continue;
                    WxPublicPO wxPublicPO = (WxPublicPO)collectMap.get(been.getSysBrandId());
                    been.setAppId(wxPublicPO.getAppid());
                }
            }
        } else {
            pageInfo = new PageInfo(new ArrayList());
        }
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<String> reduceDifindustryCouponQuantity(CouponDefinitionVO vo) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        vo.setIsdDistributeGuide(SystemConstants.DISTRIBUTE_COUPON_GUIDE);
        ResponseData listResponseData = this.couponDifindustryQuantityRecordService.addOrUpdateCouponDifindustryQuantityRecord(vo);
        responseData.setCode(listResponseData.getCode());
        responseData.setMessage(listResponseData.getMessage());
        return responseData;
    }

    public ResponseData<String> releaseDifindustryCouponQuantity(SendCouponSimpleRequestVO vo) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        if (CollectionUtils.isEmpty((Collection)vo.getSendGuideIdList())) {
            responseData.setMessage("\u5bfc\u8d2d\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        CouponDefinitionVO record = new CouponDefinitionVO();
        record.setManualId(vo.getManualId());
        record.setSendGuideId(vo.getSendGuideId());
        record.setTotalQuantiy(vo.getSendCouponQuantity());
        record.setSendGuideIdList(vo.getSendGuideIdList());
        record.setCouponQuotaId(vo.getCouponQuotaId());
        record.setIsdDistributeGuide(SystemConstants.RELEASE_COUPON_GUIDE);
        ResponseData listResponseData = this.couponDifindustryQuantityRecordService.addOrUpdateCouponDifindustryQuantityRecord(record);
        responseData.setCode(listResponseData.getCode());
        responseData.setMessage(listResponseData.getMessage());
        return responseData;
    }

    private void setSendCouponByMq(SendCouponAsyncSimpleRequestVO vo, Map<Long, CouponManualPO> collectmap, Map<Long, CouponDefinitionPOWithBLOBs> couponMap, Byte isDeductionQuantity, Long couponDifindustrySendDetailId) {
        CouponManualPO po = collectmap.get(vo.getManualId());
        String memberCode = vo.getMemberCode();
        Long brandId = vo.getBrandId();
        Long sourceBrandId = po.getSysBrandId();
        Long sysCompanyId = po.getSysCompanyId();
        SendCouponDifindustryBo sendCouponDifindustryBo = new SendCouponDifindustryBo();
        CouponDefinitionPOWithBLOBs coupon = couponMap.get(Long.valueOf(po.getCouponDefinitionId()));
        sendCouponDifindustryBo.setCouponDefinitionPOWithBLOBs(coupon);
        sendCouponDifindustryBo.setBatchNum(po.getBatchNum());
        sendCouponDifindustryBo.setSysCompanyId(sysCompanyId);
        sendCouponDifindustryBo.setSysBrandId(brandId);
        sendCouponDifindustryBo.setSourceBrandId(sourceBrandId);
        sendCouponDifindustryBo.setSourceBusinessId(po.getCouponManualId());
        sendCouponDifindustryBo.setGuid(UUID.randomUUID().toString());
        sendCouponDifindustryBo.setCouponDifindustrySendDetailId(couponDifindustrySendDetailId);
        SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
        ArrayList<MemberInfoSimpleVO> memberList = new ArrayList<MemberInfoSimpleVO>();
        MemberInfoSimpleVO memberInfoSimpleVO = new MemberInfoSimpleVO();
        memberInfoSimpleVO.setMemberCode(memberCode);
        memberList.add(memberInfoSimpleVO);
        requestVO.setBusinessId(vo.getSendBussienId());
        requestVO.setBusinessType(vo.getSendType());
        requestVO.setBusinessName(vo.getBusinessName());
        requestVO.setSysCompanyId(sysCompanyId);
        requestVO.setSysBrandId(brandId);
        requestVO.setBatchSendCodeDetail(coupon.getCouponDefinitionId());
        requestVO.setCouponDefinitionId(coupon.getCouponDefinitionId());
        requestVO.setMemberListManual(memberList);
        sendCouponDifindustryBo.setRequestVO(requestVO);
        sendCouponDifindustryBo.setIsDeductionQuantity(isDeductionQuantity);
        CouponBatchSendRecordPO boBatchPO = new CouponBatchSendRecordPO();
        BeanUtils.copyProperties((Object)requestVO, (Object)boBatchPO);
        boBatchPO.setBizType(vo.getSendType());
        Long mqMbrMemberId = 0L;
        this.sendCouponBatchDifindustryNow(sendCouponDifindustryBo, boBatchPO, mqMbrMemberId);
    }

    @Async
    public void registerSendDifindustryCouponSendMessage(Map<String, List<CouponEntityPO>> map, Boolean isSyncOffline, MemberInfoModel m) {
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(m);
        MemberInfoModel data = (MemberInfoModel)singleMemberModel.getData();
        ArrayList<MemberInfoSimpleVO> memBerList = new ArrayList<MemberInfoSimpleVO>();
        MemberInfoSimpleVO memberInfoSimpleVO = new MemberInfoSimpleVO();
        BeanUtils.copyProperties((Object)data, (Object)memberInfoSimpleVO);
        memBerList.add(memberInfoSimpleVO);
        for (Map.Entry<String, List<CouponEntityPO>> entry : map.entrySet()) {
            String couponDefinitionId = entry.getKey();
            long id = Long.parseLong(couponDefinitionId);
            List<CouponEntityPO> entityPOList = entry.getValue();
            CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(id));
            String topic = TopicEnum.getTopic((int)1);
            String tags = "tagDifindustryCouponService";
            if (SystemConstants.USE_CHANNEL_ONLINE.equals(definitionPO.getUseChannel()) || SystemConstants.USE_CHANNEL_INTEGRAL.equals(definitionPO.getUseChannel())) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPO));
                jsonObject.put("entityPOList", (Object)JSONObject.toJSONString(entityPOList));
                this.rocketMQProducerService.sendWechatMessage(topic, tags, (Object)jsonObject, definitionPO.getSysCompanyId().longValue());
                log.info("TagOnlineSendCouponService\u7ebf\u4e0a\u5238\u53d1\u9001\u6d88\u606f");
                continue;
            }
            if (null == isSyncOffline || !isSyncOffline.booleanValue()) continue;
            log.info("\u7ebf\u4e0a\u903b\u8f91\u5904\u7406\u5b8c\u6210, \u6254\u5230\u7b2c\u4e8c\u5c42topic" + topic);
            JSONObject jsonObjectMq = new JSONObject();
            jsonObjectMq.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPO));
            for (CouponEntityPO couponEntityPO : entityPOList) {
                CouponBatchSendRecordPO couponBatchSendRecordPO = new CouponBatchSendRecordPO();
                couponBatchSendRecordPO.setSysCompanyId(couponEntityPO.getSysCompanyId());
                couponBatchSendRecordPO.setSysBrandId(couponEntityPO.getSysBrandId());
                couponBatchSendRecordPO.setBizCode(String.valueOf(couponEntityPO.getSendBusinessId()));
                couponBatchSendRecordPO.setBizType(SendTypeEnum.SEND_COUPON_DIF.getCode());
                jsonObjectMq.put("batchPO", (Object)JSONObject.toJSONString((Object)couponBatchSendRecordPO));
                SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
                BeanUtils.copyProperties((Object)couponBatchSendRecordPO, (Object)requestVO);
                requestVO.setCouponDefinitionId(definitionPO.getCouponDefinitionId());
                requestVO.setBusinessId(Long.valueOf(Long.parseLong(couponBatchSendRecordPO.getBizCode())));
                requestVO.setBusinessType(couponBatchSendRecordPO.getBizType());
                requestVO.setBatchSendCodeDetail(Long.valueOf(BusinessCodeUtil.getCouponBatchSendCodelong()));
                requestVO.setMemberListManual(memBerList);
                jsonObjectMq.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVO));
                ArrayList<CouponEntityPO> arr = new ArrayList<CouponEntityPO>();
                arr.add(couponEntityPO);
                jsonObjectMq.put("entityPOList", (Object)JSONObject.toJSONString(arr));
                this.rocketMQProducerService.sendOfflineMessage(topic, tags, (Object)jsonObjectMq, definitionPO.getSysCompanyId().longValue());
            }
        }
    }

    @Async
    public void sendDifindustryCouponContinue(Long businessId, List<SendCouponDifindustryBo> list, CouponBatchSendRecordPO batchPO) {
        String bizType = batchPO.getBizType();
        log.info("\u5f02\u6b65\u6267\u884c\u53d1\u5238\u4efb\u52a1:" + businessId + ",\u53d1\u5377\u7c7b\u578b" + bizType);
        StringBuffer stringBuffer = new StringBuffer("sendDifindustryCouponContinue_");
        stringBuffer.append("bizType:").append(bizType);
        stringBuffer.append("businessId:").append(businessId);
        this.redisLock.setNx(stringBuffer.toString(), 60L);
        Long mqMbrMemberId = 0L;
        if (SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(bizType)) {
            CouponManualPO manualPO = this.couponManualService.getCouponManualPoById(businessId);
            if (manualPO == null || manualPO.getMqState() == null || manualPO.getMqState() != 0) {
                log.info("\u53d1\u5238\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u4e0d\u518d\u6267\u884c");
                return;
            }
            mqMbrMemberId = manualPO.getMqMbrMemberId();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("businessId", businessId);
            map.put("businessType", bizType);
            map.put("sendCouponDifindustryBoList", list);
            map.put("batchPO", batchPO);
            this.couponManualService.updateMqCouponJson(businessId, JSONObject.toJSONString(map));
            this.couponManualService.updateMqMbrMemberId(businessId, Long.valueOf(0L), 2);
            this.couponManualService.updateMqCouponJson(businessId, "");
        }
        for (int i = 0; i < list.size(); ++i) {
            SendCouponDifindustryBo sendCouponDifindustryBo = list.get(i);
            this.sendCouponBatchDifindustryNow(sendCouponDifindustryBo, batchPO, mqMbrMemberId);
        }
    }

    public ResponseData<String> sendCouponBatchDifindustryNow(SendCouponDifindustryBo sendCouponDifindustryBo, CouponBatchSendRecordPO boBatchPO, Long mqMbrMemberId) {
        ResponseData responseData = new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
        MembersInfoSearchVo searchVo = null;
        Long bussessId = null;
        SendCouponBatchRequestVO sendCouponBatchRequestVO = sendCouponDifindustryBo.getRequestVO();
        CouponDefinitionPOWithBLOBs definitionPO = sendCouponDifindustryBo.getCouponDefinitionPOWithBLOBs();
        if (Boolean.FALSE.equals(definitionPO.getStatus())) {
            log.info("\u5238\u5b9a\u4e49\u88ab\u505c\u7528,\u4e0d\u5141\u8bb8\u53d1\u5238,\u5238\u5b9a\u4e49id={}", (Object)definitionPO.getCouponDefinitionId());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_ALREADY_DEACTIVATE.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_ALREADY_DEACTIVATE.getMessage());
            return responseData;
        }
        ResponseData esFirstResult = null;
        if (!SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(boBatchPO.getBizType())) {
            SendCouponBatchRequestVO requestVO = sendCouponDifindustryBo.getRequestVO();
            List memberListManual = requestVO.getMemberListManual();
            List memberCodeList = memberListManual.stream().map(MemberInfoSimpleVO::getMemberCode).collect(Collectors.toList());
            CouponMemberPo couponMemberPo = new CouponMemberPo();
            couponMemberPo.setMemberCodeList(memberCodeList);
            couponMemberPo.setBrandId(sendCouponDifindustryBo.getSysBrandId());
            couponMemberPo.setSysCompanyId(sendCouponBatchRequestVO.getSysCompanyId());
            ResponseData memberInfoByCodeList = this.memberInfoApiService.getMemberInfoByCodeList(couponMemberPo);
            if (memberInfoByCodeList != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == memberInfoByCodeList.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)memberInfoByCodeList.getData()))) {
                List data = (List)memberInfoByCodeList.getData();
                List list = data.stream().map(t -> {
                    MemberInfoSimpleVO memberInfoSimpleVO = new MemberInfoSimpleVO();
                    memberInfoSimpleVO.setMbrMemberId(t.getMbrMemberId());
                    memberInfoSimpleVO.setPhone(t.getPhone());
                    memberInfoSimpleVO.setMemberCode(t.getMemberCode());
                    memberInfoSimpleVO.setCardNo(t.getCardNo());
                    memberInfoSimpleVO.setErpId(t.getErpId());
                    memberInfoSimpleVO.setOfflineCardNo(t.getOfflineCardNo());
                    return memberInfoSimpleVO;
                }).collect(Collectors.toList());
                sendCouponBatchRequestVO.setTotalNumber(Integer.valueOf(data.size()));
                sendCouponBatchRequestVO.setCouponManualId(bussessId);
                sendCouponBatchRequestVO.setMemberListManual(list);
                SendResult sendResult = this.mqSendCouponService.sendDifindustryCoupon(sendCouponDifindustryBo, boBatchPO, data.size());
                log.info("sendDifinstryCouponBatchNow Mq\u53d1\u9001\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)sendResult));
            }
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        CouponManualPO manualPO = this.couponManualService.getCouponManualPoById(sendCouponBatchRequestVO.getBusinessId());
        searchVo = (MembersInfoSearchVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)manualPO.getMemberCondition()), MembersInfoSearchVo.class);
        searchVo.setPageNumber(SystemConstants.SEARCH_MEMBERS_PAGE_NUMBER);
        searchVo.setPageSize(SystemConstants.SEARCH_MEMBERS_PAGE_SIZE_TEM);
        searchVo.setSysCompanyId(sendCouponBatchRequestVO.getSysCompanyId());
        log.info("sendCouponBatchOfflineNow advancedSearch ent\uff1a" + JSONObject.toJSONString((Object)searchVo));
        bussessId = manualPO.getCouponManualId();
        esFirstResult = this.membersAdvancedSearchApiService.advancedSearch(searchVo);
        log.info("sendDifinstryCouponBatchNow advancedSearch out\uff1a" + JSONObject.toJSONString((Object)esFirstResult));
        if (esFirstResult == null || esFirstResult.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode()) {
            this.updateSendCouponBatchException(boBatchPO, boBatchPO.getSendNum(), (CouponDefinitionPO)definitionPO);
            return responseData;
        }
        int totalNumber = new Long(((com.bizvane.utils.responseinfo.PageInfo)esFirstResult.getData()).getTotal()).intValue();
        StringBuffer key = new StringBuffer("coupon:mqConsumer:offLine:sum:");
        key.append(definitionPO.getCouponDefinitionId()).append("::").append(sendCouponBatchRequestVO.getBatchSendCodeDetail());
        if (this.redisLock.setNx(key.toString(), 604800L)) {
            this.updateSendNum(Integer.valueOf(totalNumber), boBatchPO);
        }
        sendCouponBatchRequestVO.setTotalNumber(Integer.valueOf(totalNumber));
        sendCouponBatchRequestVO.setCouponManualId(bussessId);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order();
        order.setDirection(DirectionEnum.ASC);
        order.setProperty("mbrMemberId");
        orderList.add(order);
        searchVo.setOrders(orderList);
        while (true) {
            ArrayList<SearchRangRequest> searchRangRequestList = new ArrayList<SearchRangRequest>();
            SearchRangRequest searchRangRequest = new SearchRangRequest();
            searchRangRequest.setMin(String.valueOf(mqMbrMemberId));
            searchRangRequestList.add(searchRangRequest);
            searchVo.setMbrMemberIdRanges(searchRangRequestList);
            ResponseData esResult = this.membersAdvancedSearchApiService.advancedSimpleSearch(searchVo);
            if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != esResult.getCode()) break;
            List dataList = ((com.bizvane.utils.responseinfo.PageInfo)esResult.getData()).getList();
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return responseData;
            }
            for (MemberInfoSimpleVO memberInfoSimpleVO : dataList) {
                ArrayList<MemberInfoSimpleVO> memberListManual = new ArrayList<MemberInfoSimpleVO>();
                memberListManual.add(memberInfoSimpleVO);
                sendCouponBatchRequestVO.setMemberListManual(memberListManual);
                SendResult sendResult = null;
                sendResult = this.mqSendCouponService.sendDifindustryCoupon(sendCouponDifindustryBo, boBatchPO, totalNumber);
                log.info("Send MQ is ok sendCouponBatchOfflineNow sendMQMessageId:!" + sendResult.getMsgId());
                String bizType = boBatchPO.getBizType();
                if (!SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(bizType)) continue;
                this.couponManualService.updateMqMbrMemberId(Long.valueOf(Long.parseLong(boBatchPO.getBizCode())), memberInfoSimpleVO.getMbrMemberId(), 1);
                this.couponManualPOMapper.updateMemberCount(Integer.valueOf(1), Long.valueOf(Long.parseLong(boBatchPO.getBizCode())));
            }
            mqMbrMemberId = ((MemberInfoSimpleVO)dataList.get(dataList.size() - 1)).getMbrMemberId();
        }
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public void updateSendNum(Integer totalNumber, CouponBatchSendRecordPO batchPo) {
        if (SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(batchPo.getBizType())) {
            this.couponBatchSendRecordPOMapper.updateSendNum(totalNumber, batchPo.getCouponBatchSendRecordId());
        }
    }

    public void updateSendCouponBatchException(CouponBatchSendRecordPO batchPo, Integer count, CouponDefinitionPO definitionPo) {
        if (SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(batchPo.getBizType())) {
            this.couponBatchSendRecordPOMapper.updateFailNum(count, batchPo.getCouponBatchSendRecordId());
            int syncFailCount = 0;
            if (definitionPo.getUseChannel().equals(SystemConstants.USE_CHANNEL_OFFLINE) || definitionPo.getUseChannel().equals(SystemConstants.USE_CHANNEL_ANY)) {
                syncFailCount = count;
            }
            this.couponManualPOMapper.updateCouponManualFailCount(count.intValue(), syncFailCount, Long.valueOf(Long.parseLong(batchPo.getBizCode())));
            this.couponManualService.updateTaskStatus(Long.valueOf(Long.parseLong(batchPo.getBizCode())), Byte.valueOf(CouponManualTaskStatusEnum.TASK_STATUS_PART_FAIL.getCode().byteValue()));
        }
    }
}

