/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.core.facade.enums.ActionLogEnum;
import com.bizvane.core.facade.interfaces.SysCommonActionLogService;
import com.bizvane.couponfacade.enums.CouponManualTaskStatusEnum;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponDifindustryQuantityRecordPO;
import com.bizvane.couponfacade.models.po.CouponDifindustrySendDetailPO;
import com.bizvane.couponfacade.models.po.CouponDifindustrySendDetailPOExample;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.po.CouponManualPOExample;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponDifindustryQuantityRecordVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponDifindustryQuantityRecordPOMapper;
import com.bizvane.couponservice.mappers.CouponDifindustrySendDetailPOMapper;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.service.CouponDifindustryQuantityRecordService;
import com.bizvane.couponservice.service.CouponDifindustryService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponDifindustryQuantityRecordServiceImpl
implements CouponDifindustryQuantityRecordService {
    private static final Logger log = LoggerFactory.getLogger(CouponDifindustryQuantityRecordServiceImpl.class);
    @Autowired
    private CouponDifindustryQuantityRecordPOMapper couponDifindustryQuantityRecordPOMapper;
    @Autowired
    private CouponManualPOMapper couponManualPOMapper;
    @Autowired
    private CouponDifindustrySendDetailPOMapper CouponDifindustrySendDetailPOMapper;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private SysCommonActionLogService sysCommonActionLogService;
    @Autowired
    @Lazy
    private CouponDifindustryService couponDifindustryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<List<CouponDifindustrySendDetailPO>> addOrUpdateCouponDifindustryQuantityRecord(CouponDefinitionVO record) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(record.getManualId());
        StringBuffer key = new StringBuffer("CouponDifindustry");
        key.append("company:").append(couponManualPO.getSysCompanyId()).append(":");
        key.append("bandid:").append(couponManualPO.getEmpowerBrandId()).append(":");
        key.append("num:").append(couponManualPO.getBatchNum());
        if (record.getCouponQuotaId() != null && SystemConstants.DISTRIBUTE_COUPON_GUIDE != record.getIsdDistributeGuide()) {
            key.append(":").append(record.getCouponQuotaId());
        }
        RLock lock = this.redissonClient.getLock(key.toString());
        try {
            lock.lock();
            Integer quntity = 1;
            if (record.getTotalQuantiy() != null) {
                quntity = record.getTotalQuantiy();
            }
            Boolean isdeductQuantity = true;
            Long sendguideId = null;
            Long couponQuotaId = null;
            List sendDetailPOS = null;
            Byte sendStatus = SystemConstants.COUPON_DIFINDUSTRY_CREATE_POOL;
            CouponDifindustrySendDetailPOExample example = new CouponDifindustrySendDetailPOExample();
            CouponDifindustrySendDetailPOExample.Criteria criteria = example.createCriteria();
            criteria.andSysCompanyIdEqualTo(couponManualPO.getSysCompanyId());
            criteria.andSysBrandIdEqualTo(couponManualPO.getEmpowerBrandId());
            criteria.andSendMemberCodeEqualTo("1");
            criteria.andCouponManualIdEqualTo(record.getManualId());
            criteria.andValidEqualTo(SystemConstants.VALID);
            criteria.andSendStatusEqualTo(sendStatus);
            if (SystemConstants.RELEASE_COUPON_GUIDE == record.getIsdDistributeGuide() && CollectionUtils.isNotEmpty((Collection)record.getSendGuideIdList()) && record.getCouponQuotaId() != null) {
                criteria.andSendGuideIdIn(record.getSendGuideIdList());
                criteria.andCouponQuotaIdEqualTo(record.getCouponQuotaId());
                sendDetailPOS = this.CouponDifindustrySendDetailPOMapper.selectByExample(example);
                quntity = -sendDetailPOS.size();
                sendguideId = SystemConstants.DEFAULT_POOL_SEND_GUIDEID;
                log.info("\u91ca\u653e\u5bfc\u8d2d\u6570\u91cf - param\uff1a{}", (Object)JSON.toJSONString((Object)record));
            } else {
                if (SystemConstants.DISTRIBUTE_COUPON_GUIDE == record.getIsdDistributeGuide() && CollectionUtils.isNotEmpty((Collection)record.getSendCouponSimpleRequestVOS()) && record.getCouponQuotaId() != null) {
                    criteria.andSendGuideIdEqualTo(SystemConstants.DEFAULT_POOL_SEND_GUIDEID);
                    quntity = record.getSendCouponSimpleRequestVOS().stream().map(e -> e.getSendCouponQuantity()).reduce(Integer::sum).get();
                    couponQuotaId = record.getCouponQuotaId();
                    log.info("\u5206\u914d\u5bfc\u8d2d\u6570\u91cf - param\uff1a{}", (Object)JSON.toJSONString((Object)record));
                } else if (record.getSendGuideId() != null) {
                    criteria.andSendGuideIdEqualTo(record.getSendGuideId());
                    if (record.getCouponQuotaId() != null) {
                        criteria.andCouponQuotaIdEqualTo(record.getCouponQuotaId());
                        couponQuotaId = record.getCouponQuotaId();
                    }
                    isdeductQuantity = false;
                    sendStatus = SystemConstants.COUPON_DIFINDUSTRY_SENDING;
                    sendguideId = record.getSendGuideId();
                    log.info("\u5bfc\u8d2d\u53d1\u5238 - param\uff1a{}", (Object)JSON.toJSONString((Object)record));
                } else {
                    criteria.andSendGuideIdEqualTo(SystemConstants.DEFAULT_POOL_SEND_GUIDEID);
                    sendStatus = SystemConstants.COUPON_DIFINDUSTRY_SENDING;
                    log.info("\u6b63\u5e38\u53d1\u5238 - param\uff1a{}", (Object)JSON.toJSONString((Object)record));
                }
                PageHelper.startPage((int)1, (int)quntity, (boolean)false);
                sendDetailPOS = this.CouponDifindustrySendDetailPOMapper.selectByExample(example);
                if (sendDetailPOS == null || sendDetailPOS.isEmpty() || sendDetailPOS.size() != quntity.intValue()) {
                    responseData.setMessage("\u6570\u91cf\u4e0d\u8db3");
                    log.info("\u6570\u91cf\u4e0d\u8db3------------------------------------");
                    ResponseData responseData2 = responseData;
                    return responseData2;
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)sendDetailPOS)) {
                if (SystemConstants.DISTRIBUTE_COUPON_GUIDE == record.getIsdDistributeGuide() && CollectionUtils.isNotEmpty((Collection)record.getSendCouponSimpleRequestVOS())) {
                    List sendCouponSimpleRequestVOS = record.getSendCouponSimpleRequestVOS();
                    int start = 0;
                    int end = 0;
                    for (int i = 0; i < sendCouponSimpleRequestVOS.size(); ++i) {
                        SendCouponSimpleRequestVO vo = (SendCouponSimpleRequestVO)sendCouponSimpleRequestVOS.get(i);
                        List sendDetailPOS1 = sendDetailPOS.subList(start, end += vo.getSendCouponQuantity().intValue());
                        start = end - 1;
                        for (CouponDifindustrySendDetailPO po : sendDetailPOS1) {
                            po.setSendGuideId(vo.getSendGuideId());
                            po.setCouponQuotaId(couponQuotaId);
                        }
                    }
                    this.CouponDifindustrySendDetailPOMapper.updateBatch(sendDetailPOS);
                } else {
                    for (CouponDifindustrySendDetailPO couponDifindustrySendDetailPO : sendDetailPOS) {
                        couponDifindustrySendDetailPO.setSendMemberCode(record.getMemberCode());
                        couponDifindustrySendDetailPO.setSendStatus(sendStatus);
                        couponDifindustrySendDetailPO.setCouponQuotaId(couponQuotaId);
                        if (sendguideId == null) continue;
                        couponDifindustrySendDetailPO.setSendGuideId(sendguideId);
                    }
                    this.CouponDifindustrySendDetailPOMapper.updateBatch(sendDetailPOS);
                }
            }
            if (isdeductQuantity.booleanValue()) {
                CouponManualPO po = new CouponManualPO();
                po.setMemberNum(Integer.valueOf(0));
                po.setSuccessCount(quntity);
                po.setCouponManualId(record.getManualId());
                this.couponManualPOMapper.updateCouponCount(po);
            }
            log.info("\u6267\u884c\u5b8c\u6210------------------------------------");
            responseData.setData((Object)sendDetailPOS);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        }
        finally {
            lock.unlock();
        }
        return responseData;
    }

    public ResponseData<List<CouponDifindustrySendDetailPO>> addOrUpdateCouponDifindustryQuantityRecord(Long couponManualId, String memberCode) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(couponManualId);
        Byte sendStatus = SystemConstants.COUPON_DIFINDUSTRY_CREATE_POOL;
        CouponDifindustrySendDetailPOExample example = new CouponDifindustrySendDetailPOExample();
        CouponDifindustrySendDetailPOExample.Criteria criteria = example.createCriteria();
        criteria.andSysCompanyIdEqualTo(couponManualPO.getSysCompanyId());
        criteria.andSysBrandIdEqualTo(couponManualPO.getEmpowerBrandId());
        criteria.andSendMemberCodeEqualTo("1");
        criteria.andCouponManualIdEqualTo(couponManualId);
        criteria.andValidEqualTo(SystemConstants.VALID);
        criteria.andSendStatusEqualTo(sendStatus);
        criteria.andSendGuideIdEqualTo(SystemConstants.DEFAULT_POOL_SEND_GUIDEID);
        sendStatus = SystemConstants.COUPON_DIFINDUSTRY_SENDING;
        log.info("\u6b63\u5e38\u53d1\u5238 - param\uff1a{}", (Object)JSON.toJSONString((Object)memberCode));
        PageHelper.startPage((int)1, (int)100, (boolean)false);
        List sendDetailPOS = this.CouponDifindustrySendDetailPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)sendDetailPOS)) {
            log.error("\u6570\u91cf\u4e0d\u8db3" + memberCode);
            return new ResponseData(-1, "\u6570\u91cf\u4e0d\u8db3");
        }
        CouponDifindustrySendDetailPO sendDetailPO = (CouponDifindustrySendDetailPO)sendDetailPOS.get(new Random().nextInt(sendDetailPOS.size()));
        criteria.andCouponDifindustrySendDetailIdEqualTo(sendDetailPO.getCouponDifindustrySendDetailId());
        CouponDifindustrySendDetailPO couponDifindustrySendDetailPO = new CouponDifindustrySendDetailPO();
        couponDifindustrySendDetailPO.setSendMemberCode(memberCode);
        couponDifindustrySendDetailPO.setSendStatus(sendStatus);
        int count = this.CouponDifindustrySendDetailPOMapper.updateByExampleSelectiveLimitCount(couponDifindustrySendDetailPO, example);
        if (count == 0) {
            log.error("\u591a\u7ebf\u7a0b\u66f4\u65b0\u51b2\u7a81:" + memberCode);
            throw new BizException(-1, "\u591a\u7ebf\u7a0b\u66f4\u65b0\u51b2\u7a81:" + memberCode);
        }
        CouponManualPO po = new CouponManualPO();
        po.setMemberNum(Integer.valueOf(0));
        po.setSuccessCount(Integer.valueOf(1));
        po.setCouponManualId(couponManualId);
        this.couponManualPOMapper.updateCouponCount(po);
        log.info("\u6267\u884c\u5b8c\u6210------------------------------------");
        ArrayList<CouponDifindustrySendDetailPO> dataList = new ArrayList<CouponDifindustrySendDetailPO>();
        dataList.add(sendDetailPO);
        responseData.setData(dataList);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<CouponDifindustryQuantityRecordVO> selectByManualId(Long mnualId, SysAccountPO sysAccountPo) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(mnualId);
        Integer totalQuantity = couponManualPO.getMemberCount();
        Integer useQuantity = couponManualPO.getSuccessCount();
        if (useQuantity == null) {
            useQuantity = 0;
        }
        Integer surplusQuantiy = totalQuantity - useQuantity;
        CouponDifindustryQuantityRecordPO record = new CouponDifindustryQuantityRecordPO();
        record.setCouponManualId(mnualId);
        record.setSysCompanyId(sysAccountPo.getSysCompanyId());
        record.setValid(Boolean.valueOf(true));
        record.setBatchNum(couponManualPO.getBatchNum());
        record.setSourceBrandId(sysAccountPo.getBrandId());
        CouponDifindustryQuantityRecordVO couponDifindustryQuantityRecordVO = new CouponDifindustryQuantityRecordVO();
        BeanUtils.copyProperties((Object)couponManualPO, (Object)couponDifindustryQuantityRecordVO);
        couponDifindustryQuantityRecordVO.setCouponManualId(mnualId);
        couponDifindustryQuantityRecordVO.setTotalQuantiy(totalQuantity);
        couponDifindustryQuantityRecordVO.setSurplusQuantiy(surplusQuantiy);
        couponDifindustryQuantityRecordVO.setUseQuantiy(useQuantity);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)couponDifindustryQuantityRecordVO);
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<CouponDifindustryQuantityRecordPO> addAuantityByManualId(CouponDifindustryQuantityRecordPO couponDifindustryQuantityRecordPO) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        CouponManualPO couponManualPO = this.couponManualPOMapper.selectByPrimaryKey(couponDifindustryQuantityRecordPO.getCouponManualId());
        if (couponManualPO == null) {
            return responseData;
        }
        Byte taskStatus = couponManualPO.getTaskStatus();
        if (CouponManualTaskStatusEnum.TASK_STATUS_SEND_SUCCESS.getCode().byteValue() != taskStatus.byteValue()) {
            responseData.setMessage("\u6267\u884c\u5b8c\u6210\u624d\u5141\u8bb8\u8ffd\u52a0\u6570\u91cf");
            return responseData;
        }
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        SysAccountPO sysAccountPo = new SysAccountPO();
        sysAccountPo.setSysCompanyId(couponDifindustryQuantityRecordPO.getSysCompanyId());
        sysAccountPo.setBrandId(couponDifindustryQuantityRecordPO.getSourceBrandId());
        ResponseData recordVOResponseData = this.selectByManualId(couponDifindustryQuantityRecordPO.getCouponManualId(), sysAccountPo);
        if (recordVOResponseData != null && SysResponseEnum.SUCCESS.getCode() == recordVOResponseData.getCode()) {
            CouponDifindustryQuantityRecordVO data = (CouponDifindustryQuantityRecordVO)recordVOResponseData.getData();
            logMap.put("couponManual", couponDifindustryQuantityRecordPO.getCouponManualId());
            logMap.put("batchNum", data.getBatchNum());
            logMap.put("totalQuantiy", data.getTotalQuantiy());
            logMap.put("surplusQuantiy", data.getSurplusQuantiy());
        }
        couponDifindustryQuantityRecordPO.setGradationType(Byte.valueOf((byte)1));
        couponDifindustryQuantityRecordPO.setBatchNum(couponManualPO.getBatchNum());
        couponDifindustryQuantityRecordPO.setCouponDefintionId(Long.valueOf(Long.parseLong(couponManualPO.getCouponDefinitionId())));
        couponDifindustryQuantityRecordPO.setSourceBrandId(couponManualPO.getSysBrandId());
        couponDifindustryQuantityRecordPO.setValid(Boolean.valueOf(true));
        int i = this.couponDifindustryQuantityRecordPOMapper.insertSelective(couponDifindustryQuantityRecordPO);
        if (i > 0) {
            CouponManualPO po = new CouponManualPO();
            po.setMemberCount(Integer.valueOf(couponManualPO.getMemberCount() + couponDifindustryQuantityRecordPO.getCouponDefintionQuantity()));
            po.setCouponManualId(couponManualPO.getCouponManualId());
            this.couponManualPOMapper.updateByPrimaryKeySelective(po);
            CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
            CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponManualPO.getCouponDefinitionId()));
            BeanUtils.copyProperties((Object)couponDefinitionPOWithBLOBs, (Object)couponDefinitionVO);
            couponDefinitionVO.setBatchNum(couponManualPO.getBatchNum());
            couponDefinitionVO.setManualId(couponManualPO.getCouponManualId());
            couponDefinitionVO.setTotalQuantiy(couponDifindustryQuantityRecordPO.getCouponDefintionQuantity());
            couponDefinitionVO.setSysCompanyId(couponManualPO.getSysCompanyId());
            couponDefinitionVO.setSysBrandId(couponManualPO.getEmpowerBrandId());
            couponDefinitionVO.setSourceBrandId(couponManualPO.getSysBrandId());
            this.couponDifindustryService.createCouponPool(couponDefinitionVO);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            logMap.put("addQuantiy", couponDifindustryQuantityRecordPO.getCouponDefintionQuantity());
            logMap.put("remark", couponDifindustryQuantityRecordPO.getRemark());
            String logstr = JSONObject.toJSONString(logMap);
            this.sysCommonActionLogService.collect(logstr, Byte.valueOf(ActionLogEnum.OPERATION_TYPE_MODIFY.getCode()), "COUPONMANUAL");
        }
        return responseData;
    }

    public ResponseData<List<CouponDefinitionVO>> getSurplusQuantityByList(List<CouponDefinitionVO> list) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        CouponManualPOExample example = new CouponManualPOExample();
        CouponManualPOExample.Criteria criteria = example.createCriteria();
        List collect = list.stream().map(CouponDefinitionVO::getManualId).collect(Collectors.toList());
        criteria.andCouponManualIdIn(collect);
        List couponManualPOS = this.couponManualPOMapper.selectByExample(example);
        List collect1 = couponManualPOS.stream().map(t -> {
            CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
            couponDefinitionVO.setManualId(t.getCouponManualId());
            couponDefinitionVO.setTotalQuantiy(t.getMemberCount());
            couponDefinitionVO.setSurplusQuantiy(Integer.valueOf(t.getMemberCount() - t.getSuccessCount()));
            return couponDefinitionVO;
        }).collect(Collectors.toList());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData(collect1);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }
}

