/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.baisonBase.facade.models.mj.LedengCouponDefinitionUpdateRequest;
import com.bizvane.baisonBase.facade.rpc.LedengServiceRpc;
import com.bizvane.centerstageservice.consts.SelectTypeEnum;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysDimSkuPo;
import com.bizvane.centerstageservice.models.po.SysOnlineOrgPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.po.SysYzBrandStoreMapping;
import com.bizvane.centerstageservice.models.vo.DefSkuExtendDetailVO;
import com.bizvane.centerstageservice.models.vo.SelectCacheKeyVo;
import com.bizvane.centerstageservice.models.vo.SysCacheVo;
import com.bizvane.centerstageservice.models.vo.SysDimSkuVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCacheServiceRpc;
import com.bizvane.centerstageservice.rpc.SysDimSkuServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOnlineOrgServcieRpc;
import com.bizvane.centerstageservice.rpc.SysProductCategoryRpc;
import com.bizvane.centerstageservice.rpc.SysProductCategoryServiceRpc;
import com.bizvane.centerstageservice.rpc.SysYzBrandStoreMappingServiceRpc;
import com.bizvane.channelsservice.models.tmallcoupon.bo.CouponAddRequestBo;
import com.bizvane.channelsservice.models.tmallcoupon.vo.CouponAddResponseVo;
import com.bizvane.channelsservice.rpc.TmallCouponServiceFeign;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.AddCouponDefToErpRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.connectorservice.interfaces.rpc.WmConnectorServiceFeign;
import com.bizvane.connectorservice.util.HttpClientUtil;
import com.bizvane.couponfacade.models.bo.CompanyBrandBO;
import com.bizvane.couponfacade.models.bo.CouponDefReq361BO;
import com.bizvane.couponfacade.models.bo.CouponDefReqURBO;
import com.bizvane.couponfacade.models.bo.CouponDefinitionBO;
import com.bizvane.couponfacade.models.po.CouponDefinitionCodePO;
import com.bizvane.couponfacade.models.po.CouponDefinitionMoneyPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionMoneyPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.po.YzCouponDefinitionPO;
import com.bizvane.couponfacade.models.vo.BatchInvalidateRequestVo;
import com.bizvane.couponfacade.models.vo.CouponDefinitionCodeQueryVO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionListQueryVO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.ProductCategoryVO;
import com.bizvane.couponfacade.models.vo.YzCouponDefinitionVo;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.BusinessCodeUtil;
import com.bizvane.couponservice.common.utils.DateUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionCodePOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionMoneyPOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.YzCouponDefinitionPOMapper;
import com.bizvane.couponservice.service.CouponDefinitionService;
import com.bizvane.couponservice.service.ThirdBusinessService;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.thirddock.service.rpc.YouzanCouponServiceRpc;
import com.bizvane.thirdrouting.bo.AsynBO;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.jsonwebtoken.lang.Assert;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponDefinitionServiceImpl
implements CouponDefinitionService {
    private static Logger logger = LoggerFactory.getLogger(CouponDefinitionServiceImpl.class);
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponDefinitionMoneyPOMapper couponDefinitionMoneyPOMapper;
    @Autowired
    private SysDimSkuServiceRpc sysDimSkuServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private CouponDefinitionCodePOMapper couponDefinitionCodePOMapper;
    @Autowired
    TmallCouponServiceFeign tmallCouponServiceFeign;
    @Autowired
    private SysProductCategoryServiceRpc sysProductCategoryServiceRpc;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Value(value="${gd.gdCompanyId}")
    private Long gdCompanyId;
    @Value(value="${mjwm.wmCompanyId}")
    private Long mjCompanyId;
    @Value(value="#{'${weimeng.companyIdList}'.split(',')}")
    private List<Long> weimengCompanyIdList;
    @Value(value="${mjwm.urlPrefix}")
    private String wmAddCouponUrl;
    @Value(value="${hs.hsCompanyId}")
    private Long hsCompanyId;
    @Value(value="#{'${couponDefToOfflineLikeLD.companyIdList}'.split(',')}")
    private List<Long> couponDefToOfflineLikeLDCompanyIdList;
    @Value(value="#{'${ledeng.sysBrandIdList}'.split(',')}")
    private List<Long> ledengSysBrandIdList;
    @Autowired
    private WmConnectorServiceFeign wmConnectorServiceFeign;
    @Autowired
    private SysProductCategoryRpc sysProductCategoryRpc;
    @Autowired
    private SysYzBrandStoreMappingServiceRpc sysYzBrandStoreMappingServiceRpc;
    @Autowired
    private YzCouponDefinitionPOMapper yzCouponDefinitionPOMapper;
    @Autowired
    private SysCacheServiceRpc sysCacheServiceRpc;
    @Autowired
    private ThirdBusinessService thirdBusinessService;
    @Autowired
    private YouzanCouponServiceRpc youzanCouponServiceRpc;
    @Autowired
    private LedengServiceRpc ledengServiceRpc;
    @Autowired
    private IRedisCacheService iRedisCacheServiceRpc;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Lazy
    @Autowired
    private CouponDefinitionService couponDefinitionService;
    @Autowired
    private SysOnlineOrgServcieRpc sysOnlineOrgServcieRpc;

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponDefinitionVO>> getList(CouponDefinitionListQueryVO vo, PageFormUtil pageForm, Long sysBrandId, Long companyId) {
        logger.info("enter CouponDefinitionServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        logger.info("enter CouponDefinitionServiceImpl getList param:" + JSON.toJSONString((Object)vo));
        List list = this.couponDefinitionPOMapper.findCouponDefinitionListByConds(vo, sysBrandId, companyId);
        com.bizvane.utils.responseinfo.PageInfo page = new com.bizvane.utils.responseinfo.PageInfo(list);
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo();
        BeanUtils.copyProperties((Object)page, (Object)pageInfo);
        ArrayList<CouponDefinitionVO> objects = new ArrayList<CouponDefinitionVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ResponseData listResponseData;
            String collectStr = list.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getOrganizationCode())).map(CouponDefinitionPO::getOrganizationCode).distinct().collect(Collectors.joining(","));
            Map<String, SysOnlineOrgPo> map = null;
            if (StringUtils.isNotBlank((CharSequence)collectStr) && (listResponseData = this.sysOnlineOrgServcieRpc.queryOnlineOrgList(companyId, collectStr)) != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == listResponseData.getCode()) {
                List data = (List)listResponseData.getData();
                map = data.stream().collect(Collectors.toMap(SysOnlineOrgPo::getOnlineOrgCode, t -> t, (a, b) -> b));
            }
            for (CouponDefinitionPO couponDefinitionPO : list) {
                CouponDefinitionVO couponVo = new CouponDefinitionVO();
                BeanUtils.copyProperties((Object)couponDefinitionPO, (Object)couponVo);
                if (StringUtils.isNotBlank((CharSequence)couponDefinitionPO.getOrganizationCode()) && map.containsKey(couponDefinitionPO.getOrganizationCode())) {
                    SysOnlineOrgPo sysOnlineOrgPo = map.get(couponDefinitionPO.getOrganizationCode());
                    String onlineOrgName = sysOnlineOrgPo.getOnlineOrgName();
                    couponVo.setOrganizationName(onlineOrgName);
                }
                objects.add(couponVo);
            }
        }
        pageInfo.setList(objects);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponDefinitionCodePO>> getListDefinitionCode(CouponDefinitionCodeQueryVO vo, PageFormUtil pageForm, Long sysBrandId, Long sysCompanyId) {
        logger.info("enter CouponDefinitionServiceImpl getListDefinitionCode method");
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        List list = this.couponDefinitionCodePOMapper.findCountTableNew(vo, sysBrandId, sysCompanyId);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ResponseData listResponseData = this.sysOnlineOrgServcieRpc.queryOnlineOrgList(sysCompanyId, "");
            Map<Object, Object> orgMap = new HashMap();
            if (listResponseData != null && SysResponseEnum.SUCCESS.getCode() == listResponseData.getCode()) {
                List sysOnlineOrgPoList = (List)listResponseData.getData();
                orgMap = sysOnlineOrgPoList.stream().collect(Collectors.toMap(SysOnlineOrgPo::getOnlineOrgCode, SysOnlineOrgPo::getOnlineOrgName));
            }
            for (CouponDefinitionCodePO couponDefinitionCodePO : list) {
                if (!StringUtils.isNotBlank((CharSequence)couponDefinitionCodePO.getOrganizationCode())) continue;
                couponDefinitionCodePO.setOrganizationName((String)orgMap.get(couponDefinitionCodePO.getOrganizationCode()));
            }
        }
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public CouponDefinitionPO getCouponDefinitionByErp(String erpCouponDefinitionCode, CompanyBrandBO companyBrandBO) {
        CouponDefinitionPOExample example = new CouponDefinitionPOExample();
        example.createCriteria().andErpCouponDefinitionCodeEqualTo(erpCouponDefinitionCode).andSysCompanyIdEqualTo(companyBrandBO.getCompanyId()).andSysBrandIdEqualTo(companyBrandBO.getBrandId()).andStatusEqualTo(Boolean.TRUE).andValidEqualTo(Boolean.TRUE);
        List lists = this.couponDefinitionPOMapper.selectByExample(example);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)lists) ? 1 : 0) != 0, (String)"\u6839\u636eerpcode\u627e\u4e0d\u5230\u5238\u5b9a\u4e49");
        return (CouponDefinitionPO)lists.get(0);
    }

    public CouponDefinitionPO getTmallCouponDefinition(Long couponDefinitionId, CompanyBrandBO companyBrand) {
        CouponDefinitionPOExample example = new CouponDefinitionPOExample();
        example.createCriteria().andCouponDefinitionIdEqualTo(couponDefinitionId).andSysCompanyIdEqualTo(companyBrand.getCompanyId()).andSysBrandIdEqualTo(companyBrand.getBrandId());
        List list = this.couponDefinitionPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (CouponDefinitionPO)list.get(0);
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponDefinitionPOWithBLOBs>> queryCouponDefinitionList(CouponDefReq361BO bo) {
        logger.info("CouponDefinitionServiceImpl queryCouponDefinitionList method");
        ResponseData responseData = new ResponseData();
        SysBrandPo brandPo = new SysBrandPo();
        brandPo.setBrandCode(bo.getBrandCode());
        ResponseData brandPoResponseData = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(brandPo);
        if (brandPoResponseData.getCode() != com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() || brandPoResponseData.getData() == null) {
            logger.info("queryCouponDefinitionList getBrandIdAndCompanyIdByCode \u6839\u636e\u4f20\u5165\u7684brandCode:{}\u67e5\u8be2\u4e0d\u5230\u54c1\u724c\u4fe1\u606f", (Object)bo.getBrandCode());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
            responseData.setMessage(brandPoResponseData.getMessage());
            return responseData;
        }
        SysBrandPo sysBrandPo = (SysBrandPo)brandPoResponseData.getData();
        PageHelper.startPage((int)bo.getPageNo(), (int)bo.getPageSize());
        List<Object> defIdList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)bo.getCoupoDefinitionIds())) {
            String[] coupoDefinitionIds = bo.getCoupoDefinitionIds().split(",");
            if (coupoDefinitionIds.length > 10) {
                coupoDefinitionIds = Arrays.copyOfRange(coupoDefinitionIds, 0, 10);
            }
            try {
                defIdList = Arrays.stream(coupoDefinitionIds).map(Long::valueOf).collect(Collectors.toList());
                logger.info("queryCouponDefinitionList defIdList size:{}", (Object)defIdList.size());
            }
            catch (Exception e) {
                logger.info("queryCouponDefinitionList \u4f20\u5165\u7684\u5238\u5b9a\u4e49ids \u6709\u8bef\uff01coupoDefinitionIds:{}", (Object)bo.getCoupoDefinitionIds());
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u5238\u5b9a\u4e49id\u6709\u8bef");
                return responseData;
            }
        }
        List couonDefinitionList = this.couponDefinitionPOMapper.getCouonDefinitionList(sysBrandPo.getSysCompanyId(), sysBrandPo.getSysBrandId(), defIdList, bo.getPlatform());
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(couonDefinitionList);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponDefinitionPOWithBLOBs>> queryCouponDefinitionListUR(CouponDefReqURBO bo) {
        logger.info("CouponDefinitionServiceImpl queryCouponDefinitionListUR method :{}", (Object)JSON.toJSONString((Object)bo));
        ResponseData responseData = new ResponseData();
        if (bo.getBrandId() == null) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)bo.getPageNo(), (int)bo.getPageSize());
        List couonDefinitionList = this.couponDefinitionPOMapper.getCouponDefListByIds(bo.getBrandId(), bo.getCouponDefinitionIds());
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(couonDefinitionList);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Object> updateDefinition(CouponDefinitionBO bo, SysAccountPO stageUser) {
        bo.setSysBrandId(stageUser.getBrandId());
        Long couponDefinitionId = bo.getCouponDefinitionId();
        ResponseData checkParamResp = this.checkLinkParams(bo);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != checkParamResp.getCode()) {
            return new ResponseData(checkParamResp.getCode(), checkParamResp.getMessage());
        }
        this.dealDataBySelectKey((Object)bo);
        if (bo.getApplianceCommodityType() != null) {
            ResponseData verifyCouponGoodsConditionRes = this.verifyCouponGoodsCondition(bo);
            if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != verifyCouponGoodsConditionRes.getCode()) {
                return verifyCouponGoodsConditionRes;
            }
        }
        if (null != bo.getApplianceStoreType()) {
            ResponseData verifyCouponStoreConditionRes = this.verifyCouponStoreCondition(bo);
            if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != verifyCouponStoreConditionRes.getCode()) {
                return verifyCouponStoreConditionRes;
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)bo.getStoreBlacklist()) && bo.getStoreBlacklist().matches("^[,]+$")) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u95e8\u5e97\u9ed1\u540d\u5355\u95e8\u5e97\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getStoreWhitelist()) && bo.getStoreWhitelist().matches("^[,]+$")) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u95e8\u5e97\u767d\u540d\u5355\u95e8\u5e97\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
        }
        this.handleCouponStoreAndGoodsCondition(bo);
        Assert.isTrue((couponDefinitionId != null ? 1 : 0) != 0, (String)"couponDefinitionId\u4e3a\u7a7a");
        logger.info("CouponDefinitionServiceImpl updateDefinition method,couponDefinitionId:{}", (Object)couponDefinitionId);
        String couponDefinitionCode = this.couponDefinitionPOMapper.selectCouponDefinitionCodePrimaryKey(couponDefinitionId);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)couponDefinitionCode), (String)"\u67e5\u8be2\u4f18\u60e0\u5238\u4fe1\u606f\u7ed3\u679c\u4e3a\u7a7a");
        List productCategoryVOList = JSONObject.parseArray((String)bo.getOfflinePrdCode(), ProductCategoryVO.class);
        this.update((CouponDefinitionPOWithBLOBs)bo, stageUser);
        if (CollectionUtils.isNotEmpty((Collection)productCategoryVOList)) {
            this.saveCategoryToConnector(Integer.valueOf(couponDefinitionId.toString()), couponDefinitionCode, productCategoryVOList);
        }
        this.ledengUpdateSync(bo);
        return new ResponseData();
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponDefinitionPOWithBLOBs>> getCouponDefListByCompanyId(Long sysCompanyId, Integer pageNum, Integer pageSize) {
        ResponseData responseData = new ResponseData();
        CouponDefinitionPOExample definitionPOExample = new CouponDefinitionPOExample();
        CouponDefinitionPOExample.Criteria criteria = definitionPOExample.createCriteria();
        criteria.andSysCompanyIdEqualTo(sysCompanyId);
        criteria.andStatusEqualTo(Boolean.TRUE);
        criteria.andCouponDefinitionTypeEqualTo(Byte.valueOf((byte)2));
        definitionPOExample.setOrderByClause("create_date desc");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List definitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByExampleWithBLOBs(definitionPOExample);
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(definitionPOWithBLOBs);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponDefinitionPO>> getListRpc(CouponDefinitionListQueryVO vo, PageFormUtil pageForm) {
        logger.info("enter CouponDefinitionServiceImpl getList method");
        ResponseData responseData = new ResponseData();
        if (null == vo.getSysBrandId()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        List list = this.couponDefinitionPOMapper.findCouponDefinitionListByConds(vo, vo.getSysBrandId(), vo.getSysCompanyId());
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<Long> addRpc(CouponDefinitionPOWithBLOBs po) {
        logger.info("enter CouponDefinitionServiceImpl addRpc method#po:{}", (Object)JSON.toJSONString((Object)po));
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)po.getErpCouponDefinitionCode())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.ERP_COUPON_DEFINITION_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        String key = this.couponDefinitionPOMapper.findErpCouponDefinitionCode(po.getErpCouponDefinitionCode(), po.getBrandCode());
        if (!StringUtils.isBlank((CharSequence)key)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.ERP_COUPON_DEFINITION_CODE_HAVE.getMessage());
            return responseData;
        }
        Long brandId = this.couponDefinitionPOMapper.selectBrandId(po.getBrandCode(), this.gdCompanyId);
        if (brandId == null) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        po.setSysBrandId(brandId);
        this.couponDefinitionPOMapper.insertSelective(po);
        try {
            AsynBO asynBO = new AsynBO(po.getSysCompanyId(), po.getSysBrandId(), "couponDefinitionAdd", JSON.toJSONString((Object)po));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("addOrUpdateYzCouponDefinition thirdBusinessService.asyn e {}", (Throwable)e);
        }
        Long id = po.getCouponDefinitionId();
        responseData.setData((Object)id);
        return responseData;
    }

    public ResponseData<Long> addCoupon(CouponDefinitionPOWithBLOBs po) {
        logger.info("enter CouponDefinitionServiceImpl addRpc method#po:{}", (Object)JSON.toJSONString((Object)po));
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)po.getErpCouponDefinitionCode())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.ERP_COUPON_DEFINITION_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        String key = this.couponDefinitionPOMapper.findErpCouponDefinitionCode(po.getErpCouponDefinitionCode(), po.getBrandCode());
        if (!StringUtils.isBlank((CharSequence)key)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.ERP_COUPON_DEFINITION_CODE_HAVE.getMessage());
            return responseData;
        }
        po.setCouponDefinitionCode(BusinessCodeUtil.getCouponDefinitionCode());
        Long brandId = this.couponDefinitionPOMapper.selectBrandId(po.getBrandCode(), po.getSysCompanyId());
        if (brandId == null) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        po.setSysBrandId(brandId);
        this.couponDefinitionPOMapper.insertSelective(po);
        try {
            AsynBO asynBO = new AsynBO(po.getSysCompanyId(), po.getSysBrandId(), "couponDefinitionAdd", JSON.toJSONString((Object)po));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("addOrUpdateYzCouponDefinition thirdBusinessService.asyn e {}", (Throwable)e);
        }
        Long id = po.getCouponDefinitionId();
        responseData.setData((Object)id);
        return responseData;
    }

    @Async
    public void ledengCouponStop(long couponDefinitionId, SysAccountPO stageUser) {
        logger.info("\u4e50\u767b\u5238\u505c\u7528\u5b9e\u4f8b\u5f00\u59cb:" + couponDefinitionId);
        long min = 0L;
        long end = 0L;
        int stopSum = 0;
        while (true) {
            CouponEntityPOExample minExample = new CouponEntityPOExample();
            minExample.createCriteria().andSysBrandIdEqualTo(stageUser.getBrandId()).andCouponDefinitionIdEqualTo(String.valueOf(couponDefinitionId)).andCouponEntityIdGreaterThanOrEqualTo(Long.valueOf(min));
            PageHelper.startPage((int)1, (int)1, (boolean)false);
            CouponEntityPO minCoupon = (CouponEntityPO)this.couponEntityPOMapper.selectByExample(minExample).get(0);
            if (minCoupon == null) break;
            min = minCoupon.getCouponEntityId();
            logger.info("\u5238id\u8d77\u59cb\u70b9:" + min);
            end = min + 20000L;
            CouponEntityPOExample updateExample = new CouponEntityPOExample();
            updateExample.createCriteria().andSysBrandIdEqualTo(stageUser.getBrandId()).andCouponDefinitionIdEqualTo(String.valueOf(couponDefinitionId)).andCouponEntityIdGreaterThanOrEqualTo(Long.valueOf(min)).andCouponEntityIdLessThan(Long.valueOf(end)).andCouponStatusEqualTo(Byte.valueOf("20"));
            CouponEntityPO record = new CouponEntityPO();
            record.setValid(Boolean.valueOf(false));
            record.setModifiedDate(new Date());
            record.setModifiedUserId(stageUser.getSysAccountId());
            record.setModifiedUserName(stageUser.getName());
            int stop = this.couponEntityPOMapper.updateByExampleSelective(record, updateExample);
            stopSum += stop;
            logger.info("\u4e50\u767b\u6210\u529f\u505c\u7528\u5238\u6570\u91cf;" + stop);
            min = end;
        }
        logger.info("\u4e50\u767b\u5238\u505c\u7528\u5b8c\u6210:{},{}", (Object)couponDefinitionId, (Object)stopSum);
        logger.info("\u5171\u505c\u7528:" + stopSum);
    }

    public ResponseData<Long> add(CouponDefinitionBO bo, SysAccountPO accountPo) {
        SimpleDateFormat format;
        AddCouponDefToErpRequestVO requestVO;
        List definitionPOList;
        CouponDefinitionPOExample example;
        logger.info("enter CouponDefinitionServiceImpl add method#po:{},accountPo:{}", (Object)JSON.toJSONString((Object)bo), (Object)JSON.toJSONString((Object)accountPo));
        ResponseData responseData = new ResponseData();
        ResponseData checkParamResp = this.checkLinkParams(bo);
        if (com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() != checkParamResp.getCode()) {
            responseData.setCode(checkParamResp.getCode());
            responseData.setMessage(checkParamResp.getMessage());
            return responseData;
        }
        this.dealDataBySelectKey((Object)bo);
        if (bo.getApplianceCommodityType() != null) {
            ResponseData verifyCouponGoodsConditionRes = this.verifyCouponGoodsCondition(bo);
            if (responseData.getCode() != verifyCouponGoodsConditionRes.getCode()) {
                return verifyCouponGoodsConditionRes;
            }
        }
        if (null != bo.getApplianceStoreType()) {
            ResponseData verifyCouponStoreConditionRes = this.verifyCouponStoreCondition(bo);
            if (responseData.getCode() != verifyCouponStoreConditionRes.getCode()) {
                return verifyCouponStoreConditionRes;
            }
        }
        this.handleCouponStoreAndGoodsCondition(bo);
        CouponDefinitionBO po = bo;
        if (SystemConstants.COUPON_DEFINITION_TYPE_ERP.equals(po.getCouponDefinitionType())) {
            if (StringUtils.isBlank((CharSequence)po.getErpCouponDefinitionCode())) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.ERP_COUPON_DEFINITION_CODE_NOT_NULL.getMessage());
                return responseData;
            }
            example = new CouponDefinitionPOExample();
            example.createCriteria().andErpCouponDefinitionCodeEqualTo(po.getErpCouponDefinitionCode()).andCouponDefinitionTypeEqualTo(Byte.valueOf((byte)2)).andSysBrandIdEqualTo(accountPo.getBrandId()).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
            definitionPOList = this.couponDefinitionPOMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)definitionPOList)) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.ERP_COUPON_DEFINITION_CODE_HAVE.getMessage());
                return responseData;
            }
        }
        if (SystemConstants.COUPON_DEFINITION_TYPE_ONLINE.equals(po.getCouponDefinitionType()) && StringUtils.isNotBlank((CharSequence)po.getErpCouponDefinitionCode())) {
            example = new CouponDefinitionPOExample();
            example.createCriteria().andErpCouponDefinitionCodeEqualTo(po.getErpCouponDefinitionCode()).andCouponDefinitionTypeEqualTo(Byte.valueOf((byte)1)).andSysBrandIdEqualTo(accountPo.getBrandId()).andStatusEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
            definitionPOList = this.couponDefinitionPOMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)definitionPOList)) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.ERP_COUPON_DEFINITION_CODE_HAVE.getMessage());
                return responseData;
            }
        }
        po.setSysCompanyId(accountPo.getSysCompanyId());
        po.setSysBrandId(accountPo.getBrandId());
        if (!CollectionUtils.isEmpty((Collection)this.weimengCompanyIdList) && this.weimengCompanyIdList.contains(accountPo.getSysCompanyId()) && SystemConstants.USE_CHANNEL_ANY.equals(po.getUseChannel())) {
            try {
                String wmCouponDefinitonCode = this.addWmMerchantCoupon((CouponDefinitionPOWithBLOBs)po);
                po.setWmCouponDefinitionCode(wmCouponDefinitonCode);
            }
            catch (Exception e) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage(e.getMessage());
                return responseData;
            }
        }
        if (SystemConstants.USE_CHANNEL_TMALL.equals(po.getUseChannel())) {
            CouponAddRequestBo acouponBo = new CouponAddRequestBo();
            acouponBo.setDenominations(po.getMoney());
            acouponBo.setStartTime(DateUtils.dateFormatTime((Date)po.getValidDateStart()));
            acouponBo.setCondition(po.getMinConsume() == null ? BigDecimal.ZERO : po.getMinConsume());
            acouponBo.setEndTime(DateUtils.dateFormatTime((Date)po.getValidDateEnd()));
            acouponBo.setBrandId(accountPo.getBrandId());
            ResponseData acouponData = this.tmallCouponServiceFeign.addTmallCoupon(acouponBo);
            if (null == acouponData || acouponData.getCode() == com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode()) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u521b\u5efa\u5931\u8d25");
                return responseData;
            }
            CouponAddResponseVo addCoupon = (CouponAddResponseVo)acouponData.getData();
            po.setCouponDefinitionCode(addCoupon.getCouponId().toString());
        } else {
            po.setCouponDefinitionCode(BusinessCodeUtil.getCouponDefinitionCode());
        }
        po.setCouponDefinitionType(po.getCouponDefinitionType());
        po.setCreateUserId(accountPo.getSysAccountId());
        po.setCreateUserName(accountPo.getName());
        po.setCreateDate(TimeUtils.getNowTime());
        po.setMinConsume(po.getMinConsume() == null ? BigDecimal.ZERO : po.getMinConsume());
        String offlinePrdCode = po.getOfflinePrdCode();
        if (offlinePrdCode.startsWith("\"") && offlinePrdCode.endsWith("\"")) {
            offlinePrdCode = offlinePrdCode.substring(1, offlinePrdCode.length() - 1);
            po.setOfflinePrdCode(offlinePrdCode);
        }
        if (null != po.getLinkUrlJson()) {
            po.setLinkUrl(po.getLinkUrlJson().toJSONString());
        }
        String brandCode = this.iRedisCacheServiceRpc.getOnlineBrand(po.getSysCompanyId(), po.getSysBrandId()).getBrandCode();
        po.setBrandCode(brandCode);
        if (Byte.valueOf("1").equals(po.getPreferentialType())) {
            po.setMaxPreferential(null);
        }
        int id = this.couponDefinitionPOMapper.insertSelective((CouponDefinitionPOWithBLOBs)po);
        logger.info("youZanCompanyIdList {}", (Object)JSON.toJSONString((Object)po));
        if (SystemConstants.USE_CHANNEL_ANY.equals(po.getUseChannel()) && (Byte.valueOf("1").equals(po.getPreferentialType()) || Byte.valueOf("2").equals(po.getPreferentialType()))) {
            try {
                this.addOrUpdateYzCouponDefinition((CouponDefinitionPOWithBLOBs)po, "insert", accountPo);
            }
            catch (BizException e) {
                logger.error("addOrUpdateYzCouponDefinition e {}", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error("addOrUpdateYzCouponDefinition e {}", (Throwable)e);
                throw new BizException(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u540c\u6b65\u6709\u8d5e\u53d1\u751f\u5f02\u5e38");
            }
        }
        try {
            AsynBO asynBO = new AsynBO(po.getSysCompanyId(), po.getSysBrandId(), "couponDefinitionAdd", JSON.toJSONString((Object)po));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("addOrUpdateYzCouponDefinition thirdBusinessService.asyn e {}", (Throwable)e);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{po.getOfflinePrdCode()})) {
            List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
            String couponDefinitionCode = po.getCouponDefinitionCode();
            this.saveCategoryToConnector(Integer.valueOf(id), couponDefinitionCode, productCategoryVOS);
        }
        if (this.gdCompanyId.equals(po.getSysCompanyId())) {
            logger.info("\u54e5\u5f1f\u5238\u5b9a\u4e49\u5199\u7ebf\u4e0b");
            requestVO = new AddCouponDefToErpRequestVO();
            requestVO.setValidDay(po.getValidDay());
            requestVO.setCommodityBlacklist(po.getCommodityBlacklist());
            requestVO.setApplianceCommodityType(po.getApplianceCommodityType());
            requestVO.setApplianceStoreType(po.getApplianceStoreType());
            requestVO.setCommodityCompoundWhitelist(po.getCommodityCompoundWhitelist());
            requestVO.setCouponBackGroundType(Boolean.TRUE.equals(po.getCouponBackGroundType()) ? 1 : 0);
            requestVO.setCouponDefinitionType(po.getCouponDefinitionType());
            requestVO.setInfo(po.getInfo());
            requestVO.setIsTransfer(po.getIsTransfer());
            requestVO.setMoney(po.getMoney());
            requestVO.setStoreWhitelist(po.getStoreWhitelist());
            requestVO.setTransferFission(po.getTransferFission());
            requestVO.setTransferSend(po.getTransferSend());
            requestVO.setUseChannel(po.getUseChannel());
            requestVO.setValidDateEnd(po.getValidDateEnd());
            requestVO.setValidDateStart(po.getValidDateStart());
            requestVO.setValidTimeState(po.getValidTimeState());
            requestVO.setValidType(po.getValidType());
            requestVO.setBrandId(po.getSysBrandId());
            requestVO.setErpCouponDefinitionCode(po.getErpCouponDefinitionCode());
            requestVO.setCouponName(po.getCouponName());
            requestVO.setPreferentialType(Integer.valueOf(po.getPreferentialType().byteValue()));
            requestVO.setMinDiscount(po.getMinDiscount());
            requestVO.setDiscount(po.getDiscount());
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            requestVO.setCreateDate(format.format(po.getCreateDate()));
            if (po.getMinConsume().compareTo(BigDecimal.ZERO) != 0) {
                requestVO.setMinConsumeFlag(Integer.valueOf(1));
            } else {
                requestVO.setMinConsumeFlag(Integer.valueOf(0));
            }
            requestVO.setMinConsume(po.getMinConsume());
            logger.info("requestVO\uff1a{}" + JSON.toJSONString((Object)requestVO));
            this.connectorServiceFeign.addCouponDefToErp(requestVO);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.couponDefToOfflineLikeLDCompanyIdList) && this.couponDefToOfflineLikeLDCompanyIdList.contains(po.getSysCompanyId())) {
            ResponseData offlineOrgCodesRes;
            logger.info("\u7c7b\u4f3c\u4e50\u767b\u5238\u5b9a\u4e49\u5199\u7ebf\u4e0b,\u4f01\u4e1aid:{}", (Object)po.getSysCompanyId());
            requestVO = new AddCouponDefToErpRequestVO();
            requestVO.setBrandId(po.getSysBrandId());
            requestVO.setErpCouponDefinitionCode(po.getErpCouponDefinitionCode());
            requestVO.setCouponName(po.getCouponName());
            requestVO.setPreferentialType(Integer.valueOf(po.getPreferentialType().byteValue()));
            requestVO.setMinDiscount(po.getMinDiscount());
            requestVO.setDiscount(po.getDiscount());
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            requestVO.setCreateDate(format.format(po.getCreateDate()));
            if (po.getMinConsume().compareTo(BigDecimal.ZERO) != 0) {
                requestVO.setMinConsumeFlag(Integer.valueOf(1));
            } else {
                requestVO.setMinConsumeFlag(Integer.valueOf(0));
            }
            requestVO.setMinConsume(po.getMinConsume());
            if (StringUtils.isNotBlank((CharSequence)po.getOrganizationCode())) {
                String organizationCode = po.getOrganizationCode();
                logger.info("enter sysOnlineOrgServcieRpc queryOfflineOrgCodes:sysCompanyId:{},organizationCode:{}", (Object)po.getSysCompanyId(), (Object)organizationCode);
                offlineOrgCodesRes = this.sysOnlineOrgServcieRpc.queryOfflineOrgCodes(po.getSysCompanyId(), organizationCode);
                if (offlineOrgCodesRes != null && CollectionUtils.isNotEmpty((Collection)((Collection)offlineOrgCodesRes.getData()))) {
                    requestVO.setOfflineOrgCodes(((List)offlineOrgCodesRes.getData()).stream().collect(Collectors.joining(",")));
                }
            }
            if (Integer.valueOf(2).equals(po.getApplianceOrgType()) && StringUtils.isNotBlank((CharSequence)po.getApplianceOrgCodes())) {
                String applianceOrgCodes = po.getApplianceOrgCodes();
                logger.info("enter sysOnlineOrgServcieRpc queryOfflineOrgCodes:sysCompanyId:{},applianceOrgCodes:{}", (Object)po.getSysCompanyId(), (Object)applianceOrgCodes);
                offlineOrgCodesRes = this.sysOnlineOrgServcieRpc.queryOfflineOrgCodes(po.getSysCompanyId(), applianceOrgCodes);
                if (offlineOrgCodesRes != null && CollectionUtils.isNotEmpty((Collection)((Collection)offlineOrgCodesRes.getData()))) {
                    requestVO.setCouponDefOrgOfflineCodes(((List)offlineOrgCodesRes.getData()).stream().collect(Collectors.joining(",")));
                }
            }
            this.connectorServiceFeign.addCouponDefToErp(requestVO);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.ledengSysBrandIdList) && this.ledengSysBrandIdList.contains(po.getSysBrandId())) {
            logger.info("\u4e50\u767b\u5238\u5b9a\u4e49\u5199\u767e\u76db2.0\uff0c{}", (Object)JacksonUtil.bean2Json((Object)po));
            boolean syncErp = (Boolean)this.ledengServiceRpc.definitionAdd((CouponDefinitionPOWithBLOBs)po).getTData();
            if (!syncErp) {
                int flag = this.couponDefinitionPOMapper.deleteByPrimaryKey(po.getCouponDefinitionId());
                throw new BizException(-1, "\u540c\u6b65\u767e\u76db2.0\u5931\u8d25");
            }
        }
        if (this.hsCompanyId.equals(po.getSysCompanyId())) {
            logger.info("\u701a\u5347\u5238\u5b9a\u4e49\u5199\u7ebf\u4e0b");
            AddCouponDefToErpRequestVO requestVO2 = new AddCouponDefToErpRequestVO();
            requestVO2.setBrandId(po.getSysBrandId());
            requestVO2.setErpCouponDefinitionCode(po.getErpCouponDefinitionCode());
            requestVO2.setCouponName(po.getCouponName());
            requestVO2.setPreferentialType(Integer.valueOf(po.getPreferentialType().byteValue()));
            requestVO2.setMinDiscount(po.getMinDiscount());
            requestVO2.setDiscount(po.getDiscount());
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            requestVO2.setCreateDate(format.format(po.getCreateDate()));
            if (po.getMinConsume().compareTo(BigDecimal.ZERO) != 0) {
                requestVO2.setMinConsumeFlag(Integer.valueOf(1));
            } else {
                requestVO2.setMinConsumeFlag(Integer.valueOf(0));
            }
            requestVO2.setMinConsume(po.getMinConsume());
            this.connectorServiceFeign.addCouponDefToErp(requestVO2);
        }
        responseData.setData((Object)po.getCouponDefinitionId());
        return responseData;
    }

    private void handleCouponStoreAndGoodsCondition(CouponDefinitionBO bo) {
        if (null != bo.getApplianceStoreType() && 1 == bo.getApplianceStoreType()) {
            bo.setStoreWhitelist("");
            bo.setStoreBlacklist("");
        }
        if (null != bo.getApplianceCommodityType() && 2 == bo.getApplianceCommodityType() && null != bo.getCommodityLimitType()) {
            if (1 == bo.getCommodityLimitType()) {
                bo.setCommodityWhitelist("");
                bo.setOfflinePrdCode("");
                bo.setCommodityCompoundWhitelist("");
            } else if (2 == bo.getCommodityLimitType()) {
                bo.setCommodityBlacklist("");
                bo.setOfflinePrdCode("");
                bo.setCommodityCompoundWhitelist("");
            } else if (3 == bo.getCommodityLimitType()) {
                bo.setCommodityWhitelist("");
                bo.setCommodityBlacklist("");
                bo.setCommodityCompoundWhitelist("");
            } else if (4 == bo.getCommodityLimitType()) {
                bo.setCommodityWhitelist("");
                bo.setCommodityBlacklist("");
                bo.setOfflinePrdCode("");
            }
        } else if (null != bo.getApplianceCommodityType() && 1 == bo.getApplianceCommodityType()) {
            bo.setCommodityBlacklist("");
            bo.setCommodityWhitelist("");
            bo.setOfflinePrdCode("");
            bo.setCommodityCompoundWhitelist("");
        }
    }

    private ResponseData verifyCouponStoreCondition(CouponDefinitionBO bo) {
        if (null == bo.getApplianceStoreType()) {
            return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u95e8\u5e97\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (2 == bo.getApplianceStoreType() && null == bo.getStoreListType()) {
            return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u95e8\u5e97\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (2 == bo.getApplianceStoreType() && 1 == bo.getStoreListType()) {
            if (StringUtils.isBlank((CharSequence)bo.getStoreWhitelist())) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u95e8\u5e97\u767d\u540d\u5355\u95e8\u5e97\u4e3a\u7a7a");
            }
            if (bo.getStoreWhitelist().matches("^[,]+$")) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u95e8\u5e97\u767d\u540d\u5355\u95e8\u5e97\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
        } else if (2 == bo.getApplianceStoreType() && 2 == bo.getStoreListType()) {
            if (StringUtils.isBlank((CharSequence)bo.getStoreBlacklist())) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u95e8\u5e97\u9ed1\u540d\u5355\u95e8\u5e97\u4e3a\u7a7a");
            }
            if (bo.getStoreBlacklist().matches("^[,]+$")) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u95e8\u5e97\u9ed1\u540d\u5355\u95e8\u5e97\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
        }
        return new ResponseData();
    }

    private ResponseData verifyCouponGoodsCondition(CouponDefinitionBO bo) {
        if (null == bo.getApplianceCommodityType()) {
            return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9002\u7528\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (2 == bo.getApplianceCommodityType() && null == bo.getCommodityLimitType()) {
            return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u90e8\u5206\u9002\u7528\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (2 == bo.getApplianceCommodityType() && 1 == bo.getCommodityLimitType()) {
            if (StringUtils.isBlank((CharSequence)bo.getCommodityBlacklist())) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9ed1\u540d\u5355\u5546\u54c1\u4e3a\u7a7a");
            }
            if (bo.getCommodityBlacklist().matches("^[,]+$")) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u9ed1\u540d\u5355\u5546\u54c1\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
        } else if (2 == bo.getApplianceCommodityType() && 2 == bo.getCommodityLimitType()) {
            if (StringUtils.isBlank((CharSequence)bo.getCommodityWhitelist())) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u5355\u4e00\u767d\u540d\u5355\u5546\u54c1\u4e3a\u7a7a");
            }
            if (bo.getCommodityWhitelist().matches("^[,]+$")) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u5355\u4e00\u767d\u540d\u5355\u5546\u54c1\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
        } else if (2 == bo.getApplianceCommodityType() && 3 == bo.getCommodityLimitType()) {
            if (StringUtils.isBlank((CharSequence)bo.getOfflinePrdCode())) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u5546\u54c1\u5c5e\u6027\u4e3a\u7a7a");
            }
        } else if (2 == bo.getApplianceCommodityType() && 4 == bo.getCommodityLimitType()) {
            if (StringUtils.isBlank((CharSequence)bo.getCommodityCompoundWhitelist())) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u5546\u54c1\u590d\u5408\u767d\u540d\u5355\u5546\u54c1\u4e3a\u7a7a");
            }
            if (bo.getCommodityCompoundWhitelist().matches("^[,]+$")) {
                return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), "\u5546\u54c1\u590d\u5408\u767d\u540d\u5355\u5546\u54c1\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
        }
        return new ResponseData();
    }

    public void dealDataBySelectKey(Object obj) {
        if (obj != null && obj instanceof CouponDefinitionBO) {
            CouponDefinitionBO vo = (CouponDefinitionBO)obj;
            SelectCacheKeyVo selectCacheKeyVo = vo.getSelectCacheKeyVo();
            if (selectCacheKeyVo != null && StringUtils.isNotBlank((CharSequence)selectCacheKeyVo.getSelectStoreKey()) && null != vo.getApplianceStoreType() && 2 == vo.getApplianceStoreType() && null != vo.getStoreListType()) {
                String storeIds = this.getListStrBySelectKey(selectCacheKeyVo.getSelectStoreKey());
                String storeCodes = this.getStoreCodeByIdstrs(storeIds);
                if (1 == vo.getStoreListType()) {
                    vo.setStoreWhitelist(storeCodes);
                } else if (2 == vo.getStoreListType()) {
                    vo.setStoreBlacklist(storeCodes);
                }
            }
            if (selectCacheKeyVo != null && StringUtils.isNotBlank((CharSequence)selectCacheKeyVo.getSelectGoodsKey()) && null != vo.getApplianceCommodityType() && 2 == vo.getApplianceCommodityType() && null != vo.getCommodityLimitType()) {
                String listStrBySelectKey = this.getListStrBySelectKey(selectCacheKeyVo.getSelectGoodsKey());
                if (1 == vo.getCommodityLimitType()) {
                    vo.setCommodityBlacklist(listStrBySelectKey);
                } else if (2 == vo.getCommodityLimitType()) {
                    vo.setCommodityWhitelist(listStrBySelectKey);
                } else if (3 != vo.getCommodityLimitType() && 4 == vo.getCommodityLimitType()) {
                    vo.setCommodityCompoundWhitelist(listStrBySelectKey);
                }
            }
        }
    }

    public void ledengUpdateSync(CouponDefinitionBO vo) {
        LedengCouponDefinitionUpdateRequest ledengRequest;
        boolean r;
        String storeCodes = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getStoreWhitelist())) {
            storeCodes = vo.getStoreWhitelist();
        } else if (StringUtils.isNotBlank((CharSequence)vo.getStoreBlacklist())) {
            storeCodes = vo.getStoreBlacklist();
        }
        String goodsList = null;
        if (null != vo.getApplianceCommodityType() && 2 == vo.getApplianceCommodityType() && null != vo.getCommodityLimitType()) {
            if (1 == vo.getCommodityLimitType()) {
                goodsList = vo.getCommodityBlacklist();
            } else if (2 == vo.getCommodityLimitType()) {
                goodsList = vo.getCommodityWhitelist();
            } else if (4 == vo.getCommodityLimitType()) {
                goodsList = vo.getCommodityCompoundWhitelist();
            }
        }
        logger.info("goodsList:" + goodsList);
        logger.info("storeCodes:" + storeCodes);
        if (CollectionUtils.isNotEmpty((Collection)this.ledengSysBrandIdList) && this.ledengSysBrandIdList.contains(vo.getSysBrandId()) && (StringUtils.isNotBlank((CharSequence)storeCodes) || StringUtils.isNotBlank((CharSequence)goodsList)) && !(r = ((Boolean)this.ledengServiceRpc.definitionUpdate(ledengRequest = new LedengCouponDefinitionUpdateRequest(vo.getCouponDefinitionId(), goodsList, storeCodes, Boolean.valueOf(true))).getTData()).booleanValue())) {
            throw new BizException(-1, "\u540c\u6b65\u767e\u76db2.0\u5931\u8d25");
        }
    }

    public void getSelectKeyByList(Object obj) {
        if (obj != null && obj instanceof CouponDefinitionBO) {
            CouponDefinitionBO vo = (CouponDefinitionBO)obj;
            SelectCacheKeyVo selectCacheKeyVo = new SelectCacheKeyVo();
            if (null != vo.getApplianceStoreType() && vo.getApplianceStoreType() == 2 && (StringUtils.isNotBlank((CharSequence)vo.getStoreWhitelist()) || StringUtils.isNotBlank((CharSequence)vo.getStoreBlacklist()))) {
                String selectKey;
                String ids;
                if (StringUtils.isNotBlank((CharSequence)vo.getStoreWhitelist())) {
                    vo.setStoreListType(Byte.valueOf((byte)1));
                    ids = this.getIdsByCodestrs(vo.getStoreWhitelist(), vo.getSysCompanyId(), vo.getSysBrandId());
                    selectKey = this.getSelectKey(ids, SelectTypeEnum.STORE.getCode());
                    selectCacheKeyVo.setSelectStoreKey(selectKey);
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getStoreBlacklist())) {
                    vo.setStoreListType(Byte.valueOf((byte)2));
                    ids = this.getIdsByCodestrs(vo.getStoreBlacklist(), vo.getSysCompanyId(), vo.getSysBrandId());
                    selectKey = this.getSelectKey(ids, SelectTypeEnum.STORE.getCode());
                    selectCacheKeyVo.setSelectStoreKey(selectKey);
                }
            }
            if (selectCacheKeyVo != null && 2 == vo.getApplianceCommodityType()) {
                String selectKey;
                if (StringUtils.isNotBlank((CharSequence)vo.getCommodityBlacklist())) {
                    vo.setCommodityLimitType(Byte.valueOf((byte)1));
                    selectKey = this.getSelectKey(vo.getCommodityBlacklist(), SelectTypeEnum.GOODS.getCode());
                    selectCacheKeyVo.setSelectGoodsKey(selectKey);
                } else if (StringUtils.isNotBlank((CharSequence)vo.getCommodityWhitelist())) {
                    vo.setCommodityLimitType(Byte.valueOf((byte)2));
                    selectKey = this.getSelectKey(vo.getCommodityWhitelist(), SelectTypeEnum.GOODS.getCode());
                    selectCacheKeyVo.setSelectGoodsKey(selectKey);
                } else if (StringUtils.isNotBlank((CharSequence)vo.getCommodityCompoundWhitelist())) {
                    vo.setCommodityLimitType(Byte.valueOf((byte)4));
                    selectKey = this.getSelectKey(vo.getCommodityCompoundWhitelist(), SelectTypeEnum.GOODS.getCode());
                    selectCacheKeyVo.setSelectGoodsKey(selectKey);
                }
            }
            vo.setSelectCacheKeyVo(selectCacheKeyVo);
        }
    }

    private String getSelectKey(String storeListStr, String keyType) {
        String key = null;
        SysCacheVo sysCacheVo = new SysCacheVo();
        sysCacheVo.setListStr(storeListStr);
        sysCacheVo.setCacheType(keyType);
        ResponseData responseData = this.sysCacheServiceRpc.getSelectKeyByList(sysCacheVo);
        if (responseData != null && SysResponseEnum.SUCCESS.getCode() == responseData.getCode()) {
            key = (String)responseData.getData();
        }
        return key;
    }

    private String getListStrBySelectKey(String key) {
        String listStr = null;
        ResponseData responseData = this.sysCacheServiceRpc.getSelectEdList(key);
        if (responseData != null && SysResponseEnum.SUCCESS.getCode() == responseData.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)responseData.getData()))) {
            List data = (List)responseData.getData();
            listStr = data.stream().collect(Collectors.joining(","));
        }
        return listStr;
    }

    private String getStoreCodeByIdstrs(String ids) {
        List collect;
        ResponseData idStoreLists;
        String storeNums = null;
        if (StringUtils.isNotBlank((CharSequence)ids) && (idStoreLists = this.storeServiceRpc.getIdStoreLists(collect = Arrays.stream(ids.split(",")).map(t -> Long.valueOf(t)).collect(Collectors.toList()))) != null && SysResponseEnum.SUCCESS.getCode() == idStoreLists.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)idStoreLists.getData()))) {
            List data = (List)idStoreLists.getData();
            storeNums = data.stream().map(SysStorePo::getSysStoreOnlineCode).collect(Collectors.joining(","));
        }
        return storeNums;
    }

    private String getIdsByCodestrs(String codes, Long sysCompanyId, Long sysBrandId) {
        List collect;
        ResponseData idStoreLists;
        String ids = null;
        if (StringUtils.isNotBlank((CharSequence)codes) && (idStoreLists = this.storeServiceRpc.getStoreListByOnlineCode(collect = Arrays.stream(codes.split(",")).collect(Collectors.toList()), sysCompanyId)) != null && SysResponseEnum.SUCCESS.getCode() == idStoreLists.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)idStoreLists.getData()))) {
            List data = (List)idStoreLists.getData();
            ids = data.stream().map(SysStorePo::getSysStoreId).map(Objects::toString).collect(Collectors.joining(","));
        }
        return ids;
    }

    private void saveCategoryToConnector(Integer couponDefinitionId, String couponDefinitionCode, List<ProductCategoryVO> productCategoryVOS) {
        for (ProductCategoryVO productCategoryVO : productCategoryVOS) {
            String prdParentName = productCategoryVO.getPrdParentName();
            String str = productCategoryVO.getStr();
            if ("\u5927\u7c7b".equals(prdParentName)) {
                this.connectorServiceFeign.saveCategory("bigCategory-" + couponDefinitionCode, str);
                this.connectorServiceFeign.saveCategory("bigCategory-" + couponDefinitionId, str);
                continue;
            }
            if ("\u4e2d\u7c7b".equals(prdParentName)) {
                this.connectorServiceFeign.saveCategory("middleCategory-" + couponDefinitionCode, str);
                this.connectorServiceFeign.saveCategory("middleCategory-" + couponDefinitionId, str);
                continue;
            }
            if ("\u5c0f\u7c7b".equals(prdParentName)) {
                this.connectorServiceFeign.saveCategory("smallCategory-" + couponDefinitionCode, str);
                this.connectorServiceFeign.saveCategory("smallCategory-" + couponDefinitionId, str);
                continue;
            }
            if ("\u5e74\u4efd".equals(prdParentName)) {
                this.connectorServiceFeign.saveCategory("particularYear-" + couponDefinitionCode, str);
                this.connectorServiceFeign.saveCategory("particularYear-" + couponDefinitionId, str);
                continue;
            }
            if (!"\u5b63\u8282".equals(prdParentName)) continue;
            this.connectorServiceFeign.saveCategory("season-" + couponDefinitionCode, str);
            this.connectorServiceFeign.saveCategory("season-" + couponDefinitionId, str);
        }
    }

    public ResponseData<Object> update(CouponDefinitionPOWithBLOBs po, SysAccountPO accountPo) {
        logger.info("enter CouponDefinitionServiceImpl update method#po:{}", (Object)JSON.toJSONString((Object)po));
        ResponseData responseData = new ResponseData();
        if (null == po.getCouponDefinitionId()) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_DEFINITION_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (null != po.getLinkUrlJson()) {
            po.setLinkUrl(po.getLinkUrlJson().toJSONString());
        }
        po.setModifiedDate(TimeUtils.getNowTime());
        long couponDefinitionId = po.getCouponDefinitionId();
        if (CollectionUtils.isNotEmpty((Collection)this.ledengSysBrandIdList) && this.ledengSysBrandIdList.contains(accountPo.getBrandId()) && po.getStatus() != null && !po.getStatus().booleanValue()) {
            LedengCouponDefinitionUpdateRequest request = new LedengCouponDefinitionUpdateRequest(Long.valueOf(couponDefinitionId), null, null, Boolean.valueOf(false));
            boolean r = (Boolean)this.ledengServiceRpc.definitionUpdate(request).getTData();
            if (!r) {
                throw new BizException(-1, "\u767e\u76db\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
            }
            this.couponDefinitionService.ledengCouponStop(po.getCouponDefinitionId().longValue(), accountPo);
        }
        int result = this.couponDefinitionPOMapper.updateByPrimaryKeySelective(po);
        if (po.getStatus() != null && !po.getStatus().booleanValue()) {
            this.taskServiceForWXRpc.takeDownCoupon(po.getCouponDefinitionId());
        }
        responseData.setData((Object)result);
        return responseData;
    }

    public ResponseData<Integer> batchInvalidate(BatchInvalidateRequestVo requestVo) {
        for (Long couponDefinitionId : requestVo.getCouponDefinitionIdList()) {
            CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = new CouponDefinitionPOWithBLOBs();
            couponDefinitionPOWithBLOBs.setCouponDefinitionId(couponDefinitionId);
            couponDefinitionPOWithBLOBs.setStatus(Boolean.FALSE);
            couponDefinitionPOWithBLOBs.setModifiedDate(new Date());
            couponDefinitionPOWithBLOBs.setModifiedUserId(requestVo.getModifiedUserId());
            couponDefinitionPOWithBLOBs.setModifiedUserName(requestVo.getModifiedUserName());
            this.couponDefinitionPOMapper.updateByPrimaryKeySelective(couponDefinitionPOWithBLOBs);
            this.taskServiceForWXRpc.takeDownCoupon(couponDefinitionId);
        }
        return new ResponseData();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Object> definitionMoneyRpc(CouponDefinitionMoneyPO po) {
        logger.info("enter CouponDefinitionServiceImpl definitionMoneyRpc method");
        ResponseData responseData = new ResponseData();
        CouponDefinitionMoneyPOExample example = new CouponDefinitionMoneyPOExample();
        example.createCriteria().andTaskIdEqualTo(po.getTaskId());
        List selectByExamplelist = this.couponDefinitionMoneyPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)selectByExamplelist)) {
            po.setNumber(Byte.valueOf((byte)1));
            int result = this.couponDefinitionMoneyPOMapper.insert(po);
            responseData.setData((Object)result);
            return responseData;
        }
        po.setModifiedDate(TimeUtils.getNowTime());
        CouponDefinitionMoneyPO couponDefinitionMoneyOld = (CouponDefinitionMoneyPO)selectByExamplelist.get(0);
        po.setMoneyAdd(po.getMoneyAdd().add(couponDefinitionMoneyOld.getMoneyAdd()));
        po.setNumber(Byte.valueOf((byte)(couponDefinitionMoneyOld.getNumber() + 1)));
        po.setCouponDefinitionMoneyId(couponDefinitionMoneyOld.getCouponDefinitionMoneyId());
        int result = this.couponDefinitionMoneyPOMapper.updateByPrimaryKeySelective(po);
        responseData.setData((Object)result);
        return responseData;
    }

    public ResponseData<CouponDefinitionPOWithBLOBs> getCouponDefinition(Long couponDefinitionId) {
        logger.info("enter CouponDefinitionServiceImpl getCouponDefinition method");
        ResponseData responseData = new ResponseData();
        if (null == couponDefinitionId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_DEFINITION_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(couponDefinitionId);
        CouponDefinitionBO couponDefinitionBO = new CouponDefinitionBO();
        try {
            if (couponDefinitionPOWithBLOBs.getValidType() == 1) {
                couponDefinitionPOWithBLOBs.setValidTimeState(DateUtil.hourMinuteBetween((Date)couponDefinitionPOWithBLOBs.getValidDateStart(), (Date)couponDefinitionPOWithBLOBs.getValidDateEnd()));
            } else {
                couponDefinitionPOWithBLOBs.setValidTimeState(true);
            }
            if (!couponDefinitionPOWithBLOBs.getStatus().booleanValue()) {
                couponDefinitionPOWithBLOBs.setValidTimeState(false);
            }
            BeanUtils.copyProperties((Object)couponDefinitionPOWithBLOBs, (Object)couponDefinitionBO);
            Long sysCompanyId = couponDefinitionPOWithBLOBs.getSysCompanyId();
            Long sysBrandId = couponDefinitionPOWithBLOBs.getSysBrandId();
            String offlinePrdCode = couponDefinitionPOWithBLOBs.getOfflinePrdCode();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode}) && offlinePrdCode.toCharArray().length > 2) {
                HashMap<String, List> map = new HashMap<String, List>();
                List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
                for (ProductCategoryVO productCategoryVO : productCategoryVOS) {
                    String prdParentName = productCategoryVO.getPrdParentName();
                    String str = productCategoryVO.getStr();
                    List data = (List)this.sysProductCategoryServiceRpc.selectSysProductCategoryDetail(sysBrandId, sysCompanyId, prdParentName, str).getData();
                    map.put(prdParentName, data);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
            logger.info("enter CouponDefinitionServiceImpl getTemplate hourMinuteBetween \u8f6c\u6362\u65f6\u95f4\u62a5\u9519");
        }
        responseData.setData((Object)couponDefinitionPOWithBLOBs);
        return responseData;
    }

    public ResponseData<List<CouponDefinitionPOWithBLOBs>> findByIdList(List<Long> couponDefinitionIdList) {
        logger.info("CouponDefinitionServiceImpl-findByIdList-info,couponDefinitionIdList:{}", (Object)JSONObject.toJSONString(couponDefinitionIdList));
        ResponseData responseData = new ResponseData();
        if (CollectionUtils.isEmpty(couponDefinitionIdList)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5238\u5b9a\u4e49ID\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        CouponDefinitionPOExample example = new CouponDefinitionPOExample();
        example.createCriteria().andCouponDefinitionIdIn(couponDefinitionIdList);
        List list = this.couponDefinitionPOMapper.selectByExampleWithBLOBs(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setData(new ArrayList());
            return responseData;
        }
        for (CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs : list) {
            try {
                if (couponDefinitionPOWithBLOBs.getValidType() == 1) {
                    couponDefinitionPOWithBLOBs.setValidTimeState(DateUtil.hourMinuteBetween((Date)couponDefinitionPOWithBLOBs.getValidDateStart(), (Date)couponDefinitionPOWithBLOBs.getValidDateEnd()));
                } else {
                    couponDefinitionPOWithBLOBs.setValidTimeState(true);
                }
                if (couponDefinitionPOWithBLOBs.getStatus().booleanValue()) continue;
                couponDefinitionPOWithBLOBs.setValidTimeState(false);
            }
            catch (Exception e) {
                logger.info("CouponDefinitionServiceImpl-findByIdList-info,\u8f6c\u6362\u65f6\u95f4\u62a5\u9519,e:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        responseData.setData((Object)list);
        logger.info("CouponDefinitionServiceImpl-findByIdList-info,responseData:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        return responseData;
    }

    public ResponseData<CouponDefinitionBO> getCouponDefinitionNew(Long couponDefinitionId) {
        logger.info("enter CouponDefinitionServiceImpl getCouponDefinition method");
        ResponseData responseData = new ResponseData();
        if (null == couponDefinitionId) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.COUPON_DEFINITION_ID_NOT_NULL.getMessage());
            return responseData;
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(couponDefinitionId);
        CouponDefinitionBO couponDefinitionBO = new CouponDefinitionBO();
        try {
            if (couponDefinitionPOWithBLOBs.getValidType() == 1) {
                couponDefinitionPOWithBLOBs.setValidTimeState(DateUtil.hourMinuteBetween((Date)couponDefinitionPOWithBLOBs.getValidDateStart(), (Date)couponDefinitionPOWithBLOBs.getValidDateEnd()));
            } else {
                couponDefinitionPOWithBLOBs.setValidTimeState(true);
            }
            if (!couponDefinitionPOWithBLOBs.getStatus().booleanValue()) {
                couponDefinitionPOWithBLOBs.setValidTimeState(false);
            }
            BeanUtils.copyProperties((Object)couponDefinitionPOWithBLOBs, (Object)couponDefinitionBO);
            Long sysCompanyId = couponDefinitionPOWithBLOBs.getSysCompanyId();
            Long sysBrandId = couponDefinitionPOWithBLOBs.getSysBrandId();
            String offlinePrdCode = couponDefinitionPOWithBLOBs.getOfflinePrdCode();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode}) && offlinePrdCode.toCharArray().length > 2) {
                HashMap<String, List> map = new HashMap<String, List>();
                List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
                for (ProductCategoryVO productCategoryVO : productCategoryVOS) {
                    String prdParentName = productCategoryVO.getPrdParentName();
                    String str = productCategoryVO.getStr();
                    List data = (List)this.sysProductCategoryServiceRpc.selectSysProductCategoryDetail(sysBrandId, sysCompanyId, prdParentName, str).getData();
                    map.put(prdParentName, data);
                }
                couponDefinitionBO.setMap(map);
            }
            if (!StringUtils.isEmpty((CharSequence)offlinePrdCode) && offlinePrdCode.length() > 2) {
                DefSkuExtendDetailVO sd = new DefSkuExtendDetailVO();
                sd.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
                sd.setSysCompanyId(couponDefinitionPOWithBLOBs.getSysCompanyId());
                sd.setSysBrandId(couponDefinitionPOWithBLOBs.getSysBrandId());
                ResponseData spRd = this.sysProductCategoryRpc.listDefSkuAttribute(sd);
                PageInfo data = (PageInfo)spRd.getData();
                if (data != null && data.getList() != null) {
                    List productCategoryVOS = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
                    HashSet<String> set = new HashSet<String>();
                    for (ProductCategoryVO categoryVO : productCategoryVOS) {
                        String[] split;
                        if (!StringUtils.isNotEmpty((CharSequence)categoryVO.getStr())) continue;
                        for (String s : split = categoryVO.getStr().split(",")) {
                            set.add(categoryVO.getPrdParentName() + "#" + s);
                        }
                    }
                    List list = data.getList();
                    List rs = list.stream().filter(f -> set.contains(f.getPrdParentName() + "#" + f.getOfflinePrdCode())).collect(Collectors.toList());
                    couponDefinitionBO.setCommodityAttributeList(rs);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)couponDefinitionBO.getOrganizationCode())) {
                ResponseData listResponseData = this.sysOnlineOrgServcieRpc.queryOnlineOrgList(sysCompanyId, "");
                Map<Object, Object> orgMap = new HashMap();
                if (listResponseData != null && SysResponseEnum.SUCCESS.getCode() == listResponseData.getCode()) {
                    List sysOnlineOrgPoList = (List)listResponseData.getData();
                    orgMap = sysOnlineOrgPoList.stream().collect(Collectors.toMap(SysOnlineOrgPo::getOnlineOrgCode, SysOnlineOrgPo::getOnlineOrgName));
                }
                couponDefinitionBO.setOrganizationName((String)orgMap.get(couponDefinitionBO.getOrganizationCode()));
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
            logger.info("enter CouponDefinitionServiceImpl getTemplate hourMinuteBetween \u8f6c\u6362\u65f6\u95f4\u62a5\u9519");
        }
        this.getSelectKeyByList((Object)couponDefinitionBO);
        responseData.setData((Object)couponDefinitionBO);
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo> getTemplate(CouponDefinitionPO couponDefinitionPo, PageFormUtil pageFormUtil, SysAccountPo accountPo) {
        logger.info("enter CouponDefinitionServiceImpl getTemplate method");
        ResponseData responseData = new ResponseData();
        CouponDefinitionPOExample example = new CouponDefinitionPOExample();
        CouponDefinitionPOExample.Criteria criteria = example.createCriteria();
        criteria.andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        criteria.andCreateUserIdEqualTo(accountPo.getSysAccountId());
        criteria.andIsAddTemplateEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        criteria.andSysBrandIdEqualTo(accountPo.getBrandId());
        criteria.andStatusEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        if (StringUtils.isNotBlank((CharSequence)couponDefinitionPo.getCouponName())) {
            criteria.andCouponNameLike("%" + couponDefinitionPo.getCouponName() + "%");
        }
        if (couponDefinitionPo.getPreferentialType() != null) {
            criteria.andPreferentialTypeEqualTo(couponDefinitionPo.getPreferentialType());
        }
        if (couponDefinitionPo.getUseChannel() != null) {
            criteria.andUseChannelEqualTo(couponDefinitionPo.getUseChannel());
        }
        example.setOrderByClause("create_date DESC");
        PageHelper.startPage((int)pageFormUtil.getPageNumber(), (int)pageFormUtil.getPageSize());
        List list = this.couponDefinitionPOMapper.selectByExampleWithBLOBs(example);
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<CouponDefinitionPO>> getUseList(CouponDefinitionListQueryVO vo, PageFormUtil pageForm, Long brandId) {
        ResponseData responseData = new ResponseData();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = format.parse(format.format(new Date()), new ParsePosition(0));
        PageHelper.startPage((int)pageForm.getPageNumber(), (int)pageForm.getPageSize());
        if (vo.getUseChannel() != null && vo.getUseChannel() == 13) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sysCompanyId", vo.getSysCompanyId());
            map.put("sysBrandId", vo.getSysBrandId());
            map.put("validTypeList", Arrays.asList(SystemConstants.VALID_TYPE__INTERVAL, SystemConstants.VALID_TYPE__SOMEDAY, SystemConstants.VALID_TYPE_DELAY));
            map.put("useChannelList", Arrays.asList(SystemConstants.USE_CHANNEL_OFFLINE, SystemConstants.USE_CHANNEL_ANY, SystemConstants.USE_CHANNEL_ONLINE));
            map.put("couponDefinitionTypeList", Arrays.asList(SystemConstants.COUPON_DEFINITION_TYPE_ONLINE));
            map.put("valid", SystemConstants.TABLE_VALID_EFFECTIVE);
            map.put("organizationCode", vo.getOrganizationCode());
            map.put("status", SystemConstants.COUPON_DEFINITION_STATUS_USE);
            map.put("date", date);
            map.put("couponDefinitionId", vo.getCouponDefinitionId());
            map.put("couponName", vo.getCouponName());
            map.put("transferFission", vo.getTransferFission());
            List listByMap = this.couponDefinitionPOMapper.getListByMap(map);
            com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(listByMap);
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        List definitionPOList = StringUtils.isBlank((CharSequence)vo.getOrganizationCode()) && null != vo.getBrandOrgCodeEmpty() && vo.getBrandOrgCodeEmpty() != false ? this.couponDefinitionPOMapper.getUseListOrgCodeEmpty(vo.getTransferFission(), vo.getPreferentialType(), brandId, date, SystemConstants.TABLE_VALID_EFFECTIVE, SystemConstants.COUPON_DEFINITION_STATUS_USE, vo.getCouponDefinitionId(), vo.getCouponName(), SystemConstants.VALID_TYPE__INTERVAL, SystemConstants.VALID_TYPE__SOMEDAY, vo.getUseChannel(), SystemConstants.VALID_TYPE_DELAY, vo.getBusiness()) : this.couponDefinitionPOMapper.getUseList(vo.getTransferFission(), vo.getPreferentialType(), brandId, date, SystemConstants.TABLE_VALID_EFFECTIVE, SystemConstants.COUPON_DEFINITION_STATUS_USE, vo.getCouponDefinitionId(), vo.getCouponName(), SystemConstants.VALID_TYPE__INTERVAL, SystemConstants.VALID_TYPE__SOMEDAY, vo.getUseChannel(), SystemConstants.VALID_TYPE_DELAY, vo.getOrganizationCode(), vo.getBusiness());
        if (CollectionUtils.isNotEmpty((Collection)definitionPOList)) {
            ResponseData listResponseData = this.sysOnlineOrgServcieRpc.queryOnlineOrgList(vo.getSysCompanyId(), "");
            Map<Object, Object> orgMap = new HashMap();
            if (listResponseData != null && SysResponseEnum.SUCCESS.getCode() == listResponseData.getCode()) {
                List sysOnlineOrgPoList = (List)listResponseData.getData();
                orgMap = sysOnlineOrgPoList.stream().collect(Collectors.toMap(SysOnlineOrgPo::getOnlineOrgCode, SysOnlineOrgPo::getOnlineOrgName));
            }
            for (CouponDefinitionPO couponDefinitionPO : definitionPOList) {
                if (!StringUtils.isNotBlank((CharSequence)couponDefinitionPO.getOrganizationCode())) continue;
                couponDefinitionPO.setOrganizationName((String)orgMap.get(couponDefinitionPO.getOrganizationCode()));
            }
        }
        com.bizvane.utils.responseinfo.PageInfo pageInfo = new com.bizvane.utils.responseinfo.PageInfo(definitionPOList);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public List<String> getUseListNew(CouponDefinitionListQueryVO vo, Long brandId) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = format.parse(format.format(new Date()), new ParsePosition(0));
        logger.info("getUseListNew\u53c2\u65700");
        List definitionPOList = this.couponDefinitionPOMapper.getUseListNoTimeLimit(vo.getTransferFission(), vo.getPreferentialType(), brandId, date, SystemConstants.TABLE_VALID_EFFECTIVE, SystemConstants.COUPON_DEFINITION_STATUS_USE, vo.getCouponDefinitionId(), vo.getCouponName(), SystemConstants.VALID_TYPE__INTERVAL, SystemConstants.VALID_TYPE__SOMEDAY, vo.getUseChannel(), SystemConstants.VALID_TYPE_DELAY, vo.getOrganizationCode());
        logger.info("getUseListNew\u53c2\u65701");
        if (CollectionUtils.isNotEmpty((Collection)definitionPOList)) {
            logger.info("getUseListNew\u53c2\u65702");
            ArrayList<String> strList = new ArrayList<String>();
            for (CouponDefinitionPO po : definitionPOList) {
                strList.add(String.valueOf(po.getCouponDefinitionId()));
            }
            logger.info("getUseListNew\u53c2\u65703");
            return strList;
        }
        return null;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<SysDimSkuPo>> getIdSysDimSkuList(String order, String productCode, String productName, PageFormUtil page, SysAccountPo sysAccountPo) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)order)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        List<String> sysDimSkuIdList = Arrays.asList(order.split(","));
        ArrayList<String> id = new ArrayList<String>();
        for (String value : sysDimSkuIdList) {
            id.add(value);
        }
        SysDimSkuVo vo = new SysDimSkuVo();
        vo.setProductCodeList(id);
        vo.setProductCode(productCode);
        vo.setProductName(productName);
        vo.setPageNumber(page.getPageNumber());
        vo.setPageSize(page.getPageSize());
        responseData = this.sysDimSkuServiceRpc.getIdSysDimProductListPlus(vo);
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<SysDimSkuPo>> getIdSysDimSkuListNew(String order, String condition, String productCode, String productName, PageFormUtil page, SysAccountPo sysAccountPo) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)order)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        List<String> sysDimSkuIdList = Arrays.asList(order.split(","));
        ArrayList<String> id = new ArrayList<String>();
        for (String value : sysDimSkuIdList) {
            id.add(value);
        }
        SysDimSkuVo vo = new SysDimSkuVo();
        if (sysAccountPo.getBrandId() != null) {
            vo.setSysBrandId(sysAccountPo.getBrandId());
        }
        vo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            vo.setSearchValue(condition);
        }
        vo.setProductCode(order);
        vo.setProductName(productName);
        vo.setPageNumber(page.getPageNumber());
        vo.setPageSize(page.getPageSize());
        logger.info("couponDefinitionService getIdSysDimSkuListNew param : {}", (Object)JSON.toJSONString((Object)vo));
        responseData = this.sysDimSkuServiceRpc.getIdSysDimProductListNew(vo);
        return responseData;
    }

    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<SysStorePo>> getIdStoreList(String store, String sysStoreOfflineCode, String storeName, PageFormUtil page, SysAccountPo sysAccountPo) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)store)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        List<String> storeList = Arrays.asList(store.split(","));
        ArrayList<Long> id = new ArrayList<Long>();
        for (String value : storeList) {
            ResponseData getStoreIdByCode = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(value, sysAccountPo.getSysCompanyId());
            if (getStoreIdByCode == null || getStoreIdByCode.getData() == null) continue;
            id.add(((SysStorePo)getStoreIdByCode.getData()).getSysStoreId());
        }
        responseData = this.storeServiceRpc.getIdStoreList(id, sysStoreOfflineCode, storeName, page.getPageNumber(), page.getPageSize());
        return responseData;
    }

    public ResponseData<Boolean> couponDefinitionExpire(Long couponDefinitionId) throws Exception {
        ResponseData responseData = new ResponseData();
        Boolean ifExpire = Boolean.FALSE;
        CouponDefinitionPOWithBLOBs couponDefinitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(couponDefinitionId);
        if (couponDefinitionPO.getValidType().equals(SystemConstants.VALID_TYPE__INTERVAL)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date endDate = format.parse(format.format(couponDefinitionPO.getValidDateEnd()));
            Date now = format.parse(format.format(new Date()));
            if (endDate.getTime() < now.getTime()) {
                ifExpire = Boolean.TRUE;
            }
        }
        responseData.setData((Object)ifExpire);
        return responseData;
    }

    public String addWmMerchantCoupon(CouponDefinitionPOWithBLOBs po) throws Exception {
        try {
            String data;
            Long sysBrandId = po.getSysBrandId();
            Result resultToken = this.wmConnectorServiceFeign.queryWmToken(sysBrandId);
            if (resultToken.getCode().equals(SysResponseEnum.FAILED.getCode())) {
                logger.info("addWmMerchantCoupon \u83b7\u53d6token\u5931\u8d25");
                throw new Exception("\u83b7\u53d6\u5fae\u76dftoken\u5931\u8d25");
            }
            String accessToken = String.valueOf(resultToken.getData());
            String sendCouponUrl = this.wmAddCouponUrl + "ec/coupon/addMerchantCoupon" + "?accesstoken=" + accessToken;
            JSONObject jsonCouponRequest = new JSONObject();
            jsonCouponRequest.put("name", (Object)po.getCouponName());
            jsonCouponRequest.put("type", (Object)(po.getPreferentialType() - 1));
            jsonCouponRequest.put("cashTicketCondition", (Object)po.getMinConsume());
            jsonCouponRequest.put("cashTicketAmt", (Object)po.getMoney());
            jsonCouponRequest.put("discount", (Object)po.getDiscount());
            jsonCouponRequest.put("selectLimitType", (Object)0);
            if (po.getMaxCommodityNum() != null) {
                jsonCouponRequest.put("selectLimitType", (Object)2);
                jsonCouponRequest.put("maxGoodsAmount", (Object)po.getMaxCommodityNum());
            }
            if (po.getValidType().equals(SystemConstants.VALID_TYPE__INTERVAL)) {
                jsonCouponRequest.put("expireDateType", (Object)1);
                jsonCouponRequest.put("startDate", (Object)po.getValidDateStart());
                jsonCouponRequest.put("expireDate", (Object)po.getValidDateEnd());
            } else if (po.getValidType().equals(SystemConstants.VALID_TYPE__SOMEDAY)) {
                jsonCouponRequest.put("expireDateType", (Object)2);
                jsonCouponRequest.put("startDayCount", (Object)0);
                jsonCouponRequest.put("expDayCount", (Object)po.getValidDay());
            } else if (po.getValidType().equals(SystemConstants.VALID_TYPE_DELAY)) {
                jsonCouponRequest.put("expireDateType", (Object)2);
                jsonCouponRequest.put("startDayCount", (Object)po.getDelayDay());
                jsonCouponRequest.put("expDayCount", (Object)po.getDelayValidDay());
            }
            jsonCouponRequest.put("stock", (Object)99999999);
            jsonCouponRequest.put("acceptGoodsType", (Object)1);
            jsonCouponRequest.put("selectStoreType", (Object)1);
            int[] useScenes = new int[]{1, 10, 8, 9, 3, 7};
            jsonCouponRequest.put("useSceneList", (Object)useScenes);
            jsonCouponRequest.put("userTakeLimit", (Object)10);
            if (po.getPerMaxNum() != null) {
                jsonCouponRequest.put("userTakeLimit", (Object)po.getPerMaxNum());
            }
            jsonCouponRequest.put("useNotice", (Object)po.getInfo());
            jsonCouponRequest.put("canGiveFriend", (Object)(po.getIsTransfer() != null ? po.getIsTransfer() : true));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=utf-8");
            headers.put("accept", "application/json; charset=utf-8");
            logger.info("CouponDefinitionServiceImpl addWmMerchantCoupon\uff0curl:{}\uff0cparam:{}", (Object)sendCouponUrl, (Object)jsonCouponRequest.toJSONString());
            String resultStr = HttpClientUtil.dopost((String)sendCouponUrl, (String)jsonCouponRequest.toJSONString(), headers);
            logger.info("CouponDefinitionServiceImpl addWmMerchantCoupon\uff0cresult:{}", (Object)resultStr);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                logger.info("addWmMerchantCoupon \u65b0\u589e\u5238\u5fae\u76df\u8fd4\u56de\u4e3a\u7a7a");
                throw new Exception("\u65b0\u589e\u5238\u5fae\u76df\u8fd4\u56de\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSON.parseObject((String)resultStr);
            String codeMain = jsonObject.getString("code");
            if (StringUtils.isNotEmpty((CharSequence)codeMain)) {
                JSONObject codeJson = JSONObject.parseObject((String)codeMain);
                String errCode = codeJson.getString("errcode");
                String errMsg = codeJson.getString("errmsg");
                if (!"0".equals(errCode)) {
                    logger.info("addWmMerchantCoupon \u8c03\u7528\u5fae\u76df\u8fd4\u56de\u5931\u8d25:" + errMsg);
                    throw new Exception(errMsg);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(data = jsonObject.getString("data")))) {
                JSONObject dataJson = JSONObject.parseObject((String)data);
                String couponCode = dataJson.getString("couponTemplateId");
                logger.info("\u8c03\u7528\u5fae\u76df\u65b0\u589e\u5238\u8fd4\u56de\u5238\u7c7b\u578b\u53f7:" + couponCode);
                return couponCode;
            }
            logger.info("\u8c03\u7528\u5fae\u76df\u65b0\u589e\u5238\u8fd4\u56de\u7c7b\u578b\u53f7\u4e3a\u7a7a");
            throw new Exception("\u8c03\u7528\u5fae\u76df\u65b0\u589e\u5238\u8fd4\u56de\u7c7b\u578b\u53f7\u4e3a\u7a7a");
        }
        catch (Exception e) {
            logger.info("CouponDefinitionServiceImpl addWmMerchantCoupon error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new Exception(e.getMessage());
        }
    }

    public void addOrUpdateYzCouponDefinition(CouponDefinitionPOWithBLOBs po, String type, SysAccountPO sysAccountPO) throws Exception {
        SysYzBrandStoreMapping sysYzBrandStoreMapping = (SysYzBrandStoreMapping)this.sysYzBrandStoreMappingServiceRpc.getYzStoreInfoBySysBrandId(sysAccountPO.getBrandId()).getData();
        if (sysYzBrandStoreMapping == null) {
            return;
        }
        String authorityId = sysYzBrandStoreMapping.getAuthorityId();
        YzCouponDefinitionVo yzCouponDefinitionVo = new YzCouponDefinitionVo();
        logger.info("addOrUpdateYzCouponDefinition po {}, sysAccountPO {}", (Object)po.toString(), (Object)sysAccountPO.toString());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS+0800");
        if (po.getValidDateStart() != null) {
            yzCouponDefinitionVo.setAbsoluteValidStartTime(DateUtils.dateFormatTime((Date)DateUtil.getStartDateOfDay((Date)po.getValidDateStart())));
        }
        if (po.getValidDateEnd() != null) {
            yzCouponDefinitionVo.setAbsoluteValidEndTime(DateUtils.dateFormatTime((Date)DateUtil.getEndDateOfDay((Date)po.getValidDateEnd())));
        }
        yzCouponDefinitionVo.setActivityId(po.getCouponDefinitionId());
        yzCouponDefinitionVo.setIsWeixinSync(Boolean.valueOf(false));
        yzCouponDefinitionVo.setColorName("");
        yzCouponDefinitionVo.setColorValue("");
        yzCouponDefinitionVo.setServicePhone("");
        yzCouponDefinitionVo.setWeixinTitle("");
        yzCouponDefinitionVo.setWeixinSubTitle("");
        yzCouponDefinitionVo.setApplicableOnlineGoodsRangeType(Integer.valueOf(po.getApplianceCommodityType() == null ? 1 : po.getApplianceCommodityType().intValue()));
        ArrayList<Long> storeIds = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)po.getStoreWhitelist())) {
            String[] storeCodes;
            for (String storeCode : storeCodes = po.getStoreWhitelist().split(",")) {
                SysYzBrandStoreMapping temp = this.getYzStoreInfo(storeCode);
                if (temp == null) continue;
                storeIds.add(Long.parseLong(temp.getAuthorityId()));
            }
        }
        yzCouponDefinitionVo.setApplicableShopIds(storeIds);
        Integer applicableShopRangeType = 1;
        if (po.getApplianceStoreType() == 1) {
            applicableShopRangeType = 3;
        } else if (po.getApplianceStoreType() == 1) {
            applicableShopRangeType = 2;
        }
        if (po.getValidType() == 1) {
            yzCouponDefinitionVo.setValidTimeGenerateType(Integer.valueOf(1));
        } else if (po.getValidType() == 2) {
            yzCouponDefinitionVo.setValidTimeGenerateType(Integer.valueOf(2));
            yzCouponDefinitionVo.setRelativeValidTimeBeginInterval(Integer.valueOf(0));
            yzCouponDefinitionVo.setRelativeValidTimeDuration(po.getValidDay());
        } else if (po.getValidType() == 5) {
            yzCouponDefinitionVo.setValidTimeGenerateType(Integer.valueOf(2));
            yzCouponDefinitionVo.setRelativeValidTimeBeginInterval(po.getValidDay());
            yzCouponDefinitionVo.setRelativeValidTimeDuration(po.getValidDay());
        }
        logger.info("getPreferentialType {}", (Object)po.getPreferentialType());
        if (1 == po.getPreferentialType()) {
            yzCouponDefinitionVo.setValue(Long.valueOf(po.getMoney().multiply(new BigDecimal("100")).longValue()));
            yzCouponDefinitionVo.setVoucherValueGenerateType(Integer.valueOf(1));
        } else if (2 == po.getPreferentialType()) {
            yzCouponDefinitionVo.setVoucherValueGenerateType(Integer.valueOf(1));
            yzCouponDefinitionVo.setValue(Long.valueOf(po.getDiscount().multiply(new BigDecimal("10")).longValue()));
            BigDecimal maxPreferential = po.getMaxPreferential();
            if (maxPreferential != null) {
                yzCouponDefinitionVo.setMaxDiscountAmount(Integer.valueOf(po.getMaxPreferential().multiply(new BigDecimal("100")).intValue()));
            }
        }
        yzCouponDefinitionVo.setPreferentialMode(Integer.valueOf(po.getPreferentialType().intValue()));
        yzCouponDefinitionVo.setApplicableShopRangeType(applicableShopRangeType);
        yzCouponDefinitionVo.setIsForbidOverlayPreferential(po.getIsSuperposition());
        yzCouponDefinitionVo.setThresholdAmount(Long.valueOf(po.getMinConsume() == null ? new BigDecimal(0).longValue() : po.getMinConsume().multiply(new BigDecimal(100)).longValue()));
        yzCouponDefinitionVo.setMaxValue(Long.valueOf(0L));
        yzCouponDefinitionVo.setMinValue(Long.valueOf(0L));
        yzCouponDefinitionVo.setIsExpireNotice(Boolean.valueOf(false));
        yzCouponDefinitionVo.setExpireNoticeDays(Integer.valueOf(0));
        yzCouponDefinitionVo.setIsForbidPublicTake(Boolean.valueOf(false));
        yzCouponDefinitionVo.setIsPublicDisplay(Boolean.valueOf(false));
        yzCouponDefinitionVo.setIsSharable(Boolean.valueOf(false));
        yzCouponDefinitionVo.setAuthorityId(authorityId);
        yzCouponDefinitionVo.setOperatorId(String.valueOf(sysAccountPO.getSysAccountId()));
        yzCouponDefinitionVo.setOperatorType("1");
        yzCouponDefinitionVo.setRemark(po.getRemark());
        yzCouponDefinitionVo.setTitle(po.getCouponName());
        yzCouponDefinitionVo.setAppName("CRM");
        yzCouponDefinitionVo.setDescription(po.getInfo());
        yzCouponDefinitionVo.setIsWechatPaymchsync(Boolean.valueOf(false));
        yzCouponDefinitionVo.setSysBrandId(sysAccountPO.getBrandId());
        try {
            Long couponDefinitionId = po.getCouponDefinitionId();
            String data = JSONObject.toJSONString((Object)yzCouponDefinitionVo);
            logger.info("CouponDefinitionServiceImpl addYzCouponDefinition\uff0cparam:{}", (Object)data);
            ResponseData resultStr = this.youzanCouponServiceRpc.couponDefinitionAdd(yzCouponDefinitionVo);
            logger.info("CouponDefinitionServiceImpl addYzCouponDefinition\uff0cresult:{}", (Object)resultStr);
            Long activityId = (Long)resultStr.getData();
            if (activityId == null) {
                logger.info("addYzCouponDefinition \u6709\u8d5e\u65b0\u589e\u5931\u8d25");
                throw new Exception("\u6709\u8d5e\u65b0\u589e\u5238\u5b9a\u4e49\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            logger.info("\u8c03\u7528\u6709\u8d5e\u6dfb\u52a0\u5238\u5b9a\u4e49\u8fd4\u56dedata\u4e3a:{}", (Object)activityId);
            YzCouponDefinitionPO record = new YzCouponDefinitionPO();
            record.setActivityId(activityId);
            record.setCouponDefinitionId(po.getCouponDefinitionId());
            record.setCreateDate(new Date());
            record.setSysCompanyId(po.getSysCompanyId());
            record.setSysBrandId(po.getSysBrandId());
            this.yzCouponDefinitionPOMapper.insertSelective(record);
        }
        catch (Exception e) {
            int flag = this.couponDefinitionPOMapper.deleteByPrimaryKey(po.getCouponDefinitionId());
            logger.info("CouponDefinitionServiceImpl addYzCouponDefinition error deleteByPrimaryKey:{}", (Object)flag);
            logger.info("CouponDefinitionServiceImpl addYzCouponDefinition error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new Exception(e.getMessage());
        }
    }

    private SysYzBrandStoreMapping getYzStoreInfo(String code) throws Exception {
        ResponseData responseData = this.sysYzBrandStoreMappingServiceRpc.getYzStoreInfoByStoreCode(code);
        if (SysResponseEnum.SUCCESS.getCode() == responseData.getCode()) {
            return (SysYzBrandStoreMapping)responseData.getData();
        }
        throw new Exception("\u67e5\u8be2\u5e97\u94fa\u4fe1\u606f\u5f02\u5e38");
    }

    private ResponseData<String> checkLinkParams(CouponDefinitionBO bo) {
        ResponseData responseData = new ResponseData();
        if (null != bo && Boolean.TRUE.equals(bo.getLinkType())) {
            if (null == bo.getLinkUrlJson()) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u9009\u62e9\u94fe\u63a5\u4e3a\u7a7a");
                return responseData;
            }
            if (StringUtils.isBlank((CharSequence)bo.getButtonName())) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u94fe\u63a5\u540d\u79f0\u4e3a\u7a7a");
                return responseData;
            }
            if (StringUtils.isBlank((CharSequence)bo.getButtonNameCustom())) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u83dc\u5355\u540d\u79f0\u4e3a\u7a7a");
                return responseData;
            }
        }
        return new ResponseData();
    }
}

