/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.service.CouponAuthTmallService;
import com.bizvane.members.facade.service.taobao.MemberTaoBaoQueryApiService;
import com.bizvane.members.facade.vo.taobao.MemberTaoBaoQueryResponseVo;
import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.rpc.ActivityManualServiceRpc;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponAuthTmallServiceImpl
implements CouponAuthTmallService {
    private static final Logger log = LoggerFactory.getLogger(CouponAuthTmallServiceImpl.class);
    @Autowired
    private ActivityManualServiceRpc activityManualServiceRpc;
    @Autowired
    private MemberTaoBaoQueryApiService memberTaoBaoQueryApiService;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWxRpc;

    public ResponseData<String> getTaobaoName(ActivityManualVO vo) {
        log.info("enter CouponAuthTmallServiceImpl getTaobaoName method!");
        ResponseData stringResponseData = new ResponseData();
        ResponseData responseData = this.activityManualServiceRpc.validateActivity(vo);
        if (responseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return responseData;
        }
        String taobaoName = null;
        ResponseData memberTaoBaoQueryResponseVoResponseData = this.memberTaoBaoQueryApiService.taobaoQuery(vo.getSysCompanyId(), vo.getMemberInfoModel().getBrandId(), vo.getMemberInfoModel().getMemberCode());
        if (memberTaoBaoQueryResponseVoResponseData != null && memberTaoBaoQueryResponseVoResponseData.getData() != null) {
            taobaoName = ((MemberTaoBaoQueryResponseVo)memberTaoBaoQueryResponseVoResponseData.getData()).getTaobaoName();
        }
        stringResponseData.setData(taobaoName);
        return stringResponseData;
    }

    public ResponseData<String> getTmallNick(CouponRecordVO vo) {
        log.info("enter CouponAuthTmallServiceImpl getTmallNick method!");
        ResponseData stringResponseData = new ResponseData();
        ResponseData responseData = this.taskServiceForWxRpc.validateConvernCoupon(vo);
        if (responseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return responseData;
        }
        String taobaoName = null;
        ResponseData memberTaoBaoQueryResponseVoResponseData = this.memberTaoBaoQueryApiService.taobaoQuery(vo.getSysCompanyId(), vo.getBrandId(), vo.getMemberCode());
        if (memberTaoBaoQueryResponseVoResponseData != null && memberTaoBaoQueryResponseVoResponseData.getData() != null) {
            taobaoName = ((MemberTaoBaoQueryResponseVo)memberTaoBaoQueryResponseVoResponseData.getData()).getTaobaoName();
        }
        stringResponseData.setData(taobaoName);
        return stringResponseData;
    }
}

