/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.models.po.SysOnlineOrgPo;
import com.bizvane.centerstageservice.models.po.SysStoreGroupPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreGroupServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOnlineOrgServcieRpc;
import com.bizvane.couponfacade.models.bo.BigDataPartBo;
import com.bizvane.couponfacade.models.bo.CouponPartBo;
import com.bizvane.couponfacade.models.bo.GetCouponSurveyBo;
import com.bizvane.couponfacade.models.bo.VouTypeListBo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionPartVo;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponStoreGroupVo;
import com.bizvane.couponfacade.models.vo.CouponStoreVo;
import com.bizvane.couponservice.common.datavo.ReportTempPO;
import com.bizvane.couponservice.common.utils.BaseUrl;
import com.bizvane.couponservice.common.utils.DateConversionUtil;
import com.bizvane.couponservice.common.utils.SetBasicBigDataPartBoUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.CouponAnalysisService;
import com.bizvane.couponservice.service.CouponReportTempService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.otto.flummi.Flummi;
import de.otto.flummi.aggregations.AggregationBuilder;
import de.otto.flummi.aggregations.SumAggregationBuilder;
import de.otto.flummi.aggregations.TermsBuilder;
import de.otto.flummi.request.SearchRequestBuilder;
import de.otto.flummi.response.AggregationResult;
import de.otto.flummi.response.Bucket;
import de.otto.flummi.response.SumAggregationResult;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class CouponAnalysisServiceImpl
implements CouponAnalysisService {
    Logger logger = LoggerFactory.getLogger(CouponAnalysisServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private StoreGroupServiceRpc storeGroupServiceRpc;
    @Autowired
    private CouponReportTempService couponReportTempService;
    @Autowired
    SetBasicBigDataPartBoUtil setBasicBigDataPartBoUtil;
    @Autowired
    private BaseUrl BaseUrl;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private Flummi flummi;
    @Autowired
    private SysOnlineOrgServcieRpc sysOnlineOrgServcieRpc;
    public static final String YYYY_MM_DD_T_HH_MM_SS_SSS_0800 = "yyyy-MM-dd'T'HH:mm:ss.SSS+0800";
    private static DecimalFormat df = new DecimalFormat("0.00");

    public ResponseData getCouponSurvey(Long sysBrandId) {
        this.logger.info("======\u5165\u53c2:" + sysBrandId);
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        GetCouponSurveyBo couponSurveyBo = new GetCouponSurveyBo();
        String oneYearAgo = DateUtil.format((Date)DateUtil.offset((Date)DateUtil.date(), (DateField)DateField.YEAR, (int)-1), (String)YYYY_MM_DD_T_HH_MM_SS_SSS_0800);
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"valid", (Object)true));
        builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"sysBrandId", (Object)sysBrandId));
        builder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"createDate").includeLower(Boolean.TRUE.booleanValue()).includeUpper(Boolean.TRUE.booleanValue()).timeZone("Asia/Shanghai").gte((Object)oneYearAgo));
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson(builder.toString(), JsonObject.class);
        SearchRequestBuilder searchRequestBuilder = this.flummi.prepareSearch(new String[]{"t_coupon_entity"}).setTypes(new String[]{"doc"}).setQuery(json).addAggregation((AggregationBuilder)new TermsBuilder("couponStatus").field("couponStatus"));
        Map aggregations = searchRequestBuilder.execute().getAggregations();
        double couponUnusedSum = 0.0;
        double couponOverdueSum = 0.0;
        double couponUsedSum = 0.0;
        double couponAmountSum = 0.0;
        List buckets = ((AggregationResult)aggregations.get("couponStatus")).getBuckets();
        for (Bucket bucket : buckets) {
            Long count = bucket.getDocCount();
            if ("20".equals(bucket.getKey())) {
                couponUnusedSum = count.longValue();
                continue;
            }
            if ("25".equals(bucket.getKey())) {
                couponOverdueSum = count.longValue();
                continue;
            }
            if (!"30".equals(bucket.getKey())) continue;
            couponUsedSum = count.longValue();
        }
        double couponCountSum = couponUnusedSum + couponOverdueSum + couponUsedSum;
        double writeOffRate = 0.0;
        if (couponCountSum > 0.0) {
            writeOffRate = couponUsedSum / couponCountSum;
        }
        String writeOffRates = df.format(writeOffRate);
        couponSurveyBo.setWriteOffRate(writeOffRates);
        couponSurveyBo.setCouponCountSum(couponCountSum);
        couponSurveyBo.setCouponOverdueSum(couponOverdueSum);
        couponSurveyBo.setCouponUnusedSum(couponUnusedSum);
        couponSurveyBo.setCouponUsedSum(couponUsedSum);
        builder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"couponStatus", (Object)"30"));
        JsonObject jsonUsed = (JsonObject)gson.fromJson(builder.toString(), JsonObject.class);
        SearchRequestBuilder searchRequestBuilderUsed = this.flummi.prepareSearch(new String[]{"t_coupon_entity"}).setTypes(new String[]{"doc"}).setQuery(jsonUsed).addAggregation((AggregationBuilder)new SumAggregationBuilder("USED_COUPON", "useBusinessAmount"));
        SumAggregationResult aggregationResult = (SumAggregationResult)searchRequestBuilderUsed.execute().getAggregations().get("USED_COUPON");
        couponAmountSum = aggregationResult.getValue().doubleValue();
        couponSurveyBo.setCouponAmountSum("\uffe5" + df.format(couponAmountSum));
        responseData.setData((Object)couponSurveyBo);
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData getCouponUsed(CouponPartBo bo) {
        this.logger.info("=============\u8fdb\u5165\u975e\u5355\u5238\u6838\u9500\u91cf\u7684\u5165\u53e3==============");
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getParticleSize())) {
            responseData.setMessage("\u62a5\u8868\u7c92\u5ea6\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(bo.getNumber() + ""))) {
            responseData.setMessage("\u7c92\u5ea6\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        DateConversionUtil dateConversionUtil = new DateConversionUtil();
        BigDataPartBo bigDataPartBo = new BigDataPartBo();
        bigDataPartBo.setBusinessNum(this.BaseUrl.businessNum);
        bigDataPartBo.setApiKey(this.BaseUrl.apiKey);
        bigDataPartBo.setParticleSize(bo.getParticleSize());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bo.getVouTypeId())) {
            bigDataPartBo.setVouTypeId(bo.getVouTypeId());
        }
        bigDataPartBo = this.getBigDataPart(bo.getSysCompanyId(), bo.getSysBrandId(), bo.getNumber(), bo.getParticleSize(), dateConversionUtil, bigDataPartBo);
        if ("1".equals(bo.getParticleSize()) && bo.getNumber() == 0) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getStartDate()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getEndDate())) {
                responseData.setMessage("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
                return responseData;
            }
            bigDataPartBo.setStartDate(bo.getStartDate());
            bigDataPartBo.setEndDate(bo.getEndDate());
        }
        String analysisUrl = this.BaseUrl.url + "vouSalesVolume";
        ResponseEntity response = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setCode(500);
            responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
        String flag = jsonObject.getString("successFlag");
        if ("0".equals(flag)) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u6570\u636e:" + jsonObject.getString("message"));
            responseData.setData(new ArrayList());
            return responseData;
        }
        JSONObject dataJson = jsonObject.getJSONObject("data");
        JSONArray resultJson = dateConversionUtil.getDataHandle(dataJson, bo.getParticleSize());
        responseData.setData((Object)resultJson);
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData getCouponStore(CouponStoreVo vo, HttpServletRequest request) {
        String flag1;
        ResponseEntity response1;
        this.logger.info("=============\u8fdb\u5165\u5238\u6548\u679c\u5206\u6790\u5e97\u94fa\u7684\u5165\u53e3==============");
        SysAccountPO stageUser = TokenUtils.getStageUser((HttpServletRequest)request);
        ResponseData responseData = new ResponseData();
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(vo.getPageNumber());
        pageInfo.setPageSize(vo.getPageSize());
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vo.getParticleSize())) {
            responseData.setMessage("\u62a5\u8868\u7c92\u5ea6\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(vo.getNumber() + ""))) {
            responseData.setMessage("\u7c92\u5ea6\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        DateConversionUtil dateConversionUtil = new DateConversionUtil();
        BigDataPartBo bigDataPartBo = new BigDataPartBo();
        bigDataPartBo.setBusinessNum(this.BaseUrl.businessNum);
        bigDataPartBo.setApiKey(this.BaseUrl.apiKey);
        bigDataPartBo.setParticleSize(vo.getParticleSize());
        bigDataPartBo = this.getBigDataPart(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getNumber(), vo.getParticleSize(), dateConversionUtil, bigDataPartBo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getVouTypeId())) {
            bigDataPartBo.setVouTypeId(vo.getVouTypeId());
        }
        if ("1".equals(vo.getParticleSize()) && vo.getNumber() == 0) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vo.getStartDate()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vo.getEndDate())) {
                responseData.setMessage("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
                return responseData;
            }
            bigDataPartBo.setStartDate(vo.getStartDate());
            bigDataPartBo.setEndDate(vo.getEndDate());
        }
        SysStoreVo sysStoreVo = new SysStoreVo();
        sysStoreVo.setSysBrandId(vo.getSysBrandId());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getStoreCode())) {
            sysStoreVo.setSysStoreOfflineCode(vo.getStoreCode());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getStoreName())) {
            sysStoreVo.setStoreName(vo.getStoreName());
        }
        sysStoreVo.setOnlineOrgCode(stageUser.getOnlineOrgCode());
        JSONObject storeJson = new JSONObject();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getStoreCode()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getStoreName()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)stageUser.getOnlineOrgCode())) {
            List sysStorePoList = (List)this.storeServiceRpc.getCouponStoreList(sysStoreVo).getData();
            if (sysStorePoList.size() > 0) {
                String[] storeIds = new String[sysStorePoList.size()];
                for (int i = 0; i < sysStorePoList.size(); ++i) {
                    String storeId;
                    storeIds[i] = storeId = ((SysStorePo)sysStorePoList.get(i)).getStoreId();
                    storeJson.put(storeId, sysStorePoList.get(i));
                }
                bigDataPartBo.setStoreIds(storeIds);
            } else {
                pageInfo.setStartRow(1);
                pageInfo.setPageSize(10);
                pageInfo.setList(new ArrayList());
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
                responseData.setData((Object)pageInfo);
                return responseData;
            }
        }
        bigDataPartBo.setStartRecord("1");
        bigDataPartBo.setQueryNum(10000);
        String analysisUrl = this.BaseUrl.url + "storeVou";
        ResponseEntity response = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setCode(500);
            responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
        String flag = jsonObject.getString("successFlag");
        if ("0".equals(flag)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u5168\u90e8\u6570\u636e:" + jsonObject.getString("message"));
            pageInfo.setTotal(0L);
            pageInfo.setList(new ArrayList());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        JSONArray dataJsonSum = jsonObject.getJSONArray("data");
        this.logger.info("bigData\u603b\u6761\u6570:" + dataJsonSum.size());
        Long sysBrandId = vo.getSysBrandId();
        Long sysCompanyId = vo.getSysCompanyId();
        if (bigDataPartBo.getStoreIds() == null || bigDataPartBo.getStoreIds().length == 0) {
            List sysStorePoList;
            ArrayList<String> storeIds = new ArrayList<String>();
            for (int i = 0; i < dataJsonSum.size(); ++i) {
                String id = dataJsonSum.getJSONObject(i).get((Object)"id").toString();
                storeIds.add(id);
            }
            if (storeIds.size() > 0 && (sysStorePoList = (List)this.storeServiceRpc.getCouponStoreIdList1(storeIds, sysBrandId, sysCompanyId).getData()).size() > 0) {
                pageInfo.setTotal((long)sysStorePoList.size());
            }
        }
        if ("1".equals(vo.getIsExport())) {
            response1 = null;
            try {
                JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
                this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
                response1 = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
            }
            catch (Exception e) {
                this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
                responseData.setCode(500);
                responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
                responseData.setData((Object)bigDataPartBo);
                return responseData;
            }
            JSONObject jsonObject1 = JSONObject.parseObject((String)((String)response1.getBody()));
            flag1 = jsonObject.getString("successFlag");
            if ("0".equals(flag1)) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u90e8\u5206\u6570\u636e:" + jsonObject.getString("message"));
                pageInfo.setList(new ArrayList());
                responseData.setData((Object)pageInfo);
                return responseData;
            }
            JSONArray dataJson = jsonObject1.getJSONArray("data");
            if (dataJson.size() == 0) {
                responseData.setMessage("\u5bfc\u51fa\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getCode());
                return responseData;
            }
            if (bigDataPartBo.getStoreIds() == null || bigDataPartBo.getStoreIds().length == 0) {
                List sysStorePoList;
                ArrayList<String> storeIds = new ArrayList<String>();
                for (int i = 0; i < dataJson.size(); ++i) {
                    String id = dataJson.getJSONObject(i).get((Object)"id").toString();
                    storeIds.add(id);
                }
                if (storeIds.size() > 0 && (sysStorePoList = (List)this.storeServiceRpc.getCouponStoreIdList1(storeIds, sysBrandId, sysCompanyId).getData()).size() > 0) {
                    for (int i = 0; i < sysStorePoList.size(); ++i) {
                        String storeId = ((SysStorePo)sysStorePoList.get(i)).getStoreId();
                        storeJson.put(storeId, sysStorePoList.get(i));
                    }
                }
            }
            JSONArray couponStoreResultVoArray = dateConversionUtil.getCouponStore(dataJson, storeJson, "store");
            ReportTempPO reportTempPO = new ReportTempPO();
            reportTempPO.setTemplateName("\u5238\u6548\u679c\u5206\u6790\u5e97\u94fa\u7fa4\u7ec4\u5bfc\u51fa");
            reportTempPO.setReportDataName("\u95e8\u5e97\u7f16\u53f7,\u95e8\u5e97\u540d\u79f0,\u6838\u9500\u6570\u91cf,\u5ba2\u5355\u4ef7,\u8fde\u5e26\u7387,\u5238\u6536\u76ca,ROI");
            reportTempPO.setReportData("storeCode,storeName,salesVolume,unitPrice,jointRate,achievements,roi");
            this.couponReportTempService.export(stageUser, "", couponStoreResultVoArray.toString(), reportTempPO);
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        bigDataPartBo.setStartRecord(String.valueOf((vo.getPageNumber() - 1) * vo.getPageSize() + 1));
        bigDataPartBo.setQueryNum(vo.getPageSize());
        response1 = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response1 = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setCode(500);
            responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject1 = JSONObject.parseObject((String)((String)response1.getBody()));
        flag1 = jsonObject.getString("successFlag");
        if ("0".equals(flag1)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u90e8\u5206\u6570\u636e:" + jsonObject.getString("message"));
            pageInfo.setList(new ArrayList());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        JSONArray dataJson = jsonObject1.getJSONArray("data");
        if (bigDataPartBo.getStoreIds() == null || bigDataPartBo.getStoreIds().length == 0) {
            List sysStorePoList;
            ArrayList<String> storeIds = new ArrayList<String>();
            for (int i = 0; i < dataJson.size(); ++i) {
                String id = dataJson.getJSONObject(i).get((Object)"id").toString();
                storeIds.add(id);
            }
            if (storeIds.size() > 0 && (sysStorePoList = (List)this.storeServiceRpc.getCouponStoreIdList1(storeIds, sysBrandId, sysCompanyId).getData()).size() > 0) {
                for (int i = 0; i < sysStorePoList.size(); ++i) {
                    String storeId = ((SysStorePo)sysStorePoList.get(i)).getStoreId();
                    storeJson.put(storeId, sysStorePoList.get(i));
                }
            }
        }
        JSONArray couponStoreResultVoArray = dateConversionUtil.getCouponStore(dataJson, storeJson, "store");
        pageInfo.setList((List)couponStoreResultVoArray);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    private BigDataPartBo getBigDataPart(Long sysCompanyId, Long sysBrandId, int number, String particleSize, DateConversionUtil dateConversionUtil, BigDataPartBo bigDataPartBo) {
        SysCompanyPo sysCompanyPo = (SysCompanyPo)this.companyServiceRpc.getCompanyById(sysCompanyId).getData();
        bigDataPartBo.setCorpId(sysCompanyPo.getCompanyCode());
        SysBrandPo sysBrandPo = (SysBrandPo)this.brandServiceRpc.getBrandByID(sysBrandId).getData();
        bigDataPartBo.setBrandId(sysBrandPo.getBrandCode());
        if (number != 0) {
            String yesterday = dateConversionUtil.getYesterday();
            bigDataPartBo.setEndDate(yesterday + " 23:59:59");
            String startDate = dateConversionUtil.getStartAndEndDate(yesterday, number, particleSize);
            bigDataPartBo.setStartDate(startDate + " 00:00:00");
        }
        return bigDataPartBo;
    }

    public ResponseData getCouponStoreGroup(CouponStoreGroupVo vo, HttpServletRequest request) {
        JSONObject jsonObject1;
        JSONObject bigDataPartBoJson;
        ResponseEntity response1;
        this.logger.info("=============\u8fdb\u5165\u5238\u6548\u679c\u5206\u6790\u7fa4\u7ec4\u7684\u5165\u53e3==============");
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(vo.getPageNumber());
        pageInfo.setPageSize(vo.getPageSize());
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vo.getParticleSize())) {
            responseData.setMessage("\u62a5\u8868\u7c92\u5ea6\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(vo.getNumber() + ""))) {
            responseData.setMessage("\u7c92\u5ea6\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        DateConversionUtil dateConversionUtil = new DateConversionUtil();
        BigDataPartBo bigDataPartBo = new BigDataPartBo();
        bigDataPartBo.setBusinessNum(this.BaseUrl.businessNum);
        bigDataPartBo.setApiKey(this.BaseUrl.apiKey);
        bigDataPartBo = this.getBigDataPart(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getNumber(), vo.getParticleSize(), dateConversionUtil, bigDataPartBo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getVouTypeId())) {
            bigDataPartBo.setVouTypeId(vo.getVouTypeId());
        }
        if ("1".equals(vo.getParticleSize()) && vo.getNumber() == 0) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vo.getStartDate()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vo.getEndDate())) {
                responseData.setMessage("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
                return responseData;
            }
            bigDataPartBo.setStartDate(vo.getStartDate());
            bigDataPartBo.setEndDate(vo.getEndDate());
        }
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        SysAccountVo sysAccountVo = new SysAccountVo();
        sysAccountVo.setSysBrandId(String.valueOf(vo.getSysBrandId()));
        sysAccountVo.setSysAccountId(vo.getSysAccountId());
        sysAccountVo.setManageMemberType(sysAccountPO.getManageMemberType());
        sysAccountVo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getStoreGroupName())) {
            sysAccountVo.setStoreGroupName(vo.getStoreGroupName());
        }
        sysAccountVo.setOnlineOrgCode(sysAccountPO.getOnlineOrgCode());
        JSONObject sysAccountVoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)sysAccountVo));
        this.logger.info("\u8c03\u4e2d\u53f0\u63a5\u53e3\uff1agetCounponStoreGroupList \u5165\u53c2" + sysAccountVoJson.toString());
        JSONObject storeGroupJson = (JSONObject)this.storeGroupServiceRpc.getCounponStoreGroupList(sysAccountVo).getData();
        if (storeGroupJson == null || storeGroupJson.size() == 0) {
            pageInfo.setList(null);
            pageInfo.setPageSize(vo.getPageSize());
            pageInfo.setPageNum(vo.getPageNumber());
            responseData.setData((Object)pageInfo);
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        this.logger.info("\u8c03\u4e2d\u53f0\u63a5\u53e3\uff1agetCounponStoreGroupList \u51fa\u53c2" + storeGroupJson.toString());
        JSONObject storeGroupDataJson = new JSONObject();
        if (storeGroupJson != null) {
            LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)JSON.toJSONString((Object)storeGroupJson), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            HashMap<String, List> storeGroupList = new HashMap<String, List>();
            for (Map.Entry entry : jsonMap.entrySet()) {
                String[] key = ((String)entry.getKey()).split(",");
                List list = JSONArray.parseArray((String)((String)entry.getValue()), String.class);
                storeGroupList.put(key[0], list);
                SysStoreGroupPo sysStoreGroupPo = new SysStoreGroupPo();
                sysStoreGroupPo.setSysStoreGroupCode(key[1]);
                sysStoreGroupPo.setStoreGroupName(key[2]);
                storeGroupDataJson.put(key[0], (Object)sysStoreGroupPo);
            }
            bigDataPartBo.setStoreIdsInArea(storeGroupList);
        }
        bigDataPartBo.setStartRecord("1");
        bigDataPartBo.setQueryNum(10000);
        String analysisUrl = this.BaseUrl.url + "areaVou";
        ResponseEntity response = null;
        try {
            JSONObject bigDataPartBoJson2 = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson2.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setCode(500);
            responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
        String flag = jsonObject.getString("successFlag");
        if ("0".equals(flag)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u5168\u90e8\u6570\u636e:" + jsonObject.getString("message"));
            pageInfo.setTotal(0L);
            pageInfo.setList(new ArrayList());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        JSONArray dataJsonSum = jsonObject.getJSONArray("data");
        this.logger.info("bigData\u603b\u6761\u6570:" + dataJsonSum.size());
        pageInfo.setTotal((long)dataJsonSum.size());
        if ("1".equals(vo.getIsExport())) {
            response1 = null;
            try {
                bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
                this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
                response1 = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
            }
            catch (Exception e) {
                this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
                responseData.setCode(500);
                responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
                responseData.setData((Object)bigDataPartBo);
                return responseData;
            }
            jsonObject1 = JSONObject.parseObject((String)((String)response1.getBody()));
            String flag1 = jsonObject.getString("successFlag");
            if ("0".equals(flag1)) {
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u90e8\u5206\u6570\u636e:" + jsonObject.getString("message"));
                pageInfo.setList(new ArrayList());
                responseData.setData((Object)pageInfo);
                return responseData;
            }
            JSONArray dataJson = jsonObject1.getJSONArray("data");
            JSONArray couponStoreResultVoArray = dateConversionUtil.getCouponStore(dataJson, storeGroupDataJson, "storeGroup");
            ReportTempPO reportTempPO = new ReportTempPO();
            reportTempPO.setTemplateName("\u5238\u6548\u679c\u5206\u6790\u5e97\u94fa\u7fa4\u7ec4\u5bfc\u51fa");
            reportTempPO.setReportDataName("\u7fa4\u7ec4\u7f16\u53f7,\u7fa4\u7ec4\u540d\u79f0,\u6838\u9500\u6570\u91cf,\u5ba2\u5355\u4ef7,\u8fde\u5e26\u7387,\u5238\u6536\u76ca,ROI");
            reportTempPO.setReportData("storeGroupCode,storeGroupName,salesVolume,unitPrice,jointRate,achievements,roi");
            this.couponReportTempService.export(TokenUtils.getStageUser((HttpServletRequest)request), "", couponStoreResultVoArray.toString(), reportTempPO);
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        bigDataPartBo.setStartRecord(String.valueOf((vo.getPageNumber() - 1) * vo.getPageSize() + 1));
        bigDataPartBo.setQueryNum(vo.getPageSize());
        response1 = null;
        try {
            bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response1 = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setCode(500);
            responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        jsonObject1 = JSONObject.parseObject((String)((String)response1.getBody()));
        String flag1 = jsonObject.getString("successFlag");
        if ("0".equals(flag1)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u90e8\u5206\u6570\u636e:" + jsonObject.getString("message"));
            pageInfo.setList(new ArrayList());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        JSONArray dataJson = jsonObject1.getJSONArray("data");
        JSONArray couponStoreResultVoArray = dateConversionUtil.getCouponStore(dataJson, storeGroupDataJson, "storeGroup");
        pageInfo.setList((List)couponStoreResultVoArray);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData couponOrders(CouponPartBo bo) {
        this.logger.info("=============\u8fdb\u5165\u975e\u5355\u5238\u8ba2\u5355\u91cf\u6216\u8005\u6210\u4ea4\u989d\u7684\u5165\u53e3==============");
        ResponseData responseData = new ResponseData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getParticleSize())) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
            responseData.setData((Object)"\u62a5\u8868\u7c92\u5ea6\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (bo.getNumber() == 0 && (bo.getStartDate() == null || bo.getEndDate() == null)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage());
            responseData.setMessage("\u7c92\u5ea6\u6761\u4ef6\u4e3a\u96f6\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3anull");
            return responseData;
        }
        BigDataPartBo bigDataPartBo = new BigDataPartBo();
        bigDataPartBo.setApiKey(this.BaseUrl.getApiKey());
        bigDataPartBo.setBusinessNum(this.BaseUrl.getBusinessNum());
        SysCompanyPo sysCompanyPo = (SysCompanyPo)this.companyServiceRpc.getCompanyById(bo.getSysCompanyId()).getData();
        bigDataPartBo.setCorpId(sysCompanyPo.getCompanyCode());
        SysBrandPo sysBrandPo = (SysBrandPo)this.brandServiceRpc.getBrandByID(bo.getSysBrandId()).getData();
        bigDataPartBo.setBrandId(sysBrandPo.getBrandCode());
        bigDataPartBo = this.setBasicBigDataPartBoUtil.setBigDataPartBo(bigDataPartBo, bo);
        bigDataPartBo.setParticleSize(bo.getParticleSize());
        String analysisUrl = "";
        if ("\u8ba2\u5355\u91cf".equals(bo.getOrderNumOrTurnVolume())) {
            analysisUrl = this.BaseUrl.url + "couponOrders";
        } else if ("\u6210\u4ea4\u989d".equals(bo.getOrderNumOrTurnVolume())) {
            analysisUrl = this.BaseUrl.url + "couponVouIncome";
        } else if ("\u6838\u9500\u91cf".equals(bo.getOrderNumOrTurnVolume())) {
            analysisUrl = this.BaseUrl.url + "vouSalesVolume";
        }
        ResponseEntity response = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setCode(500);
            responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
        String successFlag = jsonObject.getString("successFlag");
        if ("0".equals(successFlag)) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u6570\u636e~");
            responseData.setData(new ArrayList());
            return responseData;
        }
        DateConversionUtil dateConversionUtil = new DateConversionUtil();
        JSONObject dataJson = jsonObject.getJSONObject("data");
        JSONArray resultJson = dateConversionUtil.getDataHandle(dataJson, bo.getParticleSize());
        responseData.setData((Object)resultJson);
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData couponDisplay(CouponDefinitionPartVo vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        if (StringUtils.isNotBlank((String)sysAccountPO.getOnlineOrgCode())) {
            vo.setOrganizationCode(sysAccountPO.getOnlineOrgCode());
        }
        this.logger.info("=============\u8fdb\u5165\u975e\u5355\u5238\u5238\u5c55\u793a\u7684\u5165\u53e3,\u8bf7\u6c42\u6570\u636e:{}==============", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(vo.getPageNumber());
        pageInfo.setPageSize(vo.getPageSize());
        BigDataPartBo bigDataPartBo = new BigDataPartBo();
        bigDataPartBo.setApiKey(this.BaseUrl.getApiKey());
        bigDataPartBo.setBusinessNum(this.BaseUrl.getBusinessNum());
        SysCompanyPo sysCompanyPo = (SysCompanyPo)this.companyServiceRpc.getCompanyById(vo.getSysCompanyId()).getData();
        bigDataPartBo.setCorpId(sysCompanyPo.getCompanyCode());
        SysBrandPo sysBrandPo = (SysBrandPo)this.brandServiceRpc.getBrandByID(vo.getSysBrandId()).getData();
        bigDataPartBo.setBrandId(sysBrandPo.getBrandCode());
        bigDataPartBo = this.setBasicBigDataPartBoUtil.setBigDataPartBo(bigDataPartBo, (CouponPartBo)vo);
        CouponDefinitionPO couponDefinitionPO = new CouponDefinitionPO();
        couponDefinitionPO.setSysBrandId(vo.getSysBrandId());
        Long couponDefinitionId = vo.getCouponDefinitionId();
        JSONObject couponDefinitionIdJson = new JSONObject();
        String couponName = vo.getCouponName();
        if (couponDefinitionId != null || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)couponName) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getOrganizationCode()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getStartCreateDate()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getEndCreateDate()) || org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getCreateName())) {
            CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
            couponDefinitionVO.setSysBrandId(vo.getSysBrandId());
            couponDefinitionVO.setSysCompanyId(vo.getSysCompanyId());
            if (couponDefinitionId != null) {
                couponDefinitionVO.setCouponDefinitionId(couponDefinitionId);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)couponName)) {
                couponDefinitionVO.setCouponName(couponName);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getStartCreateDate())) {
                couponDefinitionVO.setStartDate(vo.getStartCreateDate());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getEndCreateDate())) {
                couponDefinitionVO.setEndDate(vo.getEndCreateDate());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getCreateName())) {
                couponDefinitionVO.setCreateUserName(vo.getCreateName());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getOrganizationCode())) {
                couponDefinitionVO.setOrganizationCode(vo.getOrganizationCode());
            }
            List couponDefinitionPOList = this.couponDefinitionPOMapper.selectByDefinitionAndCouponName(couponDefinitionVO);
            String[] vouTypeIdList = new String[couponDefinitionPOList.size()];
            if (couponDefinitionPOList != null && couponDefinitionPOList.size() > 0) {
                for (int i = 0; i < couponDefinitionPOList.size(); ++i) {
                    String couponDefinitionId1;
                    vouTypeIdList[i] = couponDefinitionId1 = ((CouponDefinitionPO)couponDefinitionPOList.get(i)).getCouponDefinitionId() + "";
                    couponDefinitionIdJson.put(couponDefinitionId + "", (Object)(((CouponDefinitionPO)couponDefinitionPOList.get(i)).getCouponDefinitionId() + ""));
                }
                bigDataPartBo.setVouTypeIdList(vouTypeIdList);
            } else {
                pageInfo.setList(new ArrayList());
                responseData.setData((Object)pageInfo);
                responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
        }
        bigDataPartBo.setQueryNum(10000);
        bigDataPartBo.setStartRecord("1");
        String analysisUrl = this.BaseUrl.url + "vouTypeList";
        ResponseEntity response = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setCode(500);
            responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)((String)response.getBody()));
        String flag = jsonObject.getString("successFlag");
        if ("0".equals(flag)) {
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u5168\u90e8\u6570\u636e:" + jsonObject.getString("message"));
            pageInfo.setTotal(0L);
            pageInfo.setList(new ArrayList());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        JSONArray sumObject = jsonObject.getJSONArray("data");
        if ("1".equals(vo.getIsExport())) {
            List vouTypeListBoList = this.getVouTypeListBos(vo, sumObject);
            ReportTempPO reportTempPO = new ReportTempPO();
            reportTempPO.setTemplateName("\u5238\u6548\u679c\u5206\u6790\u5238\u5217\u8868\u5bfc\u51fa");
            reportTempPO.setReportDataName("\u5238\u5b9a\u4e49ID,\u5238\u540d\u79f0,\u521b\u5efa\u65f6\u95f4,\u9762\u989d\u6216\u8005\u6298\u6263,\u6709\u6548\u671f,\u53d1\u5238\u6570\u91cf,\u7d2f\u8ba1\u6838\u9500\u6570\u91cf,\u6838\u9500\u7387,\u5238\u6210\u4ea4\u91d1\u989d");
            reportTempPO.setReportData("vouTypeId,vouName,createDate,moneyOrDiscount,validDate,totalTickets,salesVolume,saleRate,achievements");
            this.couponReportTempService.export(sysAccountPO, "", JSON.toJSONString((Object)vouTypeListBoList), reportTempPO);
            responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        this.logger.info("\u6240\u6709\u6570\u636e\u7684\u603b\u6761\u6570:" + sumObject.size());
        pageInfo.setTotal((long)sumObject.size());
        bigDataPartBo.setStartRecord(String.valueOf((vo.getPageNumber() - 1) * vo.getPageSize() + 1));
        bigDataPartBo.setQueryNum(vo.getPageSize());
        ResponseEntity response1 = null;
        try {
            JSONObject bigDataPartBoJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bigDataPartBo));
            this.logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + bigDataPartBoJson.toString());
            response1 = this.restTemplate.postForEntity(analysisUrl, (Object)bigDataPartBo, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("\u5927\u6570\u636e\u8fde\u63a5\u5f02\u5e38" + e.getMessage() + analysisUrl + bigDataPartBo.toString());
            responseData.setCode(500);
            responseData.setMessage("\u6570\u636e\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u7b49");
            responseData.setData((Object)bigDataPartBo);
            return responseData;
        }
        this.logger.info("\u83b7\u53d6\u5230\u5927\u6570\u636e\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", response1.getBody());
        JSONObject jsonObject1 = JSONObject.parseObject((String)((String)response1.getBody()));
        String flag1 = jsonObject1.getString("successFlag");
        if ("0".equals(flag1)) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8c03\u7528\u5927\u6570\u636e\u63a5\u53e3\uff0c\u6ca1\u6709\u5f97\u5230\u5206\u9875\u6570\u636e:" + jsonObject.getString("message"));
            pageInfo.setList(new ArrayList());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        JSONArray jsonArray = jsonObject1.getJSONArray("data");
        List vouTypeListBoList = this.getVouTypeListBos(vo, jsonArray);
        pageInfo.setList(vouTypeListBoList);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    private List<VouTypeListBo> getVouTypeListBos(CouponDefinitionPartVo vo, JSONArray jsonArray) {
        ArrayList<VouTypeListBo> vouTypeListBoList = new ArrayList<VouTypeListBo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                VouTypeListBo vouTypeListBo = new VouTypeListBo();
                JSONObject mapObject = jsonArray.getJSONObject(i);
                Long vouTypeId = mapObject.getLong("id");
                Double salesVolume = mapObject.getDouble("salesVolume");
                Double achievements = mapObject.getDouble("achievements");
                Double totalTickets = mapObject.getDouble("totalTickets");
                vouTypeListBo.setVouTypeId(vouTypeId + "");
                vouTypeListBo.setSalesVolume(this.eraseZero(salesVolume));
                vouTypeListBo.setAchievements("\uffe5" + df.format(achievements));
                vouTypeListBo.setTotalTickets(this.eraseZero(totalTickets));
                Double saleRate = salesVolume == 0.0 || totalTickets == 0.0 ? Double.valueOf(0.0) : Double.valueOf(salesVolume / totalTickets * 100.0);
                vouTypeListBo.setSaleRate(this.eraseZero(saleRate) + "%");
                this.logger.info("\u5238\u5206\u6790\u5927\u6570\u636e\u8fd4\u56de\u7ed3\u679c\u904d\u5386id\uff1a{}", (Object)vouTypeId);
                List couponDefinitionPOList1 = this.couponDefinitionPOMapper.selectByDefinitionIdWithSys(vouTypeId, vo.getSysCompanyId(), vo.getSysBrandId());
                if (couponDefinitionPOList1.size() <= 0) continue;
                CouponDefinitionPO po = (CouponDefinitionPO)couponDefinitionPOList1.get(0);
                vouTypeListBo.setOrganizationCode(po.getOrganizationCode());
                vouTypeListBo.setVouName(po.getCouponName());
                vouTypeListBo.setCreateDate(sdf.format(po.getCreateDate()));
                if (po.getPreferentialType() == 1) {
                    vouTypeListBo.setMoneyOrDiscount("\uffe5" + po.getMoney() + "");
                } else if (po.getPreferentialType() == 2) {
                    vouTypeListBo.setMoneyOrDiscount("\u4eab\u53d7" + po.getDiscount() + "\u6298\u4f18\u60e0");
                }
                if (po.getValidType() == 1) {
                    String startDate = sdf.format(po.getValidDateStart());
                    String endDate = sdf.format(po.getValidDateEnd());
                    vouTypeListBo.setValidDate(startDate + "~" + endDate);
                } else if (po.getValidType() == 2) {
                    vouTypeListBo.setValidDate("\u9886\u53d6\u540e" + po.getValidDay() + "\u5929");
                }
                vouTypeListBo.setCreateName(po.getCreateUserName());
                vouTypeListBoList.add(vouTypeListBo);
            }
            if (CollectionUtils.isNotEmpty(vouTypeListBoList)) {
                ResponseData listResponseData;
                String collectStr = vouTypeListBoList.stream().filter(t -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)t.getOrganizationCode())).map(VouTypeListBo::getOrganizationCode).distinct().collect(Collectors.joining(","));
                Map<String, SysOnlineOrgPo> map = null;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)collectStr) && (listResponseData = this.sysOnlineOrgServcieRpc.queryOnlineOrgList(vo.getSysCompanyId(), collectStr)) != null && com.bizvane.couponservice.common.constants.SysResponseEnum.SUCCESS.getCode() == listResponseData.getCode()) {
                    List data = (List)listResponseData.getData();
                    map = data.stream().collect(Collectors.toMap(SysOnlineOrgPo::getOnlineOrgCode, t -> t, (a, b) -> b));
                }
                for (VouTypeListBo BO : vouTypeListBoList) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)BO.getOrganizationCode()) || !map.containsKey(BO.getOrganizationCode())) continue;
                    SysOnlineOrgPo sysOnlineOrgPo = (SysOnlineOrgPo)map.get(BO.getOrganizationCode());
                    String onlineOrgName = sysOnlineOrgPo.getOnlineOrgName();
                    BO.setOrganizationName(onlineOrgName);
                }
            }
        }
        return vouTypeListBoList;
    }

    public String eraseZero(Double number) {
        DecimalFormat df = new DecimalFormat("0.00");
        String numberString = df.format(number);
        if (numberString.indexOf(".") > 0) {
            numberString = numberString.replaceAll("0+?$", "");
            numberString = numberString.replaceAll("[.]$", "");
        }
        return numberString;
    }
}

