/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.models.po.CouponBatchSendDetailPO;
import com.bizvane.couponfacade.models.po.CouponBatchSendDetailPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.po.CouponManualPOExample;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.datavo.BitDataRequestVO;
import com.bizvane.couponservice.common.datavo.BitDataVO;
import com.bizvane.couponservice.common.datavo.BitDataXiaLaiVO;
import com.bizvane.couponservice.common.utils.DigitalJudgmentUtil;
import com.bizvane.couponservice.mappers.CouponBatchSendDetailPOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.service.BitDataAnalysisService;
import com.bizvane.couponservice.service.CouponDifindustryQuantityRecordService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BitDataQuotaAnalysisServiceServiceImpl
implements BitDataAnalysisService {
    @Autowired
    private CouponManualPOMapper couponManualPoMapper;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPoMapper;
    @Autowired
    private CouponBatchSendDetailPOMapper couponBatchSendDetailPoMapper;
    @Autowired
    private CouponDifindustryQuantityRecordService couponDifindustryQuantityRecordService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    public ResponseData<BitDataRequestVO> getCouponQuotaAnalysisDetail(BitDataVO vo, SysAccountPo accountPo) {
        CouponManualPOExample example;
        ResponseData bitDataRequestVoResponse = new ResponseData();
        BitDataRequestVO bitDataRequestVO = new BitDataRequestVO();
        CouponManualPO couponManualPo = this.couponManualPoMapper.selectByPrimaryKey(vo.getCouponManualId());
        bitDataRequestVO.setTaskName(couponManualPo.getTaskName());
        bitDataRequestVO.setCreateDate(couponManualPo.getCreateDate());
        if (couponManualPo.getStoreids() != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)couponManualPo.getStoreids());
            bitDataRequestVO.setStoresSum(String.valueOf(jsonObject.size()));
        } else {
            bitDataRequestVO.setStoresSum("0");
        }
        ArrayList<Object> couponDefinitionPoList = new ArrayList<Object>();
        ArrayList<Long> idList = new ArrayList<Long>();
        ArrayList<Long> couponIdList = new ArrayList<Long>();
        for (String couponDefinitionId : couponManualPo.getCouponDefinitionId().split(",")) {
            boolean numeric = DigitalJudgmentUtil.isNumeric((String)couponDefinitionId);
            if (numeric) {
                couponIdList.add(Long.parseLong(couponDefinitionId));
                continue;
            }
            String[] split = couponDefinitionId.split("_");
            String id = split[1];
            idList.add(Long.valueOf(id));
        }
        if (!idList.isEmpty()) {
            example = new CouponManualPOExample();
            CouponManualPOExample.Criteria criteria = example.createCriteria();
            criteria.andValidEqualTo(Boolean.valueOf(true));
            criteria.andCouponManualIdIn(idList);
            List manualPOS = this.couponManualPoMapper.selectByExample(example);
            if (manualPOS != null) {
                List brandList = manualPOS.stream().map(CouponManualPO::getSysBrandId).collect(Collectors.toList());
                SysBrandVo sysBrandVo = new SysBrandVo();
                sysBrandVo.setSysBrandIdList(brandList);
                sysBrandVo.setSysCompanyId(couponManualPo.getSysCompanyId());
                ResponseData barndListByBrandIds = this.brandServiceRpc.getBarndListByBrandIds(sysBrandVo);
                List data = (List)barndListByBrandIds.getData();
                Map collectMap = data.stream().collect(Collectors.toMap(SysBrandPo::getSysBrandId, Function.identity(), (a, b) -> a));
                for (CouponManualPO t2 : manualPOS) {
                    CouponDefinitionPOWithBLOBs couponDefinitionPO = this.couponDefinitionPoMapper.selectByPrimaryKey(Long.valueOf(t2.getCouponDefinitionId()));
                    CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
                    BeanUtils.copyProperties((Object)couponDefinitionPO, (Object)couponDefinitionVO);
                    couponDefinitionVO.setBatchNum(t2.getBatchNum());
                    couponDefinitionVO.setIsDifindustryCoupon(Byte.valueOf((byte)1));
                    couponDefinitionPoList.add(couponDefinitionVO);
                    if (!collectMap.containsKey(t2.getSysBrandId())) continue;
                    SysBrandPo sysBrandPo = (SysBrandPo)collectMap.get(t2.getSysBrandId());
                    couponDefinitionVO.setSourceBrandName(sysBrandPo.getBrandName());
                }
            }
        }
        if (!couponIdList.isEmpty()) {
            CouponDefinitionPOExample poExample = new CouponDefinitionPOExample();
            CouponDefinitionPOExample.Criteria criteria = poExample.createCriteria();
            criteria.andCouponDefinitionIdIn(couponIdList);
            List couponDefinitionPos = this.couponDefinitionPoMapper.selectByExample(poExample);
            List collect = couponDefinitionPos.stream().map(t -> {
                CouponDefinitionVO couponDefinitionVO = new CouponDefinitionVO();
                BeanUtils.copyProperties((Object)t, (Object)couponDefinitionVO);
                return couponDefinitionVO;
            }).collect(Collectors.toList());
            couponDefinitionPoList.addAll(collect);
        }
        example = new CouponBatchSendDetailPOExample();
        example.createCriteria().andCouponManualIdEqualTo(couponManualPo.getCouponManualId().toString());
        List selectByExamplelist = this.couponBatchSendDetailPoMapper.selectByExample((CouponBatchSendDetailPOExample)example);
        if (selectByExamplelist != null && !selectByExamplelist.isEmpty()) {
            List collect = selectByExamplelist.stream().map(t -> Long.valueOf(t.getCouponDefinitionId())).collect(Collectors.toList());
            CouponDefinitionPOExample poExample = new CouponDefinitionPOExample();
            CouponDefinitionPOExample.Criteria criteria = poExample.createCriteria();
            criteria.andCouponDefinitionIdIn(collect);
            List couponDefinitionPOS = this.couponDefinitionPoMapper.selectByExample(poExample);
            Map poMap = null;
            if (couponDefinitionPOS != null && !couponDefinitionPOS.isEmpty()) {
                poMap = couponDefinitionPOS.stream().collect(Collectors.toMap(CouponDefinitionPO::getCouponDefinitionId, Function.identity(), (a, b) -> a));
            }
            ArrayList<BitDataXiaLaiVO> bitDataXiaLaiVoList = new ArrayList<BitDataXiaLaiVO>();
            for (CouponBatchSendDetailPO couponDefinitionName : selectByExamplelist) {
                BitDataXiaLaiVO bitDataXiaLaiVO = new BitDataXiaLaiVO();
                bitDataXiaLaiVO.setCode(couponDefinitionName.getBatchSendCodeDetail());
                bitDataXiaLaiVO.setName(couponDefinitionName.getCouponName());
                CouponDefinitionPO couponDefinitionPo = (CouponDefinitionPO)poMap.get(Long.valueOf(couponDefinitionName.getCouponDefinitionId()));
                Calendar calendar = Calendar.getInstance();
                if (couponDefinitionPo.getValidType().equals(SystemConstants.VALID_TYPE__SOMEDAY)) {
                    calendar.add(5, couponDefinitionPo.getValidDay());
                    calendar.set(11, 23);
                    calendar.set(13, 59);
                    calendar.set(12, 59);
                    calendar.set(14, 59);
                    bitDataXiaLaiVO.setValidDateStart(couponDefinitionName.getCreateDate());
                    bitDataXiaLaiVO.setValidDateEnd(calendar.getTime());
                } else if (SystemConstants.VALID_TYPE_DELAY.equals(couponDefinitionPo.getValidType())) {
                    ZoneId zoneId = ZoneId.systemDefault();
                    LocalDate localDate = LocalDate.now().plusDays(couponDefinitionPo.getDelayDay().intValue());
                    LocalDateTime validDateStart = localDate.atTime(0, 0, 0);
                    ZonedDateTime startTime = validDateStart.atZone(zoneId);
                    LocalDate endDate = localDate.plusDays((long)couponDefinitionPo.getDelayValidDay().intValue() - 1L);
                    LocalDateTime validEndDate = endDate.atTime(23, 59, 59);
                    ZonedDateTime endTime = validEndDate.atZone(zoneId);
                    bitDataXiaLaiVO.setValidDateStart(Date.from(startTime.toInstant()));
                    bitDataXiaLaiVO.setValidDateEnd(Date.from(endTime.toInstant()));
                } else {
                    bitDataXiaLaiVO.setValidDateStart(couponDefinitionPo.getValidDateStart());
                    bitDataXiaLaiVO.setValidDateEnd(couponDefinitionPo.getValidDateEnd());
                }
                bitDataXiaLaiVoList.add(bitDataXiaLaiVO);
                for (CouponDefinitionPO couponDefinitionPO : couponDefinitionPoList) {
                    if (!couponDefinitionPO.getCouponDefinitionId().equals(couponDefinitionPo.getCouponDefinitionId())) continue;
                    couponDefinitionPO.setValidDateStart(bitDataXiaLaiVO.getValidDateStart());
                    couponDefinitionPO.setValidDateEnd(bitDataXiaLaiVO.getValidDateEnd());
                }
            }
            bitDataRequestVO.setBitDataXiaLaiVOList(bitDataXiaLaiVoList);
        }
        bitDataRequestVO.setCouponDefinitionPOList(couponDefinitionPoList);
        bitDataRequestVoResponse.setData((Object)bitDataRequestVO);
        return bitDataRequestVoResponse;
    }
}

