/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq.rocketutils;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.bizvane.couponservice.offlinemq.offlinerocketutils.OfflineTagEnum;
import com.bizvane.couponservice.offlinemq.offlinerocketutils.OfflineTopicEnum;
import com.bizvane.couponservice.rocketmq.rocketutils.TopicEnum;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RocketMQProducerService {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducerService.class);
    @Autowired
    private RocketMQTemplate rocketMqTemplate;
    private SendResult sendResult = new SendResult();

    public SendResult sendMessage(String tag, Object messageBody, long sysCompanyId, int messageSum) {
        String topic = TopicEnum.getTopic((int)messageSum);
        log.info("1111444444444444444444444444444444444444444444444444444" + topic);
        return this.syncSendMessage(tag, messageBody, sysCompanyId, messageSum);
    }

    public SendResult syncSendMessage(String tag, Object messageBody, long sysCompanyId, int messageSum) {
        String topic = TopicEnum.getTopic((int)messageSum);
        log.info("1666666666666666666666666666666666666666666666666:{}", (Object)topic);
        return this.rocketMqTemplate.send(new Destination(topic, tag, null), messageBody, (MessageQueueSelector)new /* Unavailable Anonymous Inner Class!! */, String.valueOf(sysCompanyId));
    }

    public SendResult sendOfflineMessage(String topic, String tag, Object messageBody, long sysCompanyId) {
        String offlineTopic = OfflineTopicEnum.getTopic((String)topic);
        String offlineTag = OfflineTagEnum.getOfflineTag((String)tag);
        log.info("===========\u7ebf\u4e0atopic:{}\uff0c\u5bf9\u5e94\u7ebf\u4e0btopic:{}", (Object)topic, (Object)offlineTopic);
        log.info("===========\u7ebf\u4e0atag:{}\uff0c\u5bf9\u5e94\u7ebf\u4e0btag:{}", (Object)tag, (Object)offlineTag);
        return this.rocketMqTemplate.send(new Destination(offlineTopic, offlineTag, null), messageBody, (MessageQueueSelector)new /* Unavailable Anonymous Inner Class!! */, String.valueOf(sysCompanyId));
    }

    public SendResult sendWechatMessage(String topic, String tag, Object messageBody, long sysCompanyId) {
        String messageTopic = topic + "_message";
        return this.rocketMqTemplate.send(new Destination(messageTopic, tag, null), messageBody, (MessageQueueSelector)new /* Unavailable Anonymous Inner Class!! */, String.valueOf(sysCompanyId));
    }

    public SendResult sendMktCenterMessage(String topic, String tag, Object messageBody) {
        return this.rocketMqTemplate.send(Destination.builder().topic(topic).tag(tag).build(), messageBody);
    }
}

