/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq.messagelisterner;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.members.facade.service.card.response.PushMbrModel;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;

@Profile(value={"TOPIC_1"})
@RocketMQMessageListener(topic="public_pro_member_bind_message", tags={"*"})
public class TopicBindSendCouponConsumer
implements RocketMQListener<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(TopicBindSendCouponConsumer.class);
    @Autowired
    private CouponService couponService;

    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("TopicBindSendCouponConsumer---onMessage(), topic:{},tags:{},message:{}", new Object[]{consumerMessage.getTopic(), consumerMessage.getTags(), consumerMessage.getMessage()});
        JSONObject message = (JSONObject)consumerMessage.getMessage();
        PushMbrModel pushMbrModel = (PushMbrModel)JacksonUtil.json2Obj((String)message.toJSONString(), PushMbrModel.class);
        log.info("TopicBindSendCouponConsumer---json\u8f6c\u6362pushMbrModel:{}", (Object)JSONObject.toJSONString((Object)pushMbrModel));
        CouponListByMemberCodeRequestVO vo = new CouponListByMemberCodeRequestVO();
        vo.setSysCompanyId(pushMbrModel.getSysCompanyId());
        vo.setSysBrandId(pushMbrModel.getBrandId());
        vo.setMemberCode(pushMbrModel.getMemberCode());
        ResponseData responseData = this.couponService.registerSendDifindustryCoupon(vo);
        log.info("TopicBindSendCouponConsumer---\u6d88\u8d39\u7ed3\u679c:{}", (Object)responseData);
    }
}

