/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq.messagelisterner;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.exception.ExceptionUtils;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.mq.OnlineCouponUseEvent;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.service.CouponEntityService;
import java.util.Date;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;

@Profile(value={"TOPIC_1", "TOPIC_2", "TOPIC_3", "TOPIC_4"})
@RocketMQMessageListener(topic="online_coupon_use")
public class OnlineCouponUseConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(OnlineCouponUseConsumer.class);
    @Value(value="${361wm.wmCompanyId}")
    private Long wmCompanyId;
    private final CouponEntityService couponEntityService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;

    public void onMessage(ConsumerMessage<String> consumerMessage) {
        log.info("OnlineCouponUseConsumer on message : {}", consumerMessage.getMessage());
        OnlineCouponUseEvent.OnlineCouponUseVO msgVO = (OnlineCouponUseEvent.OnlineCouponUseVO)JSON.parseObject((String)((String)consumerMessage.getMessage()), OnlineCouponUseEvent.OnlineCouponUseVO.class);
        CouponEntityPO couponEntity = this.findCoupon(msgVO);
        if (this.impossibleUseCoupon(couponEntity)) {
            return;
        }
        CouponDefinitionPO couponDefinition = this.findCouponDefinition(couponEntity);
        this.useCoupon(couponEntity, msgVO, couponDefinition);
    }

    private void useCoupon(CouponEntityPO couponEntity, OnlineCouponUseEvent.OnlineCouponUseVO msgVO, CouponDefinitionPO couponDefinitionPO) {
        Date now = new Date();
        couponEntity.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        couponEntity.setIsUse(SystemConstants.COUPON_USE_USED);
        couponEntity.setUseStoreId(msgVO.getOfflineUseStoreId());
        couponEntity.setUseBusinessCode(msgVO.getUseBusinessCode());
        couponEntity.setUseBusinessAmount(msgVO.getUseBusinessAmount());
        couponEntity.setUseTime(msgVO.getUseTime() == null ? now : msgVO.getUseTime());
        couponEntity.setModifiedDate(now);
        if (this.couponEntityService.updateCouponEntitySelective(couponEntity)) {
            log.info("\u6838\u9500\u6210\u529f");
            try {
                if (this.wmCompanyId.equals(msgVO.getSysCompanyId()) && couponDefinitionPO != null && SystemConstants.USE_CHANNEL_ANY.equals(couponDefinitionPO.getUseChannel())) {
                    log.info("OnlineCouponUseConsumer useCoupon mq send param:{}", (Object)JSONObject.toJSONString((Object)couponEntity));
                    SendResult send = this.rocketMQTemplate.send(Destination.builder().topic("wm_topic_use_channel_coupon").build(), (Object)JSONObject.toJSONString((Object)couponEntity));
                    log.info("OnlineCouponUseConsumer useCoupon mq sendResult param:{}", (Object)send.toString());
                }
            }
            catch (Exception e) {
                log.error("OnlineCouponUseConsumer useCoupon send mq\uff0cerror:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private CouponEntityPO findCoupon(OnlineCouponUseEvent.OnlineCouponUseVO msgVO) {
        return this.couponEntityService.findCouponEntityByCouponCode(msgVO.getCouponCode(), msgVO.getSysCompanyId());
    }

    private boolean impossibleUseCoupon(CouponEntityPO couponEntity) {
        if (couponEntity == null) {
            log.warn("\u6838\u9500\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
            return true;
        }
        if (couponEntity.getIsUse().booleanValue()) {
            log.warn("\u6838\u9500\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u5df2\u7ecf\u6838\u9500");
            return true;
        }
        return false;
    }

    private CouponDefinitionPO findCouponDefinition(CouponEntityPO couponEntityPO) {
        return this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(couponEntityPO.getCouponDefinitionId())));
    }

    public OnlineCouponUseConsumer(CouponEntityService couponEntityService) {
        this.couponEntityService = couponEntityService;
    }
}

