/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq.impl;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.rocketmq.messagelisterner.MqConsumerService;
import com.bizvane.couponservice.rocketmq.rocketutils.RocketMQProducerService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisClient;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tagSendCouponService")
public class TagSendCouponServiceImpl
implements MqConsumerService {
    private static final Logger log = LoggerFactory.getLogger(TagSendCouponServiceImpl.class);
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPoMapper;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private RocketMQProducerService rocketMqProducerService;

    public void actionConsumer(ConsumerMessage<JSONObject> message) {
        log.info("TagSendCouponServiceImpl\u89e3\u6790\u6210\u529f\uff1a" + message.getMessage());
        JSONObject body = (JSONObject)message.getMessage();
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        CouponDefinitionPOWithBLOBs couponDefinitionPoWithBlobs = this.couponDefinitionPoMapper.selectByPrimaryKey(definitionPo.getCouponDefinitionId());
        definitionPo.setOfflinePrdCode(couponDefinitionPoWithBlobs.getOfflinePrdCode());
        SendCouponBatchRequestVO requestVo = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)body.getString("requestVO"), SendCouponBatchRequestVO.class);
        CouponBatchSendRecordPO batchPo = (CouponBatchSendRecordPO)JacksonUtil.json2Objs((String)body.getString("batchPO"), CouponBatchSendRecordPO.class);
        if ("154485".equals(batchPo.getBizCode())) {
            log.info("\u6392\u9664154485");
            return;
        }
        List entityPoList = this.sendCouponMqService.allChannelOnLine(definitionPo, requestVo, batchPo, SystemConstants.COUPON_STATUS_SYNCHROING);
        if (CollectionUtils.isEmpty((Collection)entityPoList)) {
            return;
        }
        log.info("\u7ebf\u4e0a\u903b\u8f91\u5904\u7406\u5b8c\u6210, \u6254\u5230\u7b2c\u4e8c\u5c42topic" + message.getTopic());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
        jsonObject.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVo));
        jsonObject.put("batchPO", (Object)JSONObject.toJSONString((Object)batchPo));
        jsonObject.put("entityPOList", (Object)JSONObject.toJSONString((Object)entityPoList));
        this.rocketMqProducerService.sendOfflineMessage(message.getTopic(), message.getTags(), (Object)jsonObject, definitionPo.getSysCompanyId().longValue());
    }
}

