/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq.impl;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.rocketmq.messagelisterner.MqConsumerService;
import com.bizvane.couponservice.rocketmq.rocketutils.RocketMQProducerService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tagPreEmpSendCouponService")
public class TagPreEmpSendCouponServiceImpl
implements MqConsumerService {
    private static final Logger log = LoggerFactory.getLogger(TagPreEmpSendCouponServiceImpl.class);
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPoMapper;
    @Autowired
    private RocketMQProducerService rocketMqProducerService;

    public void actionConsumer(ConsumerMessage<JSONObject> message) {
        log.info("TagPreEmpSendCouponServiceImpl\u89e3\u6790\u6210\u529f\uff1a" + message.getMessage());
        JSONObject body = (JSONObject)message.getMessage();
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        CouponDefinitionPOWithBLOBs couponDefinitionPoWithBlobs = this.couponDefinitionPoMapper.selectByPrimaryKey(definitionPo.getCouponDefinitionId());
        definitionPo.setOfflinePrdCode(couponDefinitionPoWithBlobs.getOfflinePrdCode());
        CouponBatchSendRecordPO batchPo = (CouponBatchSendRecordPO)JacksonUtil.json2Objs((String)body.getString("batchPO"), CouponBatchSendRecordPO.class);
        SendCouponBatchRequestVO requestVo = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)body.getString("requestVO"), SendCouponBatchRequestVO.class);
        try {
            CouponEntityPO couponEntityPo = this.sendCouponMqService.savePreCouponEmpEntitySingle(definitionPo, requestVo, batchPo.getCouponBatchSendRecordId(), SystemConstants.COUPON_STATUS_SYNCHROING);
            log.info("\u7ebf\u4e0a\u903b\u8f91\u5904\u7406\u5b8c\u6210, \u6254\u5230\u7b2c\u4e8c\u5c42topic" + message.getTopic());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
            jsonObject.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVo));
            jsonObject.put("batchPO", (Object)JSONObject.toJSONString((Object)batchPo));
            jsonObject.put("couponEntityPO", (Object)JSONObject.toJSONString((Object)couponEntityPo));
            this.rocketMqProducerService.sendOfflineMessage(message.getTopic(), message.getTags(), (Object)jsonObject, definitionPo.getSysCompanyId().longValue());
            if (SendTypeEnum.SEND_ALIPAY_VOUCHER.getCode().equals(batchPo.getBizType())) {
                String topic = "ACTIVITY_SEND_COUPON_ONLINE_SUCCESS_MQ";
                String tag = "ALIPAY_VOUCHER";
                this.rocketMqProducerService.sendMktCenterMessage(topic, tag, (Object)jsonObject);
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u5238\u5f02\u5e38\u5f02\u5e38!" + e.getMessage(), (Throwable)e);
            this.sendCouponMqService.updateSendCouponBatchException(batchPo, Integer.valueOf(1), (CouponDefinitionPO)definitionPo);
            throw new BizException("\u6d88\u8d39\u5f02\u5e38\uff1a" + message.getMsgId());
        }
    }
}

