/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq.impl;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.rocketmq.messagelisterner.MqConsumerService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tagPreEmpOnlineSendCouponService")
public class TagPreEmpOnlineSendCouponServiceImpl
implements MqConsumerService {
    private static final Logger log = LoggerFactory.getLogger(TagPreEmpOnlineSendCouponServiceImpl.class);
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private CouponManualService couponManualService;

    public void actionConsumer(ConsumerMessage<JSONObject> message) {
        JSONObject body = (JSONObject)message.getMessage();
        log.info("TagPreEmpOnlineSendCouponServiceImpl\u89e3\u6790\u6210\u529f\uff1a" + body);
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        SendCouponBatchRequestVO requestVo = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)body.getString("requestVO"), SendCouponBatchRequestVO.class);
        CouponBatchSendRecordPO batchPo = (CouponBatchSendRecordPO)JacksonUtil.json2Objs((String)body.getString("batchPO"), CouponBatchSendRecordPO.class);
        try {
            this.sendCouponMqService.savePreCouponEmpEntitySingle(definitionPo, requestVo, batchPo.getCouponBatchSendRecordId(), SystemConstants.COUPON_STATUS_UNUSED);
            this.couponManualService.findAndUpdateTaskStatus(requestVo.getTotalNumber().intValue(), 1, requestVo.getCouponManualId());
        }
        catch (Exception e) {
            log.error("\u53d1\u5238\u5f02\u5e38\u5f02\u5e38!" + e.getMessage(), (Throwable)e);
            this.sendCouponMqService.updateSendCouponBatchException(batchPo, Integer.valueOf(1), (CouponDefinitionPO)definitionPo);
            throw new BizException("\u6d88\u8d39\u5f02\u5e38\uff1a" + message.getMsgId());
        }
    }
}

