/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq.impl;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.rocketmq.messagelisterner.MqConsumerService;
import com.bizvane.couponservice.rocketmq.rocketutils.RocketMQProducerService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisClient;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tagOnlineSendCouponService")
public class TagOnlineSendCouponServiceImpl
implements MqConsumerService {
    private static final Logger log = LoggerFactory.getLogger(TagOnlineSendCouponServiceImpl.class);
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private RocketMQProducerService rocketMqProducerService;
    @Autowired
    private RedisClient redisClient;

    public void actionConsumer(ConsumerMessage<JSONObject> message) {
        JSONObject body = (JSONObject)message.getMessage();
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        SendCouponBatchRequestVO requestVO = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)body.getString("requestVO"), SendCouponBatchRequestVO.class);
        CouponBatchSendRecordPO batchPo = (CouponBatchSendRecordPO)JacksonUtil.json2Objs((String)body.getString("batchPO"), CouponBatchSendRecordPO.class);
        List entityPoList = this.sendCouponMqService.onLine(definitionPo, requestVO, batchPo, SystemConstants.COUPON_STATUS_UNUSED);
        try {
            if (!CollectionUtils.isEmpty((Collection)entityPoList)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
                jsonObject.put("entityPOList", (Object)JSONObject.toJSONString((Object)entityPoList));
                jsonObject.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVO));
                if (requestVO != null && SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(requestVO.getBusinessType())) {
                    if (1 == requestVO.getIsSendLastCoupon()) {
                        this.rocketMqProducerService.sendWechatMessage(message.getTopic(), message.getTags(), (Object)jsonObject, definitionPo.getSysCompanyId().longValue());
                        log.info("TagOnlineSendCouponService\u7ebf\u4e0a\u5238\u53d1\u9001\u6d88\u606f");
                    }
                } else {
                    this.rocketMqProducerService.sendWechatMessage(message.getTopic(), message.getTags(), (Object)jsonObject, definitionPo.getSysCompanyId().longValue());
                    log.info("TagOnlineSendCouponService\u7ebf\u4e0a\u5238\u53d1\u9001\u6d88\u606f");
                }
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u53d1\u5238\u6d88\u606f\u63a5\u53e3\u5f02\u5e38!" + e.getMessage(), (Throwable)e);
        }
    }
}

