/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq.impl;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.bo.SendCouponDifindustryBo;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.rocketmq.messagelisterner.MqConsumerService;
import com.bizvane.couponservice.rocketmq.rocketutils.RocketMQProducerService;
import com.bizvane.couponservice.service.CouponDifindustryService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tagDifindustryCouponService")
public class TagDifindustryCouponServiceImpl
implements MqConsumerService {
    private static final Logger log = LoggerFactory.getLogger(TagDifindustryCouponServiceImpl.class);
    @Autowired
    private CouponDifindustryService couponDifindustryService;
    @Autowired
    private RocketMQProducerService rocketMQProducerService;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private CouponManualPOMapper couponManualPOMapper;
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private SendCouponService sendCouponService;

    public void actionConsumer(ConsumerMessage<JSONObject> message) {
        log.info("\u8fdb\u5165\u5f02\u4e1a\u5377\u6d88\u8d39\u6d88\u606ftopic:{},tags:{},msg:{}", new Object[]{message.getTopic(), message.getTags(), message.getMessage()});
        JSONObject jsonObject = (JSONObject)message.getMessage();
        SendCouponBatchRequestVO sendCouponBatchRequestVO = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)((String)jsonObject.get((Object)"requestVO")), SendCouponBatchRequestVO.class);
        SendCouponDifindustryBo sendCouponDifindustryBo = (SendCouponDifindustryBo)JacksonUtil.json2Objs((String)((String)jsonObject.get((Object)"couponDifindustryBo")), SendCouponDifindustryBo.class);
        CouponBatchSendRecordPO batchPo = (CouponBatchSendRecordPO)JacksonUtil.json2Objs((String)((String)jsonObject.get((Object)"batchPO")), CouponBatchSendRecordPO.class);
        CouponDefinitionPOWithBLOBs definitionPo = sendCouponDifindustryBo.getCouponDefinitionPOWithBLOBs();
        SendCouponBatchRequestVO requestVO = sendCouponDifindustryBo.getRequestVO();
        ResponseData responseData = this.couponDifindustryService.consumeMqSendCoupon(sendCouponDifindustryBo, batchPo);
        if (SysResponseEnum.SUCCESS.getCode() == responseData.getCode()) {
            Integer sucessCount = ((SendCouponBatchRequestVO)responseData.getData()).getSucessCount();
            Integer totalNumber = ((SendCouponBatchRequestVO)responseData.getData()).getTotalNumber();
            Integer failCount = ((SendCouponBatchRequestVO)responseData.getData()).getFailCount();
            if (SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(requestVO.getBusinessType())) {
                this.couponManualPOMapper.updateCouponManualFailCount(failCount.intValue(), 0, requestVO.getBusinessId());
                this.couponManualService.findAndUpdateTaskStatus(totalNumber.intValue(), sucessCount.intValue(), requestVO.getBusinessId());
            }
            List entityPOList = ((SendCouponBatchRequestVO)responseData.getData()).getEntityPOList();
            List memberListManual = ((SendCouponBatchRequestVO)responseData.getData()).getMemberListManual();
            if (entityPOList != null && !entityPOList.isEmpty()) {
                String topic = message.getTopic();
                String tags = message.getTags();
                CouponDefinitionPOWithBLOBs definitionPO = sendCouponDifindustryBo.getCouponDefinitionPOWithBLOBs();
                List preEntityPOList = entityPOList.stream().filter(t -> t.getMemberCode().equals("1")).collect(Collectors.toList());
                List newEntityPOList = entityPOList.stream().filter(t -> !t.getMemberCode().equals("1")).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(preEntityPOList)) {
                    if (!SystemConstants.USE_CHANNEL_ONLINE.equals(definitionPo.getUseChannel())) {
                        sendCouponBatchRequestVO.setType(Integer.valueOf(1));
                        ResponseData sendResult = this.sendCouponMqService.sendCouponBatchOfflineSync(definitionPo, preEntityPOList, batchPo, sendCouponBatchRequestVO);
                        log.info("sendCouponMqService\u540c\u6b65\u5230\u7ebf\u4e0b\uff1a" + sendResult.getMessage());
                    }
                } else if (CollectionUtils.isNotEmpty(newEntityPOList)) {
                    if (SystemConstants.USE_CHANNEL_ONLINE.equals(definitionPo.getUseChannel()) || SystemConstants.USE_CHANNEL_INTEGRAL.equals(definitionPo.getUseChannel())) {
                        if (requestVO != null && SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(requestVO.getBusinessType())) {
                            if (1 == requestVO.getIsSendLastCoupon()) {
                                log.info("\u624b\u52a8\u53d1\u5f02\u4e1a\u5238 \u63d0\u793a\u6700\u540e\u4e00\u5f20\u5238\u5230\u8d26");
                                this.sendCouponService.sendBatchLastCouponArrivalMessage(requestVO, (CouponDefinitionPO)definitionPO, newEntityPOList);
                            }
                            return;
                        }
                        JSONObject json = new JSONObject();
                        json.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPO));
                        json.put("entityPOList", (Object)JSONObject.toJSONString(newEntityPOList));
                        json.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVO));
                        this.rocketMQProducerService.sendWechatMessage(topic, tags, (Object)jsonObject, definitionPO.getSysCompanyId().longValue());
                        log.info("TagOnlineSendCouponService\u7ebf\u4e0a\u5238\u53d1\u9001\u6d88\u606f");
                    } else {
                        log.info("\u7ebf\u4e0a\u903b\u8f91\u5904\u7406\u5b8c\u6210, \u6254\u5230\u7b2c\u4e8c\u5c42topic" + message.getTopic());
                        sendCouponBatchRequestVO.setMemberListManual(memberListManual);
                        batchPo.setBizType(SendTypeEnum.SEND_COUPON_DIF.getCode());
                        JSONObject jsonObjectMq = new JSONObject();
                        jsonObjectMq.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
                        jsonObjectMq.put("requestVO", (Object)sendCouponBatchRequestVO);
                        jsonObjectMq.put("batchPO", (Object)batchPo);
                        jsonObjectMq.put("entityPOList", (Object)JSONObject.toJSONString(newEntityPOList));
                        this.rocketMQProducerService.sendOfflineMessage(message.getTopic(), message.getTags(), (Object)jsonObjectMq, definitionPo.getSysCompanyId().longValue());
                    }
                }
            }
        }
    }
}

