/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.rocketmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.bo.SendCouponDifindustryBo;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.ProductCategoryVO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.rocketmq.rocketutils.RocketMQProducerService;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MQSendCouponService {
    private static final Logger log = LoggerFactory.getLogger(MQSendCouponService.class);
    @Autowired
    private RocketMQProducerService rocketMqProducerService;

    public SendResult sendCoupon(SendCouponSimpleRequestVO vo, int messageSum) {
        log.info("enter sendCoupon method param:{}" + JSONObject.toJSONString((Object)vo));
        SendResult sendResult = this.rocketMqProducerService.sendMessage("tagSendCouponService", (Object)JSONObject.parseObject((String)JSONObject.toJSON((Object)vo).toString()), vo.getCompanyId().longValue(), messageSum);
        log.info("out sendCoupon method simpleMQ", (Object)sendResult.toString());
        return sendResult;
    }

    public SendResult sendCoupon(CouponDefinitionPOWithBLOBs definitionPo, SendCouponBatchRequestVO requestVO, CouponBatchSendRecordPO batchPo, int messageSum) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
        jsonObject.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVO));
        jsonObject.put("batchPO", (Object)JSONObject.toJSONString((Object)batchPo));
        jsonObject.put("goodsCondition", (Object)definitionPo.getGoodsCondition());
        String offlinePrdCode = definitionPo.getOfflinePrdCode();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode})) {
            List productCategoryVos = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
            for (ProductCategoryVO productCategoryVO : productCategoryVos) {
                String prdParentName = productCategoryVO.getPrdParentName();
                String str = productCategoryVO.getStr();
                if ("\u5927\u7c7b".equals(prdParentName)) {
                    jsonObject.put("bigCategory", (Object)str);
                    continue;
                }
                if ("\u4e2d\u7c7b".equals(prdParentName)) {
                    jsonObject.put("middleCategory", (Object)str);
                    continue;
                }
                if ("\u5c0f\u7c7b".equals(prdParentName)) {
                    jsonObject.put("smallCategory", (Object)str);
                    continue;
                }
                if ("\u5e74\u4efd".equals(prdParentName)) {
                    jsonObject.put("particularYear", (Object)str);
                    continue;
                }
                if (!"\u5b63\u8282".equals(prdParentName)) continue;
                jsonObject.put("season", (Object)str);
            }
        }
        SendResult sendResult = null;
        if (SystemConstants.USE_CHANNEL_ONLINE.equals(definitionPo.getUseChannel()) || SystemConstants.USE_CHANNEL_INTEGRAL.equals(definitionPo.getUseChannel())) {
            sendResult = this.rocketMqProducerService.sendMessage("tagOnlineSendCouponService", (Object)jsonObject, definitionPo.getSysCompanyId().longValue(), messageSum);
        } else {
            List memberListManualList = requestVO.getMemberListManual();
            for (MemberInfoSimpleVO pojo : memberListManualList) {
                ArrayList<MemberInfoSimpleVO> list = new ArrayList<MemberInfoSimpleVO>();
                list.add(pojo);
                requestVO.setMemberListManual(list);
                jsonObject.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVO));
                sendResult = this.rocketMqProducerService.sendMessage("tagSendCouponService", (Object)jsonObject, definitionPo.getSysCompanyId().longValue(), messageSum);
            }
        }
        return sendResult;
    }

    public SendResult sendSinglePreCoupon(CouponDefinitionPOWithBLOBs definitionPo, SendCouponBatchRequestVO requestVO, CouponBatchSendRecordPO batchPo, int messageSum) {
        JSONObject parmas = new JSONObject();
        parmas.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
        parmas.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVO));
        parmas.put("batchPO", (Object)JSONObject.toJSONString((Object)batchPo));
        log.info("enter sendSinglePreCoupon method param : {}" + parmas.toString());
        SendResult sendResult = null;
        sendResult = SystemConstants.USE_CHANNEL_OFFLINE.equals(definitionPo.getUseChannel()) || SystemConstants.USE_CHANNEL_ANY.equals(definitionPo.getUseChannel()) || SystemConstants.USE_CHANNEL_EMP.equals(definitionPo.getUseChannel()) ? this.rocketMqProducerService.sendMessage("tagPreEmpSendCouponService", (Object)parmas, definitionPo.getSysCompanyId().longValue(), messageSum) : this.rocketMqProducerService.sendMessage("tagPreEmpOnlineSendCouponService", (Object)parmas, definitionPo.getSysCompanyId().longValue(), messageSum);
        log.info("out sendCoupon method simpleMQ : {}", (Object)sendResult.toString());
        return sendResult;
    }

    public SendResult sendDifindustryCoupon(SendCouponDifindustryBo sendCouponDifindustryBo, CouponBatchSendRecordPO batchPo, int messageSum) {
        SendCouponBatchRequestVO requestVO = sendCouponDifindustryBo.getRequestVO();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("couponDifindustryBo", (Object)JSONObject.toJSONString((Object)sendCouponDifindustryBo));
        jsonObject.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVO));
        jsonObject.put("batchPO", (Object)JSONObject.toJSONString((Object)batchPo));
        CouponDefinitionPOWithBLOBs definitionPo = sendCouponDifindustryBo.getCouponDefinitionPOWithBLOBs();
        jsonObject.put("goodsCondition", (Object)definitionPo.getGoodsCondition());
        String offlinePrdCode = definitionPo.getOfflinePrdCode();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{offlinePrdCode})) {
            List productCategoryVos = JSON.parseArray((String)offlinePrdCode, ProductCategoryVO.class);
            for (ProductCategoryVO productCategoryVO : productCategoryVos) {
                String prdParentName = productCategoryVO.getPrdParentName();
                String str = productCategoryVO.getStr();
                if ("\u5927\u7c7b".equals(prdParentName)) {
                    jsonObject.put("bigCategory", (Object)str);
                    continue;
                }
                if ("\u4e2d\u7c7b".equals(prdParentName)) {
                    jsonObject.put("middleCategory", (Object)str);
                    continue;
                }
                if ("\u5c0f\u7c7b".equals(prdParentName)) {
                    jsonObject.put("smallCategory", (Object)str);
                    continue;
                }
                if ("\u5e74\u4efd".equals(prdParentName)) {
                    jsonObject.put("particularYear", (Object)str);
                    continue;
                }
                if (!"\u5b63\u8282".equals(prdParentName)) continue;
                jsonObject.put("season", (Object)str);
            }
        }
        log.info("enter sendCoupon method param111:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        log.info("enter sendCoupon method \u5f02\u4e1a\u5377\u53d1\u9001mq:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        SendResult sendResult = this.rocketMqProducerService.sendMessage("tagDifindustryCouponService", (Object)jsonObject, definitionPo.getSysCompanyId().longValue(), messageSum);
        log.info("enter sendCoupon method \u5f02\u4e1a\u5377mq\u6210\u529f\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        return sendResult;
    }
}

