/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.offlinemq.offlineimpl;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.offlinemq.messageofflinelisterner.MqOfflineConsumerService;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="tagSimpleSendOfflineCouponService")
public class TagSimpleSendOfflineCouponServiceImpl
implements MqOfflineConsumerService {
    private static final Logger log = LoggerFactory.getLogger(TagSimpleSendOfflineCouponServiceImpl.class);
    @Value(value="${361wm.wmCompanyId}")
    private Long wmCompanyId;
    @Value(value="${mjwm.wmCompanyId}")
    private Long mjWmCompanyId;
    @Value(value="#{'${weimeng.companyIdList}'.split(',')}")
    private List<Long> weimengCompanyIdList;
    @Autowired
    private SendCouponService sendCouponService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CouponEntityService couponEntityService;

    public void actionConsumerOffline(ConsumerMessage<JSONObject> message) {
        log.info("TagSendOfflineCouponServiceImpl\u89e3\u6790\u6210\u529f\uff1a" + message.getMessage());
        JSONObject body = (JSONObject)message.getMessage();
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        CouponEntityPO entityPo = (CouponEntityPO)JacksonUtil.json2Objs((String)body.getString("entityPO"), CouponEntityPO.class);
        SendCouponSimpleRequestVO param = (SendCouponSimpleRequestVO)JacksonUtil.json2Objs((String)body.toJSONString(), SendCouponSimpleRequestVO.class);
        try {
            String value = (String)this.redisTemplateService.stringGetStringByKey((Object)("coupon:mqConsumer:offline:" + entityPo.getCouponCode()));
            if (StringUtils.isNotEmpty((CharSequence)value) || message.getReconsumeTimes() > 3) {
                log.info("TagPreEmpSendOfflineCouponServiceImpl \u6d88\u606f\u5df2\u7ecf\u88ab\u6d88\u8d39\u8fc7\uff1a" + entityPo.getCouponCode() + "\t" + message.getReconsumeTimes());
                return;
            }
            this.sendCouponService.asyncOfflineSimple(param, definitionPo, entityPo);
            log.info("actionConsumerOffline1 definitionPo:{}", (Object)JacksonUtil.bean2Json((Object)definitionPo));
            if (!CollectionUtils.isEmpty((Collection)this.weimengCompanyIdList) && this.weimengCompanyIdList.contains(definitionPo.getSysCompanyId()) && SystemConstants.USE_CHANNEL_ANY.equals(definitionPo.getUseChannel())) {
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                memberInfoModel.setBrandId(definitionPo.getSysBrandId());
                memberInfoModel.setMemberCode(entityPo.getMemberCode());
                ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                if (singleMemberModel.getCode() == SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                    this.sendMessageToWm(definitionPo, entityPo, ((MemberInfoModel)singleMemberModel.getData()).getOfflineCardNo());
                }
            } else if (this.wmCompanyId.equals(definitionPo.getSysCompanyId()) && SystemConstants.USE_CHANNEL_ANY.equals(definitionPo.getUseChannel())) {
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                memberInfoModel.setBrandId(definitionPo.getSysBrandId());
                memberInfoModel.setMemberCode(entityPo.getMemberCode());
                ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                if (singleMemberModel.getCode() == SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                    log.info("\u5f53\u524dmemberCode:{},\u83b7\u53d6\u5f53\u524d\u4f1a\u5458\u4fe1\u606f\uff1a{}", (Object)entityPo.getMemberCode(), (Object)JSONObject.toJSONString((Object)singleMemberModel.getData()));
                    MemberInfoModel data = (MemberInfoModel)singleMemberModel.getData();
                    Long openCardChannelId = data.getOpenCardChannelId();
                    String allChannelIds = data.getAllChannelIds();
                    if (openCardChannelId.equals(Long.parseLong("8")) || allChannelIds.contains("8")) {
                        this.sendMessageToWm(definitionPo, entityPo, data.getOfflineCardNo());
                    }
                }
            }
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("coupon:mqConsumer:offline:" + entityPo.getCouponCode()), (Object)"1", 259200000L);
        }
        catch (Exception e) {
            log.error("\u53d1\u5238\u5f02\u5e38\u5f02\u5e38!" + e.getMessage(), (Throwable)e);
            throw new BizException("\u6d88\u8d39\u5f02\u5e38\uff1a" + message.getMsgId());
        }
    }

    private void sendMessageToWm(CouponDefinitionPOWithBLOBs definitionPo, CouponEntityPO entityPo, String cardNo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
        MemberInfoSimpleVO memberInfoSimpleVO = new MemberInfoSimpleVO();
        memberInfoSimpleVO.setCardNo(cardNo);
        SendCouponBatchRequestVO requestVo = new SendCouponBatchRequestVO();
        ArrayList memberListManual = Lists.newArrayList();
        memberListManual.add(memberInfoSimpleVO);
        requestVo.setMemberListManual((List)memberListManual);
        jsonObject.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVo));
        ArrayList entityPoList = Lists.newArrayList();
        entityPoList.add(entityPo);
        jsonObject.put("entityPOList", (Object)JSONObject.toJSONString((Object)entityPoList));
        log.info("TagSimpleSendOfflineCouponServiceImpl mq send param:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        SendResult send = this.rocketMQTemplate.send(Destination.builder().topic("wm_topic_omni_channel_coupon").build(), (Object)jsonObject);
        log.info("TagSimpleSendOfflineCouponServiceImpl mq sendResult result:{}", (Object)send.toString());
    }
}

