/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.offlinemq.offlineimpl;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.offlinemq.messageofflinelisterner.MqOfflineConsumerService;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="tagSendOfflineCouponService")
public class TagSendOfflineCouponServiceImpl
implements MqOfflineConsumerService {
    private static final Logger log = LoggerFactory.getLogger(TagSendOfflineCouponServiceImpl.class);
    @Value(value="${361wm.wmCompanyId}")
    private Long wmCompanyId;
    @Value(value="${mjwm.wmCompanyId}")
    private Long mjWmCompanyId;
    @Value(value="#{'${weimeng.companyIdList}'.split(',')}")
    private List<Long> weimengCompanyIdList;
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CouponEntityService couponEntityService;

    public void actionConsumerOffline(ConsumerMessage<JSONObject> message) {
        log.info("TagSendOfflineCouponServiceImpl\u89e3\u6790\u6210\u529f\uff1a" + message.getMessage());
        JSONObject body = (JSONObject)message.getMessage();
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        CouponBatchSendRecordPO batchPo = (CouponBatchSendRecordPO)JacksonUtil.json2Objs((String)body.getString("batchPO"), CouponBatchSendRecordPO.class);
        if ("154485".equals(batchPo.getBizCode())) {
            log.info("\u6392\u9664154485");
            return;
        }
        SendCouponBatchRequestVO requestVo = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)body.getString("requestVO"), SendCouponBatchRequestVO.class);
        List entityPoList = JacksonUtil.json2List((String)body.getString("entityPOList"), CouponEntityPO.class);
        try {
            String key = "offline_coupon_" + requestVo.getBatchSendCodeDetail() + "_" + ((CouponEntityPO)entityPoList.get(0)).getCouponCode();
            String value = (String)this.redisTemplateService.stringGetStringByKey((Object)("coupon:mqConsumer:offline:" + key));
            if (StringUtils.isNotEmpty((CharSequence)value) || message.getReconsumeTimes() > 3) {
                log.info("TagSendOfflineCouponServiceImpl \u6d88\u606f\u5df2\u7ecf\u88ab\u6d88\u8d39\u8fc7\uff1a" + key + "\t" + message.getReconsumeTimes() + "\t" + ((CouponEntityPO)entityPoList.get(0)).getCouponCode());
                return;
            }
            ResponseData sendResult = this.sendCouponMqService.sendCouponBatchOfflineSync(definitionPo, entityPoList, batchPo, requestVo);
            log.info("sendCouponMqService\u540c\u6b65\u5230\u7ebf\u4e0b\uff1a" + sendResult.getMessage());
            log.info("actionConsumerOffline definitionPo:{},weimengCompanyIdList :{}", (Object)JacksonUtil.bean2Json((Object)definitionPo), (Object)JacksonUtil.bean2Json((Object)this.weimengCompanyIdList));
            if (!CollectionUtils.isEmpty((Collection)this.weimengCompanyIdList) && this.weimengCompanyIdList.contains(definitionPo.getSysCompanyId()) && SystemConstants.USE_CHANNEL_ANY.equals(definitionPo.getUseChannel())) {
                this.sendMessageToWm(body);
            } else if (sendResult.getCode() == SysResponseEnum.SUCCESS.getCode() && this.wmCompanyId.equals(definitionPo.getSysCompanyId()) && SystemConstants.USE_CHANNEL_ANY.equals(definitionPo.getUseChannel())) {
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                memberInfoModel.setBrandId(definitionPo.getSysBrandId());
                memberInfoModel.setMemberCode(((MemberInfoSimpleVO)requestVo.getMemberListManual().get(0)).getMemberCode());
                ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                if (singleMemberModel.getCode() == SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                    log.info("\u83b7\u53d6\u5f53\u524d\u4f1a\u5458\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)singleMemberModel.getData()));
                    MemberInfoModel data = (MemberInfoModel)singleMemberModel.getData();
                    Long openCardChannelId = data.getOpenCardChannelId();
                    String allChannelIds = data.getAllChannelIds();
                    if (openCardChannelId.equals(Long.parseLong("8")) || allChannelIds.contains("8")) {
                        this.sendMessageToWm(body);
                    }
                }
            }
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("coupon:mqConsumer:offline:" + key), (Object)"1", 259200000L);
        }
        catch (Exception e) {
            log.error("\u53d1\u5238\u5f02\u5e38\u5f02\u5e38!" + e.getMessage(), (Throwable)e);
            this.sendCouponMqService.updateSendCouponBatchException(batchPo, Integer.valueOf(1), (CouponDefinitionPO)definitionPo);
            throw new BizException("\u6d88\u8d39\u5f02\u5e38\uff1a" + message.getMsgId());
        }
    }

    private void sendMessageToWm(JSONObject body) {
        log.info("TagSendOfflineCouponServiceImpl mq send param:{}", (Object)body);
        SendResult send = this.rocketMQTemplate.send(Destination.builder().topic("wm_topic_omni_channel_coupon").build(), (Object)body);
        log.info("TagSendOfflineCouponServiceImpl mq sendResult result:{}", (Object)send.toString());
    }
}

