/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.offlinemq.offlineimpl;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.po.CouponBatchSendRecordPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.offlinemq.messageofflinelisterner.MqOfflineConsumerService;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tagPreEmpSendOfflineCouponService")
public class TagPreEmpSendOfflineCouponServiceImpl
implements MqOfflineConsumerService {
    private static final Logger log = LoggerFactory.getLogger(TagPreEmpSendOfflineCouponServiceImpl.class);
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;

    public void actionConsumerOffline(ConsumerMessage<JSONObject> message) {
        log.info("TagPreEmpSendOfflineCouponServiceImpl\u89e3\u6790\u6210\u529f\uff1a" + message.getMessage());
        JSONObject body = (JSONObject)message.getMessage();
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        CouponBatchSendRecordPO batchPo = (CouponBatchSendRecordPO)JacksonUtil.json2Objs((String)body.getString("batchPO"), CouponBatchSendRecordPO.class);
        SendCouponBatchRequestVO requestVo = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)body.getString("requestVO"), SendCouponBatchRequestVO.class);
        CouponEntityPO couponEntityPo = (CouponEntityPO)JacksonUtil.json2Objs((String)body.getString("couponEntityPO"), CouponEntityPO.class);
        try {
            String value = (String)this.redisTemplateService.stringGetStringByKey((Object)("coupon:mqConsumer:offline:" + couponEntityPo.getCouponCode()));
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                log.info("TagPreEmpSendOfflineCouponServiceImpl \u6d88\u606f\u5df2\u7ecf\u88ab\u6d88\u8d39\u8fc7\uff1a" + couponEntityPo.getCouponCode());
                return;
            }
            ArrayList<CouponEntityPO> list = new ArrayList<CouponEntityPO>(1);
            list.add(couponEntityPo);
            requestVo.setType(Integer.valueOf(1));
            ResponseData sendResult = this.sendCouponMqService.sendCouponBatchOfflineSync(definitionPo, list, batchPo, requestVo);
            log.info("sendCouponMqService\u540c\u6b65\u5230\u7ebf\u4e0b\uff1a" + sendResult.getMessage());
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("coupon:mqConsumer:offline:" + couponEntityPo.getCouponCode()), (Object)JSONObject.toJSONString((Object)couponEntityPo), 259200000L);
        }
        catch (Exception e) {
            log.error("\u53d1\u5238\u5f02\u5e38\u5f02\u5e38!" + e.getMessage(), (Throwable)e);
            this.sendCouponMqService.updateSendCouponBatchException(batchPo, Integer.valueOf(1), (CouponDefinitionPO)definitionPo);
            throw new BizException("\u6d88\u8d39\u5f02\u5e38\uff1a" + message.getMsgId());
        }
    }
}

