/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.offlinemq.messageofflinelisterner;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponDefinitionMoneyPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionMoneyPOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.SendCouponAsyncRequestBOMQ;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponfacade.utils.TimeUtils;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionMoneyPOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.ThirdBusinessService;
import com.bizvane.couponservice.service.impl.SendCouponServiceImpl;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.vo.MemberInfoSimpleVO;
import com.bizvane.thirdrouting.bo.AsynBO;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;

@Profile(value={"coupon"})
@RocketMQMessageListener(topic="bizvane_topic_send_coupon_simple", tags={"*"})
public class TopicSendCouponConsumer
implements RocketMQListener<SendCouponAsyncRequestBOMQ> {
    private static final Logger log = LoggerFactory.getLogger(TopicSendCouponConsumer.class);
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private RedisTemplateServiceImpl redisTemplateService;
    @Autowired
    private SendCouponServiceImpl sendCouponService;
    @Value(value="${mjwm.wmCompanyId}")
    private Long mjWmCompanyId;
    @Value(value="#{'${weimeng.companyIdList}'.split(',')}")
    private List<Long> weimengCompanyIdList;
    @Value(value="${361wm.wmCompanyId}")
    private Long wmCompanyId;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CouponDefinitionMoneyPOMapper couponDefinitionMoneyPOMapper;
    @Autowired
    private ThirdBusinessService thirdBusinessService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public void onMessage(ConsumerMessage<SendCouponAsyncRequestBOMQ> message) {
        ResponseData offlineResult;
        log.info("enter TopicSendCouponConsumer param :{}", (Object)JSONObject.toJSONString((Object)message.getMessage()));
        SendCouponSimpleRequestVO param = ((SendCouponAsyncRequestBOMQ)message.getMessage()).getVo();
        String couponCode = ((SendCouponAsyncRequestBOMQ)message.getMessage()).getCoupon();
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(param.getCouponDefinitionId());
        BigDecimal money = definitionPO.getMoney();
        if (StringUtils.isNotEmpty((CharSequence)param.getTaskId())) {
            CouponDefinitionMoneyPOExample example = new CouponDefinitionMoneyPOExample();
            example.createCriteria().andTaskIdEqualTo(param.getTaskId());
            List selectByExamplelist = this.couponDefinitionMoneyPOMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)selectByExamplelist)) {
                CouponDefinitionMoneyPO couponDefinitionMoneyOld = (CouponDefinitionMoneyPO)selectByExamplelist.get(0);
                money = money.add(couponDefinitionMoneyOld.getMoneyAdd());
            }
        }
        CouponEntityPO entityPO = new CouponEntityPO();
        entityPO.setCouponCode(couponCode);
        entityPO.setCouponDefinitionId(definitionPO.getCouponDefinitionId() + "");
        entityPO.setCouponBatchSendRecordId(definitionPO.getCouponDefinitionId());
        entityPO.setMemberCode(param.getMemberCode());
        entityPO.setCouponName(definitionPO.getCouponName());
        entityPO.setMoney(money);
        entityPO.setDiscount(definitionPO.getDiscount());
        entityPO.setImg(definitionPO.getImg());
        entityPO.setInfo(definitionPO.getInfo());
        entityPO.setTransferSend(definitionPO.getTransferSend());
        entityPO.setTransferCouponDefinitionId(definitionPO.getTransferCouponDefinitionId());
        entityPO.setTransferInfo(definitionPO.getTransferInfo());
        entityPO.setBindStatus(SystemConstants.COUPON_BIND_STATUS_UNBIND);
        Calendar calendar = Calendar.getInstance();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (definitionPO.getValidType().equals(SystemConstants.VALID_TYPE__SOMEDAY)) {
            calendar.add(5, definitionPO.getValidDay());
            calendar.set(11, 23);
            calendar.set(13, 59);
            calendar.set(12, 59);
            calendar.set(14, 59);
            entityPO.setValidDateStart(TimeUtils.getNowTime());
            entityPO.setValidDateEnd(calendar.getTime());
        } else if (SystemConstants.VALID_TYPE_DELAY.equals(definitionPO.getValidType())) {
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate startDate = LocalDate.now().plusDays(definitionPO.getDelayDay().intValue());
            LocalDateTime validDateStart = startDate.atTime(0, 0, 0);
            ZonedDateTime startTime = validDateStart.atZone(zoneId);
            LocalDate endDate = startDate.plusDays((long)definitionPO.getDelayValidDay().intValue() - 1L);
            LocalDateTime validEndDate = endDate.atTime(23, 59, 59);
            ZonedDateTime endTime = validEndDate.atZone(zoneId);
            entityPO.setValidDateStart(Date.from(startTime.toInstant()));
            entityPO.setValidDateEnd(Date.from(endTime.toInstant()));
        } else {
            entityPO.setValidDateStart(definitionPO.getValidDateStart());
            calendar.setTime(definitionPO.getValidDateEnd());
            calendar.set(11, 23);
            calendar.set(13, 59);
            calendar.set(12, 59);
            calendar.set(14, 59);
            entityPO.setValidDateEnd(calendar.getTime());
        }
        entityPO.setIsLock(SystemConstants.COUPON_STATUS_CHANGE_IS_UNLOCK);
        entityPO.setSendType(param.getSendType());
        entityPO.setSendBusinessId(param.getSendBussienId());
        entityPO.setRemark(definitionPO.getRemark());
        entityPO.setValid(SystemConstants.TABLE_VALID_EFFECTIVE);
        entityPO.setPreferentialType(definitionPO.getPreferentialType());
        entityPO.setCreateDate(TimeUtils.getNowTime());
        entityPO.setModifiedDate(TimeUtils.getNowTime());
        entityPO.setBrandCode(param.getBrandCode());
        entityPO.setSysBrandId(definitionPO.getSysBrandId());
        entityPO.setSysCompanyId(definitionPO.getSysCompanyId());
        entityPO.setBusinessName(param.getBusinessName());
        Byte couponStatus = null;
        if (SystemConstants.USE_CHANNEL_ONLINE.equals(definitionPO.getUseChannel()) || SystemConstants.USE_CHANNEL_INTEGRAL.equals(definitionPO.getUseChannel()) || SystemConstants.USE_CHANNEL_FORM_OFFLINE.equals(definitionPO.getUseChannel())) {
            couponStatus = SystemConstants.COUPON_STATUS_UNUSED;
        } else if (SystemConstants.USE_CHANNEL_OFFLINE.equals(definitionPO.getUseChannel())) {
            couponStatus = SystemConstants.COUPON_STATUS_SYNCHROING;
        } else if (SystemConstants.USE_CHANNEL_ANY.equals(definitionPO.getUseChannel())) {
            couponStatus = SystemConstants.COUPON_STATUS_SYNCHROING;
        }
        entityPO.setCouponStatus(couponStatus);
        this.couponEntityPOMapper.insertSelective(entityPO);
        try {
            AsynBO asynBO = new AsynBO(entityPO.getSysCompanyId(), entityPO.getSysBrandId(), "couponSend", JSON.toJSONString((Object)entityPO));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            log.error("saveErpSendCouponEntity thirdBusinessService.asyn e {}", (Throwable)e);
        }
        log.info("\u5355\u5f20\u53d1\u5238\u53c2\u6570:{}", (Object)JacksonUtil.bean2Json((Object)param));
        log.info("\u5238\u5b9e\u4f53:{}", (Object)JacksonUtil.bean2Json((Object)entityPO));
        if (param.getMktGiftBagId() != null) {
            if (param.getIsGiftBagLastCoupon() == 1) {
                log.info("\u5199\u5165redisk \u53d1\u9001\u5238\u5305\u6d88\u606f:{}", (Object)("GiftBagCoupon-" + entityPO.getCouponCode()));
                this.redisTemplateService.stringSetValueAndExpireTime((Object)("GiftBagCoupon-" + entityPO.getCouponCode()), (Object)(param.getMktGiftBagId() + ""), 300000L);
            } else {
                log.info("\u5199\u5165redisk \u4e0d\u53d1\u9001\u5238\u5305\u6d88\u606f:{}", (Object)("GiftBagCoupon-" + entityPO.getCouponCode()));
                this.redisTemplateService.stringSetValueAndExpireTime((Object)("GiftBagCoupon-" + entityPO.getCouponCode()), (Object)"0", 300000L);
            }
        }
        if (SystemConstants.USE_CHANNEL_ONLINE.equals(definitionPO.getUseChannel()) || SystemConstants.USE_CHANNEL_INTEGRAL.equals(definitionPO.getUseChannel()) || SystemConstants.USE_CHANNEL_FORM_OFFLINE.equals(definitionPO.getUseChannel())) {
            ResponseData e = this.sendCouponService.sendCouponOnline(param, definitionPO, entityPO);
        } else if (SystemConstants.USE_CHANNEL_OFFLINE.equals(definitionPO.getUseChannel())) {
            offlineResult = new ResponseData();
            offlineResult = SendTypeEnum.SEND_COUPON_ORIENT_MARKET.getCode().equals(param.getSendType()) ? this.sendCouponService.sendCouponOfflineForMarketing(definitionPO, entityPO, SystemConstants.COUPON_SEND_AGAIN_NO) : this.sendCouponService.sendCouponOffline(definitionPO, entityPO, SystemConstants.COUPON_SEND_AGAIN_NO);
            log.info("\u5355\u5f20\u53d1\u5238\u540c\u6b65\u7ebf\u4e0b\u8fd4\u56de\u7ed3\u679cofflineResult:{}", (Object)JacksonUtil.bean2Json((Object)offlineResult));
        } else if (SystemConstants.USE_CHANNEL_ANY.equals(definitionPO.getUseChannel())) {
            ResponseData singleMemberModel;
            MemberInfoModel memberInfoModel;
            offlineResult = new ResponseData();
            offlineResult = SendTypeEnum.SEND_COUPON_ORIENT_MARKET.getCode().equals(param.getSendType()) ? this.sendCouponService.sendCouponOfflineForMarketing(definitionPO, entityPO, SystemConstants.COUPON_SEND_AGAIN_NO) : this.sendCouponService.sendCouponOffline(definitionPO, entityPO, SystemConstants.COUPON_SEND_AGAIN_NO);
            log.info("\u5355\u5f20\u53d1\u5238\u540c\u6b65\u7ebf\u4e0b\u8fd4\u56de\u7ed3\u679cofflineResult:{}", (Object)JacksonUtil.bean2Json((Object)offlineResult));
            if (!CollectionUtils.isEmpty((Collection)this.weimengCompanyIdList) && this.weimengCompanyIdList.contains(definitionPO.getSysCompanyId())) {
                memberInfoModel = new MemberInfoModel();
                memberInfoModel.setBrandId(definitionPO.getSysBrandId());
                memberInfoModel.setMemberCode(param.getMemberCode());
                singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                if (singleMemberModel.getCode() == SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                    this.sendCouponService.sendMessageToWm(definitionPO, entityPO, ((MemberInfoModel)singleMemberModel.getData()).getOfflineCardNo());
                }
            } else if (this.wmCompanyId.equals(definitionPO.getSysCompanyId()) && SystemConstants.USE_CHANNEL_ANY.equals(definitionPO.getUseChannel())) {
                memberInfoModel = new MemberInfoModel();
                memberInfoModel.setBrandId(definitionPO.getSysBrandId());
                memberInfoModel.setMemberCode(entityPO.getMemberCode());
                singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                if (singleMemberModel.getCode() == SysResponseEnum.SUCCESS.getCode() && singleMemberModel.getData() != null) {
                    log.info("\u5f53\u524dmemberCode:{},\u83b7\u53d6\u5f53\u524d\u4f1a\u5458\u4fe1\u606f\uff1a{}", (Object)entityPO.getMemberCode(), (Object)JSONObject.toJSONString((Object)singleMemberModel.getData()));
                    MemberInfoModel data = (MemberInfoModel)singleMemberModel.getData();
                    Long openCardChannelId = data.getOpenCardChannelId();
                    String allChannelIds = data.getAllChannelIds();
                    if (openCardChannelId.equals(Long.parseLong("8")) || allChannelIds.contains("8")) {
                        this.sendMessageToWm(definitionPO, entityPO, data.getOfflineCardNo());
                    }
                }
            }
        }
    }

    private void sendMessageToWm(CouponDefinitionPOWithBLOBs definitionPo, CouponEntityPO entityPo, String cardNo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
        MemberInfoSimpleVO memberInfoSimpleVO = new MemberInfoSimpleVO();
        memberInfoSimpleVO.setCardNo(cardNo);
        SendCouponBatchRequestVO requestVo = new SendCouponBatchRequestVO();
        ArrayList memberListManual = Lists.newArrayList();
        memberListManual.add(memberInfoSimpleVO);
        requestVo.setMemberListManual((List)memberListManual);
        jsonObject.put("requestVO", (Object)JSONObject.toJSONString((Object)requestVo));
        ArrayList entityPoList = Lists.newArrayList();
        entityPoList.add(entityPo);
        jsonObject.put("entityPOList", (Object)JSONObject.toJSONString((Object)entityPoList));
        log.info("TagSimpleSendOfflineCouponServiceImpl mq send param:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        SendResult send = this.rocketMQTemplate.send(Destination.builder().topic("wm_topic_omni_channel_coupon").build(), (Object)jsonObject);
        log.info("TagSimpleSendOfflineCouponServiceImpl mq sendResult result:{}", (Object)send.toString());
    }
}

