/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.message.messagelisterner;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponservice.service.SendCouponMqService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;

@Profile(value={"TOPIC_2"})
@RocketMQMessageListener(topic="bizvane_topic_send_coupon2_message", tags={"*"})
public class TopicTwoMessageCouponConsumer
implements RocketMQListener<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(TopicTwoMessageCouponConsumer.class);
    @Autowired
    private SendCouponMqService sendCouponMqService;
    @Autowired
    private SendCouponService sendCouponService;
    @Autowired
    private RedisClient redisClient;

    public void onMessage(ConsumerMessage<JSONObject> message) {
        JSONObject body = (JSONObject)message.getMessage();
        String msgId = message.getMsgId();
        if (this.redisClient.get("coupon:mqConsumer:message:" + msgId) != null) {
            return;
        }
        this.redisClient.set("coupon:mqConsumer:message:" + msgId, (Object)Boolean.TRUE, Long.valueOf(172800L));
        CouponDefinitionPOWithBLOBs definitionPo = (CouponDefinitionPOWithBLOBs)JacksonUtil.json2Objs((String)body.getString("definitionPO"), CouponDefinitionPOWithBLOBs.class);
        List entityPoList = JSONObject.parseArray((String)body.getString("entityPOList"), CouponEntityPO.class);
        SendCouponBatchRequestVO requestVO = (SendCouponBatchRequestVO)JacksonUtil.json2Objs((String)body.getString("requestVO"), SendCouponBatchRequestVO.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("definitionPO", (Object)JSONObject.toJSONString((Object)definitionPo));
        jsonObject.put("entityPOList", (Object)JSONObject.toJSONString((Object)entityPoList));
        if (requestVO != null && SendTypeEnum.SEND_COUPON_BATCH.getCode().equals(requestVO.getBusinessType())) {
            if (1 == requestVO.getIsSendLastCoupon()) {
                this.sendCouponService.sendBatchLastCouponArrivalMessage(requestVO, (CouponDefinitionPO)definitionPo, entityPoList);
                log.info("TopicOneMessageCouponConsumer\u6d88\u8d39\u6210\u529f  \u8c03\u7528sendCouponService.sendBatchLastCouponArrivalMessage \u7ebf\u4e0a\u5238\u53d1\u9001\u6d88\u606f");
            }
            return;
        }
        this.sendCouponMqService.sendCouponBatchOnline((CouponDefinitionPO)definitionPo, entityPoList);
        log.info("TopicOneMessageCouponConsumer\u6d88\u8d39\u6210\u529f  \u8c03\u7528sendCouponMqService.sendCouponBatchOnline \u7ebf\u4e0a\u5238\u53d1\u9001\u6d88\u606f");
    }
}

