/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.kafka.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.vo.CouponOfflineUseResponseVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.StandardMessageUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.couponservice.service.impl.CouponMessageComponentServiceImpl;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.service.api.MemberOrderApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagefacade.interfaces.WechatCouponServiceFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(value={"spring.application.name"}, havingValue="coupon")
@RocketMQMessageListener(topic="COUPON_OFFLINE_USE_SIT")
public class MqCouponOfflineUseSit
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(MqCouponOfflineUseSit.class);
    private static final Logger logger = LoggerFactory.getLogger(MqCouponOfflineUseSit.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WechatCouponServiceFeign wechatCouponServiceFeign;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private SendCouponService sendCouponService;
    @Autowired
    private StandardMessageUtil standardMessageUtil;
    @Autowired
    private MemberOrderApiService memberOrderApiService;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponMessageComponentServiceImpl couponMessageComponentService;

    public Long findCompanyId(String companyCode) {
        CompanyCacheDto companyCache = this.iRedisCacheService.getCompanyCache(companyCode);
        return companyCache.getCompanyId();
    }

    public ResponseData<String> sendMessage(CouponEntityPO couponEntityPo) {
        ResponseData responseData = new ResponseData();
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(couponEntityPo.getMemberCode());
        channelVO.setBrandId(couponEntityPo.getSysBrandId());
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        WxChannelInfoVo channelInfoVo = null;
        MemberInfoModel memberInfoModel = null;
        if (channelResult.getData() != null) {
            channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
            memberInfoModel = ((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel();
        }
        if (null == channelInfoVo) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.WECHAT_CHANNEL_NOT_EXISTS.getMessage());
            return responseData;
        }
        CouponMessageVO messageVO = new CouponMessageVO();
        messageVO.setMemberCode(couponEntityPo.getMemberCode());
        messageVO.setCouponCode(couponEntityPo.getCouponCode());
        messageVO.setCouponName(couponEntityPo.getCouponName());
        messageVO.setPreferentialType(couponEntityPo.getPreferentialType() + "");
        messageVO.setDenomination(couponEntityPo.getMoney() + "");
        if (couponEntityPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
            messageVO.setDenomination(couponEntityPo.getMoney() + "");
        } else if (couponEntityPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
            messageVO.setDenomination(couponEntityPo.getDiscount() + "");
        }
        messageVO.setSendType(couponEntityPo.getSendType());
        messageVO.setSendBusinessId(couponEntityPo.getSendBusinessId());
        messageVO.setUseTime(couponEntityPo.getUseTime());
        messageVO.setValidDateStart(couponEntityPo.getValidDateStart());
        messageVO.setValidDateEnd(couponEntityPo.getValidDateEnd());
        messageVO.setMemberName(channelInfoVo.getName());
        messageVO.setOrderNo(couponEntityPo.getUseBusinessCode());
        messageVO.setSysBrandId(couponEntityPo.getSysBrandId());
        messageVO.setMemberPhone(channelInfoVo.getPhone());
        messageVO.setNickName(channelInfoVo.getWxNick());
        messageVO.setSendWxmember(channelInfoVo.getFocus() + "");
        messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
        messageVO.setServiceStoreCode(memberInfoModel.getServiceStoreCode());
        messageVO.setServiceStoreId(memberInfoModel.getServiceStoreId());
        messageVO.setAreaCode(memberInfoModel.getAreaCode());
        ResponseData publicPo = this.wxPublicServiceFeign.getWxPublicBySysBrandId(couponEntityPo.getSysBrandId());
        if (publicPo.getData() != null) {
            messageVO.setNickName(((WxPublicPO)publicPo.getData()).getNickName());
        }
        ResponseData onlineResult = this.wechatCouponServiceFeign.couponUse(messageVO);
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPo.getCouponDefinitionId()));
        ResponseData subscribeResp = this.couponMessageComponentService.couponUse(messageVO, definitionPO, couponEntityPo, new Date());
        logger.info("MqCouponOfflineUseSit#CouponMessageComponentServiceImpl#couponUse#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
        this.standardMessageUtil.useCouponMessage(couponEntityPo, channelInfoVo, messageVO);
        return onlineResult;
    }

    public void onMessage(ConsumerMessage<String> message) {
        ResponseData responseData;
        String messageContent = (String)message.getMessage();
        logger.info("enter MqCouponOfflineUseSit consumer method! value:{}", (Object)messageContent);
        if (StringUtils.isBlank((CharSequence)messageContent)) {
            logger.info(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageContent);
        CouponOfflineUseResponseVO offlineVO = (CouponOfflineUseResponseVO)JSONObject.toJavaObject((JSON)jsonObject, CouponOfflineUseResponseVO.class);
        if (StringUtils.isBlank((CharSequence)offlineVO.getCouponCode())) {
            logger.info("enter MqCouponOfflineUseSit consumer method ! CouponCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        if (StringUtils.isBlank((CharSequence)offlineVO.getCompanyCode())) {
            logger.info("enter MqCouponOfflineUseSit consumer method ! getCompanyCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        Long findCompanyId = this.findCompanyId(offlineVO.getCompanyCode());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(offlineVO.getCouponCode()).andSysCompanyIdEqualTo(findCompanyId);
        List entityPoList = this.couponEntityPoMapper.selectByExample(entityExample);
        if (CollectionUtils.isEmpty((Collection)entityPoList)) {
            logger.info("enter MqCouponOfflineUseSit consumer method ! CouponEntityPO is null!" + JSONObject.toJSONString((Object)entityPoList));
            return;
        }
        CouponEntityPO entityPo = (CouponEntityPO)entityPoList.get(0);
        if (entityPo.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            logger.info("Coupon is used" + JSONObject.toJSONString((Object)entityPo));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)offlineVO.getUseStoreCode()) && (responseData = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(offlineVO.getUseStoreCode(), findCompanyId)) != null && SysResponseEnum.SUCCESS.getCode() == responseData.getCode()) {
            entityPo.setUseStoreId(((SysStorePo)responseData.getData()).getStoreId());
        }
        entityPo.setUseBusinessCode(offlineVO.getUseBusinessCode());
        entityPo.setUseBusinessAmount(offlineVO.getUseBusinessAmount());
        try {
            if (offlineVO.getUseTime() != null) {
                entityPo.setUseTime(dateFormat.parse(offlineVO.getUseTime()));
            }
        }
        catch (Exception e) {
            logger.info(SysResponseEnum.DATE_TRANSFER_EXCEPTION.getMessage());
        }
        entityPo.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        entityPo.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        entityPo.setUseFrom(Byte.valueOf((byte)4));
        entityPo.setModifiedDate(new Date());
        OrderModel orderModel = new OrderModel();
        orderModel.setBrandId(entityPo.getSysBrandId());
        orderModel.setSysCompanyId(entityPo.getSysCompanyId());
        orderModel.setOrderNo(offlineVO.getUseBusinessCode());
        ResponseData memberInfoModelResponseData = this.memberOrderApiService.queryMemberInfoByOrderNo(orderModel);
        logger.info("\u6839\u636e\u8ba2\u5355\u53f7:{}\u67e5\u8be2\u51fa\u6765\u7684\u4f1a\u5458\u662f:{}", (Object)offlineVO.getUseBusinessCode(), (Object)JSON.toJSONString((Object)memberInfoModelResponseData));
        if (memberInfoModelResponseData != null && memberInfoModelResponseData.getData() != null) {
            String useMemberCode = ((MemberInfoModel)memberInfoModelResponseData.getData()).getMemberCode();
            entityPo.setUseMemberCode(useMemberCode);
            entityPo.setUseBusinessAmount(offlineVO.getUseBusinessAmount());
        }
        this.couponEntityPoMapper.updateByExampleSelective(entityPo, entityExample);
        ResponseData responseData2 = this.sendMessage(entityPo);
        logger.info("enter MqCouponOfflineUseSit consumer method sendMessage! param:responseData:{}", (Object)JSONObject.toJSONString((Object)responseData2));
        if (entityPo.getSendType().equals(SendTypeEnum.SEND_COUPON_BATCH.getCode())) {
            logger.info("enter MqCouponOfflineUseSit consumer method sendMessage!");
            BigDecimal useBusinessAmount = null;
            if (null != offlineVO.getUseBusinessAmount()) {
                useBusinessAmount = offlineVO.getUseBusinessAmount();
            }
            this.couponManualService.updateCouponManualCount(entityPo.getUseStoreId(), entityPo.getSendBusinessId(), useBusinessAmount, offlineVO.getDiscountMoney());
        }
        logger.info("enter semd getTransferSend", (Object)(entityPo.getCouponCode() + JSONObject.toJSONString((Object)entityPo)));
        if (entityPo.getTransferSend() != null && entityPo.getTransferSend().booleanValue()) {
            SendCouponSimpleRequestVO sendVO = new SendCouponSimpleRequestVO();
            sendVO.setMemberCode(entityPo.getTransferMemberCode());
            sendVO.setCouponDefinitionId(entityPo.getTransferCouponDefinitionId());
            sendVO.setSendType(entityPo.getSendType());
            sendVO.setSendBussienId(entityPo.getSendBusinessId());
            sendVO.setBusinessName(entityPo.getBusinessName());
            sendVO.setBrandId(entityPo.getSysBrandId());
            sendVO.setCompanyId(entityPo.getSysCompanyId());
            sendVO.setBrandCode(entityPo.getBrandCode());
            this.sendCouponService.simple(sendVO);
        }
    }
}

