/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.kafka.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.baisonBase.facade.models.mj.MjCouponUseRequestVo;
import com.bizvane.baisonBase.facade.rpc.MjMemberServiceNewRpc;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.vo.CouponOfflineUseResponseVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponservice.common.config.Mj2Config;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.datavo.YouzanCouponBO;
import com.bizvane.couponservice.common.utils.StandardMessageUtil;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.couponservice.service.ThirdBusinessService;
import com.bizvane.couponservice.service.impl.CouponMessageComponentServiceImpl;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberOrderApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.messagefacade.interfaces.WechatCouponServiceFeign;
import com.bizvane.messagefacade.models.vo.CouponMessageVO;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.thirddock.service.rpc.YouzanCouponServiceRpc;
import com.bizvane.thirdrouting.bo.AsynBO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(value={"spring.application.name"}, havingValue="coupon")
@RocketMQMessageListener(topic="COUPON_OFFLINE_USE")
public class MqCouponOfflineUse
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(MqCouponOfflineUse.class);
    private static final Logger logger = LoggerFactory.getLogger(MqCouponOfflineUse.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WechatCouponServiceFeign wechatCouponServiceFeign;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private SendCouponService sendCouponService;
    @Autowired
    private StandardMessageUtil standardMessageUtil;
    @Autowired
    private MemberOrderApiService memberOrderApiService;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    @Autowired
    private ThirdBusinessService thirdBusinessService;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponMessageComponentServiceImpl couponMessageComponentService;
    @Autowired
    private Mj2Config mj2Config;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MjMemberServiceNewRpc mjMemberServiceNewRpc;
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private YouzanCouponServiceRpc youzanCouponServiceRpc;

    public Long findCompanyId(String companyCode) {
        CompanyCacheDto companyCache = this.iRedisCacheService.getCompanyCache(companyCode);
        return companyCache.getCompanyId();
    }

    public ResponseData<String> sendMessage(CouponEntityPO couponEntityPo) {
        ResponseData responseData = new ResponseData();
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(couponEntityPo.getMemberCode());
        channelVO.setBrandId(couponEntityPo.getSysBrandId());
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        WxChannelInfoVo channelInfoVo = null;
        MemberInfoModel memberInfoModel = null;
        if (channelResult.getData() != null) {
            channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
            memberInfoModel = ((WxChannelAndMemberVo)channelResult.getData()).getMemberInfoModel();
        }
        if (null == channelInfoVo) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.WECHAT_CHANNEL_NOT_EXISTS.getMessage());
            return responseData;
        }
        CouponMessageVO messageVO = new CouponMessageVO();
        messageVO.setMemberCode(couponEntityPo.getMemberCode());
        messageVO.setCouponCode(couponEntityPo.getCouponCode());
        messageVO.setCouponName(couponEntityPo.getCouponName());
        messageVO.setPreferentialType(couponEntityPo.getPreferentialType() + "");
        messageVO.setDenomination(couponEntityPo.getMoney() + "");
        if (couponEntityPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_MONEY)) {
            messageVO.setDenomination(couponEntityPo.getMoney() + "");
        } else if (couponEntityPo.getPreferentialType().equals(SystemConstants.PREFERENTIAL_TYPE_DISCOUNT)) {
            messageVO.setDenomination(couponEntityPo.getDiscount() + "");
        }
        messageVO.setUseTime(couponEntityPo.getUseTime());
        messageVO.setValidDateStart(couponEntityPo.getValidDateStart());
        messageVO.setValidDateEnd(couponEntityPo.getValidDateEnd());
        messageVO.setMemberName(channelInfoVo.getName());
        messageVO.setOrderNo(couponEntityPo.getUseBusinessCode());
        messageVO.setSysBrandId(couponEntityPo.getSysBrandId());
        messageVO.setMemberPhone(channelInfoVo.getPhone());
        messageVO.setNickName(channelInfoVo.getWxNick());
        messageVO.setSendWxmember(channelInfoVo.getFocus() + "");
        messageVO.setSysCompanyId(channelInfoVo.getSysCompanyId());
        messageVO.setServiceStoreCode(memberInfoModel.getServiceStoreCode());
        messageVO.setServiceStoreId(memberInfoModel.getServiceStoreId());
        messageVO.setAreaCode(memberInfoModel.getAreaCode());
        messageVO.setSendType(couponEntityPo.getSendType());
        messageVO.setSendBusinessId(couponEntityPo.getSendBusinessId());
        ResponseData publicPo = this.wxPublicServiceFeign.getWxPublicBySysBrandId(couponEntityPo.getSysBrandId());
        if (publicPo.getData() != null) {
            messageVO.setNickName(((WxPublicPO)publicPo.getData()).getNickName());
        }
        CouponDefinitionPOWithBLOBs definitionPO = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(couponEntityPo.getCouponDefinitionId()));
        ResponseData subscribeResp = this.couponMessageComponentService.couponUse(messageVO, definitionPO, couponEntityPo, new Date());
        logger.info("MqCouponOfflineUse#CouponMessageComponentServiceImpl#couponUse#subscribeResp:{}", (Object)JSON.toJSONString((Object)subscribeResp));
        logger.info("\u8c03\u7528\u6d88\u606f\u6a21\u5757\u7684   standardMessageUtil.useCouponMessage:{}", (Object)JSON.toJSONString((Object)messageVO));
        this.standardMessageUtil.useCouponMessage(couponEntityPo, channelInfoVo, messageVO);
        logger.info("wechatCouponServiceFeign.couponUse:{}", (Object)JSON.toJSONString((Object)messageVO));
        return this.wechatCouponServiceFeign.couponUse(messageVO);
    }

    public void onMessage(ConsumerMessage<String> message) {
        ResponseData sysStorePoResponseData;
        String messageContent = (String)message.getMessage();
        logger.info("enter MqCouponOfflineUse consumer method! value:{}", (Object)messageContent);
        if (StringUtils.isBlank((CharSequence)messageContent)) {
            logger.info(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageContent);
        CouponOfflineUseResponseVO offlineVO = (CouponOfflineUseResponseVO)JSONObject.toJavaObject((JSON)jsonObject, CouponOfflineUseResponseVO.class);
        if (StringUtils.isBlank((CharSequence)offlineVO.getCouponCode())) {
            logger.info("enter MqCouponOfflineUse consumer method ! CouponCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        if (StringUtils.isBlank((CharSequence)offlineVO.getCompanyCode())) {
            logger.info("enter MqCouponOfflineUse consumer method ! getCompanyCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        Long findCompanyId = this.findCompanyId(offlineVO.getCompanyCode());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(offlineVO.getCouponCode()).andSysCompanyIdEqualTo(findCompanyId);
        List entityPoList = this.couponEntityPoMapper.selectByExample(entityExample);
        if (CollectionUtils.isEmpty((Collection)entityPoList)) {
            logger.info("enter MqCouponOfflineUse consumer method ! CouponEntityPO is null!" + JSONObject.toJSONString((Object)entityPoList));
            return;
        }
        CouponEntityPO entityPo = (CouponEntityPO)entityPoList.get(0);
        boolean firstUse = true;
        if (entityPo.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            logger.info("Coupon is used" + JSONObject.toJSONString((Object)entityPo));
            firstUse = false;
        }
        if (StringUtils.isNotBlank((CharSequence)offlineVO.getUseStoreCode()) && (sysStorePoResponseData = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(offlineVO.getUseStoreCode(), findCompanyId)) != null && SysResponseEnum.SUCCESS.getCode() == sysStorePoResponseData.getCode()) {
            entityPo.setUseStoreId(((SysStorePo)sysStorePoResponseData.getData()).getStoreId());
        }
        entityPo.setUseBusinessCode(offlineVO.getUseBusinessCode());
        entityPo.setUseBusinessAmount(offlineVO.getUseBusinessAmount());
        try {
            if (offlineVO.getUseTime() != null) {
                entityPo.setUseTime(dateFormat.parse(offlineVO.getUseTime()));
            }
        }
        catch (Exception e) {
            logger.info(SysResponseEnum.DATE_TRANSFER_EXCEPTION.getMessage());
        }
        entityPo.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        entityPo.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        entityPo.setUseFrom(Byte.valueOf((byte)4));
        entityPo.setModifiedDate(new Date());
        OrderModel orderModel = new OrderModel();
        orderModel.setBrandId(entityPo.getSysBrandId());
        orderModel.setSysCompanyId(entityPo.getSysCompanyId());
        orderModel.setOrderNo(offlineVO.getUseBusinessCode());
        ResponseData memberInfoModelResponseData = this.memberOrderApiService.queryMemberInfoByOrderNo(orderModel);
        logger.info("\u6839\u636e\u8ba2\u5355\u53f7:{}\u67e5\u8be2\u51fa\u6765\u7684\u4f1a\u5458\u662f:{}", (Object)offlineVO.getUseBusinessCode(), (Object)JSON.toJSONString((Object)memberInfoModelResponseData));
        if (memberInfoModelResponseData != null && memberInfoModelResponseData.getData() != null) {
            String useMemberCode = ((MemberInfoModel)memberInfoModelResponseData.getData()).getMemberCode();
            entityPo.setUseMemberCode(useMemberCode);
            entityPo.setUseBusinessAmount(offlineVO.getUseBusinessAmount());
        }
        this.couponEntityPoMapper.updateByExampleSelective(entityPo, entityExample);
        try {
            AsynBO asynBO = new AsynBO(entityPo.getSysCompanyId(), entityPo.getSysBrandId(), "couponUsed", JSON.toJSONString((Object)entityPo));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("addOrUpdateYzCouponDefinition thirdBusinessService.asyn e {}", (Throwable)e);
        }
        if (firstUse) {
            ResponseData responseData = this.sendMessage(entityPo);
            logger.info("enter MqCouponOfflineUse consumer method sendMessage! param:responseData:{}", (Object)JSONObject.toJSONString((Object)responseData));
            if (entityPo.getSendType().equals(SendTypeEnum.SEND_COUPON_BATCH.getCode())) {
                logger.info("enter MqCouponOfflineUse consumer method sendMessage!");
                BigDecimal useBusinessAmount = null;
                if (null != offlineVO.getUseBusinessAmount()) {
                    useBusinessAmount = offlineVO.getUseBusinessAmount();
                }
                this.couponManualService.updateCouponManualCount(entityPo.getUseStoreId(), entityPo.getSendBusinessId(), useBusinessAmount, offlineVO.getDiscountMoney());
            }
            logger.info("enter semd getTransferSend", (Object)(entityPo.getCouponCode() + JSONObject.toJSONString((Object)entityPo)));
            if (entityPo.getTransferSend() != null && entityPo.getTransferSend().booleanValue()) {
                SendCouponSimpleRequestVO sendVO = new SendCouponSimpleRequestVO();
                sendVO.setMemberCode(entityPo.getTransferMemberCode());
                sendVO.setCouponDefinitionId(entityPo.getTransferCouponDefinitionId());
                sendVO.setSendType(entityPo.getSendType());
                sendVO.setSendBussienId(entityPo.getSendBusinessId());
                sendVO.setBusinessName(entityPo.getBusinessName());
                sendVO.setBrandId(entityPo.getSysBrandId());
                sendVO.setCompanyId(entityPo.getSysCompanyId());
                sendVO.setBrandCode(entityPo.getBrandCode());
                this.sendCouponService.simple(sendVO);
            }
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(entityPo.getCouponDefinitionId()));
        YouzanCouponBO youzanCouponBO = this.couponEntityService.isSyncYouzan(entityPo.getSysBrandId().longValue(), entityPo, couponDefinitionPOWithBLOBs);
        if (youzanCouponBO != null) {
            try {
                logger.info("youzanCouponServiceRpc.couponUse\u5165\u53c2\uff1a{}", (Object)offlineVO.getCouponCode());
                Boolean youzanResult = (Boolean)this.youzanCouponServiceRpc.couponUse(entityPo.getSysBrandId(), offlineVO.getCouponCode()).getData();
                logger.info("youzanCouponServiceRpc.couponUse:" + offlineVO.getCouponCode());
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u6709\u8d5e\u5238\u5b9e\u4f8b\u62a5\u9519 e {}", (Throwable)e);
            }
        }
        if (this.mj2Config.isSyncMj(entityPo.getSysCompanyId().longValue(), couponDefinitionPOWithBLOBs.getUseChannel())) {
            MemberInfoModel memberInfoModelParam = new MemberInfoModel();
            memberInfoModelParam.setMemberCode(entityPo.getMemberCode());
            MemberInfoModel member = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModelParam).getData();
            String cardNo = member.getCardNo();
            String name = member.getName();
            entityPo.setStaffCode(member.getServiceGuideCode());
            MjCouponUseRequestVo mjCouponUseRequestVo = new MjCouponUseRequestVo(cardNo, name, entityPo);
            log.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:{}" + JSON.toJSONString((Object)mjCouponUseRequestVo));
            boolean syncResult = (Boolean)this.mjMemberServiceNewRpc.couponUse(mjCouponUseRequestVo).getTData();
            log.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:" + syncResult);
        }
    }
}

