/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.kafka.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.couponfacade.models.po.CouponDefinitionCodePO;
import com.bizvane.couponfacade.models.po.CouponDefinitionCodePOExample;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOExample;
import com.bizvane.couponfacade.models.vo.CouponOfflineCreateResponseVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.mappers.CouponDefinitionCodePOMapper;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(value={"spring.application.name"}, havingValue="coupon")
@RocketMQMessageListener(topic="COUPON_OFFLINE_CREATE")
public class MqCouponOfflineCreate
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(MqCouponOfflineCreate.class);
    private static final Logger logger = LoggerFactory.getLogger(MqCouponOfflineCreate.class);
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CouponDefinitionCodePOMapper couponDefinitionCodePOMapper;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    @Value(value="${hongqignting.sysBrandId.zhiying:}")
    private Long sysBrandIdZhiying;
    @Value(value="${hongqignting.sysBrandId.jiameng:}")
    private Long sysBrandJiameng;
    @Value(value="${hongqignting.orgCode.zhiying:}")
    private String orgCodeZhiying;
    @Value(value="${hongqignting.orgCode.jiameng:}")
    private String orgCodeJiameng;

    public Long findBrandId(String brandCode, String companyCode) {
        if (companyCode == null) {
            logger.info("\u4f01\u4e1a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BizException(-1, "\u4f01\u4e1a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyCacheDto companyCache = this.iRedisCacheService.getCompanyCache(companyCode);
        if (companyCache == null) {
            logger.info("\u4f01\u4e1a\u7f16\u53f7\u4e0d\u5b58\u5728");
            throw new BizException(-1, "\u4f01\u4e1a\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        SysBrandPo brandPo = new SysBrandPo();
        brandPo.setBrandCode(brandCode);
        brandPo.setSysCompanyId(companyCache.getCompanyId());
        ResponseData brandResult = this.brandServiceRpc.getBrandIdByCode(brandPo);
        return (Long)brandResult.getData();
    }

    public List<CouponDefinitionPO> findCouponDefinition(Long brandId, String couponDefinitionCode) {
        CouponDefinitionPOExample example = new CouponDefinitionPOExample();
        example.createCriteria().andErpCouponDefinitionCodeEqualTo(couponDefinitionCode).andCouponDefinitionTypeEqualTo(Byte.valueOf((byte)2)).andSysBrandIdEqualTo(brandId).andStatusEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List definitionPOList = this.couponDefinitionPOMapper.selectByExample(example);
        return definitionPOList;
    }

    public void onMessage(ConsumerMessage<String> message) {
        String messageContent = (String)message.getMessage();
        logger.info("enter MqCouponOfflineCreate consumer method! value:{}", (Object)messageContent);
        if (StringUtils.isBlank((CharSequence)messageContent)) {
            logger.info(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageContent);
        CouponOfflineCreateResponseVO offlineVO = (CouponOfflineCreateResponseVO)JSONObject.toJavaObject((JSON)jsonObject, CouponOfflineCreateResponseVO.class);
        if (StringUtils.isBlank((CharSequence)offlineVO.getBrandCode())) {
            logger.info("enter MqCouponOfflineCreate consumer method ! brandCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        if (StringUtils.isBlank((CharSequence)offlineVO.getCouponCode())) {
            logger.info("enter MqCouponOfflineCreate consumer method ! couponCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        if (StringUtils.isBlank((CharSequence)offlineVO.getCouponDefinitioncode())) {
            logger.info("enter MqCouponOfflineCreate consumer method ! couponDefinitionCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        Long brandId = this.findBrandId(offlineVO.getBrandCode(), offlineVO.getCompanyCode());
        List definitionList = this.findCouponDefinition(brandId, offlineVO.getCouponDefinitioncode());
        CouponDefinitionCodePO couponDefinitionCodePO = new CouponDefinitionCodePO();
        CouponDefinitionPO definitionPO = new CouponDefinitionPO();
        if (CollectionUtils.isEmpty((Collection)definitionList)) {
            logger.warn("enter MqCouponOfflineCreate consumer method ! definitionList is null!" + offlineVO.getCouponDefinitioncode());
            return;
        }
        couponDefinitionCodePO.setStatusCode(Boolean.valueOf(true));
        definitionPO = (CouponDefinitionPO)definitionList.get(0);
        Long companyId = null;
        if (StringUtils.isNotBlank((CharSequence)offlineVO.getCompanyCode())) {
            CompanyCacheDto companyCache = this.iRedisCacheService.getCompanyCache(offlineVO.getCompanyCode());
            companyId = companyCache.getCompanyId();
        }
        couponDefinitionCodePO.setSysCompanyId(companyId);
        couponDefinitionCodePO.setSysBrandId(brandId);
        couponDefinitionCodePO.setBrandCode(offlineVO.getBrandCode());
        couponDefinitionCodePO.setCouponCode(offlineVO.getCouponCode());
        couponDefinitionCodePO.setCouponDefinitionId(definitionPO.getCouponDefinitionId());
        couponDefinitionCodePO.setErpCouponDefinitionCode(offlineVO.getCouponDefinitioncode());
        couponDefinitionCodePO.setCouponName(definitionPO.getCouponName());
        couponDefinitionCodePO.setPreferentialType(definitionPO.getPreferentialType());
        couponDefinitionCodePO.setCreateDate(new Date());
        couponDefinitionCodePO.setValid(Boolean.valueOf(true));
        couponDefinitionCodePO.setUsePassword(offlineVO.getUsePassWord());
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            couponDefinitionCodePO.setValidDateStart(dateFormat.parse(offlineVO.getCouponStartDate()));
            couponDefinitionCodePO.setValidDateEnd(dateFormat.parse(offlineVO.getCouponEndDate()));
            couponDefinitionCodePO.setModifiedDate(dateFormat.parse(offlineVO.getOfflineUpdateDate()));
        }
        catch (Exception e) {
            logger.info(SysResponseEnum.DATE_TRANSFER_EXCEPTION.getMessage());
        }
        CouponDefinitionCodePOExample couponExample = new CouponDefinitionCodePOExample();
        CouponDefinitionCodePOExample.Criteria criteria = couponExample.createCriteria();
        criteria.andCouponCodeEqualTo(couponDefinitionCodePO.getCouponCode());
        List couponDefinitionCodePOList = this.couponDefinitionCodePOMapper.selectByExample(couponExample);
        if (CollectionUtils.isNotEmpty((Collection)couponDefinitionCodePOList)) {
            logger.warn("MqCouponOfflineCreate selectByExample error ! " + couponDefinitionCodePO.getCouponCode() + " already exists!");
            return;
        }
        try {
            this.couponDefinitionCodePOMapper.insertSelective(couponDefinitionCodePO);
        }
        catch (Exception e) {
            logger.warn("MqCouponOfflineCreate insertSelective error ! " + (e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
            return;
        }
        try {
            int count = this.couponDefinitionCodePOMapper.selectCountTable(couponDefinitionCodePO);
            if (count > 0) {
                this.couponDefinitionCodePOMapper.updateCountTable(couponDefinitionCodePO);
            } else {
                this.couponDefinitionCodePOMapper.insertCountTable(couponDefinitionCodePO);
            }
        }
        catch (Exception e) {
            String msg = e.getCause().getMessage();
            if (msg.startsWith("Duplicate entry") && msg.endsWith("for key 'coupon_definition_id'")) {
                this.couponDefinitionCodePOMapper.updateCountTable(couponDefinitionCodePO);
            }
            logger.warn("MqCouponOfflineCreate countTable error ! " + (e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
        }
    }
}

