/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.kafka.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.baisonBase.facade.models.mj.MjCouponUseRequestVo;
import com.bizvane.baisonBase.facade.rpc.MjMemberServiceNewRpc;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.vo.CouponOfflineUseResponseVO;
import com.bizvane.couponservice.common.config.Mj2Config;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.datavo.YouzanCouponBO;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.ThirdBusinessService;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.thirddock.service.rpc.YouzanCouponServiceRpc;
import com.bizvane.thirdrouting.bo.AsynBO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(value={"spring.application.name"}, havingValue="coupon")
@RocketMQMessageListener(topic="ALL_COUPON_OFFLINE_USE")
public class MqAllCouponOfflineUse
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(MqAllCouponOfflineUse.class);
    private static final Logger logger = LoggerFactory.getLogger(MqAllCouponOfflineUse.class);
    @Autowired
    private CouponEntityPOMapper couponEntityPoMapper;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private ThirdBusinessService thirdBusinessService;
    @Autowired
    private IRedisCacheService iRedisCacheService;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;
    @Autowired
    private Mj2Config mj2Config;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MjMemberServiceNewRpc mjMemberServiceNewRpc;
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private YouzanCouponServiceRpc youzanCouponServiceRpc;

    public Long findCompanyId(String companyCode) {
        CompanyCacheDto companyCache = this.iRedisCacheService.getCompanyCache(companyCode);
        return companyCache.getCompanyId();
    }

    public void onMessage(ConsumerMessage<String> message) {
        ResponseData sysStorePoResponseData;
        String messageContent = (String)message.getMessage();
        logger.info("enter MqAllCouponOfflineUse consumer method! value:{}", (Object)messageContent);
        if (StringUtils.isBlank((CharSequence)messageContent)) {
            logger.info(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageContent);
        CouponOfflineUseResponseVO offlineVO = (CouponOfflineUseResponseVO)JSONObject.toJavaObject((JSON)jsonObject, CouponOfflineUseResponseVO.class);
        if (StringUtils.isBlank((CharSequence)offlineVO.getCouponCode())) {
            logger.info("enter MqAllCouponOfflineUse consumer method ! CouponCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        if (StringUtils.isBlank((CharSequence)offlineVO.getCompanyCode())) {
            logger.info("enter MqAllCouponOfflineUse consumer method ! getCompanyCode is null!" + JSONObject.toJSONString((Object)offlineVO));
            return;
        }
        Long findCompanyId = this.findCompanyId(offlineVO.getCompanyCode());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponEntityPOExample entityExample = new CouponEntityPOExample();
        entityExample.createCriteria().andCouponCodeEqualTo(offlineVO.getCouponCode()).andSysCompanyIdEqualTo(findCompanyId);
        List entityPoList = this.couponEntityPoMapper.selectByExample(entityExample);
        if (CollectionUtils.isEmpty((Collection)entityPoList)) {
            logger.info("enter MqAllCouponOfflineUse consumer method ! CouponEntityPO is null!" + JSONObject.toJSONString((Object)entityPoList));
            return;
        }
        CouponEntityPO entityPo = (CouponEntityPO)entityPoList.get(0);
        if (entityPo.getCouponStatus().equals(SystemConstants.COUPON_STATUS_USED)) {
            logger.info("Coupon is used" + JSONObject.toJSONString((Object)entityPo));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)offlineVO.getUseStoreCode()) && (sysStorePoResponseData = this.storeServiceRpc.getStoreInfoByCodeAndSysCompanyId(offlineVO.getUseStoreCode(), findCompanyId)) != null && SysResponseEnum.SUCCESS.getCode() == sysStorePoResponseData.getCode()) {
            entityPo.setUseStoreId(((SysStorePo)sysStorePoResponseData.getData()).getStoreId());
        }
        entityPo.setUseBusinessCode(offlineVO.getUseBusinessCode());
        entityPo.setUseBusinessAmount(offlineVO.getUseBusinessAmount());
        try {
            if (offlineVO.getUseTime() != null) {
                entityPo.setUseTime(dateFormat.parse(offlineVO.getUseTime()));
            }
        }
        catch (Exception e) {
            logger.info(SysResponseEnum.DATE_TRANSFER_EXCEPTION.getMessage());
        }
        entityPo.setCouponStatus(SystemConstants.COUPON_STATUS_USED);
        entityPo.setIsUse(SystemConstants.COUPON_DEFINITION_STATUS_USE);
        entityPo.setModifiedDate(new Date());
        this.couponEntityPoMapper.updateByExampleSelective(entityPo, entityExample);
        try {
            AsynBO asynBO = new AsynBO(entityPo.getSysCompanyId(), entityPo.getSysBrandId(), "couponUsed", JSON.toJSONString((Object)entityPo));
            this.thirdBusinessService.asyn(asynBO);
        }
        catch (Exception e) {
            logger.error("addOrUpdateYzCouponDefinition thirdBusinessService.asyn e {}", (Throwable)e);
        }
        CouponDefinitionPOWithBLOBs couponDefinitionPOWithBLOBs = this.couponDefinitionPOMapper.selectByPrimaryKey(Long.valueOf(entityPo.getCouponDefinitionId()));
        YouzanCouponBO youzanCouponBO = this.couponEntityService.isSyncYouzan(entityPo.getSysBrandId().longValue(), entityPo, couponDefinitionPOWithBLOBs);
        if (youzanCouponBO != null) {
            try {
                logger.info("youzanCouponServiceRpc.couponUse\u5165\u53c2\uff1a{}", (Object)offlineVO.getCouponCode());
                Boolean youzanResult = (Boolean)this.youzanCouponServiceRpc.couponUse(entityPo.getSysBrandId(), offlineVO.getCouponCode()).getData();
                logger.info("youzanCouponServiceRpc.couponUse:" + offlineVO.getCouponCode());
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u6709\u8d5e\u5238\u5b9e\u4f8b\u62a5\u9519 e {}", (Throwable)e);
            }
        }
        if (this.mj2Config.isSyncMj(entityPo.getSysCompanyId().longValue(), couponDefinitionPOWithBLOBs.getUseChannel())) {
            MemberInfoModel memberInfoModelParam = new MemberInfoModel();
            memberInfoModelParam.setMemberCode(entityPo.getMemberCode());
            MemberInfoModel member = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModelParam).getData();
            String cardNo = member.getCardNo();
            String name = member.getName();
            entityPo.setStaffCode(member.getServiceGuideCode());
            MjCouponUseRequestVo mjCouponUseRequestVo = new MjCouponUseRequestVo(cardNo, name, entityPo);
            log.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:{}" + JSON.toJSONString((Object)mjCouponUseRequestVo));
            boolean syncResult = (Boolean)this.mjMemberServiceNewRpc.couponUse(mjCouponUseRequestVo).getTData();
            log.info("\u68a6\u6d01\u540c\u6b65\u53d1\u5238:" + syncResult);
        }
        if (entityPo.getSendType().equals(SendTypeEnum.SEND_COUPON_BATCH.getCode())) {
            BigDecimal useBusinessAmount = null;
            if (null != offlineVO.getUseBusinessAmount()) {
                useBusinessAmount = offlineVO.getUseBusinessAmount();
            }
            this.couponManualService.updateCouponManualCount(entityPo.getUseStoreId(), entityPo.getSendBusinessId(), useBusinessAmount, offlineVO.getDiscountMoney());
        }
    }
}

