/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.kafka.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.vo.CouponReversalRequestVO;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.redis.canal.dto.CompanyCacheDto;
import com.bizvane.redis.canal.service.IRedisCacheService;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(value={"spring.application.name"}, havingValue="coupon")
@RocketMQMessageListener(topic="ALL_COUPON_OFFLINE_REVERSAL")
public class MqAllCouponOfflineReversal
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(MqAllCouponOfflineReversal.class);
    @Autowired
    private IRedisCacheService iRedisCacheService;
    @Autowired
    private CouponService couponService;

    public void onMessage(ConsumerMessage<String> message) {
        String messageContent = (String)message.getMessage();
        log.info("MqAllCouponOfflineReversal\u6d88\u8d39,topic:{},mesgId:{},messageContent:{}", new Object[]{message.getTopic(), message.getMsgId(), messageContent});
        if (StringUtils.isBlank((CharSequence)messageContent)) {
            log.info("MqAllCouponOfflineReversal\u6d88\u8d39,\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        JSONObject couponReversalRequestVOJson = JSON.parseObject((String)messageContent);
        CouponReversalRequestVO couponReversalRequestVO = (CouponReversalRequestVO)couponReversalRequestVOJson.toJavaObject(CouponReversalRequestVO.class);
        if (couponReversalRequestVO == null) {
            log.info("MqAllCouponOfflineReversal\u6d88\u8d39,\u53cd\u5e8f\u5217\u5316\u540ecouponReversalRequestVO\u5bf9\u8c61\u5185\u5bb9\u4e3a\u7a7a,\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        if (StringUtils.isBlank((CharSequence)couponReversalRequestVO.getBrandCode())) {
            log.info("MqAllCouponOfflineReversal\u6d88\u8d39,\u54c1\u724ccode\u4e3a\u7a7a,\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        if (StringUtils.isBlank((CharSequence)couponReversalRequestVO.getCouponCode())) {
            log.info("MqAllCouponOfflineReversal\u6d88\u8d39,couponCode\u4e3a\u7a7a,\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        String companyCode = couponReversalRequestVOJson.getString("companyCode");
        if (StringUtils.isBlank((CharSequence)companyCode)) {
            log.info("MqAllCouponOfflineReversal\u6d88\u8d39,companyCode\u4e3a\u7a7a,\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        CompanyCacheDto companyCache = this.iRedisCacheService.getCompanyCache(companyCode);
        couponReversalRequestVO.setSysCompanyId(companyCache.getCompanyId());
        ResponseData reversalRes = this.couponService.reversal(couponReversalRequestVO);
        log.info("MqAllCouponOfflineReversal\u6d88\u8d39,\u6d88\u8d39\u5b8c\u6210,reversalRes:{}", (Object)JacksonUtil.bean2Json((Object)reversalRes));
    }
}

