/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.utils.BarcodeUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/barcode"})
public class UtilsRpcController {
    @ApiOperation(value="\u751f\u6210\u6761\u5f62\u7801", notes="\u751f\u6210\u6761\u5f62\u7801", tags={"\u5176\u5b83\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getBarcode"})
    ResponseData<String> getBarcode(@RequestParam(value="msg", required=false) String msg) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)msg)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        String url = BarcodeUtil.generateBarCode((String)msg);
        responseData.setData((Object)url);
        return responseData;
    }

    @ApiOperation(value="\u751f\u6210\u4e8c\u7ef4\u7801", notes="\u751f\u6210\u4e8c\u7ef4\u7801", tags={"\u5176\u5b83\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getQRcode"})
    ResponseData<String> getQRcode(@RequestParam(value="msg", required=false) String msg) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)msg)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.SYSTEM_DATA_NOT_EMPTY.getMessage());
            return responseData;
        }
        String url = BarcodeUtil.generateQRCode((String)msg);
        responseData.setData((Object)url);
        return responseData;
    }
}

