/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.bo.CouponEntityAvailResponseBO;
import com.bizvane.couponfacade.models.bo.CouponOrderAvailableBO;
import com.bizvane.couponfacade.models.po.CouponOrderEntityPO;
import com.bizvane.couponfacade.models.vo.CouponOrderEntityVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.service.CouponVerifyService;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponVerify"})
public class CouponVerifyController {
    private static final Logger logger = LoggerFactory.getLogger(CouponVerifyController.class);
    @Autowired
    private CouponVerifyService couponVerifyService;

    @ApiOperation(value="\u6839\u636e\u6240\u4f20\u4f20\u6761\u4ef6\u5224\u65ad\u5238\u662f\u5426\u53ef\u7528", notes="\u6839\u636e\u6240\u4f20\u4f20\u6761\u4ef6\u5224\u65ad\u5238\u662f\u5426\u53ef\u7528", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    @RequestMapping(value={"verifyCouponRules"}, method={RequestMethod.POST})
    ResponseData<CouponOrderEntityVO> verifyCouponRules(@RequestBody CouponOrderEntityPO couponOrderEntity) {
        ResponseData result = new ResponseData();
        try {
            result = this.couponVerifyService.verifyCouponRules(couponOrderEntity);
        }
        catch (Exception e) {
            logger.error("verifyCouponRules Exception ! exception:{}", (Object)JSONObject.toJSONString((Object)e));
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return result;
    }

    @ApiOperation(value="\u6839\u636e\u6240\u4f20\u4f20\u6761\u4ef6\u8fd4\u56de\u5238\u5217\u8868", notes="\u6839\u636e\u6240\u4f20\u4f20\u6761\u4ef6\u8fd4\u56de\u5238\u5217\u8868", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    @RequestMapping(value={"mbrAvailableCouponList"}, method={RequestMethod.POST})
    ResponseData<PageInfo<CouponEntityAvailResponseBO>> mbrAvailableCouponList(@RequestBody CouponOrderAvailableBO bo) {
        logger.info("CouponVerifyController mbrAvailableCouponList param:{}", (Object)JSONObject.toJSONString((Object)bo));
        if (bo.getPageNo() == null || bo.getPageSize() == null) {
            bo.setPageNo(Integer.valueOf(1));
            bo.setPageSize(Integer.valueOf(10));
        }
        return this.couponVerifyService.mbrAvailableCouponList(bo);
    }
}

