/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.couponfacade.models.po.CouponQuotaDetailPO;
import com.bizvane.couponfacade.models.po.CouponQuotaSendDetailPO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDetailRespVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDetailVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponservice.service.CouponQuotaDetailService;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponQuotaDetailRpc"})
public class CouponQuotaDetailRpcController {
    private static final Logger logger = LoggerFactory.getLogger(CouponQuotaDetailRpcController.class);
    @Autowired
    private CouponQuotaDetailService couponQuotaDetailService;

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u5238\u7684\u53d1\u653e\u8bb0\u5f55\u5217\u8868", notes="\u5238\u7684\u53d1\u653e\u8bb0\u5f55\u5217\u8868", tags={"\u5238\u7684\u53d1\u653e\u8bb0\u5f55"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="memberCode", value="\u4f1a\u5458\u53f7", required=true, dataType="String"), @ApiImplicitParam(name="name", value="\u4f1a\u5458\u540d\u79f0", required=true, dataType="String"), @ApiImplicitParam(name="couponCode", value="\u5238\u53f7", required=true, dataType="String"), @ApiImplicitParam(name="couponName", value="\u5238\u540d\u79f0", required=true, dataType="String"), @ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7", required=true, dataType="String"), @ApiImplicitParam(name="couponStatus", value="20-\u672a\u4f7f\u7528\uff0c25-\u5df2\u8fc7\u671f\uff0c30-\u5df2\u6838\u9500,35-\u5df2\u4f5c\u5e9f", required=true, dataType="String"), @ApiImplicitParam(name="pageNumber", value="\u5f53\u524d\u9875\u6570", required=true, dataType="Integer"), @ApiImplicitParam(name="pageSize", value="\u663e\u793a\u6761\u6570", required=true, dataType="Integer"), @ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=true, dataType="Integer")})
    @PostMapping(value={"/getList"})
    ResponseData<PageInfo<CouponEntityVO>> getList(@RequestBody(required=false) CouponEntityVO vo) {
        SysAccountPo accountPo = new SysAccountPo();
        accountPo.setBrandId(vo.getSysBrandId());
        PageFormUtil pageForm = new PageFormUtil();
        pageForm.setPageNumber(vo.getPageNumber());
        pageForm.setPageSize(vo.getPageSize());
        if (vo.getDifferentBrand() != null && vo.getDifferentBrand() == 1) {
            return this.couponQuotaDetailService.getDifferentBrandList(vo, pageForm);
        }
        return this.couponQuotaDetailService.getList(vo, accountPo, pageForm);
    }

    @ApiOperation(value="\u67e5\u8be2\u6211\u7684\uff08\u5bfc\u8d2d/\u5e97\u957f\uff09\u53ef\u53d1\u9001\u4f18\u60e0\u5238\u5217\u8868\u63a5\u53e3\u8be6\u60c5\u5217\u8868", notes="\u67e5\u8be2\u6211\u7684\uff08\u5bfc\u8d2d/\u5e97\u957f\uff09\u53ef\u53d1\u9001\u4f18\u60e0\u5238\u5217\u8868\u63a5\u53e3\u8be6\u60c5\u5217\u8868", tags={"\u8be6\u60c5\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="staffcode", value="\u5458\u5de5\u7f16\u53f7", required=true, dataType="Long"), @ApiImplicitParam(name="pageNumber", value="\u5f53\u524d\u9875\u6570", required=true, dataType="Integer"), @ApiImplicitParam(name="pageSize", value="\u663e\u793a\u6761\u6570", required=true, dataType="Integer"), @ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=true, dataType="Long")})
    @PostMapping(value={"/getCouponQuotaListDetail"})
    ResponseData<PageInfo<CouponQuotaDetailRespVO>> getCouponQuotaListDetail(@RequestBody(required=false) CouponQuotaDetailVO vo) {
        SysAccountPo accountPo = new SysAccountPo();
        accountPo.setBrandId(vo.getSysBrandId());
        PageFormUtil pageForm = new PageFormUtil();
        pageForm.setPageNumber(vo.getPageNumber());
        pageForm.setPageSize(vo.getPageSize());
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        vo.setExtendNote(dateString);
        return this.couponQuotaDetailService.getCouponQuotaListForStaff(vo, accountPo, pageForm);
    }

    @ApiOperation(value="\u6211\u7684\u4f18\u60e0\u5238\u7fa4\u53d1\u8be6\u60c5", notes="\u4f18\u60e0\u5238\u7fa4\u53d1\u8be6\u60c5", tags={"\u5238\u7684\u914d\u989d\u8bb0\u5f55\u8be6\u60c5\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponQuotaDetailId", value="\u54c1\u724cid", required=true, dataType="Long")})
    @PostMapping(value={"/getSendCouponQuotaListDetailOne"})
    ResponseData<CouponQuotaDetailPO> getSendCouponQuotaListDetailOne(@RequestBody(required=false) CouponQuotaDetailVO vo) {
        return this.couponQuotaDetailService.getCouponQuotaListDetail(vo);
    }

    @ApiOperation(value="\u6211\u7684\u4f18\u60e0\u5238\u7fa4\u53d1\u5386\u53f2", notes="\u6211\u7684\u4f18\u60e0\u5238\u7fa4\u53d1\u5386\u53f2", tags={"\u6211\u7684\u4f18\u60e0\u5238\u7fa4\u53d1\u5386\u53f2"}, httpMethod="POST")
    @PostMapping(value={"/getSendCouponQuotaListDetail"})
    ResponseData<PageInfo<CouponQuotaSendDetailPO>> getSendCouponQuotaListDetail(@RequestBody(required=false) CouponQuotaDetailVO vo) {
        SysAccountPo accountPo = new SysAccountPo();
        accountPo.setBrandId(vo.getSysBrandId());
        PageFormUtil pageForm = new PageFormUtil();
        pageForm.setPageNumber(vo.getPageNumber());
        pageForm.setPageSize(vo.getPageSize());
        return this.couponQuotaDetailService.getSendCouponQuotaListDetail(vo, accountPo, pageForm);
    }
}

