/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.CouponByTransferVO;
import com.bizvane.couponfacade.models.vo.CouponDetailModelVO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponFindCouponCountResponseVO;
import com.bizvane.couponfacade.models.vo.CouponInfoVo;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponSevenDaysDataVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponQueryRpc"})
public class CouponQueryRpcController {
    private static Logger logger = LoggerFactory.getLogger(CouponQueryRpcController.class);
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CouponEntityService couponEntityService;

    @ApiOperation(value="\u6839\u636ebrandCode\u548ccouponDefinitionId/erpCouponDefinitionCode\u67e5\u8be2\u5238\u5b9a\u4e49\u63a5\u53e3", notes="\u6839\u636ebrandCode\u548ccouponDefinitionId/erpCouponDefinitionCode\u67e5\u8be2\u5238\u5b9a\u4e49\u63a5\u53e3", tags={"\u5238\u5b9a\u4e49\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getCouponDefinitionByIdOrCode"})
    ResponseData<CouponDetailResponseVO> getCouponDefinitionByIdOrCode(@RequestParam(value="couponDefinitionId", required=false) Long couponDefinitionId, @RequestParam(value="erpCouponDefinitionCode", required=false) String erpCouponDefinitionCode, @RequestParam(value="brandCode", required=false) String brandCode) {
        logger.info("enter getCouponDefinitionByIdOrCode method param:brandCode:{},couponDefinitionId:{},erpCouponDefinitionCode\uff1a{}", new Object[]{brandCode, couponDefinitionId, erpCouponDefinitionCode});
        if (StringUtils.isBlank((CharSequence)erpCouponDefinitionCode)) {
            return this.couponEntityService.findCouponDefinitionByCouponDefinitionId(brandCode, couponDefinitionId);
        }
        return this.couponEntityService.findCouponDefinitionByErpCouponDefinitionCode(brandCode, erpCouponDefinitionCode);
    }

    private Long getBrandId(SysCompanyPo sysCompanyPo, String brandCode) {
        SysBrandPo brandPo = new SysBrandPo();
        brandPo.setBrandCode(brandCode);
        brandPo.setSysCompanyId(sysCompanyPo.getSysCompanyId());
        ResponseData responseData = this.brandServiceRpc.getBrandIdByCode(brandPo);
        Assert.isTrue((SysResponseEnum.SUCCESS.getCode() == responseData.getCode() ? 1 : 0) != 0, (String)"\u83b7\u53d6\u4e0d\u5230\u6b63\u786e\u7684\u54c1\u724c\u4fe1\u606f");
        Assert.notNull((Object)responseData.getData(), (String)"\u83b7\u53d6\u4e0d\u5230\u6b63\u786e\u7684\u54c1\u724c\u4fe1\u606f");
        return (Long)responseData.getData();
    }

    @ApiOperation(value="\u6839\u636ememberCode\u67e5\u8be2\u5238\u5b9e\u4f8b\u63a5\u53e3", notes="\u6839\u636ememberCode\u67e5\u8be2\u5238\u5b9e\u4f8b\u63a5\u53e3", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getCouponListRpc"})
    ResponseData<PageInfo<CouponEntityAndDefinitionVO>> getCouponListByMemeberCode(@RequestBody CouponListByMemberCodeRequestVO vo) {
        PageFormUtil pageFormUtil = new PageFormUtil();
        if (vo.getPageNumber() == null || vo.getPageSize() == null) {
            vo.setPageNumber(Integer.valueOf(1));
            vo.setPageSize(Integer.valueOf(20));
        }
        pageFormUtil.setPageNumber(vo.getPageNumber());
        pageFormUtil.setPageSize(vo.getPageSize());
        return this.couponService.getCouponListByMemeberCode(vo, pageFormUtil);
    }

    @ApiOperation(value="\u67e5\u8be2\u67d0\u4e2a\u4f1a\u5458\u62e5\u6709\u7684\u5238", notes="\u67e5\u8be2\u67d0\u4e2a\u4f1a\u5458\u62e5\u6709\u7684\u5238", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getMemberCoupon"})
    ResponseData<List<CouponEntityAndDefinitionVO>> getMemberCoupon(@RequestBody CouponListByMemberCodeRequestVO vo) {
        if (vo.getPageSize() == null || vo.getPageNumber() == null) {
            vo.setPageSize(Integer.valueOf(20));
            vo.setPageNumber(Integer.valueOf(1));
        }
        return this.couponService.getMemberCoupon(vo);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u67d0\u4e2a\u4f1a\u5458\u62e5\u6709\u7684\u5238", notes="\u67e5\u8be2\u67d0\u4e2a\u4f1a\u5458\u62e5\u6709\u7684\u5238", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/pageListByMemberCode"})
    ResponseData<PageInfo<CouponEntityAndDefinitionVO>> pageListByMemberCode(@RequestBody CouponListByMemberCodeRequestVO vo) {
        return this.couponService.pageListByMemberCode(vo);
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5238\u5b9e\u4f8b\u63a5\u53e3", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5238\u5b9e\u4f8b\u63a5\u53e3", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=true, dataType="Long")})
    @PostMapping(value={"/getListRpc"})
    ResponseData<PageInfo<CouponEntityVO>> getListRpc(@RequestBody CouponEntityVO vo) {
        PageFormUtil pageForm = new PageFormUtil();
        pageForm.setPageNumber(vo.getPageNumber());
        pageForm.setPageSize(vo.getPageSize());
        return this.couponEntityService.getListRpc(vo, pageForm);
    }

    @ApiOperation(value="\u6839\u636e\u5238\u53f7\u83b7\u53d6\u5238\u5b9e\u4f8b\u63a5\u53e3", notes="\u6839\u636e\u5238\u53f7\u83b7\u53d6\u5238\u5b9e\u4f8b\u63a5\u53e3", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/findCouponRpc/{couponCode}"})
    ResponseData<CouponDetailModelVO> findCouponByCouponCode(@PathVariable(value="couponCode") String couponCode) {
        return this.couponService.findCouponByCouponCode(couponCode);
    }

    @PostMapping(value={"/findCouponDetailRpc"})
    ResponseData<CouponDetailResponseVO> findCouponDetailByCouponCode(@RequestParam(value="couponCode", required=false) String couponCode, @RequestParam(value="brandId", required=false) Long brandId) {
        return this.couponService.findCouponDetailByCouponCode(couponCode, brandId);
    }

    @ApiOperation(value="\u6839\u636e\u4f1a\u5458code\u7edf\u8ba1\u4f7f\u7528\u72b6\u51b5", notes="\u6839\u636e\u4f1a\u5458code\u7edf\u8ba1\u4f7f\u7528\u72b6\u51b5", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="memberCode", value="\u4f1a\u5458\u53f7", required=false, dataType="String")})
    @PostMapping(value={"/findCountByMemberCode"})
    public ResponseData<CouponFindCouponCountResponseVO> findCouponCountByMemberCode(@RequestParam(value="memberCode", required=false) String memberCode) {
        logger.info("enter findCouponCountByMemberCode method param:memberCode:{}", (Object)memberCode);
        ResponseData responseData = this.couponService.findCouponCountByMemberCode(memberCode);
        return responseData;
    }

    @ApiOperation(value="\u6839\u636esendBusinessId\u548c\u65f6\u95f4\u7edf\u8ba1\u5238\u7684\u4f7f\u7528\u72b6\u51b5", notes="\u6839\u636esendBusinessId\u7edf\u8ba1\u5238\u7684\u4f7f\u7528\u72b6\u51b5", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sendBusinessId", value="\u53d1\u5238\u4e1a\u52a1\u5355\u53f7", required=false, dataType="Long"), @ApiImplicitParam(name="sendType", value="\u4e1a\u52a1\u7c7b\u578b", required=false, dataType="String"), @ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=false, dataType="Long"), @ApiImplicitParam(name="dtStart", value="\u5f00\u59cb\u65f6\u95f4", required=false, dataType="Date"), @ApiImplicitParam(name="dtEnd", value="\u7ed3\u675f\u65f6\u95f4", required=false, dataType="Date")})
    @PostMapping(value={"/findCouponCountByDate"})
    ResponseData<CouponFindCouponCountResponseVO> findCouponCountByDate(@RequestBody CouponEntityVO vo) {
        logger.info("enter findCouponCountBySendBusinessId method param:CouponEntityVO:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = this.couponService.findCouponCountByDate(vo);
        return responseData;
    }

    @ApiOperation(value="\u7edf\u8ba1\u5238\u4f7f\u7528\u72b6\u51b5", notes="\u7edf\u8ba1\u5238\u4f7f\u7528\u72b6\u51b5", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sendBusinessId", value="\u53d1\u5238\u4e1a\u52a1\u5355\u53f7", required=false, dataType="Long"), @ApiImplicitParam(name="sendType", value="\u53d1\u9001\u7c7b\u578b", required=false, dataType="String"), @ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=false, dataType="Long")})
    @PostMapping(value={"/findCouponCountBySendBusinessId"})
    ResponseData<CouponFindCouponCountResponseVO> findCouponCountBySendBusinessId(@RequestParam(value="sendBusinessId", required=false) Long sendBusinessId, @RequestParam(value="sendType", required=false) String sendType, @RequestParam(value="sysBrandId", required=false) Long sysBrandId) {
        logger.info("enter findCouponCountBySendBusinessId method param:sendBusinessId:{},sendType:{},sysBrandId:{}", new Object[]{sendBusinessId, sendType, sysBrandId});
        ResponseData responseData = this.couponService.findCouponCountBySendBusinessId(sendBusinessId, sendType, sysBrandId);
        return responseData;
    }

    @ApiOperation(value="\u7edf\u8ba1\u5238\u4f7f\u7528\u72b6\u51b5\u4f9b\u8425\u9500\u770b\u677f\u4f7f\u7528", notes="\u7edf\u8ba1\u5238\u4f7f\u7528\u72b6\u51b5\u4f9b\u8425\u9500\u770b\u677f\u4f7f\u7528", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sendBusinessId", value="\u53d1\u5238\u4e1a\u52a1\u5355\u53f7", required=false, dataType="Long"), @ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=false, dataType="Long")})
    @RequestMapping(value={"/findCouponCountForMktScreen"}, method={RequestMethod.POST})
    ResponseData<CouponFindCouponCountResponseVO> findCouponCountForMktScreen(@RequestParam(value="sendBusinessId", required=false) Long sendBusinessId, @RequestParam(value="sysBrandId", required=false) Long sysBrandId, @RequestParam(value="sysCompanyId", required=false) Long sysCompanyId, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime) {
        logger.info("enter findCouponCountForMktScreen method param:sendBusinessId:{},sysBrandId:{},sysCompanyId:{},startTime:{},endTime:{}", new Object[]{sendBusinessId, sysBrandId, sysCompanyId, startTime, endTime});
        ResponseData responseData = this.couponService.findCouponCountForMktScreen(sendBusinessId, sysBrandId, sysCompanyId, startTime, endTime);
        return responseData;
    }

    @ApiOperation(value="\u7edf\u8ba1\u5238\u524d\u4e03\u65e5\u4f7f\u7528\u72b6\u51b5\u4f9b\u8425\u9500\u770b\u677f\u4f7f\u7528", notes="\u7edf\u8ba1\u5238\u524d\u4e03\u65e5\u4f7f\u7528\u72b6\u51b5\u4f9b\u8425\u9500\u770b\u677f\u4f7f\u7528", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @RequestMapping(value={"/findCouponCountSevenForMktScreen"}, method={RequestMethod.POST})
    ResponseData<List<CouponSevenDaysDataVO>> findCouponCountSevenForMktScreen(@RequestParam(value="sysBrandId", required=false) Long sysBrandId, @RequestParam(value="sysCompanyId", required=false) Long sysCompanyId, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="type", required=false) String type) {
        logger.info("enter findCouponCountSevenForMktScreen method param:sysBrandId:{},sysCompanyId:{},startTime:{},endTime:{},type:{}", new Object[]{sysBrandId, sysCompanyId, startTime, endTime, type});
        ResponseData responseData = this.couponService.findCouponCountSevenForMktScreen(sysBrandId, sysCompanyId, startTime, endTime, type);
        return responseData;
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u5238\u4e1a\u52a1\u5355\u53f7\u96c6\u5408\u7edf\u8ba1\u5238\u7684\u4f7f\u7528\u72b6\u51b5", notes="\u6839\u636e\u53d1\u5238\u4e1a\u52a1\u5355\u53f7\u96c6\u5408\u7edf\u8ba1\u5238\u7684\u4f7f\u7528\u72b6\u51b5", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sendIdList", value="id\u96c6\u5408", required=true, dataType="List")})
    @PostMapping(value={"/findCouponCountByList"})
    ResponseData<CouponFindCouponCountResponseVO> findCouponCountByList(@RequestBody CouponEntityVO vo) {
        logger.info("enter findCouponCountByList method param:CouponEntityVO:{}", (Object)JSONObject.toJSONString((Object)vo));
        return this.couponService.findCouponCountByList(vo);
    }

    @ApiOperation(value="\u6839\u636e\u5238\u5b9e\u4f8bid\u67e5\u8be2\u5238\u8be6\u60c5", notes="\u6839\u636e\u5238\u5b9e\u4f8bid\u67e5\u8be2\u5238\u8be6\u60c5", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponEntityId", value="\u5238\u5b9e\u4f8bid", required=true, dataType="Long")})
    @PostMapping(value={"/getCouponDetailRpc"})
    ResponseData<CouponDetailResponseVO> getCouponDetail(@RequestParam(value="couponEntityId", required=false) Long couponEntityId) {
        logger.info("enter getCouponDetail method param:couponEntityId:{}", (Object)couponEntityId);
        return this.couponEntityService.getCouponEntityAndDefinitionByEntityId(couponEntityId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5238\u8be6\u60c5\uff08\u6839\u636e\u5b9e\u4f8bid\uff09", notes="\u67e5\u8be2\u5238\u8be6\u60c5\uff08\u6839\u636e\u5b9e\u4f8bid\uff09", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getAllDetailRpc"})
    ResponseData<CouponDetailResponseVO> getAllDetailRpc(@RequestParam(value="couponEntityId", required=false) Long couponEntityId) {
        logger.info("enter getAllDetailRpc method param:couponEntityId:{}", (Object)couponEntityId);
        return this.couponEntityService.getAllDetailRpc(couponEntityId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u5f20\u5238\u5b9a\u4e49\u4fe1\u606f", notes="\u67e5\u8be2\u5355\u5f20\u5238\u5b9a\u4e49\u4fe1\u606f", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getCouponDefinitionRpc"})
    ResponseData<CouponDetailResponseVO> getCouponDefinition(@RequestParam(value="couponDefinitionId", required=false) Long couponDefinitionId) {
        logger.info("enter getCouponDefinition method param:couponDefinitionId:{}", (Object)couponDefinitionId);
        return this.couponEntityService.getCouponDefinition(couponDefinitionId);
    }

    @ApiOperation(value="\u6839\u636e\u4f1a\u5458code\u67e5\u8be2\u53ef\u4f7f\u7528\u5238\u5217\u8868", notes="\u6839\u636e\u4f1a\u5458code\u67e5\u8be2\u53ef\u4f7f\u7528\u5238\u5217\u8868", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getCouponUnused"})
    ResponseData<List<CouponEntityPO>> getCouponUnusedByMemberCode(@RequestParam(value="memberCode") String memberCode) {
        logger.info("enter getCouponUnusedByMemberCode method param:memberCode:{}", (Object)memberCode);
        return this.couponService.getCouponUnusedByMemberCode(memberCode);
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u9001\u7c7b\u578b\uff08\u6d3b\u52a8\uff0c\u4efb\u52a1\uff09\u67e5\u8be2\u5238\u6570\u91cf", notes="\u6839\u636e\u53d1\u9001\u7c7b\u578b\uff08\u6d3b\u52a8\uff0c\u4efb\u52a1\uff09\u67e5\u8be2\u5238\u6570\u91cf", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getCountBySendType"})
    ResponseData<CouponFindCouponCountResponseVO> getCountBySendType(@RequestParam(value="sendType", required=false) String sendType, @RequestParam(value="sysBrandId", required=false) Long sysBrandId) {
        logger.info("enter getCountBySendType method param:sendType:{},sysBrandId:{}", (Object)sendType, (Object)sysBrandId);
        return this.couponService.getCountBySendType(sendType, sysBrandId);
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u9001\u7c7b\u578b\uff08\u6d3b\u52a8\uff0c\u4efb\u52a1\uff09\u67e5\u8be2\u5238\u6570\u91cf-\u7ec4\u7ec7\u9694\u79bb", notes="\u6839\u636e\u53d1\u9001\u7c7b\u578b\uff08\u6d3b\u52a8\uff0c\u4efb\u52a1\uff09\u67e5\u8be2\u5238\u6570\u91cf-\u7ec4\u7ec7\u9694\u79bb", tags={"\u5238\u67e5\u8be2\u63a5\u53e3-\u7ec4\u7ec7\u9694\u79bb"}, httpMethod="POST")
    @PostMapping(value={"/getCountBySendTypeNew"})
    ResponseData<CouponFindCouponCountResponseVO> getCountBySendTypeNew(@RequestParam(value="sendType", required=false) String sendType, @RequestParam(value="sysBrandId", required=false) Long sysBrandId, @RequestParam(value="organizationCode", required=false) String organizationCode) {
        logger.info("enter getCountBySendType method param:sendType:{},sysBrandId:{},organizationCode:{}", new Object[]{sendType, sysBrandId, organizationCode});
        try {
            return this.couponService.getCountBySendType(sendType, sysBrandId, organizationCode);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return new ResponseData(com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getCode(), com.bizvane.couponservice.common.constants.SysResponseEnum.FAILED.getMessage(), (Object)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53d7\u8d60\u4eba\u4fe1\u606f", notes="\u67e5\u8be2\u53d7\u8d60\u4eba\u4fe1\u606f", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/findTOMemberInfo"})
    ResponseData<WxChannelInfoVo> findTOMemberInfo(@RequestParam(value="fromOpenId", required=false) String fromOpenId, @RequestParam(value="couponCode", required=false) String couponCode, @RequestParam(value="sysBrandId", required=false) Long sysBrandId) {
        logger.info("enter findTOMemberInfo method param:fromOpenId:{},couponCode:{},sysBrandId:{}", new Object[]{fromOpenId, couponCode, sysBrandId});
        ResponseData responseData = this.couponService.findTOMemberInfo(fromOpenId, couponCode, sysBrandId);
        return responseData;
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u5238\u65f6\u95f4\u548c\u5238\u7c7b\u578b\u7edf\u8ba1\u5238\u4f7f\u7528\u72b6\u51b5", notes="\u6839\u636e\u53d1\u5238\u65f6\u95f4\u548c\u5238\u7c7b\u578b\u7edf\u8ba1\u5238\u4f7f\u7528\u72b6\u51b5", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sendType", value="\u53d1\u9001\u7c7b\u578b", required=false, dataType="String"), @ApiImplicitParam(name="createDate", value="\u53d1\u9001\u65f6\u95f4", required=false, dataType="String"), @ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=false, dataType="Long")})
    @PostMapping(value={"/findCountBySendType"})
    ResponseData<CouponFindCouponCountResponseVO> findCountBySendType(@RequestParam(value="sendType", required=false) String sendType, @RequestParam(value="createDate", required=false) String createDate, @RequestParam(value="sysBrandId", required=false) Long sysBrandId) {
        logger.info("enter findCouponCountBySendBusinessId method param:sendType:{},createDate:{},sysBrandId:{}", new Object[]{sendType, createDate, sysBrandId});
        ResponseData responseData = null;
        try {
            responseData = this.couponService.findCountBySendType(sendType, createDate, sysBrandId);
        }
        catch (Exception e) {
            logger.info(com.bizvane.couponservice.common.constants.SysResponseEnum.DATE_TRANSFER_EXCEPTION.getMessage());
        }
        return responseData;
    }

    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u4e1a\u52a1id\u548c\u4e1a\u52a1\u7c7b\u578b\u7edf\u8ba1\u5238\u7684\u4f7f\u7528\u72b6\u51b5", notes="\u6839\u636e\u591a\u4e2a\u4e1a\u52a1id\u548c\u4e1a\u52a1\u7c7b\u578b\u7edf\u8ba1\u5238\u7684\u4f7f\u7528\u72b6\u51b5", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sendType", value="\u53d1\u9001\u7c7b\u578b", required=false, dataType="String"), @ApiImplicitParam(name="createDate", value="\u53d1\u9001\u65f6\u95f4", required=false, dataType="String"), @ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=false, dataType="Long")})
    @PostMapping(value={"/findCouponCountBySendBusinessIdList"})
    ResponseData<CouponFindCouponCountResponseVO> findCouponCount(@RequestParam(value="sendBusinessId", required=false) List<String> sendBusinessId, @RequestParam(value="sendType", required=false) Byte sendType, @RequestParam(value="sysBrandId", required=false) Long sysBrandId) {
        logger.info("enter findCouponCount method param:sendType:{},sendBusinessId:{}", (Object)sendType, (Object)JSONObject.toJSONString(sendBusinessId));
        ResponseData responseData = this.couponService.findCouponCount(sendBusinessId, sendType, sysBrandId);
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u4f01\u4e1a\u5fae\u4fe1\u6838\u9500\u5238\u5386\u53f2", notes="\u67e5\u8be2\u4f01\u4e1a\u5fae\u4fe1\u6838\u9500\u5238\u5386\u53f2", tags={"\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchValue", value="\u67e5\u8be2", required=false, dataType="String")})
    @PostMapping(value={"/findQyCouponUseHistory"})
    ResponseData<PageInfo<CouponEntityVO>> findQyCouponUseHistory(@RequestParam(value="staffCode", required=false) String staffCode, @RequestParam(value="searchValue", required=false) String searchValue, @RequestParam(value="pageNumber", required=false) int pageNumber, @RequestParam(value="pageSize", required=false) int pageSize) {
        ResponseData responseData = this.couponService.findQyCouponUseHistory(staffCode, searchValue, pageNumber, pageSize);
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u4f01\u4e1a\u5fae\u4fe1\u6838\u9500\u5238\u5386\u53f2", notes="\u67e5\u8be2\u4f01\u4e1a\u5fae\u4fe1\u6838\u9500\u5238\u5386\u53f2", tags={"\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchValue", value="\u67e5\u8be2", required=false, dataType="String")})
    @PostMapping(value={"/findQyCouponUseHistoryNew"})
    ResponseData<PageInfo<CouponEntityVO>> findQyCouponUseHistoryNew(@RequestParam(value="staffCode", required=false) String staffCode, @RequestParam(value="sysBrandId", required=false) Long sysBrandId, @RequestParam(value="searchValue", required=false) String searchValue, @RequestParam(value="pageNumber", required=false) int pageNumber, @RequestParam(value="pageSize", required=false) int pageSize) {
        ResponseData responseData = this.couponService.findQyCouponUseHistoryNew(staffCode, sysBrandId, searchValue, pageNumber, pageSize);
        return responseData;
    }

    @PostMapping(value={"/findCouponInfoRpc"})
    ResponseData<CouponInfoVo> findCouponInfoRpc(@RequestParam(value="couponCode", required=false) String couponCode, @RequestParam(value="brandId", required=false) Long brandId) {
        return this.couponService.findCouponInfoRpc(couponCode, brandId);
    }

    @PostMapping(value={"/findCouponInfoByCompanyIdRpc"})
    ResponseData<CouponInfoVo> findCouponInfoByCompanyIdRpc(@RequestParam(value="couponCode", required=false) String couponCode, @RequestParam(value="sysCompanyId", required=false) Long sysCompanyId) {
        return this.couponService.findCouponInfoByCompanyIdRpc(couponCode, sysCompanyId);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5238\u5b9e\u4f8b\u548c\u5238\u5b9a\u4e49\u8be6\u60c5", notes="\u5206\u9875\u67e5\u8be2\u5238\u5b9e\u4f8b\u548c\u5238\u5b9a\u4e49\u8be6\u60c5", tags={"\u5238\u67e5\u8be2\u63a5\u53e3"}, httpMethod="POST")
    @RequestMapping(value={"/pageListInfoByCondition"}, method={RequestMethod.POST})
    ResponseData<PageInfo<CouponInfoVo>> pageListInfoByCondition(@RequestBody CouponEntityVO requestVO) {
        return this.couponService.pageListInfoByCondition(requestVO);
    }

    @PostMapping(value={"/getCouponListByTransfer"})
    ResponseData<PageInfo<CouponByTransferVO>> getCouponListByTransfer(@RequestBody CouponListByMemberCodeRequestVO vo) {
        logger.info("CouponQueryRpcController getCouponListByTransfer params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        if (vo.getPageNumber() == null || vo.getPageSize() == null) {
            vo.setPageNumber(Integer.valueOf(1));
            vo.setPageSize(Integer.valueOf(20));
        }
        return this.couponService.getCouponListByTransfer(vo);
    }

    @PostMapping(value={"/getIsCouponRecordBack"})
    ResponseData<Boolean> getIsCouponRecordBack(@RequestBody CouponEntityVO vo) {
        logger.info("CouponQueryRpcController getIsCouponRecordBack params:{}", (Object)JSONObject.toJSONString((Object)vo));
        return this.couponService.getIsCouponRecordBack(vo);
    }

    @GetMapping(value={"/findCountByMemberCodeAndStatus"})
    ResponseData<Long> findCountByMemberCodeAndStatus(@RequestParam(value="sysBrandId") Long sysBrandId, @RequestParam(value="memberCode") String memberCode, @RequestParam(value="couponStatus") Byte couponStatus) {
        logger.info("CouponQueryRpcController findCountByMemberCodeAndStatus sysBrandId:{}, memberCode:{}, couponStatus:{}", new Object[]{sysBrandId, memberCode, couponStatus});
        return this.couponService.findCountByMemberCodeAndStatus(sysBrandId, memberCode, couponStatus);
    }
}

