/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.centerstageservice.rpc.SysAccountServiceRpc;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponManualPO;
import com.bizvane.couponfacade.models.vo.CouponManualRequestVO;
import com.bizvane.couponfacade.models.vo.CouponManualVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.SearchPhoneBatchRequest;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponManualRpc"})
public class CouponManualRpcController {
    private static final Logger logger = LoggerFactory.getLogger(CouponManualRpcController.class);
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private SysAccountServiceRpc sysAccountServiceRpc;

    @ApiOperation(value="\u67e5\u8be2\u624b\u52a8\u53d1\u5238\u5217\u8868\u63a5\u53e3", notes="\u67e5\u8be2\u624b\u52a8\u53d1\u5238\u5217\u8868\u63a5\u53e3", tags={"\u624b\u52a8\u53d1\u5238\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getList"})
    ResponseData<PageInfo<CouponManualVO>> getListRpc(@RequestBody CouponManualVO vo) {
        PageFormUtil pageForm = new PageFormUtil();
        pageForm.setPageNumber(vo.getPageNumber());
        pageForm.setPageSize(vo.getPageSize());
        return this.couponManualService.getListRpc(vo, pageForm);
    }

    @ApiOperation(value="\u66f4\u6539\u53d1\u9001\u72b6\u6001\u63a5\u53e3", notes="\u66f4\u6539\u53d1\u9001\u72b6\u6001\u63a5\u53e3", tags={"\u624b\u52a8\u53d1\u5238\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponManualId", value="\u624b\u52a8\u53d1\u5238id", required=true, dataType="Long"), @ApiImplicitParam(name="taskStatus", value="\u5ba1\u6838\u72b6\u6001", required=true, dataType="Byte")})
    @PostMapping(value={"/changeTask"})
    ResponseData<Integer> changeTaskRpc(@RequestBody CouponManualPO po) {
        return this.couponManualService.changeTask(po);
    }

    @PostMapping(value={"/getIsDefinitionCode"})
    ResponseData<Boolean> getIsDefinitionCode(@RequestBody CouponDefinitionPOWithBLOBs couponDefinitionPo) {
        return this.couponManualService.getIsDefinitionCode(couponDefinitionPo);
    }

    @PostMapping(value={"/addNewTask"})
    ResponseData<String> addNewTask(@RequestBody CouponManualRequestVO requestVO) {
        SearchPhoneBatchRequest phoneBatch;
        ResponseData responseData = new ResponseData();
        if (null == requestVO) {
            requestVO = new CouponManualRequestVO();
        }
        CouponManualVO couponManualVO = new CouponManualVO();
        couponManualVO.setCouponDefinitionIds(requestVO.getCouponDefinitionIds());
        couponManualVO.setTaskName(requestVO.getTaskName());
        couponManualVO.setSendTimeStr(requestVO.getSendTimeStr());
        couponManualVO.setSendType(requestVO.getSendType());
        couponManualVO.setTotalNumber(requestVO.getTotalNumber());
        couponManualVO.setMktGiftBagId(requestVO.getMktGiftBagId());
        MembersInfoSearchVo membersInfoSearchVo = requestVO.getSearchVo();
        SysAccountPO accountPo = new SysAccountPO();
        accountPo.setSysAccountId(membersInfoSearchVo.getMbrMemberId());
        accountPo.setBrandId(membersInfoSearchVo.getBrandId());
        accountPo.setSysCompanyId(membersInfoSearchVo.getSysCompanyId());
        membersInfoSearchVo.setSysCompanyId(null);
        membersInfoSearchVo.setBrandId(null);
        membersInfoSearchVo.setMbrMemberId(null);
        membersInfoSearchVo.setOnlineOrgCode(null);
        ResponseData sysAccountVoResponseData = this.sysAccountServiceRpc.getByAccountId(accountPo.getSysAccountId());
        if (sysAccountVoResponseData != null && sysAccountVoResponseData.getData() != null) {
            accountPo.setName(((SysAccountVo)sysAccountVoResponseData.getData()).getName());
            accountPo.setCreateUserName(((SysAccountVo)sysAccountVoResponseData.getData()).getCreateUserName());
            accountPo.setOnlineOrgCode(((SysAccountVo)sysAccountVoResponseData.getData()).getOnlineOrgCode());
        }
        ResponseData storeIds = null;
        try {
            storeIds = this.sysAccountServiceRpc.getAllStoreIds(accountPo.getSysAccountId(), accountPo.getBrandId());
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
        }
        if (storeIds != null) {
            membersInfoSearchVo.setStoreList((List)storeIds.getData());
        }
        if ((phoneBatch = membersInfoSearchVo.getPhoneBatch()) != null && StringUtils.isBlank((CharSequence)phoneBatch.getMobile()) && StringUtils.isBlank((CharSequence)phoneBatch.getUrl())) {
            return new ResponseData(-1, "\u67e5\u8be2\u6761\u4ef6\u52fe\u9009\u4e86\u624b\u673a\u53f7\uff0c\u5fc5\u987b\u586b\u5199\u624b\u673a\u53f7", null);
        }
        logger.info("enter CouponManualRpcController addNewTask method param: SearchVo:{}", (Object)JSONObject.toJSONString((Object)membersInfoSearchVo));
        logger.info("enter CouponManualRpcController addNewTask method param: CouponManualVO:{}", (Object)JSONObject.toJSONString((Object)couponManualVO));
        logger.info("enter CouponManualRpcController addNewTask method param: SysAccountPo:{}", (Object)JSONObject.toJSONString((Object)accountPo));
        try {
            responseData = this.couponManualService.addNewTask(couponManualVO, membersInfoSearchVo, accountPo);
        }
        catch (Exception e) {
            logger.info(SysResponseEnum.DATE_TRANSFER_EXCEPTION.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        return responseData;
    }
}

