/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import brave.Tracing;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.vo.MemberCouponExpireRequestVo;
import com.bizvane.messagebase.model.po.MsgCoupontimePO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import javax.validation.Valid;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponExpireRpc"})
public class CouponExpireController {
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private Tracing tracing;

    @RequestMapping(value={"/selectCouponExpireMember"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<MembersInfoSearchPojo>> selectCouponExpireMember(@RequestBody @Valid MemberCouponExpireRequestVo memberCouponExpireRequestVo, BindingResult bindingResult) {
        System.out.println(this.tracing.currentTraceContext().get().traceIdString());
        String traceId = (String)MDC.getCopyOfContextMap().get("traceId");
        System.out.println(traceId);
        if (bindingResult.hasErrors()) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), bindingResult.getFieldError().getDefaultMessage());
        }
        return this.couponEntityService.selectCouponExpireMember(memberCouponExpireRequestVo);
    }

    @RequestMapping(value={"/selectDefaultExpireDay"}, method={RequestMethod.GET})
    public ResponseData<MsgCoupontimePO> selectDefaultExpireDay(@RequestParam(value="sysCompanyId", required=false) Long sysCompanyId, @RequestParam(value="sysBrandId", required=false) Long sysBrandId) {
        ResponseData responseData = this.couponEntityService.selectDefaultExpireDay(sysCompanyId, sysBrandId);
        return responseData;
    }
}

