/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.es.CouponEntityInfoSearchPojo;
import com.bizvane.couponfacade.models.bo.CouponByCodeReq361BO;
import com.bizvane.couponfacade.models.bo.CouponEntityResponseBO;
import com.bizvane.couponfacade.models.bo.CouponInvalidBo;
import com.bizvane.couponfacade.models.bo.CouponLockReq361BO;
import com.bizvane.couponfacade.models.dto.CouponInfoDTO;
import com.bizvane.couponfacade.models.dto.CouponInfoDTO2;
import com.bizvane.couponfacade.models.dto.CouponQueryDTO;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListRequestVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListResponseVO;
import com.bizvane.couponfacade.models.vo.CouponStatusUpdateBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponEntityRpc"})
public class CouponEntityRpcController {
    private static final Logger logger = LoggerFactory.getLogger(CouponEntityRpcController.class);
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private RedissonTemplate redissonTemplate;

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u5458\u662f\u5426\u6709\u67d0\u4e2a\u5238", notes="\u67e5\u8be2\u4f1a\u5458\u662f\u5426\u6709\u67d0\u4e2a\u5238", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/findCouponHave"})
    public ResponseData<List<CouponEntityPO>> findCouponHave(@RequestParam(value="memberCode", required=false) String memberCode, @RequestParam(value="sendBusinessId", required=false) Long sendBusinessId, @RequestParam(value="date", required=false) String date) {
        return this.couponEntityService.finCouponHave(memberCode, sendBusinessId, date);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u5458\u662f\u5426\u6709\u67d0\u4e2a\u5238", notes="\u67e5\u8be2\u4f1a\u5458\u662f\u5426\u6709\u67d0\u4e2a\u5238", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/findMemberBusinessCoupon"})
    public ResponseData<List<CouponEntityPO>> findMemberBusinessCoupon(@RequestParam(value="brandId", required=false) Long brandId, @RequestParam(value="memberCode", required=false) String memberCode, @RequestParam(value="sendBusinessId", required=false) Long sendBusinessId) {
        return this.couponEntityService.findMemberBusinessCoupon(brandId, memberCode, sendBusinessId);
    }

    @PostMapping(value={"/rpcGetList"})
    ResponseData<PageInfo<CouponEntityInfoSearchPojo>> rpcGetList(@RequestBody(required=false) CouponEntityVO vo) {
        PageRequest pageableCoupon = null;
        pageableCoupon = StringUtils.isNotBlank((CharSequence)vo.getFingType()) ? PageRequest.of((int)(vo.getPageNumber() - 1), (int)vo.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"validDateStart"})) : PageRequest.of((int)(vo.getPageNumber() - 1), (int)vo.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"couponEntityId"}));
        if (vo.getSysBrandId() == 0L) {
            ResponseData responseData = new ResponseData();
            responseData.setCode(SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getCode());
            responseData.setMessage(SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        vo.setSysBrandId(vo.getSysBrandId());
        return this.couponEntityService.getListEs(vo, (Pageable)pageableCoupon);
    }

    @ApiOperation(value="\u6839\u636e\u4f1a\u5458Code\u67e5\u8be2\u4f18\u60e0\u5238\u5217\u8868\u63a5\u53e3", notes="\u4f18\u60e0\u5238\u67e5\u8be2", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @RequestMapping(value={"/listCouponByMemberCode"}, method={RequestMethod.POST})
    public ResponseData<List<CouponEntityVO>> listCouponByMemberCode(@RequestBody CouponEntityVO vo) {
        logger.info("CouponEntityRpcController-listCouponByMemberCode-info,requestVO:{}", (Object)JSONObject.toJSONString((Object)vo));
        if (vo.getSysBrandId() == null || vo.getSysBrandId() == 0L) {
            ResponseData responseData = new ResponseData();
            responseData.setCode(SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getCode());
            responseData.setMessage(SysResponseEnum.SYS_BRAND_ID_NOT_NULL.getMessage());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getMemberCode())) {
            ResponseData responseData = new ResponseData();
            responseData.setCode(SysResponseEnum.COUPON_MEMBER_CODE_NOT_NULL.getCode());
            responseData.setMessage(SysResponseEnum.COUPON_MEMBER_CODE_NOT_NULL.getMessage());
            return responseData;
        }
        vo.setSysBrandId(vo.getSysBrandId());
        ResponseData response = this.couponEntityService.listCouponByMemberCode(vo);
        logger.info("CouponEntityRpcController-listCouponByMemberCode-info,response:{}", (Object)JSONObject.toJSONString((Object)response));
        return response;
    }

    @Deprecated
    @PostMapping(value={"/listCoupon"})
    ResponseData<List<CouponInfoDTO>> listCoupon(@RequestBody CouponQueryDTO dto) {
        return this.couponEntityService.listCoupon(dto);
    }

    @PostMapping(value={"/listCoupon2"})
    ResponseData<List<CouponInfoDTO2>> listCoupon2(@RequestBody CouponQueryDTO dto) {
        return this.couponEntityService.listCoupon2(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u5458\u662f\u5426\u6709\u67d0\u4e2a\u5238", notes="\u67e5\u8be2\u4f1a\u5458\u662f\u5426\u6709\u67d0\u4e2a\u5238", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/findCouponHaveType"})
    public ResponseData<List<CouponEntityPO>> findCouponHaveType(@RequestParam(value="memberCode", required=false) String memberCode, @RequestParam(value="sendType", required=false) String sendType, @RequestParam(value="sendBusinessId", required=false) Long sendBusinessId, @RequestParam(value="date", required=false) String date) {
        return this.couponEntityService.findCouponHaveType(memberCode, sendType, sendBusinessId, date);
    }

    @ApiOperation(value="\u5355\u5f20\u53d1\u5238\u6536\u5230\u7ebf\u4e0b\u5904\u7406\u7ed3\u679c", notes="\u5355\u5f20\u53d1\u5238\u6536\u5230\u7ebf\u4e0b\u5904\u7406\u7ed3\u679c", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/updateCouponStatus"})
    public ResponseData<Integer> updateCouponStatus(@RequestParam(value="couponCode", required=false) String couponCode, @RequestParam(value="couponStatus", required=false) Byte couponStatus, @RequestParam(value="ifSendAgain", required=false) Integer ifSendAgain) {
        return this.couponEntityService.updateCouponStatus(new SendCouponSimpleRequestVO(), couponCode, couponStatus, ifSendAgain, "\u65e7\u7248\u672c\u62a5\u9519\u5185\u5bb9\u65e0\u6cd5\u663e\u793a");
    }

    @ApiOperation(value="\u5355\u5f20\u53d1\u5238\u6536\u5230\u7ebf\u4e0b\u5904\u7406\u7ed3\u679c", notes="\u5355\u5f20\u53d1\u5238\u6536\u5230\u7ebf\u4e0b\u5904\u7406\u7ed3\u679c", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/updateCouponStatus2"})
    public ResponseData<Integer> updateCouponStatus2(@RequestParam(value="couponCode", required=false) String couponCode, @RequestParam(value="couponStatus", required=false) Byte couponStatus, @RequestParam(value="ifSendAgain", required=false) Integer ifSendAgain, @RequestParam(value="failDetail") String failDetail) {
        return this.couponEntityService.updateCouponStatus2(new SendCouponSimpleRequestVO(), couponCode, couponStatus, ifSendAgain, failDetail);
    }

    @ApiOperation(value="\u6279\u91cf\u53d1\u5238\u6536\u5230\u7ebf\u4e0b\u5904\u7406\u7ed3\u679c", notes="\u6279\u91cf\u53d1\u5238\u6536\u5230\u7ebf\u4e0b\u5904\u7406\u7ed3\u679c", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/updateCouponStatusBatch"})
    public ResponseData<Integer> updateCouponStatusBatch(@RequestBody(required=false) CouponStatusUpdateBatchRequestVO vo) {
        SendCouponBatchRequestVO requestVO = new SendCouponBatchRequestVO();
        return this.couponEntityService.updateCouponStatusBatch(requestVO, vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8/\u4efb\u52a1\u53d1\u9001\u7684\u5238\u7684\u4f1a\u5458\u5217\u8868", notes="\u67e5\u8be2\u6d3b\u52a8/\u4efb\u52a1\u53d1\u9001\u7684\u5238\u7684\u4f1a\u5458\u5217\u8868", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/findCouponSendMemberList"})
    public ResponseData<PageInfo<CouponSendMemberListResponseVO>> findCouponSendMemberList(@RequestBody(required=false) CouponSendMemberListRequestVO requestVO) {
        if (requestVO.getPageNumber() == null || requestVO.getPageSize() == null) {
            requestVO.setPageNumber(Integer.valueOf(1));
            requestVO.setPageSize(Integer.valueOf(20));
        }
        return this.couponEntityService.findCouponSendMemberList(requestVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u5458\u4f18\u60e0\u5238\u5217\u8868", notes="\u67e5\u8be2\u4f1a\u5458\u4f18\u60e0\u5238\u5217\u8868", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/bycardnoqueryCoupon"})
    public ResponseData<PageInfo<CouponEntityResponseBO>> bycardnoqueryCoupon(@RequestBody(required=false) CouponByCodeReq361BO requestVO) {
        return this.couponEntityService.bycardnoqueryCoupon(requestVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4f18\u60e0\u5238\u51bb\u7ed3", notes="\u4f18\u60e0\u5238\u51bb\u7ed3", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/lockCoupon"})
    public ResponseData lockCoupon(@RequestBody(required=false) CouponLockReq361BO requestVO) {
        logger.info("CouponEntityRpcController lockCoupon param:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        this.redissonTemplate.getRLock("coupon:biz:lockCoupon:" + requestVO.getBrandCode() + requestVO.getCouponCode(), 30L, TimeUnit.SECONDS);
        try {
            responseData = this.couponEntityService.lockCoupon(requestVO);
        }
        catch (Exception e) {
            logger.info("lockCoupon is error:" + e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            ResponseData responseData2 = responseData;
            return responseData2;
        }
        finally {
            this.redissonTemplate.getRUnLook("coupon:biz:lockCoupon:" + requestVO.getBrandCode() + requestVO.getCouponCode());
        }
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4f18\u60e0\u5238\u89e3\u51bb", notes="\u4f18\u60e0\u5238\u89e3\u51bb", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/unLockCoupon"})
    public ResponseData unLockCoupon(@RequestBody(required=false) CouponLockReq361BO requestVO) {
        logger.info("CouponEntityRpcController unLockCoupon param:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        this.redissonTemplate.getRLock("coupon:biz:unLockCoupon:" + requestVO.getBrandCode() + requestVO.getCouponCode(), 30L, TimeUnit.SECONDS);
        try {
            responseData = this.couponEntityService.unLockCoupon(requestVO);
        }
        catch (Exception e) {
            logger.info("unLockCoupon is error:" + e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            ResponseData responseData2 = responseData;
            return responseData2;
        }
        finally {
            this.redissonTemplate.getRUnLook("coupon:biz:unLockCoupon:" + requestVO.getBrandCode() + requestVO.getCouponCode());
        }
        return responseData;
    }

    @ApiOperation(value="\u4f18\u60e0\u5238\u4f5c\u5e9f", notes="\u4f18\u60e0\u5238\u4f5c\u5e9f", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @RequestMapping(value={"/invalidCoupon"}, method={RequestMethod.POST})
    public ResponseData invalidCoupon(@RequestBody(required=false) CouponInvalidBo requestVO) {
        return this.couponEntityService.invalidCoupon(requestVO);
    }

    @PostMapping(value={"/getCouponEntityListEs"})
    ResponseData<PageInfo<CouponEntityInfoSearchPojo>> getCouponEntityListEs(@RequestBody CouponEntityVO vo) {
        PageFormUtil pageFormUtil = new PageFormUtil();
        pageFormUtil.setPageNumber(vo.getPageNumber());
        pageFormUtil.setPageSize(vo.getPageSize());
        return this.couponEntityService.getCouponEntityListEs(vo, pageFormUtil);
    }

    @PostMapping(value={"/couponEntityModify"})
    ResponseData<Integer> couponEntityModify(@RequestBody CouponEntityVO vo) {
        return this.couponEntityService.couponEntityModify(vo);
    }
}

