/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.bo.CouponDefReq361BO;
import com.bizvane.couponfacade.models.bo.CouponDefReqURBO;
import com.bizvane.couponfacade.models.po.CouponDefinitionMoneyPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.CouponDefinitionListQueryVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponservice.service.CouponDefinitionService;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponDefinitionRpc"})
public class CouponDefinitionRpcController {
    private static final Logger logger = LoggerFactory.getLogger(CouponDefinitionRpcController.class);
    @Autowired
    private CouponDefinitionService couponDefinitionService;

    @PostMapping(value={"/getList"})
    @ApiOperation(value="\u83b7\u53d6\u5238\u5b9a\u4e49\u5217\u8868\u63a5\u53e3", notes="\u83b7\u53d6\u5238\u5b9a\u4e49\u5217\u8868\u63a5\u53e3", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    public ResponseData<PageInfo<CouponDefinitionPO>> getListRpc(@RequestBody CouponDefinitionListQueryVO vo) {
        PageFormUtil pageForm = new PageFormUtil();
        pageForm.setPageNumber(vo.getPageNumber());
        pageForm.setPageSize(vo.getPageSize());
        return this.couponDefinitionService.getListRpc(vo, pageForm);
    }

    @ApiOperation(value="\u5238\u4fdd\u5b58", notes="\u5238\u4fdd\u5b58", tags={"\u5b9a\u4e49\u5238"}, httpMethod="POST")
    @PostMapping(value={"/add"})
    public ResponseData<Long> addRpc(@RequestBody CouponDefinitionPOWithBLOBs po) {
        return this.couponDefinitionService.addRpc(po);
    }

    @ApiOperation(value="\u5238\u4fdd\u5b58", notes="\u5238\u4fdd\u5b58", tags={"\u5b9a\u4e49\u5238"}, httpMethod="POST")
    @PostMapping(value={"/addCoupon"})
    public ResponseData<Long> addCoupon(@RequestBody CouponDefinitionPOWithBLOBs po) {
        return this.couponDefinitionService.addCoupon(po);
    }

    @ApiOperation(value="\u6839\u636eid\u4fee\u6539\u5238\u4fe1\u606f\u63a5\u53e3", notes="\u6839\u636eid\u4fee\u6539\u5238\u4fe1\u606f\u63a5\u53e3", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long"), @ApiImplicitParam(name="status", value="\u5238\u72b6\u6001\uff081\u5df2\u542f\u7528\uff0c0\u5df2\u505c\u7528\uff09", required=true, dataType="Boolean"), @ApiImplicitParam(name="sysBrandId", value="\u54c1\u724cid", required=true, dataType="Long")})
    @PostMapping(value={"/updateById"})
    public ResponseData<Object> updateRpc(@RequestBody CouponDefinitionPOWithBLOBs po, HttpServletRequest request) {
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.couponDefinitionService.update(po, accountPo);
    }

    @ApiOperation(value="\u6da8\u7ea2\u5305\u63a5\u53e3", notes="\u6da8\u7ea2\u5305\u63a5\u53e3", tags={"\u6da8\u7ea2\u5305\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u54c1\u724ctaskId", required=true, dataType="Long")})
    @PostMapping(value={"/definitionMoneyRpc"})
    public ResponseData<Object> definitionMoneyRpc(@RequestBody CouponDefinitionMoneyPO po) {
        return this.couponDefinitionService.definitionMoneyRpc(po);
    }

    @ApiOperation(value="\u590d\u5236\uff1a\u6839\u636eid\u67e5\u627e\u5355\u5f20\u5238\u63a5\u53e3", notes="\u590d\u5236\uff1a\u6839\u636eid\u67e5\u627e\u5355\u5f20\u5238\u63a5\u53e3", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long")})
    @PostMapping(value={"/findById"})
    public ResponseData<CouponDefinitionPOWithBLOBs> findByIdRpc(@RequestParam(value="couponDefinitionId", required=false) Long couponDefinitionId) {
        return this.couponDefinitionService.getCouponDefinition(couponDefinitionId);
    }

    @ApiOperation(value="\u67e5\u627e\u591a\u4e2a\u5238\u5b9a\u4e49\u63a5\u53e3", notes="\u67e5\u627e\u591a\u4e2a\u5238\u5b9a\u4e49\u63a5\u53e3", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    @RequestMapping(value={"findByIdList"}, method={RequestMethod.POST})
    ResponseData<List<CouponDefinitionPOWithBLOBs>> findByIdList(@RequestParam(value="couponDefinitionIdList", required=false) List<Long> couponDefinitionIdList) {
        return this.couponDefinitionService.findByIdList(couponDefinitionIdList);
    }

    @ApiOperation(value="\u5224\u65ad\u5238\u662f\u5426\u8fc7\u671f", notes="\u5224\u65ad\u5238\u662f\u5426\u8fc7\u671f", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"couponDefinitionExpire"})
    public ResponseData<Boolean> couponDefinitionExpire(@RequestParam(value="couponDefinitionId") Long couponDefinitionId) {
        try {
            return this.couponDefinitionService.couponDefinitionExpire(couponDefinitionId);
        }
        catch (Exception e) {
            logger.error("couponDefinitionExpire Exception ! exception:{}", (Object)JSONObject.toJSONString((Object)e));
            return new ResponseData();
        }
    }

    @ApiOperation(value="\u5238\u5b9a\u4e49\u5217\u8868\u67e5\u8be2", notes="\u5238\u5b9a\u4e49\u5217\u8868\u67e5\u8be2", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"queryCouponDefinitionList"})
    public ResponseData<PageInfo<CouponDefinitionPOWithBLOBs>> queryCouponDefinitionList(@RequestBody CouponDefReq361BO bo) {
        logger.info("CouponDefinitionRpcController queryCouponDefinitionList param:{}", (Object)JSONObject.toJSONString((Object)bo));
        if (bo.getPageNo() == null || bo.getPageSize() == null) {
            bo.setPageNo(Integer.valueOf(1));
            bo.setPageSize(Integer.valueOf(10));
        }
        return this.couponDefinitionService.queryCouponDefinitionList(bo);
    }

    @ApiOperation(value="\u5238\u5b9a\u4e49\u5217\u8868\u67e5\u8be2", notes="\u5238\u5b9a\u4e49\u5217\u8868\u67e5\u8be2", tags={"\u5238\u5b9a\u4e49\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"queryCouponDefinitionListUR"})
    public ResponseData<PageInfo<CouponDefinitionPOWithBLOBs>> queryCouponDefinitionListUR(@RequestBody CouponDefReqURBO bo) {
        logger.info("CouponDefinitionRpcController queryCouponDefinitionListUR param:{}", (Object)JSONObject.toJSONString((Object)bo));
        if (bo.getPageNo() == null || bo.getPageSize() == null) {
            bo.setPageNo(Integer.valueOf(1));
            bo.setPageSize(Integer.valueOf(10));
        }
        return this.couponDefinitionService.queryCouponDefinitionListUR(bo);
    }

    @PostMapping(value={"/getCouponDefListByCompanyId"})
    public ResponseData<PageInfo<CouponDefinitionPOWithBLOBs>> getCouponDefListByCompanyId(@RequestParam(value="sysCompanyId") Long sysCompanyId, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return this.couponDefinitionService.getCouponDefListByCompanyId(sysCompanyId, pageNum, pageSize);
    }
}

