/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller.rpc;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.vo.CouponCancelUseRequestVO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponDifindustryVO;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponIntegralCouponUseAllRequestVO;
import com.bizvane.couponfacade.models.vo.CouponInvalidRequestVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponManualVO;
import com.bizvane.couponfacade.models.vo.CouponOfflineCreateResponseVO;
import com.bizvane.couponfacade.models.vo.CouponOfflineUseRequestVO;
import com.bizvane.couponfacade.models.vo.CouponOnlineUseRequestVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaSendDetailAppletVo;
import com.bizvane.couponfacade.models.vo.CouponQuotaSendDetailVO;
import com.bizvane.couponfacade.models.vo.CouponRefundRequestVO;
import com.bizvane.couponfacade.models.vo.CouponReversalRequestVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListRequestVO;
import com.bizvane.couponfacade.models.vo.CouponSendMemberListResponseVO;
import com.bizvane.couponfacade.models.vo.CouponUseVO;
import com.bizvane.couponfacade.models.vo.ReceiveCouponStatusVO;
import com.bizvane.couponfacade.models.vo.SendCouponQuotaBatchRequestVO;
import com.bizvane.couponfacade.mq.OnlineCouponUseEvent;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.CouponQuotaDetailService;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponRpc"})
public class CouponController {
    private static Logger logger = LoggerFactory.getLogger(CouponController.class);
    @Autowired
    private CouponService couponService;
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private SendCouponService sendCouponService;
    @Autowired
    private CouponQuotaDetailService couponQuotaDetailService;

    @ApiOperation(value="\u6839\u636e\u5238\u53f7\u4f7f\u7528\u4f18\u60e0\u5238\u63a5\u53e3(\u6838\u9500)", notes="\u6839\u636e\u5238\u53f7\u4f7f\u7528\u4f18\u60e0\u5238\u63a5\u53e3", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/use"})
    ResponseData<String> use(@RequestBody(required=false) CouponUseVO requestVO) {
        requestVO.setUseFrom(Byte.valueOf((byte)1));
        return this.couponService.use(requestVO);
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u5238\u6838\u9500", notes="\u4f01\u4e1a\u5fae\u4fe1\u5238\u6838\u9500", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/wechatEnterpriseUse"})
    ResponseData<String> wechatEnterpriseUse(@RequestBody(required=false) CouponUseVO requestVO) {
        return this.couponService.wechatEnterpriseUse(requestVO);
    }

    @ApiOperation(value="\u7ebf\u4e0a\u4f7f\u7528\u4f18\u60e0\u5238\u63a5\u53e3(\u6838\u9500)", notes="\u7ebf\u4e0a\u4f7f\u7528\u4f18\u60e0\u5238\u63a5\u53e3", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/onlineUse"})
    ResponseData<String> onlineUse(@RequestBody CouponOnlineUseRequestVO vo) {
        if (vo.getUseFrom() == null) {
            vo.setUseFrom(Byte.valueOf((byte)3));
        }
        return this.couponService.onlineUse(vo);
    }

    @ApiOperation(value="\u7ebf\u4e0b\u4f7f\u7528\u4f18\u60e0\u5238\u63a5\u53e3(\u6838\u9500)", notes="\u7ebf\u4e0b\u4f7f\u7528\u4f18\u60e0\u5238\u63a5\u53e3", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/offlineUse"})
    ResponseData<Integer> offlineUse(@RequestBody(required=false) CouponOfflineUseRequestVO vo) {
        ResponseData responseData = new ResponseData();
        vo.setUseFrom(Byte.valueOf((byte)4));
        if (StrUtil.isNotBlank((CharSequence)vo.getCouponCode())) {
            String[] split;
            for (String code : split = vo.getCouponCode().split(",")) {
                vo.setCouponCode(code);
                responseData = this.couponService.offlineUseCheck(vo);
                if (responseData.getCode() == 0) continue;
                return responseData;
            }
            for (String code : split) {
                vo.setCouponCode(code);
                responseData = this.couponService.offlineUse(vo);
            }
        }
        return responseData;
    }

    @ApiOperation(value="\u6cf0\u8fea\u79ef\u5206\u5238\u6838\u9500(\u5b9a\u5236\u670d\u52a1)", notes="\u6cf0\u8fea\u79ef\u5206\u5238\u6838\u9500(\u5b9a\u5236\u670d\u52a1)", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/taiDiIntegralCouponUse"})
    ResponseData<Long> taiDiIntegralCouponAllUse(@RequestBody CouponIntegralCouponUseAllRequestVO vo) {
        logger.info("CouponController#taiDiIntegralCouponUse#vo:{}", JSON.toJSON((Object)vo));
        return this.couponService.taiDiIntegralCouponUse(vo);
    }

    @ApiOperation(value="\u51b2\u6b63\u5238\u63a5\u53e3", notes="\u51b2\u6b63\u5238\u63a5\u53e3", tags={"\u5238\u6d88\u606f\u914d\u7f6e"}, httpMethod="POST")
    @PostMapping(value={"/cancelUse"})
    ResponseData<Object> cancelUse(@RequestBody CouponCancelUseRequestVO vo) {
        return this.couponService.cancelUse(vo);
    }

    @ApiOperation(value="\u7ebf\u4e0a\u51b2\u6b63\u5238\u63a5\u53e3", httpMethod="POST")
    @PostMapping(value={"/cancelUseOnline"})
    ResponseData<Object> cancelUseOnline(@Valid @NotBlank @RequestParam(value="couponCode") String couponCode) {
        return this.couponService.cancelUseOnline(couponCode);
    }

    @ApiOperation(value="\u7ebf\u4e0a\u51b2\u6b63\u5238\u5e76\u5199\u7ebf\u4e0b\u63a5\u53e3", httpMethod="POST")
    @PostMapping(value={"/cancelUseOnlineAndSyncOffline"})
    ResponseData<Object> cancelUseOnlineAndSyncOffline(@Valid @NotBlank @RequestParam(value="couponCode") String couponCode) {
        return this.couponService.cancelUseOnlineAndSyncOffline(couponCode);
    }

    @ApiOperation(value="\u8f6c\u8d60\u5238\u63a5\u53e3", notes="\u8f6c\u8d60\u5238\u63a5\u53e3", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponCode", value="\u5238code", required=true, dataType="String"), @ApiImplicitParam(name="oldMemberCode", value="\u65e7\u4f1a\u5458code", required=true, dataType="String"), @ApiImplicitParam(name="newMemberCode", value="\u65b0\u4f1a\u5458code", required=true, dataType="String"), @ApiImplicitParam(name="useBusinessCode", value="\u4e1a\u52a1code", required=true, dataType="String")})
    @PostMapping(value={"/givenCoupon"})
    ResponseData<Integer> givenCoupon(@RequestBody(required=false) CouponEntityVO vo) {
        return this.couponService.givenCoupon(vo);
    }

    @ApiOperation(value="\u8f6c\u8d60\u72b6\u6001\u66f4\u6539\u4e3a\u8f6c\u8d60\u4e2d", notes="\u8f6c\u8d60\u72b6\u6001\u66f4\u6539\u4e3a\u8f6c\u8d60\u4e2d", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponCode", value="\u5238code", required=true, dataType="String")})
    @PostMapping(value={"/couponGiving"})
    ResponseData couponGiving(@RequestParam(value="couponCode") String couponCode, @RequestParam(value="memberCode") String memberCode, @RequestParam(value="companyId") Long companyId, @RequestParam(value="brandId") Long brandId, @RequestParam(value="transferDate", required=false) String transferDate) {
        return this.couponService.couponGiving(couponCode, memberCode, companyId, brandId, transferDate);
    }

    @ApiOperation(value="\u5238\u8f6c\u8d60\u64a4\u56de", notes="\u5238\u8f6c\u8d60\u64a4\u56de", tags={"\u5238\u5b9e\u4f8b\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponCode", value="\u5238code", required=true, dataType="String")})
    @PostMapping(value={"/transferCouponBack"})
    ResponseData transferCouponBack(@RequestParam(value="couponCode") String couponCode, @RequestParam(value="memberCode") String memberCode, @RequestParam(value="companyId") Long companyId, @RequestParam(value="brandId") Long brandId) {
        return this.couponService.transferCouponBack(couponCode, memberCode, companyId, brandId);
    }

    @ApiOperation(value="\u9501\u5b9a\u5238\u63a5\u53e3", notes="\u9501\u5b9a\u5238\u63a5\u53e3", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponCode", value="\u5238code", required=true, dataType="String"), @ApiImplicitParam(name="memberCode", value="\u4f1a\u5458code", required=true, dataType="String")})
    @PostMapping(value={"/lock"})
    ResponseData<Object> lock(@RequestBody CouponEntityVO vo) {
        return this.couponService.lock(vo);
    }

    @ApiOperation(value="\u89e3\u9501\u5238\u63a5\u53e3", notes="\u89e3\u9501\u5238\u63a5\u53e3", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponCode", value="\u5238code", required=true, dataType="String"), @ApiImplicitParam(name="memberCode", value="\u4f1a\u5458code", required=true, dataType="String")})
    @PostMapping(value={"/unlock"})
    ResponseData<Object> unlock(@RequestBody CouponEntityVO vo) {
        return this.couponService.unlock(vo);
    }

    @ApiOperation(value="\u4f18\u60e0\u5238\u5230\u671f\u63a5\u53e3", notes="\u4f18\u60e0\u5238\u5230\u671f\u63a5\u53e3", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponCode", value="\u5238code", required=true, dataType="Long"), @ApiImplicitParam(name="memberCode", value="\u4f1a\u5458code", required=true, dataType="Long"), @ApiImplicitParam(name="useBusinessCode", value="\u4f7f\u7528\u4e1a\u52a1code", required=true, dataType="Long")})
    @PostMapping(value={"/couponExpire"})
    ResponseData<Object> couponExpire(@RequestBody CouponEntityVO vo) {
        return this.couponService.couponExpire(vo);
    }

    @ApiOperation(value="\u7ebf\u4e0b\u8c03\u7528\u7ebf\u4e0a\u63a5\u53e3\u6838\u9500\u5238\uff0c\u53d6\u6d88\u53d6\u6570 \u7ebf\u4e0b\u5238\u72b6\u6001\u7ebf\u4e0b\u81ea\u5df1\u6838\u9500", notes="\u7ebf\u4e0b\u8c03\u7528\u7ebf\u4e0a\u63a5\u53e3\u6838\u9500\u5238\uff0c\u53d6\u6d88\u53d6\u6570 \u7ebf\u4e0b\u5238\u72b6\u6001\u7ebf\u4e0b\u81ea\u5df1\u6838\u9500", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/offlineSyncCoupon"})
    ResponseData offlineSyncCoupon(@RequestBody(required=false) CouponOfflineUseRequestVO vo) {
        vo.setUseFrom(Byte.valueOf((byte)4));
        return this.couponService.offlineSyncCoupon(vo);
    }

    @ApiOperation(value="\u51b2\u6b63\u5238\u63a5\u53e3", notes="\u51b2\u6b63\u5238\u63a5\u53e3", tags={"\u5238\u6d88\u606f\u914d\u7f6e"}, httpMethod="POST")
    @PostMapping(value={"/reversal"})
    ResponseData reversal(@RequestBody CouponReversalRequestVO vo) {
        return this.couponService.reversal(vo);
    }

    @ApiOperation(value="\u6839\u636e\u5238\u53f7\u521d\u59cb\u5316\u5238\u7684\u4f7f\u7528\u72b6\u6001(\u9000\u5355\u7684\u9000\u5238\u64cd\u4f5c)", notes="\u6839\u636e\u5238\u53f7\u521d\u59cb\u5316\u5238\u7684\u4f7f\u7528\u72b6\u6001(\u9000\u5355\u7684\u9000\u5238\u64cd\u4f5c)", tags={"\u5238\u64cd\u4f5c\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/refund"})
    ResponseData<String> refund(@RequestBody CouponRefundRequestVO couponRefundRequestVO) {
        ResponseData responseData = new ResponseData();
        try {
            this.couponService.refund(couponRefundRequestVO);
        }
        catch (Exception e) {
            logger.info("\u6839\u636e\u5238\u53f7\u521d\u59cb\u5316\u5238\u7684\u4f7f\u7528\u72b6\u6001,\u5e76\u63d2\u5165\u5238\u51b2\u6b63\u8bb0\u5f55\u8868\u63a5\u53e3\u6267\u884c\u5931\u8d25,\u9519\u8bef\u4fe1\u606f{}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }

    @ApiOperation(value="\u4f18\u60e0\u5238\u4f5c\u5e9f\u64cd\u4f5c", notes="\u4f18\u60e0\u5238\u4f5c\u5e9f\u64cd\u4f5c", tags={"\u4f18\u60e0\u5238\u4f5c\u5e9f\u64cd\u4f5c"}, httpMethod="POST")
    @RequestMapping(value={"/invalid"}, method={RequestMethod.POST})
    ResponseData<String> invalid(@RequestBody CouponInvalidRequestVO couponInvalidRequestVO) {
        return this.couponService.invalid(couponInvalidRequestVO);
    }

    @ApiOperation(value="\u5fae\u5546\u57ce\u95e8\u5e97\u88c5\u4fee\u4f18\u60e0\u5238\u5217\u8868\u63a5\u53e3", notes="\u5fae\u5546\u57ce\u95e8\u5e97\u88c5\u4fee\u4f18\u60e0\u5238\u5217\u8868\u63a5\u53e3", tags={"\u5fae\u5546\u57ce\u95e8\u5e97\u88c5\u4fee\u4f18\u60e0\u5238\u5217\u8868\u63a5\u53e3"}, httpMethod="GET")
    @GetMapping(value={"/activityCoupon"})
    ResponseData activityCoupon(@RequestParam(value="sysBrandId") Long sysBrandId, @RequestParam(value="page") Integer page, @RequestParam(value="pageSize") Integer pageSize) {
        return this.couponService.selectActivityCoupon(sysBrandId, page, pageSize);
    }

    @ApiOperation(value="\u6d3b\u52a8\u4f18\u60e0\u5238\u9886\u53d6\u72b6\u6001", notes="\u6d3b\u52a8\u4f18\u60e0\u5238\u9886\u53d6\u72b6\u6001\u63a5\u53e3", tags={"\u6d3b\u52a8\u4f18\u60e0\u5238\u9886\u53d6\u72b6\u6001\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getCouponReceiveStatus"})
    ResponseData getCouponReceiveStatus(@RequestBody ReceiveCouponStatusVO receiveCouponStatusVO) {
        return this.couponService.getCouponReceiveStatus(receiveCouponStatusVO);
    }

    @ApiOperation(value="\u5238\u540c\u6b65\u63a5\u53e3", notes="\u5238\u540c\u6b65\u63a5\u53e3", tags={"\u5238\u540c\u6b65\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/couponSynchronize"})
    ResponseData couponSynchronize(@RequestBody CouponOfflineCreateResponseVO couponOfflineCreateResponseVO) {
        return this.couponService.couponSynchronization(couponOfflineCreateResponseVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5176\u4ed6\u54c1\u724c\u7684\u5f02\u4e1a\u5377", notes="\u83b7\u53d6\u5176\u4ed6\u54c1\u724c\u7684\u5f02\u4e1a\u5377\u63a5\u53e3", tags={"\u83b7\u53d6\u5176\u4ed6\u54c1\u724c\u7684\u5f02\u4e1a\u5377\u63a5\u53e3"}, httpMethod="POST")
    @PostMapping(value={"/getOtherBrandDifindustryCoupon"})
    public ResponseData<PageInfo<CouponEntityAndDefinitionVO>> getOtherBrandDifindustryCoupon(@RequestBody CouponListByMemberCodeRequestVO vo) {
        return this.couponService.getOtherBrandDifindustryCoupon(vo);
    }

    @ApiOperation(value="\u5f02\u4e1a\u5238\u6279\u91cf\u67e5\u8be2\u5269\u4f59\u6570\u91cf\u5b9e\u4f8b\u63a5\u53e3", tags={"\u5f02\u4e1a\u5238\u6279\u91cf\u67e5\u8be2\u5269\u4f59\u6570\u91cf\u5b9e\u4f8b\u63a5\u53e3"})
    @RequestMapping(value={"/getSurplusQuantityByList"}, method={RequestMethod.POST})
    public ResponseData<List<CouponDefinitionVO>> getSurplusQuantityByList(@RequestBody List<CouponDefinitionVO> list) {
        ResponseData responseData = this.couponService.getSurplusQuantityByList(list);
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f02\u4e1a\u5238\u8be6\u60c5\u63a5\u53e3", tags={"\u67e5\u8be2\u5f02\u4e1a\u5238\u8be6\u60c5\u63a5\u53e3"})
    @RequestMapping(value={"/findBySendIdRpc"}, method={RequestMethod.POST})
    public ResponseData<CouponDefinitionPO> findBySendIdRpc(@RequestParam(value="couponDifindustrySendDetailId") Long couponDifindustrySendDetailId) {
        ResponseData responseData = this.couponService.findBycouponDifindustrySendDetailId(couponDifindustrySendDetailId);
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f02\u4e1a\u5238\u8be6\u60c5\u5b9e\u4f8b\u63a5\u53e3", tags={"\u67e5\u8be2\u5f02\u4e1a\u5238\u8be6\u60c5\u5b9e\u4f8b\u63a5\u53e3"})
    @RequestMapping(value={"/findCouponBySendIdRpc"}, method={RequestMethod.POST})
    public ResponseData<CouponDetailResponseVO> findCouponBySendIdRpc(@RequestParam(value="couponDifindustrySendDetailId") Long couponDifindustrySendDetailId) {
        ResponseData responseData = this.couponService.findCouponByDifindustrySendDetailId(couponDifindustrySendDetailId);
        return responseData;
    }

    @RequestMapping(value={"/getDifindustryAnalysisByBusinessIdList"}, method={RequestMethod.POST})
    public ResponseData<List<CouponDifindustryVO>> getDifindustryAnalysisByBusinessIdList(@RequestBody CouponDifindustryVO vo) {
        ResponseData responseData = this.couponService.getDifindustryAnalysisByBusinessIdList(vo);
        return responseData;
    }

    @RequestMapping(value={"getDifindustryCouponSourceBrand"}, method={RequestMethod.POST})
    public ResponseData<List<CouponDifindustryVO>> getDifindustryCouponSourceBrand(@RequestBody CouponManualVO vo) {
        ResponseData responseData = this.couponManualService.getDifindustryCouponSourceBrand(vo);
        return responseData;
    }

    @RequestMapping(value={"findCouponSendMemberList"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<CouponSendMemberListResponseVO>> findCouponSendMemberList(@RequestBody CouponSendMemberListRequestVO requestVO) {
        ResponseData responseData = this.couponService.findCouponSendMemberList(requestVO);
        return responseData;
    }

    @ApiOperation(value="\u5546\u79c0\u8c03\u7528:\u4fdd\u5b58\u5238\u53d1\u9001\u8bb0\u5f55\u63a5\u53e3", notes="\u5546\u79c0\u8c03\u7528:\u4fdd\u5b58\u5238\u53d1\u9001\u8bb0\u5f55\u63a5\u53e3", httpMethod="POST")
    @PostMapping(value={"/saveCouponQuotaSendDetail"})
    public ResponseData<Long> saveCouponQuotaSendDetail(@RequestBody SendCouponQuotaBatchRequestVO vo) {
        ResponseData responseData = this.sendCouponService.saveCouponQuotaSendDetail(vo);
        return responseData;
    }

    @ApiOperation(value="\u5546\u79c0\u8c03\u7528:\u6839\u636e\u5238\u53d1\u9001\u8bb0\u5f55ID\u67e5\u8be2\u5238\u53d1\u9001\u8be6\u60c5\u63a5\u53e3", notes="\u5546\u79c0\u8c03\u7528:\u6839\u636e\u5238\u53d1\u9001\u8bb0\u5f55ID\u67e5\u8be2\u5238\u53d1\u9001\u8be6\u60c5\u63a5\u53e3", httpMethod="POST")
    @PostMapping(value={"/getCouponQuotaSendDetailById"})
    public ResponseData<CouponQuotaSendDetailVO> getCouponQuotaSendDetailById(@RequestParam(value="couponQuotaSendDetailId") Long couponQuotaSendDetailId) {
        ResponseData responseData = this.couponQuotaDetailService.getCouponQuotaSendDetailById(couponQuotaSendDetailId);
        return responseData;
    }

    @ApiOperation(value="\u5546\u79c0\u8c03\u7528:\u6263\u51cf\u989d\u5ea6,\u9001\u5238,\u66f4\u65b0\u5238\u53d1\u9001\u72b6\u6001\u63a5\u53e3", notes="\u5546\u79c0\u8c03\u7528:\u6263\u51cf\u989d\u5ea6,\u9001\u5238,\u66f4\u65b0\u5238\u53d1\u9001\u72b6\u6001\u63a5\u53e3", httpMethod="POST")
    @PostMapping(value={"/sendCoupon"})
    public ResponseData<String> sendCoupon(@RequestBody SendCouponQuotaBatchRequestVO vo) {
        ResponseData responseData = this.sendCouponService.sendCoupon(vo);
        return responseData;
    }

    @ApiOperation(value="\u4f1a\u5458\u4e2d\u5fc3\u8c03\u7528:\u6839\u636e\u5238\u53d1\u9001\u8bb0\u5f55ID\u67e5\u8be2\u5238\u53d1\u9001\u8be6\u60c5\u63a5\u53e3", notes="\u4f1a\u5458\u4e2d\u5fc3\u8c03\u7528:\u6839\u636e\u5238\u53d1\u9001\u8bb0\u5f55ID\u67e5\u8be2\u5238\u53d1\u9001\u8be6\u60c5\u63a5\u53e3", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="getCouponQuotaSendDetailAppletVoById", value="\u5238\u53d1\u9001\u8bb0\u5f55ID", required=true, dataType="Long")})
    @RequestMapping(value={"/getCouponQuotaSendDetailAppletVoById"}, method={RequestMethod.POST})
    ResponseData<CouponQuotaSendDetailAppletVo> getCouponQuotaSendDetailAppletVoById(@RequestParam(value="couponQuotaSendDetailId") Long couponQuotaSendDetailId) {
        ResponseData responseData = this.couponQuotaDetailService.getCouponQuotaSendDetailAppletVoById(couponQuotaSendDetailId);
        return responseData;
    }

    @ApiOperation(value="361\u4f7f\u7528\u4f18\u60e0\u5238\u63a5\u53e3", notes="361\u4f7f\u7528\u4f18\u60e0\u5238\u63a5\u53e3", httpMethod="POST")
    @PostMapping(value={"/onlineUse361"})
    ResponseData<String> onlineUse361(@RequestBody OnlineCouponUseEvent.OnlineCouponUseVO vo) {
        return this.couponService.onlineUse361(vo);
    }

    @ApiOperation(value="\u5151\u6362\u9884\u751f\u6210\u5238", httpMethod="POST")
    @RequestMapping(value={"/exchangePreCoupon"}, method={RequestMethod.POST})
    ResponseData<Boolean> exchangePreCoupon(@NotBlank @RequestParam(value="couponCode") String couponCode, @NotBlank @RequestParam(value="memberCode") String memberCode) {
        return this.couponService.exchangePreCoupon(couponCode, memberCode);
    }
}

