/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.alibaba.fastjson.JSON;
import com.bizvane.base.common.bean.ListResultBean;
import com.bizvane.couponfacade.interfaces.YouZanCouponServiceFeign;
import com.bizvane.couponfacade.models.bo.AvailableCouponDto;
import com.bizvane.couponfacade.models.bo.CertificateDto;
import com.bizvane.couponfacade.models.bo.CouponDetailsDto;
import com.bizvane.couponfacade.models.bo.RefundVoucherDto;
import com.bizvane.couponfacade.models.bo.VoucherIssuanceDto;
import com.bizvane.couponfacade.models.bo.VoucherVerificationDto;
import com.bizvane.couponfacade.models.bo.YzCouponDefinitionRequest;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityYzDtoPO;
import com.bizvane.couponfacade.models.vo.AvailableCouponVo;
import com.bizvane.couponfacade.models.vo.CertificateVo;
import com.bizvane.couponfacade.models.vo.CouponDetailsVo;
import com.bizvane.couponfacade.models.vo.VoucherIssuanceVo;
import com.bizvane.couponfacade.models.vo.VoucherVerificationVo;
import com.bizvane.couponservice.common.constants.CurrencyEnum;
import com.bizvane.couponservice.common.datavo.CouponCancelUseYzVo;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.couponservice.service.StandardCouponService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/youzan/coupon"})
@RestController
public class YouZanCouponController
implements YouZanCouponServiceFeign {
    private static final Logger log = LoggerFactory.getLogger(YouZanCouponController.class);
    @Autowired
    private CouponService couponService;
    @Autowired
    private StandardCouponService standardCouponService;
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    @ApiOperation(value="4\u3001\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f (\u5238\u5b9a\u4e49\u4fe1\u606f)", notes="\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f (\u5238\u5b9a\u4e49\u4fe1\u606f)")
    public ResponseData<CouponDefinitionPOWithBLOBs> queryCouponDefinitionInfo(@RequestBody @Valid YzCouponDefinitionRequest couponDefinitionVo) {
        log.info("yz_queryCouponDefinition:{}", (Object)couponDefinitionVo.toString());
        return new ResponseData((Object)((CouponDefinitionPOWithBLOBs)this.redisTemplate.opsForValue().get((Object)("coupon:yz:getCouponDefinition:couponDefinitionId:" + couponDefinitionVo.getActivityId()))));
    }

    @ApiOperation(value="5\u3001\u4e0b\u5355\u524d\u7f6e\u9875\u83b7\u53d6\u53ef\u7528\u5238\u5217\u8868(\u83b7\u53d6\u4f1a\u5458\u7684\u53ef\u7528\u5238\u5217\u8868)", notes="\u4e0b\u5355\u524d\u7f6e\u9875\u83b7\u53d6\u53ef\u7528\u5238\u5217\u8868(\u83b7\u53d6\u4f1a\u5458\u7684\u53ef\u7528\u5238\u5217\u8868)")
    public ResponseData<List<AvailableCouponDto>> queryCouponByYzOpenId(@RequestBody @Valid AvailableCouponVo availableCouponVo) {
        log.info("queryCouponDefinition {}", (Object)availableCouponVo.toString());
        StopWatch watch = new StopWatch();
        ResponseData responseData = new ResponseData();
        ArrayList<AvailableCouponDto> availableCouponDtos = new ArrayList<AvailableCouponDto>();
        watch.start("\u67e5\u8be2\u5238\u5217\u8868\u4efb\u52a1");
        List resultBeans = this.couponEntityService.findCouponByMemberCode(availableCouponVo.getKdtId().toString(), availableCouponVo.getYzOpenId(), Integer.valueOf(20), 1, 20);
        if (resultBeans != null && resultBeans.size() > 0) {
            for (CouponEntityYzDtoPO couponEntityDto : resultBeans) {
                AvailableCouponDto availableCouponDto = new AvailableCouponDto();
                availableCouponDto.setId(couponEntityDto.getCouponEntityId());
                availableCouponDto.setActivityId(Long.valueOf(Long.parseLong(couponEntityDto.getCouponDefinitionId())));
                availableCouponDto.setPreferentialMode(couponEntityDto.getPreferentialType());
                if (Long.valueOf(1L).equals(couponEntityDto.getPreferentialType())) {
                    availableCouponDto.setValue(Long.valueOf(couponEntityDto.getMoney().longValue() * 100L));
                } else if (Long.valueOf(2L).equals(couponEntityDto.getPreferentialType())) {
                    availableCouponDto.setValue(Long.valueOf(couponEntityDto.getDiscount().longValue() * 10L));
                }
                availableCouponDto.setCurrency(CurrencyEnum.CNY.getCode());
                Integer status = 0;
                status = this.toYzCouponStatus(couponEntityDto.getCouponStatus());
                availableCouponDto.setStatus(status);
                availableCouponDto.setValidStartTime(couponEntityDto.getValidDateStart());
                availableCouponDto.setValidEndTime(couponEntityDto.getValidDateEnd());
                availableCouponDto.setPhone(couponEntityDto.getPhone());
                availableCouponDtos.add(availableCouponDto);
            }
        }
        watch.stop();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(availableCouponDtos);
        log.info("\u4efb\u52a1\u8017\u65f6 {} ms", (Object)watch.getTotalTimeMillis());
        log.info("{}", (Object)watch.prettyPrint());
        return responseData;
    }

    private Integer toYzCouponStatus(String couponStatus) {
        Integer status = "20".equals(couponStatus) ? Integer.valueOf(1) : ("30".equals(couponStatus) ? Integer.valueOf(2) : Integer.valueOf(3));
        return status;
    }

    private Integer toBzCouponStatus(Integer couponStatus) {
        Integer status = null;
        if (1 == couponStatus) {
            status = 20;
        } else if (2 == couponStatus) {
            status = 30;
        } else if (3 == couponStatus) {
            status = 25;
        }
        return status;
    }

    @ApiOperation(value="6.\u67e5\u8be2\u4e70\u5bb6\u4f18\u60e0\u51ed\u8bc1\u5217\u8868", notes="6.\u67e5\u8be2\u4e70\u5bb6\u4f18\u60e0\u51ed\u8bc1\u5217\u8868")
    public ListResultBean<CertificateDto> queryCertificateByYzOpenId(@RequestBody @Valid CertificateVo certificateVo) {
        log.info("queryCouponDefinition {}", (Object)certificateVo.toString());
        ArrayList<String> activityIdList = new ArrayList<String>();
        for (Object activityId : certificateVo.getActivityIds()) {
            activityIdList.add((String)activityId);
        }
        List listByStatusPage = this.couponEntityService.findCouponByMemberCode(certificateVo.getKdtId().toString(), certificateVo.getYzOpenId(), this.toBzCouponStatus(certificateVo.getSearchStatus()), certificateVo.getPageNum().intValue(), certificateVo.getPageSize().intValue());
        ListResultBean listResultBean = new ListResultBean();
        ArrayList<CertificateDto> list = new ArrayList<CertificateDto>();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (CouponEntityYzDtoPO couponEntityDto : listByStatusPage) {
            CertificateDto certificateDto = new CertificateDto();
            certificateDto.setId(couponEntityDto.getCouponEntityId());
            certificateDto.setActivityId(Long.valueOf(Long.parseLong(couponEntityDto.getCouponDefinitionId())));
            certificateDto.setPreferentialMode(Long.valueOf(couponEntityDto.getPreferentialType()));
            if (Long.valueOf(1L).equals(couponEntityDto.getPreferentialType())) {
                certificateDto.setValue(Long.valueOf(couponEntityDto.getMoney().longValue() * 100L));
            } else if (Long.valueOf(2L).equals(couponEntityDto.getPreferentialType())) {
                certificateDto.setValue(Long.valueOf(couponEntityDto.getDiscount().longValue() * 10L));
            }
            certificateDto.setCurrency(CurrencyEnum.CNY.getCode());
            Integer status = 0;
            status = this.toYzCouponStatus(couponEntityDto.getCouponStatus());
            certificateDto.setStatus(status);
            Date date = couponEntityDto.getValidDateStart();
            LocalDateTime localDateStartTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            certificateDto.setValidStartTime(dateTimeFormatter.format(localDateStartTime));
            Date endDate = couponEntityDto.getValidDateEnd();
            LocalDateTime localDateEndTime = LocalDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault());
            certificateDto.setValidEndTime(dateTimeFormatter.format(localDateEndTime));
            certificateDto.setPhone(couponEntityDto.getPhone());
            Date createDate = couponEntityDto.getValidDateEnd();
            LocalDateTime localDateCreateDate = LocalDateTime.ofInstant(createDate.toInstant(), ZoneId.systemDefault());
            certificateDto.setSentAt(dateTimeFormatter.format(localDateCreateDate));
            certificateDto.setVerifyCode(couponEntityDto.getCouponCode());
            list.add(certificateDto);
        }
        listResultBean.setResult(list);
        return listResultBean;
    }

    @ApiOperation(value="7\u3001\u67e5\u8be2\u51ed\u8bc1\u8be6\u60c5\u4fe1\u606f(\u5238\u8be6\u60c5)", notes="\u67e5\u8be2\u51ed\u8bc1\u8be6\u60c5\u4fe1\u606f(\u5238\u8be6\u60c5)")
    public ResponseData<CouponDetailsDto> queryCouponInfo(@RequestBody @Valid CouponDetailsVo queryCouponInfoVo) {
        log.info("enter youzan queryCouponInfo couponCode:{}", (Object)JacksonUtil.bean2Json((Object)queryCouponInfoVo));
        ResponseData result = new ResponseData();
        try {
            CouponEntityYzDtoPO couponEntityYzDtoPO = this.couponEntityService.findCouponDetailByPhoneAuthority(queryCouponInfoVo.getKdtId(), queryCouponInfoVo.getId());
            log.info("\u8c03\u7528\u5238\u670d\u52a1\u67e5\u8be2\u4f1a\u5458\u4f18\u60e0\u5238\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)couponEntityYzDtoPO);
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            CouponDetailsDto couponDetailsDto = new CouponDetailsDto();
            if (couponEntityYzDtoPO != null) {
                couponDetailsDto.setId(couponEntityYzDtoPO.getCouponEntityId());
                couponDetailsDto.setActivityId(Long.valueOf(Long.parseLong(couponEntityYzDtoPO.getCouponDefinitionId())));
                couponDetailsDto.setPreferentialMode(couponEntityYzDtoPO.getPreferentialType());
                if (Long.valueOf(1L).equals(couponEntityYzDtoPO.getPreferentialType())) {
                    couponDetailsDto.setValue(Long.valueOf(couponEntityYzDtoPO.getMoney().longValue() * 100L));
                } else if (Long.valueOf(2L).equals(couponEntityYzDtoPO.getPreferentialType())) {
                    couponDetailsDto.setValue(Long.valueOf(couponEntityYzDtoPO.getDiscount().longValue() * 10L));
                }
                couponDetailsDto.setCurrency(CurrencyEnum.CNY.getCode());
                Integer status = 0;
                status = this.toYzCouponStatus(String.valueOf(couponEntityYzDtoPO.getCouponStatus()));
                couponDetailsDto.setStatus(status);
                Date date = couponEntityYzDtoPO.getValidDateStart();
                LocalDateTime localDateStartTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                couponDetailsDto.setValidStartTime(dateTimeFormatter.format(localDateStartTime));
                Date endDate = couponEntityYzDtoPO.getValidDateEnd();
                LocalDateTime localDateEndTime = LocalDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault());
                couponDetailsDto.setValidEndTime(dateTimeFormatter.format(localDateEndTime));
                couponDetailsDto.setPhone(couponEntityYzDtoPO.getPhone());
                Date createDate = couponEntityYzDtoPO.getCreateDate();
                LocalDateTime localDateCreateDate = LocalDateTime.ofInstant(createDate.toInstant(), ZoneId.systemDefault());
                couponDetailsDto.setSentAt(dateTimeFormatter.format(localDateCreateDate));
                couponDetailsDto.setVerifyCode(couponEntityYzDtoPO.getCouponCode());
                couponDetailsDto.setYzOpenId(this.couponEntityService.getYzOpenId(couponEntityYzDtoPO.getMemberCode()));
            }
            result.setCode(SysResponseEnum.SUCCESS.getCode());
            result.setMessage(SysResponseEnum.SUCCESS.getMessage());
            result.setData((Object)couponDetailsDto);
        }
        catch (Exception e) {
            log.error("queryInfo \u8f93\u51fa\u9519\u8bef\u65e5\u5fd7{}", (Object)e.getMessage());
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(SysResponseEnum.SYSTEM_ERROR.getMessage());
        }
        return result;
    }

    @ApiOperation(value="8.\u51ed\u8bc1\u53d1\u653e", notes="8.\u51ed\u8bc1\u53d1\u653e")
    public ResponseData<VoucherIssuanceDto> sendCoupon(@RequestBody @Valid VoucherIssuanceVo param) {
        log.info("enter youZan sendCoupon start:{}", (Object)JacksonUtil.bean2Json((Object)param));
        ResponseData result = new ResponseData();
        String redisKey = "coupon:yzSendCoupon:phone:" + param.getPhone();
        CouponEntityPO couponEntityPO = (CouponEntityPO)this.redisTemplate.opsForValue().get((Object)redisKey);
        VoucherIssuanceDto voucherIssuanceDto = new VoucherIssuanceDto();
        voucherIssuanceDto.setId(couponEntityPO.getCouponEntityId());
        voucherIssuanceDto.setSuccess(Boolean.valueOf(true));
        Long money = couponEntityPO.getMoney() == null ? 0L : couponEntityPO.getMoney().multiply(BigDecimal.TEN).longValue();
        voucherIssuanceDto.setValue(money);
        voucherIssuanceDto.setIdempotentSuccess(Boolean.valueOf(true));
        voucherIssuanceDto.setVerifyCode(couponEntityPO.getCouponCode());
        result.setCode(SysResponseEnum.SUCCESS.getCode());
        result.setMessage(SysResponseEnum.SUCCESS.getMessage());
        result.setData((Object)voucherIssuanceDto);
        this.redisTemplate.delete((Object)redisKey);
        log.info("enter youZan sendCoupon end, {}", JSON.toJSON((Object)result));
        return result;
    }

    @ApiOperation(value="9.\u6838\u9500\u51ed\u8bc1", notes="9.\u6838\u9500\u51ed\u8bc1")
    @PostMapping(value={"/useCoupon"})
    public ResponseData<VoucherVerificationDto> useCoupon(@RequestBody @Valid VoucherVerificationVo param) {
        this.standardCouponService.couponUse(param);
        VoucherVerificationDto voucherVerificationDto = new VoucherVerificationDto();
        voucherVerificationDto.setOrderNo(param.getOrderNo());
        voucherVerificationDto.setOrderSource(param.getOrderSource());
        voucherVerificationDto.setIdempotentSuccess(Boolean.valueOf(true));
        voucherVerificationDto.setVerifySuccess(Boolean.valueOf(true));
        return new ResponseData((Object)voucherVerificationDto);
    }

    @ApiOperation(value="10.\u9000\u8fd8\u51ed\u8bc1", notes="10.\u9000\u8fd8\u51ed\u8bc1")
    public ResponseData<RefundVoucherDto> reversal(@RequestBody @Valid VoucherVerificationVo param) {
        log.info("enter youZan reversal start:{}", (Object)JacksonUtil.bean2Json((Object)param));
        ResponseData responseData = new ResponseData();
        StopWatch stopWatch = new StopWatch("\u6838\u9500\u51ed\u8bc1");
        RefundVoucherDto refundVoucherDto = new RefundVoucherDto();
        refundVoucherDto.setOrderNo(param.getOrderNo());
        refundVoucherDto.setOrderSource(param.getOrderSource());
        CouponCancelUseYzVo couponCancelUseYzVo = new CouponCancelUseYzVo();
        couponCancelUseYzVo.setCouponId(param.getId());
        couponCancelUseYzVo.setKdtId(param.getKdtId());
        couponCancelUseYzVo.setOrderNo(param.getOrderNo());
        String phone = this.couponEntityService.getMemberByYzOpenId(param.getYzOpenId()).getPhone();
        couponCancelUseYzVo.setPhone(phone);
        stopWatch.start("\u5238\u51b2\u6b63\u4efb\u52a1");
        ResponseData temp = this.couponService.cancelUse(couponCancelUseYzVo);
        stopWatch.stop();
        if (SysResponseEnum.SUCCESS.getCode() == temp.getCode()) {
            refundVoucherDto.setIsSystemError(Boolean.valueOf(false));
            refundVoucherDto.setSuccess(Boolean.valueOf(true));
            refundVoucherDto.setIdempotentSuccess(Boolean.valueOf(true));
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)refundVoucherDto);
        } else {
            refundVoucherDto.setIsSystemError(Boolean.valueOf(true));
            refundVoucherDto.setErrorMsg(temp.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData((Object)refundVoucherDto);
        }
        log.info("\u4efb\u52a1\u8017\u65f6 {} ms", (Object)stopWatch.getTotalTimeMillis());
        log.info("{}", (Object)stopWatch.prettyPrint());
        return responseData;
    }
}

