/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.models.bo.SendCouponWebhookRequest;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponInfoVo;
import com.bizvane.couponfacade.models.vo.CouponSendFailLogVO;
import com.bizvane.couponfacade.models.vo.PreGeneratedCouponAlipayTaskCreateVO;
import com.bizvane.couponfacade.models.vo.SendCoupon361SimpleRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponAsyncRequestBO;
import com.bizvane.couponfacade.models.vo.SendCouponAsyncSimpleRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponQuotaBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleOldVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponUrSimpleRequestVO;
import com.bizvane.couponfacade.models.vo.SimpleSendTmallCouponVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.utils.BusinessCodeUtil;
import com.bizvane.couponservice.common.utils.CouponException;
import com.bizvane.couponservice.common.utils.HttpUtils;
import com.bizvane.couponservice.common.utils.QiNiuUtil;
import com.bizvane.couponservice.rocketmq.MQSendCouponService;
import com.bizvane.couponservice.rocketmq.rocketutils.RocketMQProducerService;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.couponservice.service.CouponQuotaDetailService;
import com.bizvane.couponservice.service.SendCouponService;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sendCoupon"})
public class SendCouponController {
    @Autowired
    private SendCouponService sendCouponService;
    @Autowired
    private MQSendCouponService mqSendCouponService;
    @Autowired
    private CouponQuotaDetailService couponQuotaDetailService;
    @Autowired
    private RocketMQProducerService rocketMqProducerService;
    @Autowired
    private CouponManualService couponManualService;
    private static final Logger logger = LoggerFactory.getLogger(SendCouponController.class);

    @ApiOperation(value="\u5355\u5f20\u53d1\u5238\u63a5\u53e3", notes="\u5355\u5f20\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/simpleMQ"})
    public void simpleMQ(@RequestBody(required=false) SendCouponSimpleRequestVO vo) {
        this.mqSendCouponService.sendCoupon(vo, 1);
    }

    @PostMapping(value={"/simpleSendTmallCoupon"})
    @ApiOperation(value="\u5929\u732b\u5238\u53d1\u9001", notes="\u5355\u5f20\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    public ResponseData simpleSendTmallCoupon(@RequestBody SimpleSendTmallCouponVO vo) {
        if (vo.getCount() == null) {
            vo.setCount(Integer.valueOf(1));
        }
        return this.sendCouponService.sendSimpleTmallCoupon(vo);
    }

    @ApiOperation(value="\u5355\u5f20\u53d1\u5238\u63a5\u53e3", notes="\u5355\u5f20\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/simple"})
    @Deprecated
    public ResponseData<String> simple(@RequestBody(required=false) SendCouponSimpleRequestVO vo) {
        return this.sendCouponService.simple(vo);
    }

    @ApiOperation(value="\u5355\u5f20\u53d1\u5238\u63a5\u53e3", notes="\u5355\u5f20\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/simpleAsync"})
    public ResponseData<String> simpleAsync(@RequestBody(required=false) SendCouponAsyncRequestBO bo) {
        return this.sendCouponService.simple(bo);
    }

    @ApiOperation(value=" \u540c\u6b65\u65e7\u7cfb\u7edf\u5238", notes=" \u540c\u6b65\u65e7\u7cfb\u7edf\u5238", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/simpleOldcoupon"})
    public ResponseData<String> simpleOldcoupon(@RequestBody(required=false) SendCouponSimpleOldVO vo, HttpServletRequest request) {
        if ("FromDesktop".equals(vo.getUrl())) {
            try {
                File file = new File("C:\\Users\\pc1\\Desktop\\tem\\FileCoupon\\" + vo.getBusinessName() + ".xlsx");
                FileInputStream inputStream = new FileInputStream(file);
                String qiniuUrl2 = QiNiuUtil.upload((InputStream)inputStream, (String)("FileCoupon" + vo.getBusinessName() + BusinessCodeUtil.getCouponBatchSendCode() + ".xlsx"));
                vo.setUrl(qiniuUrl2);
            }
            catch (FileNotFoundException e) {
                logger.error("\u5f02\u5e38", (Throwable)e);
            }
        }
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        vo.setBrandId(accountPo.getBrandId());
        logger.info("enter simplesimpleOldcouponSendCouponSimpleRequestVO:{}", (Object)JSONObject.toJSONString((Object)vo));
        return this.sendCouponService.simpleOldcoupon(vo);
    }

    @ApiOperation(value="\u6279\u91cf\u53d1\u5238\u63a5\u53e3", notes="\u6279\u91cf\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/batchRpc"})
    public ResponseData<String> batchCoupon(@RequestBody SendCouponBatchRequestVO vo) {
        ResponseData responseData = this.sendCouponService.batchRpc(vo);
        return responseData;
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u5546\u5bb6\u5238\u6279\u91cf\u53d1\u5238\u63a5\u53e3", notes="\u652f\u4ed8\u5b9d\u5546\u5bb6\u5238\u6279\u91cf\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/batchAlipayCoupon"})
    public ResponseData<Long> batchAlipayCoupon(@RequestBody @Valid PreGeneratedCouponAlipayTaskCreateVO vo) throws Exception {
        ResponseData responseData = this.couponManualService.createAlipayPreGeneratedCoupon(vo);
        return responseData;
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u6279\u91cf\u53d1\u5238\u63a5\u53e3", notes="\u6279\u91cf\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/couponQuotaBatchRpc"})
    public ResponseData<String> couponQuotaBatchRpc(@RequestBody SendCouponQuotaBatchRequestVO vo) {
        vo.setBusinessType(SendTypeEnum.SEND_COUPON_QUOTA_MALl.getCode());
        vo.setBusinessName(vo.getStaffName() + "/" + vo.getStaffCode());
        vo.setCreateUserName(vo.getStaffCode());
        ArrayList<MemberInfoVo> memberList = new ArrayList<MemberInfoVo>();
        String[] memberCodes = vo.getMemberCodeStr().split(",");
        for (int i = 0; i < memberCodes.length; ++i) {
            MemberInfoVo memberInfoVo = new MemberInfoVo();
            memberInfoVo.setMemberCode(memberCodes[i]);
            memberList.add(memberInfoVo);
        }
        vo.setMemberNum(memberList.size() + "");
        ResponseData response = this.couponQuotaDetailService.batchRpc(vo);
        if (response.getCode() > 0) {
            return response;
        }
        logger.info("enter batchCoupon method param: \u4f01\u4e1a\u5fae\u4fe1 \u6279\u91cf\u53d1\u5238:{}", response.getData());
        SendCouponBatchRequestVO sendCouponBatchRequestVO = new SendCouponBatchRequestVO();
        sendCouponBatchRequestVO.setCouponDefinitionId(vo.getCouponDefinitionId());
        sendCouponBatchRequestVO.setSysCompanyId(vo.getSysCompanyId());
        sendCouponBatchRequestVO.setSysBrandId(vo.getSysBrandId());
        sendCouponBatchRequestVO.setMemberNum(vo.getMemberNum());
        sendCouponBatchRequestVO.setBusinessType(SendTypeEnum.SEND_COUPON_QUOTA_MALl.getCode());
        sendCouponBatchRequestVO.setBusinessName(vo.getStaffName() + "/" + vo.getStaffCode());
        sendCouponBatchRequestVO.setCreateUserName(vo.getStaffCode());
        sendCouponBatchRequestVO.setBusinessId(Long.valueOf(Long.parseLong((String)response.getData())));
        sendCouponBatchRequestVO.setMemberList(memberList);
        sendCouponBatchRequestVO.setMemberNum(memberList.size() + "");
        ResponseData responseData = this.sendCouponService.batchRpc(sendCouponBatchRequestVO);
        logger.info("enter batchCoupon method param: \u4f01\u4e1a\u5fae\u4fe1 \u6279\u91cf\u53d1\u5238end:{}", responseData.getData());
        return responseData;
    }

    @ApiOperation(value="\u5238\u5230\u671f\u63d0\u9192", notes="\u5238\u5230\u671f\u63d0\u9192", tags={"\u53d1\u5238"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="expireDay", value="\u8fc7\u671f\u65f6\u95f4", required=true, dataType="String")})
    @PostMapping(value={"/expire"})
    public ResponseData<Integer> expire(@RequestParam(value="expireDay", required=false) String expireDay) {
        ResponseData responseData = this.sendCouponService.expire(expireDay);
        return responseData;
    }

    @ApiOperation(value="\u5238\u8865\u53d1(\u5355\u5f20)", notes="\u5238\u8865\u53d1(\u5355\u5f20)", tags={"\u53d1\u5238"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponSendFailLogId", value="\u5238\u5931\u8d25\u65e5\u5fd7\u8868id", required=true, dataType="Long")})
    @PostMapping(value={"/sendSingleAgain.do"})
    public ResponseData<Integer> sendSingleAgain(@RequestParam(value="couponSendFailLogId", required=false) Long couponSendFailLogId) {
        return this.sendCouponService.sendSingleAgain(couponSendFailLogId);
    }

    @ApiOperation(value="\u5238\u8865\u53d1(\u6279\u91cf)", notes="\u5238\u8865\u53d1(\u6279\u91cf)", tags={"\u53d1\u5238"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5238\u5931\u8d25\u65e5\u5fd7id", required=true, dataType="String")})
    @PostMapping(value={"/sendBatchAgain.do"})
    public ResponseData<Integer> sendBatchAgain(@RequestParam(value="ids") String ids) {
        return this.sendCouponService.sendBatchAgain(ids);
    }

    @PostMapping(value={"/sendBatchAgainTask"})
    public ResponseData<Object> sendBatchAgainTask(CouponSendFailLogVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        this.sendCouponService.sendBatchAgainTask(vo, sysAccountPO);
        return new ResponseData();
    }

    @ApiOperation(value="\u5f02\u6b65\u5355\u5f20\u53d1\u5238\u63a5\u53e3", notes="\u5f02\u6b65\u5355\u5f20\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/asyncSimple"})
    ResponseData<String> asyncSimple(@RequestBody(required=false) @Valid SendCouponAsyncSimpleRequestVO vo) {
        if (vo.getTaskCouponSum() == null) {
            vo.setTaskCouponSum(Integer.valueOf(1));
        }
        this.rocketMqProducerService.syncSendMessage("tagSimpleSendCouponService", (Object)vo, vo.getCompanyId().longValue(), vo.getTaskCouponSum().intValue());
        return new ResponseData();
    }

    @ApiOperation(value="361\u4f1a\u5458\u9886\u5238\u63a5\u53e3", notes="361\u4f1a\u5458\u9886\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @RequestMapping(value={"/simpleOf361"}, method={RequestMethod.POST})
    ResponseData<CouponEntityPO> simpleOf361(@RequestBody(required=false) SendCoupon361SimpleRequestVO vo) {
        return this.sendCouponService.simpleOf361(vo);
    }

    @ApiOperation(value="361\u795e\u7b56Webhook\u53d1\u5238\u63a5\u53e3", notes="361\u795e\u7b56Webhook\u53d1\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @RequestMapping(value={"/webhookSendCoupon"}, method={RequestMethod.POST})
    ResponseData<Object> webhookSendCoupon(@RequestBody(required=false) SendCouponWebhookRequest request) {
        return this.sendCouponService.webhookSendCoupon361(request);
    }

    @ApiOperation(value="ur\u4f1a\u5458\u9886\u5238\u63a5\u53e3", notes="ur\u4f1a\u5458\u9886\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @RequestMapping(value={"/simpleOfur"}, method={RequestMethod.POST})
    ResponseData<CouponInfoVo> simpleOfur(@RequestBody(required=false) SendCouponUrSimpleRequestVO vo) {
        return this.sendCouponService.simpleOfur(vo);
    }

    @ApiOperation(value="\u5f02\u6b65\u6279\u91cf\u53d1\u5f02\u4e1a\u5238\u63a5\u53e3", notes="\u5f02\u6b65\u6279\u91cf\u53d1\u5f02\u4e1a\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/asyncBatchSendDifindustry"})
    ResponseData<String> asyncBatchSendDifindustry(@RequestBody(required=false) @Valid List<SendCouponAsyncSimpleRequestVO> list) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        try {
            responseData = this.sendCouponService.asyncBatchSendDifindustry(list);
            return responseData;
        }
        catch (CouponException e) {
            String message = e.getMessage();
            responseData.setMessage(message);
            return responseData;
        }
    }

    @ApiOperation(value="\u5f02\u6b65\u5355\u53d1\u5f02\u4e1a\u5238\u63a5\u53e3", notes="\u5f02\u6b65\u5355\u53d1\u5f02\u4e1a\u5238\u63a5\u53e3", tags={"\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/asyncSimpleSendDifindustryCoupon"})
    ResponseData<String> asyncSimpleSendDifindustryCoupon(@RequestBody @Valid SendCouponAsyncSimpleRequestVO vo) {
        if (vo.getTaskCouponSum() == null) {
            vo.setTaskCouponSum(Integer.valueOf(1));
        }
        ResponseData responseData = this.sendCouponService.asyncSimpleSendDifindustryCoupon(vo);
        return responseData;
    }

    @ApiOperation(value="\u5546\u79c0\u53d1\u5f02\u4e1a\u5238\u5238\u63d0\u524d\u9501\u5b9a\u6c60\u5b50", notes="\u5546\u79c0\u53d1\u5f02\u4e1a\u5238\u5238\u63d0\u524d\u9501\u5b9a\u6c60\u5b50", tags={"\u63d0\u524d\u9501\u5b9a\u6c60\u5b50"}, httpMethod="POST")
    @PostMapping(value={"/reduceDifindustryCouponQuantity"})
    public ResponseData<String> reduceDifindustryCouponQuantity(@RequestBody @Valid CouponDefinitionVO vo) {
        ResponseData responseData = this.sendCouponService.reduceDifindustryCouponQuantity(vo);
        return responseData;
    }

    @ApiOperation(value="\u5546\u79c0\u53d1\u5f02\u4e1a\u5238\u5238\u91ca\u653e\u5238\u6c60\u5b50", notes="\u5546\u79c0\u53d1\u5f02\u4e1a\u5238\u91ca\u653e\u5238\u6c60\u5b50", tags={"\u91ca\u653e\u5238\u6c60\u5b50"}, httpMethod="POST")
    @PostMapping(value={"/releaseDifindustryCouponQuantity"})
    public ResponseData<String> releaseDifindustryCouponQuantity(@RequestBody @Valid SendCouponSimpleRequestVO vo) {
        ResponseData responseData = this.sendCouponService.releaseDifindustryCouponQuantity(vo);
        return responseData;
    }
}

