/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysDimSkuPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysAccountServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCacheServiceRpc;
import com.bizvane.centerstageservice.rpc.SysDimSkuServiceRpc;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponservice.common.utils.HttpParamUtil;
import com.bizvane.couponservice.common.utils.HttpUtils;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.service.OtherModulesService;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.SearchExternalRequest;
import com.bizvane.members.facade.es.vo.SearchPhoneBatchRequest;
import com.bizvane.members.facade.es.vo.SearchStoreRequest;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/otherModules"})
public class OtherModulesController {
    private static final Logger logger = LoggerFactory.getLogger(OtherModulesController.class);
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private OtherModulesService otherModulesService;
    @Autowired
    private SysDimSkuServiceRpc sysDimSkuServiceRpc;
    @Autowired
    private SysAccountServiceRpc sysAccountServiceRpc;
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    @Autowired
    private SysCacheServiceRpc sysCacheServiceRpc;

    @ApiOperation(value="\u67e5\u8be2\u5e97\u94fa\u5206\u9875\u63a5\u53e3", notes="\u67e5\u8be2\u5e97\u94fa\u5206\u9875\u63a5\u53e3", tags={"\u4e2d\u53f0\u6a21\u5757"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysStoreOfflineCode", value="\u5e97\u94fa\u7ebf\u4e0b\u7f16\u53f7", required=true, dataType="String"), @ApiImplicitParam(name="storeName", value="\u5e97\u94fa\u540d\u79f0", required=true, dataType="String")})
    @PostMapping(value={"/staffPage.do"})
    public ResponseData<PageInfo<SysStorePo>> getScreenStaff(@RequestParam(value="sysStoreOfflineCode", required=false) String sysStoreOfflineCode, @RequestParam(value="storeName", required=false) String storeName, PageFormUtil page, HttpServletRequest request) {
        ResponseData responseData = this.storeServiceRpc.getConditionStoreList(sysStoreOfflineCode, storeName, page.getPageNumber(), page.getPageSize());
        return responseData;
    }

    @ApiOperation(value="\u6839\u636e\u9ad8\u7ea7\u641c\u7d22\u6761\u4ef6\u67e5\u627e\u4f1a\u5458", notes="\u6839\u636e\u9ad8\u7ea7\u641c\u7d22\u6761\u4ef6\u67e5\u627e\u4f1a\u5458", tags={"\u67e5\u8be2\u4f1a\u5458\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="", value="", required=true, dataType="String")})
    @PostMapping(value={"/getMemberList.do"})
    public ResponseData<List<MemberInfoVo>> getMemberList(MembersInfoSearchVo memberVO) {
        ResponseData responseData = null;
        try {
            responseData = this.otherModulesService.searchMembers(memberVO);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return responseData;
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1code\u548c\u5546\u54c1\u540d\u79f0\u5206\u9875\u67e5\u8be2\u5217\u8868", notes="\u6839\u636e\u5546\u54c1code\u548c\u5546\u54c1\u540d\u79f0\u5206\u9875\u67e5\u8be2\u5217\u8868", tags={"\u4e2d\u53f0\u6a21\u5757"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="productCode", value="\u5546\u54c1\u7f16\u7801", required=true, dataType="String"), @ApiImplicitParam(name="productName", value="\u5546\u54c1\u540d\u79f0", required=true, dataType="String")})
    @PostMapping(value={"/getDimSkuList.do"})
    public ResponseData<PageInfo<SysDimSkuPo>> getSysDimSkuList(@RequestParam(value="productCode", required=false) String productCode, @RequestParam(value="productName", required=false) String productName, PageFormUtil page, HttpServletRequest request) {
        ResponseData responseData = this.sysDimSkuServiceRpc.getConditionDimSkuList(productCode, productName, page.getPageNumber(), page.getPageSize());
        return responseData;
    }

    @PostMapping(value={"/memberEs.do"})
    public ResponseData<PageInfo<MembersInfoSearchPojo>> findMemberEsSearch(HttpServletRequest request) {
        SearchPhoneBatchRequest phoneBatch;
        MembersInfoSearchVo searchVo = (MembersInfoSearchVo)JacksonUtil.json2Objs((String)HttpParamUtil.getJsonParam((HttpServletRequest)request), MembersInfoSearchVo.class);
        logger.info("findMemberEsSearch searchVo:{}", (Object)JSONObject.toJSONString((Object)searchVo));
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        searchVo.setBrandId(accountPo.getBrandId());
        searchVo.setSysCompanyId(accountPo.getSysCompanyId());
        if (searchVo.getOnlineOrgCode() != null && !searchVo.getOnlineOrgCode().equals(accountPo.getOnlineOrgCode())) {
            accountPo.setOnlineOrgCode(searchVo.getOnlineOrgCode());
        }
        searchVo.setOnlineOrgCode(accountPo.getOnlineOrgCode());
        ResponseData storeIds = null;
        try {
            storeIds = this.sysAccountServiceRpc.getAllStoreIds(accountPo.getSysAccountId(), accountPo.getBrandId());
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
        }
        if (storeIds != null) {
            searchVo.setStoreList((List)storeIds.getData());
        }
        if ((phoneBatch = searchVo.getPhoneBatch()) != null && StringUtils.isBlank((CharSequence)phoneBatch.getMobile()) && StringUtils.isBlank((CharSequence)phoneBatch.getUrl())) {
            return new ResponseData(-1, "\u67e5\u8be2\u6761\u4ef6\u52fe\u9009\u4e86\u624b\u673a\u53f7\uff0c\u5fc5\u987b\u586b\u5199\u624b\u673a\u53f7", null);
        }
        this.dealStroe(searchVo);
        this.dealGroup(searchVo);
        ResponseData esResult = this.membersAdvancedSearchApiService.advancedSearch(searchVo);
        return esResult;
    }

    private void dealStroe(MembersInfoSearchVo searchVo) {
        List storeIdList;
        String openCardStoreKey;
        List storeIdList2;
        String serviceStoreKey = searchVo.getServiceStoreKey();
        if (StringUtils.isNotBlank((CharSequence)serviceStoreKey) && CollectionUtils.isNotEmpty((Collection)(storeIdList2 = (List)this.sysCacheServiceRpc.getSelectEdList(serviceStoreKey).getData()))) {
            SearchExternalRequest serviceStore = new SearchExternalRequest();
            serviceStore.setHas(Boolean.valueOf(true));
            ArrayList<SearchStoreRequest> list = new ArrayList<SearchStoreRequest>();
            for (String storeId : storeIdList2) {
                if (!StringUtils.isNotBlank((CharSequence)storeId)) continue;
                list.add(new SearchStoreRequest(Long.valueOf(storeId)));
            }
            serviceStore.setList(list);
            searchVo.setServiceStore(serviceStore);
        }
        if (StringUtils.isNotBlank((CharSequence)(openCardStoreKey = searchVo.getOpenCardStoreKey())) && CollectionUtils.isNotEmpty((Collection)(storeIdList = (List)this.sysCacheServiceRpc.getSelectEdList(openCardStoreKey).getData()))) {
            SearchExternalRequest openCardGuide = new SearchExternalRequest();
            openCardGuide.setHas(Boolean.valueOf(true));
            ArrayList<SearchStoreRequest> list = new ArrayList<SearchStoreRequest>();
            for (String storeId : storeIdList) {
                if (!StringUtils.isNotBlank((CharSequence)storeId)) continue;
                list.add(new SearchStoreRequest(Long.valueOf(storeId)));
            }
            openCardGuide.setList(list);
            searchVo.setOpenCardStore(openCardGuide);
        }
    }

    private void dealGroup(MembersInfoSearchVo searchVo) {
        if (StringUtils.isNotBlank((CharSequence)searchVo.getChildMbrGroupDefIdsStr())) {
            MbrGroupModel mbrGroupModel = new MbrGroupModel();
            mbrGroupModel.setMbrGroupDefId(Long.valueOf(searchVo.getChildMbrGroupDefIdsStr()));
            ArrayList<MbrGroupModel> groupList = new ArrayList<MbrGroupModel>();
            groupList.add(mbrGroupModel);
            ArrayList<ArrayList<MbrGroupModel>> list = new ArrayList<ArrayList<MbrGroupModel>>();
            list.add(groupList);
            SearchExternalRequest childMbrGroupDefIds = new SearchExternalRequest();
            childMbrGroupDefIds.setList(list);
            searchVo.setChildMbrGroupDefIds(childMbrGroupDefIds);
        }
    }
}

