/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.bizvane.couponfacade.models.po.SysCodeValuePO;
import com.bizvane.couponservice.service.DictService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@RestController
@RequestMapping(value={"/dict"})
public class DictController {
    private static final Logger logger = LoggerFactory.getLogger(DictController.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private RedisProperties redisProperties;

    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u7c7b\u578b\u67e5\u8be2\u53c2\u6570", notes="\u6839\u636e\u53c2\u6570\u7c7b\u578b\u67e5\u8be2\u53c2\u6570", tags={"\u53c2\u6570\u67e5\u8be2"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictType", value="\u53c2\u6570\u7c7b\u578b", required=true, dataType="String")})
    @PostMapping(value={"/get.do"})
    public ResponseData<Object> getDict(@RequestParam(value="dictType", required=false) String dictType) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)dictType)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        List list = this.dictService.getDicts(dictType);
        responseData.setData((Object)list);
        return responseData;
    }

    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u7c7b\u578b\u67e5\u8be2\u53c2\u6570(\u6279\u91cf)", notes="\u6839\u636e\u53c2\u6570\u7c7b\u578b\u67e5\u8be2\u53c2\u6570(\u6279\u91cf)", tags={"\u53c2\u6570\u67e5\u8be2"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictType", value="\u53c2\u6570\u7c7b\u578b", required=true, dataType="String", example="A,B,C")})
    @PostMapping(value={"/getBatch.do"})
    public ResponseData<Map<String, List<SysCodeValuePO>>> getDictBatch(@RequestParam(value="dictType", required=false) String dictType) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)dictType)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        Map map = this.dictService.getDictsBatch(dictType);
        responseData.setData((Object)map);
        return responseData;
    }

    @PostMapping(value={"/deleteRedisKey"})
    public ResponseData<Object> deleteRedisKey(@NotNull @RequestParam(value="db") Integer db, @NotNull @RequestParam(value="deleteSum") Integer deleteSum) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(1);
        poolConfig.setMaxIdle(1);
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, this.redisProperties.getHost(), this.redisProperties.getPort(), 30000, this.redisProperties.getPassword(), db.intValue());
        Jedis jedis = jedisPool.getResource();
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams scanParams = new ScanParams();
        scanParams.match("*");
        scanParams.count(Integer.valueOf(1000));
        int deleted = 0;
        while (true) {
            long scanStart = System.currentTimeMillis();
            ScanResult scanResult = jedis.scan(cursor, scanParams);
            cursor = scanResult.getCursor();
            List list = scanResult.getResult();
            long scanEnd = System.currentTimeMillis();
            logger.info("scan_end:" + (scanEnd - scanStart));
            Pipeline pipeline = jedis.pipelined();
            for (int m = 0; m < list.size(); ++m) {
                String mapentry = (String)list.get(m);
                pipeline.ttl(mapentry);
            }
            List timeList = pipeline.syncAndReturnAll();
            long getTTLEnd = System.currentTimeMillis();
            logger.info("getTTLEnd:" + (getTTLEnd - scanEnd));
            if (list.size() != timeList.size()) continue;
            int delCount = 0;
            for (int i = 0; i < timeList.size(); ++i) {
                if (!Long.valueOf(-1L).equals(timeList.get(i))) continue;
                pipeline.del((String)list.get(i));
                ++delCount;
                ++deleted;
            }
            if (delCount > 0) {
                pipeline.syncAndReturnAll();
                long deleteEnd = System.currentTimeMillis();
                logger.info("deleteEnd:" + (deleteEnd - getTTLEnd) + " count:" + delCount);
            }
            if ("0".equals(cursor) || deleted > deleteSum) break;
            logger.info("***********************");
        }
        logger.info("\u672c\u6b21\u5171\u6e05\u7406:" + deleted);
        jedisPool.close();
        return new ResponseData();
    }
}

