/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.bizvane.couponfacade.models.vo.CouponRecordRequestVO;
import com.bizvane.couponfacade.models.vo.CouponRecordResponseVO;
import com.bizvane.couponfacade.models.vo.CouponRecordTransferRequestVO;
import com.bizvane.couponfacade.models.vo.CouponRecordTransferVO;
import com.bizvane.couponservice.common.utils.JacksonUtil;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponRecord"})
public class CouponRecordController {
    private static final Logger logger = LoggerFactory.getLogger(CouponRecordController.class);
    @Autowired
    private CouponService couponService;

    @ResponseBody
    @PostMapping(value={"/findCouponRecordList"})
    ResponseData<PageInfo<CouponRecordTransferVO>> findCouponRecordList(CouponRecordTransferRequestVO vo, HttpServletRequest request) {
        logger.info("CouponRecordController findCouponRecordList params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysBrandId(accountPo.getBrandId());
        vo.setSysCompanyId(accountPo.getSysCompanyId());
        return this.couponService.findCouponRecordList(vo);
    }

    @ResponseBody
    @PostMapping(value={"/findCouponRecordPage"})
    ResponseData<PageInfo<CouponRecordResponseVO>> findCouponRecordPage(CouponRecordRequestVO vo, HttpServletRequest request) {
        logger.info("CouponRecordController findCouponRecordPage params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysBrandId(accountPo.getBrandId());
        vo.setSysCompanyId(accountPo.getSysCompanyId());
        return this.couponService.findCouponRecordPage(vo, accountPo);
    }

    @ResponseBody
    @PostMapping(value={"/exportCouponRecordList"})
    ResponseData exportCouponRecordList(CouponRecordRequestVO vo, HttpServletRequest request) {
        logger.info("CouponRecordController exportCouponRecordPage params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysBrandId(sysAccountPo.getBrandId());
        vo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        return this.couponService.exportCouponRecordList(vo, sysAccountPo);
    }
}

