/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.couponfacade.models.po.CouponQuotaDetailPO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDifferentBrandReqVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDifferentBrandRespVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDifferentBrandSaveVO;
import com.bizvane.couponfacade.models.vo.CouponQuotaDifferentBrandUpdateReqVO;
import com.bizvane.couponfacade.models.vo.CouponQuoteDifferentBrandDetailRespVO;
import com.bizvane.couponfacade.models.vo.StaffCouponQuotaDifferentBrandDetailReqVO;
import com.bizvane.couponservice.common.utils.HttpUtils;
import com.bizvane.couponservice.service.CouponQuotaDifferentBrandService;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponQuotaDifferentBrand"})
public class CouponQuotaDifferentBrandController {
    @Autowired
    private CouponQuotaDifferentBrandService couponQuotaDifferentBrandService;

    @PostMapping(value={"/saveOrUpdate"})
    public ResponseData<Long> saveOrUpdate(@RequestBody CouponQuotaDifferentBrandSaveVO po, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponQuotaDifferentBrandService.saveOrUpdate(po, accountPo);
    }

    @PostMapping(value={"/getList"})
    public ResponseData<PageInfo<CouponQuotaDifferentBrandRespVO>> getCouponQuotaDifferentBrandList(@RequestBody CouponQuotaDifferentBrandReqVO reqVO) {
        return this.couponQuotaDifferentBrandService.getCouponQuotaDifferentBrandList(reqVO);
    }

    @PostMapping(value={"/getDetail"})
    public ResponseData<CouponQuoteDifferentBrandDetailRespVO> getCouponQuotaDifferentBrandDetail(@RequestParam(value="couponQuotaId") Long couponQuotaId) {
        return this.couponQuotaDifferentBrandService.getCouponQuotaDifferentBrandDetail(couponQuotaId);
    }

    @PostMapping(value={"/getStaffQuotaDetailList"})
    public ResponseData<PageInfo<CouponQuotaDetailPO>> getStaffQuotaDetailList(@RequestBody StaffCouponQuotaDifferentBrandDetailReqVO reqVO) {
        return this.couponQuotaDifferentBrandService.getStaffCouponQuotaDifferentBrandDetail(reqVO);
    }

    @PostMapping(value={"/exportStaffQuotaDetailList"})
    public ResponseData<Boolean> exportStaffQuotaDetailList(@RequestBody StaffCouponQuotaDifferentBrandDetailReqVO reqVO, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponQuotaDifferentBrandService.exportStaffQuotaDetailList(reqVO, accountPo);
    }

    @PostMapping(value={"/updateStatus"})
    public ResponseData<String> updateStatus(@RequestBody CouponQuotaDifferentBrandUpdateReqVO reqVO, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponQuotaDifferentBrandService.updateStatus(reqVO, accountPo);
    }
}

