/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.rpc.SysAccountServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCacheServiceRpc;
import com.bizvane.couponfacade.enums.CouponEnum;
import com.bizvane.couponfacade.enums.CouponManualConditionEnum;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponManualRequestVO;
import com.bizvane.couponfacade.models.vo.CouponManualVO;
import com.bizvane.couponfacade.models.vo.EmpCouponTaskCreateVO;
import com.bizvane.couponfacade.models.vo.ModifyPreCouponTaskVO;
import com.bizvane.couponfacade.models.vo.PreGeneratedCouponTaskCreateVO;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.utils.HttpUtils;
import com.bizvane.couponservice.service.CouponManualService;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.SearchExternalRequest;
import com.bizvane.members.facade.es.vo.SearchStoreRequest;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponBatchManual"})
public class CouponManualBatchController {
    private static final Logger logger = LoggerFactory.getLogger(CouponManualBatchController.class);
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private SysAccountServiceRpc sysAccountServiceRpc;
    @Autowired
    private SysCacheServiceRpc sysCacheServiceRpc;

    @ApiOperation(value="\u521b\u5efa\u53d1\u5238\u4efb\u52a1", notes="\u521b\u5efa\u53d1\u5238\u4efb\u52a1", tags={"\u624b\u52a8\u53d1\u5238"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskName", value="\u4efb\u52a1\u540d\u79f0", required=true, dataType="String"), @ApiImplicitParam(name="sendTimeStr", value="\u53d1\u5238\u65f6\u95f4", required=true, dataType="String"), @ApiImplicitParam(name="sendType", value="\u53d1\u9001\u7c7b\u578b\uff1a1-\u7acb\u5373\u53d1\u9001\uff0c2-\u6307\u5b9a\u65f6\u95f4", required=true, dataType="Byte"), @ApiImplicitParam(name="couponDefinitionIds", value="\u5238\u5b9a\u4e49id\u5217\u8868", required=true, dataType="List"), @ApiImplicitParam(name="memberInfo", value="\u4f1a\u5458\u67e5\u8be2\u6761\u4ef6", required=true, dataType="MembersInfoSearchVo")})
    @PostMapping(value={"/addNewTask.do"})
    ResponseData<String> addNewTask(@RequestBody CouponManualRequestVO requestVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (null == requestVO) {
            requestVO = new CouponManualRequestVO();
        }
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        CouponManualVO couponManualVO = new CouponManualVO();
        couponManualVO.setCouponDefinitionIds(requestVO.getCouponDefinitionIds());
        couponManualVO.setTaskName(requestVO.getTaskName());
        couponManualVO.setSendTimeStr(requestVO.getSendTimeStr());
        couponManualVO.setSendType(requestVO.getSendType());
        couponManualVO.setTotalNumber(requestVO.getTotalNumber());
        couponManualVO.setMktGiftBagId(requestVO.getMktGiftBagId());
        couponManualVO.setMemberConditionType(requestVO.getMemberConditionType());
        MembersInfoSearchVo membersInfoSearchVo = requestVO.getSearchVo();
        this.dealStroe(membersInfoSearchVo);
        if (couponManualVO.getMemberConditionType() != null && CouponManualConditionEnum.MANUAL_GROUP_GROUP.getCode().equals(couponManualVO.getMemberConditionType())) {
            this.dealGroup(requestVO, membersInfoSearchVo);
        }
        ResponseData storeIds = null;
        try {
            storeIds = this.sysAccountServiceRpc.getAllStoreIds(accountPo.getSysAccountId(), accountPo.getBrandId());
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38", (Throwable)e);
        }
        if (storeIds != null) {
            membersInfoSearchVo.setStoreList((List)storeIds.getData());
        }
        logger.info("enter CouponManualBatchController addNewTask method param: SearchVo:{}", (Object)JSONObject.toJSONString((Object)membersInfoSearchVo));
        logger.info("enter CouponManualBatchController addNewTask method param: CouponManualVO:{}", (Object)JSONObject.toJSONString((Object)couponManualVO));
        logger.info("enter CouponManualBatchController addNewTask method param: SysAccountPo:{}", (Object)JSONObject.toJSONString((Object)accountPo));
        try {
            responseData = this.couponManualService.addNewTask(couponManualVO, membersInfoSearchVo, accountPo);
        }
        catch (Exception e) {
            logger.info(ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        return responseData;
    }

    private void dealStroe(MembersInfoSearchVo searchVo) {
        List storeIdList;
        String openCardStoreKey;
        List storeIdList2;
        String serviceStoreKey = searchVo.getServiceStoreKey();
        if (StringUtils.isNotBlank((CharSequence)serviceStoreKey) && CollectionUtils.isNotEmpty((Collection)(storeIdList2 = (List)this.sysCacheServiceRpc.getSelectEdList(serviceStoreKey).getData()))) {
            Map<Object, Object> sysStoreIdToStoreMap = new HashMap();
            if (searchVo.getServiceStore() != null && CollectionUtils.isNotEmpty((Collection)searchVo.getServiceStore().getList())) {
                sysStoreIdToStoreMap = searchVo.getServiceStore().getList().stream().collect(Collectors.toMap(m -> String.valueOf(m.getSysStoreId()), Function.identity()));
            }
            SearchExternalRequest serviceStore = new SearchExternalRequest();
            serviceStore.setHas(Boolean.valueOf(true));
            ArrayList<SearchStoreRequest> list = new ArrayList<SearchStoreRequest>();
            for (String storeId : storeIdList2) {
                if (!StringUtils.isNotBlank((CharSequence)storeId)) continue;
                SearchStoreRequest searchStoreRequest = (SearchStoreRequest)sysStoreIdToStoreMap.get(storeId);
                if (searchStoreRequest == null) {
                    searchStoreRequest = new SearchStoreRequest(Long.valueOf(storeId));
                }
                list.add(searchStoreRequest);
            }
            serviceStore.setList(list);
            searchVo.setServiceStore(serviceStore);
        }
        if (StringUtils.isNotBlank((CharSequence)(openCardStoreKey = searchVo.getOpenCardStoreKey())) && CollectionUtils.isNotEmpty((Collection)(storeIdList = (List)this.sysCacheServiceRpc.getSelectEdList(openCardStoreKey).getData()))) {
            Map<Object, Object> sysStoreIdToStoreMap = new HashMap();
            if (searchVo.getOpenCardStore() != null && CollectionUtils.isNotEmpty((Collection)searchVo.getOpenCardStore().getList())) {
                sysStoreIdToStoreMap = searchVo.getOpenCardStore().getList().stream().collect(Collectors.toMap(m -> String.valueOf(m.getSysStoreId()), Function.identity()));
            }
            SearchExternalRequest openCardGuide = new SearchExternalRequest();
            openCardGuide.setHas(Boolean.valueOf(true));
            ArrayList<SearchStoreRequest> list = new ArrayList<SearchStoreRequest>();
            for (String storeId : storeIdList) {
                if (!StringUtils.isNotBlank((CharSequence)storeId)) continue;
                SearchStoreRequest searchStoreRequest = (SearchStoreRequest)sysStoreIdToStoreMap.get(storeId);
                if (searchStoreRequest == null) {
                    searchStoreRequest = new SearchStoreRequest(Long.valueOf(storeId));
                }
                list.add(searchStoreRequest);
            }
            openCardGuide.setList(list);
            searchVo.setOpenCardStore(openCardGuide);
        }
    }

    private void dealGroup(CouponManualRequestVO requestVO, MembersInfoSearchVo searchVo) {
        if (requestVO.getChildMbrGroupDefIdsStr() != null) {
            MbrGroupModel mbrGroupModel = new MbrGroupModel();
            mbrGroupModel.setMbrGroupDefId(Long.valueOf(requestVO.getChildMbrGroupDefIdsStr()));
            ArrayList<MbrGroupModel> groupList = new ArrayList<MbrGroupModel>();
            groupList.add(mbrGroupModel);
            ArrayList<ArrayList<MbrGroupModel>> list = new ArrayList<ArrayList<MbrGroupModel>>();
            list.add(groupList);
            SearchExternalRequest childMbrGroupDefIds = new SearchExternalRequest();
            childMbrGroupDefIds.setList(list);
            searchVo.setChildMbrGroupDefIds(childMbrGroupDefIds);
            searchVo.setChildMbrGroupDefIdsStr(requestVO.getChildMbrGroupDefIdsStr());
        }
    }

    @ApiOperation(value="\u6839\u636e\u624b\u52a8\u53d1\u5238id\u67e5\u8be2\u53d1\u5238\u4fe1\u606f", notes="\u6839\u636e\u624b\u52a8\u53d1\u5238id\u67e5\u8be2\u53d1\u5238\u4fe1\u606f", tags={"\u624b\u52a8\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/findNew.do"})
    public ResponseData<CouponDetailResponseVO> findNewById(@RequestParam(value="couponManualId", required=false) Long couponManualId, HttpServletRequest request) {
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.couponManualService.findNewById(couponManualId);
    }

    @ApiOperation(value="\u6839\u636e\u624b\u52a8\u53d1\u5238id\u67e5\u8be2\u53d1\u5238\u4fe1\u606f\uff0c2019\u5e7408\u670828\u65e5\u65b0\u7248", notes="\u6839\u636e\u624b\u52a8\u53d1\u5238id\u67e5\u8be2\u53d1\u5238\u4fe1\u606f\uff0c2019\u5e7408\u670828\u65e5\u65b0\u7248", tags={"\u624b\u52a8\u53d1\u5238"}, httpMethod="POST")
    @PostMapping(value={"/getCouponManualDetailById"})
    public ResponseData<CouponDetailResponseVO> getCouponManualDetailById(@RequestParam(value="couponManualId", required=false) Long couponManualId) {
        return this.couponManualService.getCouponManualDetailById(couponManualId);
    }

    @ApiOperation(value="\u4fee\u6539\u624b\u52a8\u53d1\u5238\u4efb\u52a1", notes="\u4fee\u6539\u624b\u52a8\u53d1\u5238\u4efb\u52a1", tags={"\u624b\u52a8\u53d1\u5238"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskName", value="\u4efb\u52a1\u540d\u79f0", required=true, dataType="String"), @ApiImplicitParam(name="sendTimeStr", value="\u53d1\u5238\u65f6\u95f4", required=true, dataType="String"), @ApiImplicitParam(name="sendType", value="\u53d1\u9001\u7c7b\u578b\uff1a1-\u7acb\u5373\u53d1\u9001\uff0c2-\u6307\u5b9a\u65f6\u95f4", required=true, dataType="Byte"), @ApiImplicitParam(name="couponDefinitionIds", value="\u5238\u5b9a\u4e49id\u7fa4", required=true, dataType="String"), @ApiImplicitParam(name="couponManualId", value="\u624b\u52a8\u53d1\u5238id", required=true, dataType="Long"), @ApiImplicitParam(name="memberInfo", value="\u4f1a\u5458\u6761\u4ef6", required=true, dataType="MembersInfoSearchVo")})
    @PostMapping(value={"/changeNewManualTask.do"})
    ResponseData<String> changeNewManualTask(@RequestBody CouponManualVO couponManualVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        try {
            responseData = this.couponManualService.changeNewManualTask(couponManualVO, accountPo);
        }
        catch (Exception e) {
            logger.info(SysResponseEnum.DATE_TRANSFER_EXCEPTION.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        return responseData;
    }

    @ApiOperation(value="\u5458\u5de5ids\u5904\u7406", notes="\u7ed9\u751f\u6210\u5458\u5de5\u5238\u529f\u80fd\u4f7f\u7528\uff0c\u83b7\u53d6\u4e0a\u4f20\u5458\u5de5ids excel\u8868\u683c\uff0c\u89e3\u6790", tags={"\u624b\u52a8\u53d1\u5238"})
    @PostMapping(value={"/uploadEmpIds"})
    public ResponseData<JSONObject> analyzeExcel(@RequestBody JSONObject param) throws Exception {
        String key = param.getString("key");
        Assert.hasLength((String)key, (String)SysResponseEnum.OPERATE_FAILED_FILE_NOT_EXISTS.getMessage());
        return this.couponManualService.analyzeExcel(key);
    }

    @ApiOperation(value="\u521b\u5efa\u9884\u751f\u6210\u5238\u4efb\u52a1", notes="\u521b\u5efa\u9884\u751f\u6210\u5238\u4efb\u52a1", tags={"\u624b\u52a8\u53d1\u5238"})
    @PostMapping(value={"/addPreGeneratedCouponTask"})
    public ResponseData addPreGeneratedCouponTask(@RequestBody PreGeneratedCouponTaskCreateVO vo, HttpServletRequest request) throws Exception {
        Assert.notNull((Object)vo.getCouponDefinitionId(), (String)SysResponseEnum.COUPON_DEFINITION_ID_NOT_NULL.getMessage());
        Assert.notNull((Object)vo.getTaskName(), (String)SysResponseEnum.TASK_NAME_NOT_NULL.getMessage());
        Assert.notNull((Object)vo.getTotalNumber(), (String)SysResponseEnum.SEND_COUNT_NOT_NULL.getMessage());
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        Assert.notNull((Object)sysAccountPo, (String)SysResponseEnum.SYSTEM_NOT_LOGIN.getMessage());
        return this.couponManualService.createPreGeneratedCoupon(vo, sysAccountPo);
    }

    @ApiOperation(value="\u521b\u5efa\u5458\u5de5\u5238\u4efb\u52a1", notes="\u521b\u5efa\u5458\u5de5\u5238\u4efb\u52a1", tags={"\u624b\u52a8\u53d1\u5238"})
    @PostMapping(value={"/addEmpCouponTask"})
    public ResponseData addEmpCouponTask(@RequestBody EmpCouponTaskCreateVO vo, HttpServletRequest request) throws Exception {
        Assert.notNull((Object)vo.getCouponDefinitionId(), (String)SysResponseEnum.COUPON_DEFINITION_ID_NOT_NULL.getMessage());
        Assert.notNull((Object)vo.getTaskName(), (String)SysResponseEnum.TASK_NAME_NOT_NULL.getMessage());
        Assert.notNull((Object)vo.getLink(), (String)SysResponseEnum.EMPIDS_LINK_NOT_NULL.getMessage());
        Assert.notNull((Object)vo.getSingleBindNumber(), (String)SysResponseEnum.COUPON_SEND_SINGLE_NUMBER_NOT_NULL.getMessage());
        Assert.isTrue((vo.getSingleBindNumber() > 0 && vo.getSingleBindNumber() <= 25 ? 1 : 0) != 0, (String)SysResponseEnum.COUPON_SEND_SINGLE_NUMBER_NOT_NULL.getMessage());
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        Assert.notNull((Object)sysAccountPo, (String)SysResponseEnum.SYSTEM_NOT_LOGIN.getMessage());
        if (CouponEnum.COUPON_MANUAL_SEND_TYPE_SOMEDAY.getCode().equals(vo.getSendType() + "") && StringUtils.isBlank((CharSequence)vo.getSendTimeStr())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u5b9a\u65f6\u53d1\u9001\u7c7b\u578b\u65f6\uff0c\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.couponManualService.createEmpCoupon(vo, sysAccountPo);
    }

    @ApiOperation(value="\u521b\u5efa\u53d1\u653e\u5f02\u4e1a\u5377\u4efb\u52a1", notes="\u53d1\u653e\u5f02\u4e1a\u5377", tags={"\u53d1\u653e\u5f02\u4e1a\u5377"})
    @PostMapping(value={"/addDifIndustryCouponTask"})
    public ResponseData addDifIndustryCouponTask(@RequestBody PreGeneratedCouponTaskCreateVO vo, HttpServletRequest request) throws Exception {
        Assert.notNull((Object)vo.getCouponDefinitionId(), (String)SysResponseEnum.COUPON_DEFINITION_ID_NOT_NULL.getMessage());
        Assert.notNull((Object)vo.getTaskName(), (String)SysResponseEnum.TASK_NAME_NOT_NULL.getMessage());
        Assert.notNull((Object)vo.getTotalNumber(), (String)SysResponseEnum.SEND_COUNT_NOT_NULL.getMessage());
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        Assert.notNull((Object)sysAccountPo, (String)SysResponseEnum.SYSTEM_NOT_LOGIN.getMessage());
        return this.couponManualService.createDifIndustryCoupon(vo, sysAccountPo);
    }

    @ApiOperation(value="\u7f16\u8f91\u9884\u751f\u6210\u5238\u4efb\u52a1", notes="\u7f16\u8f91\u9884\u751f\u6210\u5238\u4efb\u52a1", tags={"\u624b\u52a8\u53d1\u5238"})
    @PostMapping(value={"/modifyPreGeneratedCouponTask"})
    public ResponseData modifyPreGeneratedCouponTask(@RequestBody ModifyPreCouponTaskVO vo, HttpServletRequest request) {
        Long couponManualId = vo.getCouponManualId();
        Assert.notNull((Object)couponManualId, (String)SysResponseEnum.COUPON_TASK_ID_NOT_NULL.getMessage());
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        Assert.notNull((Object)sysAccountPo, (String)SysResponseEnum.SYSTEM_NOT_LOGIN.getMessage());
        return this.couponManualService.modifyPreGeneratedCouponTask(vo, sysAccountPo);
    }

    @ApiOperation(value="\u7f16\u8f91\u5458\u5de5\u5238\u4efb\u52a1", notes="\u7f16\u8f91\u5458\u5de5\u5238\u4efb\u52a1", tags={"\u624b\u52a8\u53d1\u5238"})
    @PostMapping(value={"/modifyEmpCouponTask"})
    public ResponseData modifyEmpCouponTask(@RequestBody JSONObject params, HttpServletRequest request) {
        Long couponManualId = params.getLong("couponManualId");
        Assert.notNull((Object)couponManualId, (String)SysResponseEnum.COUPON_TASK_ID_NOT_NULL.getMessage());
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        Assert.notNull((Object)sysAccountPo, (String)SysResponseEnum.SYSTEM_NOT_LOGIN.getMessage());
        return this.couponManualService.modifyEmpCouponTask(couponManualId, sysAccountPo);
    }
}

