/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.couponfacade.enums.CouponSendTypeEnum;
import com.bizvane.couponfacade.enums.SendTypeEnum;
import com.bizvane.couponfacade.es.CouponEntityInfoSearchPojo;
import com.bizvane.couponfacade.models.po.CouponBatchSendDetailPO;
import com.bizvane.couponfacade.models.po.CouponBatchSendDetailPOExample;
import com.bizvane.couponfacade.models.po.CouponEntityExtendProperty;
import com.bizvane.couponfacade.models.po.CouponEntityExtendPropertyExample;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.couponfacade.models.po.CouponEntityPOExample;
import com.bizvane.couponfacade.models.po.CouponRecordPO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.HideCouponRecordParam;
import com.bizvane.couponfacade.models.vo.HideCouponStatisticsVo;
import com.bizvane.couponfacade.models.vo.HideCouponVo;
import com.bizvane.couponfacade.models.vo.StatisticsMemberCouponVo;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponservice.common.constants.SysResponseEnum;
import com.bizvane.couponservice.common.constants.SystemConstants;
import com.bizvane.couponservice.common.utils.HttpUtils;
import com.bizvane.couponservice.mappers.CouponBatchSendDetailPOMapper;
import com.bizvane.couponservice.mappers.CouponEntityExtendPropertyMapper;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.mappers.CouponManualPOMapper;
import com.bizvane.couponservice.service.CouponEntityService;
import com.bizvane.couponservice.service.FileTaskService;
import com.bizvane.couponservice.service.ThirdBusinessService;
import com.bizvane.members.facade.models.bo.BatchTaskBo;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.thirdrouting.bo.AsynBO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponEntity"})
public class CouponEntityController {
    private static final Logger logger = LoggerFactory.getLogger(CouponEntityController.class);
    @Autowired
    private CouponEntityService couponEntityService;
    @Autowired
    private FileTaskService fileTaskService;
    @Autowired
    private CouponManualPOMapper couponManualPoMapper;
    @Autowired
    private CouponBatchSendDetailPOMapper couponBatchSendDetailPoMapper;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    @Autowired
    private ThirdBusinessService thirdBusinessService;
    @Autowired
    private CouponEntityExtendPropertyMapper couponEntityExtendPropertyMapper;

    @PostMapping(value={"/exportExcel.do"})
    @ApiOperation(value="\u5238\u7684\u53d1\u653e\u8bb0\u5f55\u5bfc\u51fa", notes="\u5238\u7684\u53d1\u653e\u8bb0\u5f55\u5bfc\u51fa", tags={"\u5238\u7684\u53d1\u653e\u8bb0\u5f55"})
    public ResponseData<String> exportExcel(CouponEntityVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        try {
            PageFormUtil pageForm = new PageFormUtil();
            pageForm.setPageNumber(Integer.valueOf(1));
            pageForm.setPageSize(Integer.valueOf(10));
            vo.setSysBrandId(accountPo.getBrandId());
            vo.setSysCompanyId(accountPo.getSysCompanyId());
            vo.setOrganizationCode(accountPo.getOnlineOrgCode());
            responseData = this.fileTaskService.exportEntityExcelEs(vo, accountPo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("enter CouponEntityController exportExcel method! Exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return responseData;
    }

    @ResponseBody
    @PostMapping(value={"/getList.do"})
    ResponseData<PageInfo<CouponEntityInfoSearchPojo>> getList(CouponEntityVO vo, HttpServletRequest request, PageFormUtil pageForm) {
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        logger.info("enter getList.do method! vo:{},accountPo:{}", (Object)vo, (Object)accountPo);
        PageRequest pageableCoupon = null;
        pageableCoupon = StringUtils.isNotBlank((CharSequence)vo.getFingType()) ? PageRequest.of((int)(pageForm.getPageNumber() - 1), (int)pageForm.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"validDateStart"})) : PageRequest.of((int)(pageForm.getPageNumber() - 1), (int)pageForm.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"couponEntityId"}));
        vo.setSysBrandId(accountPo.getBrandId());
        vo.setSysCompanyId(accountPo.getSysCompanyId());
        vo.setOrganizationCode(accountPo.getOnlineOrgCode());
        ResponseData listEs = null;
        listEs = null != vo && CollectionUtils.isNotEmpty((Collection)vo.getTypeList()) && vo.getTypeList().size() == 1 && vo.getTypeList().contains(CouponSendTypeEnum.ALIPAY_VOUCHER_COUPON.getCode()) && vo.getSendBusinessId() != null ? this.couponEntityService.getAlipayCouponListEs(vo, (Pageable)pageableCoupon) : this.couponEntityService.getListEs(vo, (Pageable)pageableCoupon);
        if (null != accountPo.getSysAccountId() && null != listEs && null != listEs.getData() && CollectionUtils.isNotEmpty((Collection)((PageInfo)listEs.getData()).getList())) {
            if (this.couponEntityService.getMemberDataDesensitizeByAccountConfig(accountPo.getSysAccountId()).booleanValue()) {
                for (CouponEntityInfoSearchPojo pojo2 : ((PageInfo)listEs.getData()).getList()) {
                    pojo2.setCardNo(DesensitizeUtil.encrypt((String)pojo2.getCardNo()));
                    pojo2.setPhone(DesensitizeUtil.encrypt((String)pojo2.getPhone()));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)vo.getTypeList()) && vo.getTypeList().contains(Integer.valueOf(SendTypeEnum.SEND_COUPON_TYPE_OA.getCode()))) {
                List list = ((PageInfo)listEs.getData()).getList().stream().map(pojo -> {
                    if (pojo.getSendType().equals(SendTypeEnum.SEND_COUPON_TYPE_OA.getCode())) {
                        CouponEntityExtendPropertyExample example = new CouponEntityExtendPropertyExample();
                        example.createCriteria().andCouponCodeEqualTo(pojo.getCouponCode()).andSysBrandIdEqualTo(accountPo.getBrandId()).andSysCompanyIdEqualTo(accountPo.getSysCompanyId()).andMemberCodeEqualTo(pojo.getMemberCode());
                        List couponEntityExtendProperties = this.couponEntityExtendPropertyMapper.selectByExample(example);
                        if (CollectionUtils.isNotEmpty((Collection)couponEntityExtendProperties)) {
                            CouponEntityExtendProperty couponEntityExtendProperty = (CouponEntityExtendProperty)couponEntityExtendProperties.get(0);
                            pojo.setServiceOrder(couponEntityExtendProperty.getServiceOrder());
                        }
                    }
                    return pojo;
                }).collect(Collectors.toList());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getServiceOrder())) {
                CouponEntityExtendPropertyExample example = new CouponEntityExtendPropertyExample();
                example.createCriteria().andSysBrandIdEqualTo(accountPo.getBrandId()).andSysCompanyIdEqualTo(accountPo.getSysCompanyId()).andServiceOrderEqualTo(vo.getServiceOrder());
                List couponEntityExtendProperties = this.couponEntityExtendPropertyMapper.selectByExample(example);
                ((PageInfo)listEs.getData()).getList().replaceAll(pojo -> {
                    Optional<CouponEntityExtendProperty> matchingProperty = couponEntityExtendProperties.stream().filter(extendProperty -> extendProperty.getCouponCode().equals(pojo.getCouponCode())).findFirst();
                    matchingProperty.ifPresent(extendProperty -> pojo.setServiceOrder(extendProperty.getServiceOrder()));
                    return pojo;
                });
                ((PageInfo)listEs.getData()).getList().removeIf(pojo -> pojo.getServiceOrder() == null);
            }
        }
        return listEs;
    }

    @PostMapping(value={"/couponPreExportExcel"})
    @ApiOperation(value="\u9884\u751f\u4ea7\u5238\u5bfc\u51fa", notes="\u9884\u751f\u4ea7\u5238\u5bfc\u51fa", tags={"\u9884\u751f\u4ea7\u5238\u5bfc\u51fa\u8bb0\u5f55"})
    public ResponseData<String> couponPreExportExcel(String couponManualId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        CouponBatchSendDetailPOExample example = new CouponBatchSendDetailPOExample();
        example.createCriteria().andCouponManualIdEqualTo(couponManualId).andSysBrandIdEqualTo(HttpUtils.getLoginUser((HttpServletRequest)request).getBrandId());
        List list = this.couponBatchSendDetailPoMapper.selectByExample(example);
        try {
            if (StringUtils.isEmpty((CharSequence)((CouponBatchSendDetailPO)list.get(0)).getBatchSendCodeDetail())) {
                responseData.setCode(200);
                responseData.setMessage("\u627e\u4e0d\u5230\u6279\u6b21\u53f7\uff1a" + couponManualId);
                return responseData;
            }
            CouponEntityVO vo = new CouponEntityVO();
            vo.setCouponBatchSendRecordId(Long.valueOf(((CouponBatchSendDetailPO)list.get(0)).getBatchSendCodeDetail()));
            vo.setListType("9");
            responseData = this.fileTaskService.exportEntityExcelEs(vo, accountPo);
        }
        catch (Exception e) {
            logger.info("enter CouponEntityController exportExcel method! Exception:{}", (Object)JSONObject.toJSONString((Object)e));
        }
        return responseData;
    }

    @RequestMapping(value={"/getCouponTotal"})
    ResponseData<Long> getCouponTotal(CouponEntityVO entityParam, HttpServletRequest request) {
        return null;
    }

    @ApiOperation(value="\u5238\u7684\u53d1\u653e\u8bb0\u5f55\u8be6\u7ec6", notes="\u5238\u7684\u53d1\u653e\u8bb0\u5f55\u8be6\u7ec6", tags={"\u5238\u7684\u53d1\u653e\u8bb0\u5f55"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponEntityId", value="\u5238\u5b9e\u4f8bid", required=true, dataType="Long"), @ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long")})
    @ResponseBody
    @PostMapping(value={"/getAll.do"})
    ResponseData<CouponDetailResponseVO> getAll(@RequestParam(value="couponEntityId", required=false) Long couponEntityId, @RequestParam(value="couponDefinitionId", required=false) Long couponDefinitionId, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponEntityService.getCouponEntityAndDefinitionById(couponEntityId, couponDefinitionId, accountPo);
    }

    @ApiOperation(value="\u5c06\u5238\u7684\u72b6\u6001\u7f6e\u4e3a\u4e0d\u53ef\u7528", notes="\u5c06\u5238\u7684\u72b6\u6001\u7f6e\u4e3a\u4e0d\u53ef\u7528", tags={"\u5c06\u5238\u7684\u72b6\u6001\u7f6e\u4e3a\u4e0d\u53ef\u7528"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponEntityId", value="\u5238\u5b9e\u4f8bid", required=true, dataType="Long")})
    @ResponseBody
    @PostMapping(value={"/updateCouponEntityStatus"})
    ResponseData updateCouponEntityStatus(@RequestParam(value="couponEntityId", required=false) Long couponEntityId, @RequestParam(value="valid", required=false) Boolean valid, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        Optional<SysAccountPo> optional = Optional.ofNullable(accountPo);
        return this.couponEntityService.updateCouponEntityStatus(couponEntityId, valid, optional);
    }

    @ApiOperation(value="\u6838\u9500\u4f18\u60e0\u5238", notes="\u6838\u9500\u4f18\u60e0\u5238", tags={"\u6838\u9500\u4f18\u60e0\u5238"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponEntityId", value="\u5238\u5b9e\u4f8bid", required=true, dataType="Long")})
    @ResponseBody
    @PostMapping(value={"/useCoupon"})
    ResponseData useCoupon(@RequestParam(value="couponEntityId", required=false) Long couponEntityId, @RequestParam(value="couponDefinitionId", required=false) Long couponDefinitionId, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        Optional<SysAccountPo> optional = Optional.ofNullable(accountPo);
        return this.couponEntityService.useCoupon(couponEntityId, couponDefinitionId, optional);
    }

    @ResponseBody
    @PostMapping(value={"/hideCoupon.do"})
    public ResponseData<String> hideCoupon(HideCouponVo hideCouponVo, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponEntityService.hideCoupon(hideCouponVo, accountPo);
    }

    @ResponseBody
    @PostMapping(value={"/getHideCouponRecordList"})
    public ResponseData<PageInfo<CouponRecordPO>> getHideCouponRecordList(HideCouponRecordParam param, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        param.setSysCompanyId(accountPo.getSysCompanyId());
        param.setSysBrandId(accountPo.getBrandId());
        return new ResponseData((Object)this.couponEntityService.getHideCouponRecordList(param, (Pageable)PageRequest.of((int)param.getPageNum(), (int)param.getPageSize())));
    }

    @ResponseBody
    @PostMapping(value={"/getHideCouponRecordExportExcel"})
    public ResponseData<String> getHideCouponRecordExportExcel(HideCouponRecordParam param, HttpServletRequest request) {
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        param.setSysCompanyId(accountPo.getSysCompanyId());
        param.setSysBrandId(accountPo.getBrandId());
        return this.fileTaskService.getHideCouponRecordExportExcel(param, accountPo);
    }

    @ResponseBody
    @PostMapping(value={"/hideCouponTask"})
    public ResponseData<String> hideCouponTask(HideCouponVo hideCouponVo, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        if (hideCouponVo.getMaxCouponEntityId() == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u6700\u5927\u7684\u5238\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)hideCouponVo.getCouponEntityVO().getFingType())) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u4e0d\u652f\u6301\u5f53\u524d\u67e5\u8be2\u7c7b\u578b");
        }
        if (hideCouponVo.getNeedHideCouponCount() == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u603b\u6761\u6570\u672a\u4f20");
        }
        if (hideCouponVo.getNeedHideCouponCount() == 0L) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u6ca1\u6709\u53ef\u4ee5\u64cd\u4f5c\u7684\u5238");
        }
        ResponseData batchTaskBoResponseData = this.couponEntityService.createHideCouponTask(hideCouponVo, accountPo);
        if (batchTaskBoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), batchTaskBoResponseData.getMessage());
        }
        this.couponEntityService.asyncHideCouponTask(hideCouponVo, accountPo, (BatchTaskBo)batchTaskBoResponseData.getData());
        return new ResponseData();
    }

    @ResponseBody
    @PostMapping(value={"/batchHideCouponNum"})
    public ResponseData<HideCouponStatisticsVo> hideCouponNum(HideCouponVo hideCouponVo, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponEntityService.hideCouponNum(hideCouponVo, accountPo);
    }

    @ApiOperation(value="\u7edf\u8ba1\u4f1a\u5458\u5238\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="brandId", dataType="Long", value="\u54c1\u724cid", paramType="query", required=true), @ApiImplicitParam(name="memberCode", dataType="String", value="\u4f1a\u5458code", paramType="query", required=true)})
    @PostMapping(value={"/statisticsMemberCouponByMemberCode"})
    public ResponseData<StatisticsMemberCouponVo> statisticsMemberCouponByMemberCode(@RequestParam(value="brandId") Long brandId, @RequestParam(value="memberCode") String memberCode, HttpServletRequest request) {
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.couponEntityService.statisticsMemberCouponByMemberCode(currentUser.getSysCompanyId(), brandId, memberCode);
    }

    @ResponseBody
    @PostMapping(value={"/retryThird"})
    ResponseData retryThird(@RequestParam(value="sysCompanyId") @NotNull Long sysCompanyId, @RequestParam(value="sysBrandId") @NotNull Long sysBrandId, @RequestParam(value="couponEntityIdMin") @NotNull Long couponEntityIdMin, @RequestParam(value="couponEntityIdMax") @NotNull Long couponEntityIdMax, @RequestParam(value="couponDefinitionId") String couponDefinitionId) {
        do {
            CouponEntityPOExample example = new CouponEntityPOExample();
            CouponEntityPOExample.Criteria criteria = example.createCriteria();
            criteria.andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId);
            if (StringUtils.isNotBlank((CharSequence)couponDefinitionId)) {
                criteria.andCouponDefinitionIdEqualTo(couponDefinitionId);
            }
            criteria.andCouponEntityIdGreaterThanOrEqualTo(couponEntityIdMin);
            criteria.andCouponEntityIdLessThanOrEqualTo(Long.valueOf(couponEntityIdMin + 9999L));
            List list = this.couponEntityPOMapper.selectByExample(example);
            for (CouponEntityPO po : list) {
                try {
                    AsynBO asynBO = new AsynBO(po.getSysCompanyId(), po.getSysBrandId(), "couponSend", JSON.toJSONString((Object)po));
                    this.thirdBusinessService.asyn(asynBO);
                }
                catch (Exception e) {
                    logger.error("couponinsertBatch3 thirdBusinessService.asyn e {}", (Throwable)e);
                }
            }
            couponEntityIdMin = couponEntityIdMin + 10000L;
        } while (couponEntityIdMax >= couponEntityIdMin);
        logger.info("\u7ed3\u675f\u4e86");
        return new ResponseData();
    }
}

