/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponDifindustryVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponManualVO;
import com.bizvane.couponservice.mappers.CouponDefinitionPOMapper;
import com.bizvane.couponservice.service.CouponDifindustryService;
import com.bizvane.couponservice.service.CouponService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponDifindustry"})
public class CouponDifindustryController {
    private static final Logger log = LoggerFactory.getLogger(CouponDifindustryController.class);
    @Autowired
    private CouponDifindustryService couponDifindustryService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CouponDefinitionPOMapper couponDefinitionPOMapper;

    @RequestMapping(value={"/sygadd"}, method={RequestMethod.POST})
    public void sygadd(@RequestBody CouponDefinitionPOWithBLOBs vo, HttpServletRequest request) {
        this.couponDefinitionPOMapper.insertSelectiveSyg(vo);
    }

    @RequestMapping(value={"/batchAdd"}, method={RequestMethod.POST})
    public void batchAdd(@RequestBody List<CouponDefinitionPOWithBLOBs> voList) {
        for (CouponDefinitionPOWithBLOBs vo : voList) {
            try {
                this.couponDefinitionPOMapper.insertSelectiveSyg(vo);
            }
            catch (Exception e) {
                log.info("\u5931\u8d25\u65b0\u589e\u5238\u5b9a\u4e49ID,:{},\u5931\u8d25\u539f\u56e0:{}", (Object)vo.getCouponDefinitionId(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @RequestMapping(value={"/selectPage"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<CouponDifindustryVO>> selectPage(@RequestBody CouponDifindustryVO vo, HttpServletRequest request) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        ResponseData responseData = this.couponDifindustryService.selectDetailPage(vo, sysAccountPo);
        return responseData;
    }

    @RequestMapping(value={"/selectCouponDifindustryPage"}, method={RequestMethod.GET})
    public ResponseData<PageInfo<CouponDefinitionVO>> selectCouponDifindustryPage(@RequestParam(required=false, value="sysBrandId") Long sysBrandId, @RequestParam(required=false, value="batchNum") String batchNum, @RequestParam(required=false, value="couponDefinitionName") String couponDefinitionName, @RequestParam(required=false, value="pageNum", defaultValue="0") Integer pageNum, @RequestParam(required=false, value="pageSize", defaultValue="0") Integer pageSize, HttpServletRequest request) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        CouponManualVO vo = new CouponManualVO();
        vo.setSysBrandId(sysBrandId);
        vo.setCouponDefinitionName(couponDefinitionName);
        vo.setBatchNum(batchNum);
        vo.setPageNumber(pageNum);
        vo.setPageSize(pageSize);
        ResponseData responseData = this.couponDifindustryService.selectCouponDifindustryPage(vo, sysAccountPo);
        return responseData;
    }

    @RequestMapping(value={"registerSendDifindustryCoupon"}, method={RequestMethod.POST})
    public ResponseData registerSendDifindustryCoupon(@RequestBody CouponListByMemberCodeRequestVO vo) {
        ResponseData responseData = this.couponService.registerSendDifindustryCoupon(vo);
        return responseData;
    }
}

