/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.alibaba.fastjson.JSON;
import com.bizvane.centercontrolservice.rpc.DefCouponConfigureRpc;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.centerstageservice.models.po.SysDimSkuPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.couponfacade.models.bo.CouponDefinitionBO;
import com.bizvane.couponfacade.models.po.CouponDefinitionCodePO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.couponfacade.models.vo.BatchInvalidateRequestVo;
import com.bizvane.couponfacade.models.vo.CouponDefinitionCodeQueryVO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionListQueryVO;
import com.bizvane.couponfacade.models.vo.CouponDefinitionVO;
import com.bizvane.couponfacade.utils.PageFormUtil;
import com.bizvane.couponservice.common.utils.HttpUtils;
import com.bizvane.couponservice.service.CouponDefinitionService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b9a\u4e49\u5238"})
@RestController
@RequestMapping(value={"/couponDefinition"})
public class CouponDefinitionController {
    private static final Logger logger = LoggerFactory.getLogger(CouponDefinitionController.class);
    @Autowired
    private CouponDefinitionService couponDefinitionService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private DefCouponConfigureRpc defCouponConfigureRpc;

    @ApiOperation(value="\u67e5\u8be2\u5238\u5b9a\u4e49\u5217\u8868", notes="\u67e5\u8be2\u5238\u5b9a\u4e49\u5217\u8868", tags={"\u5238\u5b9a\u4e49\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponName", value="\u5238\u540d\u79f0", required=true, dataType="String"), @ApiImplicitParam(name="preferentialType", value="\u4f18\u60e0\u5f62\u5f0f\uff081\u73b0\u91d1\uff0c2\u6298\u6263\uff0c3\u793c\u54c1)", required=true, dataType="byte"), @ApiImplicitParam(name="status", value="\u5238\u72b6\u6001\uff081\u5df2\u542f\u7528\uff0c0\u5df2\u505c\u7528\uff09", required=true, dataType="Boolean"), @ApiImplicitParam(name="createDateStart", value="\u521b\u5efa\u65f6\u95f4\u5f00\u59cb", required=true, dataType="String"), @ApiImplicitParam(name="createDateEnd", value="\u521b\u5efa\u65f6\u95f4\u7ed3\u675f", required=true, dataType="String"), @ApiImplicitParam(name="useChannel", value="\u9002\u7528\u6e20\u9053\uff081\u4ec5\u7ebf\u4e0a\uff0c2\u4ec5\u7ebf\u4e0b\uff0c3\u5168\u6e20\u9053\uff09", required=true, dataType="String"), @ApiImplicitParam(name="createUserName", value="\u521b\u5efa\u4eba", required=true, dataType="String"), @ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long"), @ApiImplicitParam(name="organizationCode", value="\u7ec4\u7ec7code", required=true, dataType="String")})
    @PostMapping(value={"/getList.do"})
    public ResponseData<PageInfo<CouponDefinitionVO>> getList(HttpServletRequest request, CouponDefinitionListQueryVO vo) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        PageFormUtil pageForm = new PageFormUtil();
        pageForm.setPageNumber(vo.getPageNumber());
        pageForm.setPageSize(vo.getPageSize());
        if (StringUtils.isNotBlank((String)sysAccountPo.getOnlineOrgCode())) {
            vo.setOrganizationCode(sysAccountPo.getOnlineOrgCode());
        }
        return this.couponDefinitionService.getList(vo, pageForm, sysAccountPo.getBrandId(), sysAccountPo.getSysCompanyId());
    }

    @ApiOperation(value="\u7ebf\u4e0b\u5238\u53f7\u5217\u8868\u67e5\u8be2", notes="\u7ebf\u4e0b\u5238\u53f7\u5217\u8868\u67e5\u8be2", tags={"\u7ebf\u4e0b\u5238\u53f7\u5217\u8868\u67e5\u8be2"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponName", value="\u5238\u540d\u79f0", required=true, dataType="String")})
    @PostMapping(value={"/getListDefinitionCode"})
    public ResponseData<PageInfo<CouponDefinitionCodePO>> getListDefinitionCode(HttpServletRequest request, CouponDefinitionCodeQueryVO vo) {
        SysAccountPo sysAccountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        PageFormUtil pageForm = new PageFormUtil();
        if (vo.getPageNumber() == null || vo.getPageSize() == null) {
            vo.setPageNumber(Integer.valueOf(1));
            vo.setPageSize(Integer.valueOf(10));
        }
        pageForm.setPageNumber(vo.getPageNumber());
        pageForm.setPageSize(vo.getPageSize());
        if (StringUtils.isNotBlank((String)sysAccountPo.getOnlineOrgCode())) {
            vo.setOrganizationCode(sysAccountPo.getOnlineOrgCode());
        }
        return this.couponDefinitionService.getListDefinitionCode(vo, pageForm, sysAccountPo.getBrandId(), sysAccountPo.getSysCompanyId());
    }

    @ApiOperation(value="\u5238\u4fdd\u5b58", notes="\u5238\u4fdd\u5b58", tags={"\u5b9a\u4e49\u5238"}, httpMethod="POST")
    @PostMapping(value={"/add.do"})
    public ResponseData<Long> add(@RequestBody CouponDefinitionBO bo, HttpServletRequest request) {
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        logger.info("CouponDefinitionController#add#accountPo:{}", (Object)JSON.toJSONString((Object)accountPo));
        if (StringUtils.isNotBlank((String)accountPo.getOnlineOrgCode())) {
            bo.setOrganizationCode(accountPo.getOnlineOrgCode());
        }
        return this.couponDefinitionService.add(bo, accountPo);
    }

    @ApiOperation(value="\u4fee\u6539\u5238\u72b6\u6001", notes="\u4fee\u6539\u5238\u72b6\u6001", tags={"\u5238\u5b9a\u4e49\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long"), @ApiImplicitParam(name="status", value="\u5238\u72b6\u6001\uff081\u5df2\u542f\u7528\uff0c0\u5df2\u505c\u7528\uff09", required=true, dataType="Boolean")})
    @PostMapping(value={"/update.do"})
    public ResponseData<Object> update(CouponDefinitionPOWithBLOBs po, HttpServletRequest request) {
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        this.couponDefinitionService.update(po, accountPo);
        return new ResponseData();
    }

    @PostMapping(value={"batchInvalidate"})
    public ResponseData<Integer> batchInvalidate(@RequestBody BatchInvalidateRequestVo requestVo) {
        SysAccountPO accountPo = TokenUtils.getStageUser((HttpServletRequest)this.request);
        requestVo.setModifiedUserName(accountPo.getName());
        requestVo.setModifiedUserId(accountPo.getSysAccountId());
        return this.couponDefinitionService.batchInvalidate(requestVo);
    }

    @ApiOperation(value="\u4fee\u6539\u5238\u5b9a\u4e49\u5c5e\u6027", notes="\u4fee\u6539\u5238\u5b9a\u4e49\u5c5e\u6027", tags={"\u4fee\u6539\u5238\u5b9a\u4e49\u5c5e\u6027"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long")})
    @PostMapping(value={"/updateDefinition"})
    public ResponseData<Object> updateDefinition(CouponDefinitionBO bo, HttpServletRequest httpServletRequest) {
        SysAccountPO stageUser = TokenUtils.getStageUser((HttpServletRequest)httpServletRequest);
        bo.setModifiedUserId(stageUser.getSysAccountId());
        bo.setModifiedUserName(stageUser.getName());
        bo.setSysCompanyId(stageUser.getSysCompanyId());
        try {
            return this.couponDefinitionService.updateDefinition(bo, stageUser);
        }
        catch (Exception exception) {
            logger.info(ExceptionUtils.getStackTrace((Throwable)exception));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), exception.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5238\u5b9a\u4e49\u94fe\u63a5\u4fe1\u606f", notes="\u4fee\u6539\u5238\u5b9a\u4e49\u94fe\u63a5\u4fe1\u606f", tags={"\u4fee\u6539\u5238\u5b9a\u4e49\u94fe\u63a5\u4fe1\u606f"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long")})
    @PostMapping(value={"/updateDefinitionLink"})
    public ResponseData<Object> updateDefinitionLink(@RequestBody CouponDefinitionBO bo, HttpServletRequest httpServletRequest) {
        SysAccountPO stageUser = TokenUtils.getStageUser((HttpServletRequest)httpServletRequest);
        bo.setModifiedUserId(stageUser.getSysAccountId());
        bo.setModifiedUserName(stageUser.getName());
        bo.setSysCompanyId(stageUser.getSysCompanyId());
        try {
            return this.couponDefinitionService.updateDefinition(bo, stageUser);
        }
        catch (Exception exception) {
            logger.info(ExceptionUtils.getStackTrace((Throwable)exception));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), exception.getMessage());
        }
    }

    @ApiOperation(value="\u590d\u5236:\u67e5\u627e\u5355\u5f20\u5238", notes="\u590d\u5236\uff1a\u67e5\u627e\u5355\u5f20\u5238", tags={"\u5238\u5b9a\u4e49\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long")})
    @PostMapping(value={"/find.do"})
    public ResponseData<CouponDefinitionBO> getCouponDefinition(@RequestParam(value="couponDefinitionId", required=false) Long couponDefinitionId) {
        return this.couponDefinitionService.getCouponDefinitionNew(couponDefinitionId);
    }

    @ApiOperation(value="\u5238\u81ea\u5b9a\u4e49\u6a21\u677f\u67e5\u8be2", notes="\u5238\u81ea\u5b9a\u4e49\u6a21\u677f\u67e5\u8be2", tags={"\u5b9a\u4e49\u5238"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="createUserId", value="\u7528\u6237id", required=true, dataType="Long"), @ApiImplicitParam(name="couponName", value="\u5238\u540d\u79f0", required=true, dataType="String"), @ApiImplicitParam(name="preferentialType", value="\u5238\u7c7b\u578b", required=true, dataType="Byte")})
    @PostMapping(value={"/getTemplate.do"})
    public ResponseData<PageInfo> getTemplate(CouponDefinitionPO couponDefinitionPo, PageFormUtil pageFormUtil, HttpServletRequest request) {
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponDefinitionService.getTemplate(couponDefinitionPo, pageFormUtil, accountPo);
    }

    @ApiOperation(value="\u7ebf\u4e0b\u5238\u7c7b\u578b\u83b7\u53d6", notes="\u7ebf\u4e0b\u5238\u7c7b\u578b\u83b7\u53d6", tags={"\u5b9a\u4e49\u5238"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="isConfigure", value="\u5238\u5b9a\u4e49\u7c7b\u578b\uff1a1-\u7ebf\u4e0a\u5b9a\u4e49\uff0c2-erp\u751f\u6210", required=true, dataType="Long")})
    @PostMapping(value={"/getDefinitionType.do"})
    public ResponseData<Object> getDefinitionType(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysAccountPo accountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        Long sysCompanyId = accountPo.getSysCompanyId();
        Long sysBrandId = accountPo.getBrandId();
        if (null == sysCompanyId) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (null == sysBrandId) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        List list = this.defCouponConfigureRpc.getDefCouponConfigure(sysCompanyId, sysBrandId);
        if (null == list || list.size() == 0) {
            responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
            return responseData;
        }
        responseData.setData(list.get(0));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u7528\u7684\u5238\u4fe1\u606f", notes="\u67e5\u8be2\u53ef\u7528\u7684\u5238\u4fe1\u606f", tags={"\u5238\u5b9a\u4e49\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="couponName", value="\u5238\u540d\u79f0", required=true, dataType="String"), @ApiImplicitParam(name="couponDefinitionId", value="\u5238\u5b9a\u4e49id", required=true, dataType="Long")})
    @PostMapping(value={"/getUseList.do"})
    public ResponseData<PageInfo<CouponDefinitionPO>> getUseList(HttpServletRequest request, CouponDefinitionListQueryVO vo, PageFormUtil pageForm) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        if (StringUtils.isNotBlank((String)sysAccountPo.getOnlineOrgCode())) {
            vo.setOrganizationCode(sysAccountPo.getOnlineOrgCode());
        }
        vo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        vo.setSysBrandId(sysAccountPo.getBrandId());
        return this.couponDefinitionService.getUseList(vo, pageForm, sysAccountPo.getBrandId());
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5217\u8868", tags={"\u5238\u5b9a\u4e49\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order", value="\u5546\u54c1\u540d\u5355id", required=true, dataType="String"), @ApiImplicitParam(name="productCode", value="\u5546\u54c1code", required=true, dataType="String"), @ApiImplicitParam(name="productName", value="\u5546\u54c1\u540d\u79f0", required=true, dataType="String")})
    @PostMapping(value={"/getIdSysDimSkuList.do"})
    public ResponseData<PageInfo<SysDimSkuPo>> getIdSysDimSkuList(@RequestParam(value="order", required=false) String order, @RequestParam(value="productCode", required=false) String productCode, @RequestParam(value="productName", required=false) String productName, PageFormUtil page, HttpServletRequest request) {
        SysAccountPo sysAccountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponDefinitionService.getIdSysDimSkuList(order, productCode, productName, page, sysAccountPo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5217\u8868", tags={"\u5238\u5b9a\u4e49\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order", value="\u5546\u54c1\u540d\u5355id", required=true, dataType="String"), @ApiImplicitParam(name="productCode", value="\u5546\u54c1code", required=true, dataType="String"), @ApiImplicitParam(name="productName", value="\u5546\u54c1\u540d\u79f0", required=true, dataType="String")})
    @PostMapping(value={"/getIdSysDimSkuListNoPage.do"})
    public ResponseData<PageInfo<SysDimSkuPo>> getIdSysDimSkuListNoPage(@RequestParam(value="order", required=false) String order, @RequestParam(value="productCode", required=false) String productCode, @RequestParam(value="productName", required=false) String productName, PageFormUtil page, HttpServletRequest request) {
        SysAccountPo sysAccountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        page.setPageSize(Integer.valueOf(10000));
        return this.couponDefinitionService.getIdSysDimSkuList(order, productCode, productName, page, sysAccountPo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5217\u8868", tags={"\u5238\u5b9a\u4e49\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order", value="\u5546\u54c1\u540d\u5355id", required=true, dataType="String"), @ApiImplicitParam(name="productCode", value="\u5546\u54c1code", required=true, dataType="String"), @ApiImplicitParam(name="productName", value="\u5546\u54c1\u540d\u79f0", required=true, dataType="String")})
    @PostMapping(value={"/getIdSysDimSkuListByPage.do"})
    public ResponseData<PageInfo<SysDimSkuPo>> getIdSysDimSkuListByPage(@RequestParam(value="order", required=false) String order, @RequestParam(value="productCode", required=false) String productCode, @RequestParam(value="productName", required=false) String productName, @RequestParam(value="condition", required=false) String condition, PageFormUtil page, HttpServletRequest request) {
        SysAccountPo sysAccountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponDefinitionService.getIdSysDimSkuListNew(order, condition, productCode, productName, page, sysAccountPo);
    }

    @ApiOperation(value="\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5217\u8868", tags={"\u5238\u5b9a\u4e49\u5217\u8868"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="store", value="\u95e8\u5e97\u540d\u5355id", required=true, dataType="String"), @ApiImplicitParam(name="sysStoreOfflineCode", value="\u95e8\u5e97code", required=true, dataType="String"), @ApiImplicitParam(name="storeName", value="\u95e8\u5e97\u540d\u79f0", required=true, dataType="String")})
    @PostMapping(value={"/getIdStoreList.do"})
    public ResponseData<PageInfo<SysStorePo>> getIdStoreList(@RequestParam(value="store", required=false) String store, @RequestParam(value="sysStoreOfflineCode", required=false) String sysStoreOfflineCode, @RequestParam(value="storeName", required=false) String storeName, PageFormUtil page, HttpServletRequest request) {
        SysAccountPo sysAccountPo = HttpUtils.getLoginUser((HttpServletRequest)request);
        return this.couponDefinitionService.getIdStoreList(store, sysStoreOfflineCode, storeName, page, sysAccountPo);
    }
}

