/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.bizvane.couponfacade.models.bo.CouponPartBo;
import com.bizvane.couponfacade.models.vo.CouponDefinitionPartVo;
import com.bizvane.couponfacade.models.vo.CouponStoreGroupVo;
import com.bizvane.couponfacade.models.vo.CouponStoreVo;
import com.bizvane.couponservice.service.CouponAnalysisService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/couponAnalysis"})
public class CouponAnalysisController {
    @Autowired
    private CouponAnalysisService couponAnalysisService;

    @PostMapping(value={"/getCouponSurvey"})
    public ResponseData getCouponSurvey(Long sysBrandId) {
        return this.couponAnalysisService.getCouponSurvey(sysBrandId);
    }

    @PostMapping(value={"/getCouponUsed"})
    public ResponseData getCouponUsed(CouponPartBo bo, HttpServletRequest request) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        bo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        bo.setSysBrandId(sysAccountPo.getBrandId());
        return this.couponAnalysisService.getCouponUsed(bo);
    }

    @PostMapping(value={"/getCouponStore"})
    public ResponseData getCouponStore(CouponStoreVo vo, HttpServletRequest request) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        vo.setSysBrandId(sysAccountPo.getBrandId());
        return this.couponAnalysisService.getCouponStore(vo, request);
    }

    @PostMapping(value={"/getCouponStoreGroup"})
    public ResponseData getCouponStoreGroup(CouponStoreGroupVo vo, HttpServletRequest request) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        vo.setSysBrandId(sysAccountPo.getBrandId());
        vo.setSysAccountId(sysAccountPo.getSysAccountId());
        return this.couponAnalysisService.getCouponStoreGroup(vo, request);
    }

    @PostMapping(value={"/couponOrders"})
    public ResponseData couponOrders(CouponPartBo bo, HttpServletRequest request) {
        SysAccountPO sysAccountPo = TokenUtils.getStageUser((HttpServletRequest)request);
        bo.setSysCompanyId(sysAccountPo.getSysCompanyId());
        bo.setSysBrandId(sysAccountPo.getBrandId());
        return this.couponAnalysisService.couponOrders(bo);
    }

    @PostMapping(value={"/couponDisplay"})
    public ResponseData couponDisplay(CouponDefinitionPartVo vo, HttpServletRequest request) {
        return this.couponAnalysisService.couponDisplay(vo, request);
    }
}

