/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.couponservice.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.models.po.SysStoreGroupPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreGroupServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.models.vo.FindMembersVO;
import com.bizvane.couponservice.common.datavo.BackBitDataVO;
import com.bizvane.couponservice.common.datavo.BitDataVO;
import com.bizvane.couponservice.common.datavo.ReportTempPO;
import com.bizvane.couponservice.common.datavo.SortDataVO;
import com.bizvane.couponservice.common.utils.BaseData;
import com.bizvane.couponservice.common.utils.BaseUrl;
import com.bizvane.couponservice.mappers.CouponEntityPOMapper;
import com.bizvane.couponservice.service.CouponReportTempService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/bitDataStoreAnalysis"})
public class BitDataStoreAnalysisController {
    private static final Logger logger = LoggerFactory.getLogger(BitDataStoreAnalysisController.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BaseUrl BaseUrl;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private CouponReportTempService couponReportTempService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private StoreGroupServiceRpc storeGroupServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CouponEntityPOMapper couponEntityPOMapper;
    private final String ONE = "1";

    @PostMapping(value={"storeTop"})
    public ResponseData<JSONObject> storeTop(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData ResponseData2 = new ResponseData();
        JSONObject backJSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        backJSONObject.put("achieveMap", (Object)jSONArray);
        JSONArray jSONArray2 = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        backJSONObject.put("guestPriceMap", (Object)jSONArray2);
        ResponseData2 = this.backJSONObjectTop10(sendVO, backJSONObject, this.BaseUrl.getLoadUrl("storeTop"), request);
        return ResponseData2;
    }

    @PostMapping(value={"areaTop"})
    public ResponseData<JSONObject> areaTop(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData ResponseData2 = new ResponseData();
        JSONObject backJSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        backJSONObject.put("achieveMap", (Object)jSONArray);
        JSONArray jSONArray2 = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        backJSONObject.put("guestPriceMap", (Object)jSONArray2);
        List List2 = this.getStoreGroupIds(request, "");
        sendVO.setStoreIdsInArea((Map)List2.get(0));
        JSONObject jSONGroup = (JSONObject)List2.get(1);
        JSONObject jSONGroupName = new JSONObject();
        for (Object k : jSONGroup.keySet()) {
            SysStoreGroupPo sysStoreGroupPo = (SysStoreGroupPo)jSONGroup.get((Object)k.toString());
            jSONGroupName.put(k.toString(), (Object)sysStoreGroupPo.getStoreGroupName());
        }
        ResponseData2 = this.backJSONObjectGroupTop10(sendVO, jSONGroupName, backJSONObject, this.BaseUrl.getLoadUrl("areaTop"), request);
        return ResponseData2;
    }

    @PostMapping(value={"storeVou"})
    public ResponseData<BackBitDataVO> storeVou(BitDataVO sendVO, HttpServletRequest request) {
        JSONArray jSONArray = new JSONArray();
        JSONObject backJSONObject = new JSONObject();
        backJSONObject.put("id", (Object)"1");
        backJSONObject.put("storeName", (Object)"");
        backJSONObject.put("salesVolume", (Object)"0");
        backJSONObject.put("guestPrice", (Object)"0");
        backJSONObject.put("jointRate", (Object)"0");
        backJSONObject.put("voucherUsedPerson", (Object)"0");
        backJSONObject.put("pieceNumber", (Object)"2");
        backJSONObject.put("achievements", (Object)"100");
        backJSONObject.put("penNumber", (Object)"2");
        sendVO.setStoreIds(this.getSysStoreIdstr(request, sendVO.getStoreIdstr()));
        ResponseData responseDataBack = new ResponseData();
        BackBitDataVO backBitDataVO = new BackBitDataVO();
        ResponseData ResponseData2 = new ResponseData();
        ResponseData2 = this.backJSONObjectHaveID(sendVO, jSONArray, this.BaseUrl.getLoadUrl("storeVou"), request);
        backBitDataVO.setList(ResponseData2.getData());
        ResponseData ResponseDatatoTotal = new ResponseData();
        sendVO.setStartRecord("1");
        sendVO.setQueryNum("10000000");
        ResponseDatatoTotal = this.backJSONObjectHaveID(sendVO, jSONArray, this.BaseUrl.getLoadUrl("storeVou"), request);
        JSONArray JSONArray2 = (JSONArray)ResponseDatatoTotal.getData();
        backBitDataVO.setTotal(String.valueOf(JSONArray2.size()));
        responseDataBack.setData((Object)backBitDataVO);
        if (sendVO.getExport() != null) {
            ReportTempPO reportTempPO = new ReportTempPO();
            reportTempPO.setTemplateName("\u95e8\u5e97\u4f18\u60e0\u5238\u5bfc\u51fa");
            reportTempPO.setReportDataName("\u53c2\u4e0e\u95e8\u5e97,\u6838\u9500\u91cf,\u7528\u5238\u5ba2\u5355\u4ef7,\u8fde\u5e26\u7387,\u4f7f\u7528\u4f1a\u5458");
            reportTempPO.setReportData("storeName,salesVolume,guestPrice,jointRate,voucherUsedPerson");
            this.couponReportTempService.export(TokenUtils.getStageUser((HttpServletRequest)request), "", ((JSONArray)ResponseDatatoTotal.getData()).toString(), reportTempPO);
            responseDataBack.setMessage("\u5bfc\u51fa\u4e2d");
        }
        return responseDataBack;
    }

    @PostMapping(value={"areaVou"})
    public ResponseData<BackBitDataVO> areaVou(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData ResponseData2 = new ResponseData();
        JSONArray jSONArray = new JSONArray();
        JSONObject backJSONObject = new JSONObject();
        List List2 = this.getStoreGroupIds(request, "");
        if (StringUtils.isBlank((CharSequence)sendVO.getStoreIdstr())) {
            sendVO.setStoreIdsInArea((Map)List2.get(0));
        } else {
            Map mapAll = (Map)List2.get(0);
            HashMap mapSend = new HashMap();
            for (String AreaId : sendVO.getStoreIdstr().split(",")) {
                mapSend.put(AreaId, mapAll.get(AreaId));
            }
            sendVO.setStoreIdsInArea(mapSend);
        }
        JSONObject jSONGroup = (JSONObject)List2.get(1);
        JSONObject jSONGroupName = new JSONObject();
        for (Object k : jSONGroup.keySet()) {
            SysStoreGroupPo sysStoreGroupPo = (SysStoreGroupPo)jSONGroup.get((Object)k.toString());
            jSONGroupName.put(k.toString(), (Object)sysStoreGroupPo.getStoreGroupName());
        }
        ResponseData responseDataBack = new ResponseData();
        BackBitDataVO backBitDataVO = new BackBitDataVO();
        ResponseData2 = this.backJSONObjectHaveGroup(sendVO, jSONGroupName, jSONArray, this.BaseUrl.getLoadUrl("areaVou"), request);
        backBitDataVO.setList(ResponseData2.getData());
        ResponseData ResponseDatatoTotal = new ResponseData();
        sendVO.setStartRecord("1");
        sendVO.setQueryNum("10000000");
        ResponseDatatoTotal = this.backJSONObjectHaveGroup(sendVO, jSONGroupName, jSONArray, this.BaseUrl.getLoadUrl("areaVou"), request);
        JSONArray JSONArray2 = (JSONArray)ResponseDatatoTotal.getData();
        backBitDataVO.setTotal(String.valueOf(JSONArray2.size()));
        responseDataBack.setData((Object)backBitDataVO);
        if (sendVO.getExport() != null) {
            ReportTempPO reportTempPO = new ReportTempPO();
            reportTempPO.setTemplateName("\u7fa4\u7ec4\u4f18\u60e0\u5238\u5bfc\u51fa");
            reportTempPO.setReportDataName("\u6240\u5c5e\u7fa4\u7ec4,\u6838\u9500\u91cf,\u7528\u5238\u5ba2\u5355\u4ef7,\u8fde\u5e26\u7387,\u4f7f\u7528\u4f1a\u5458");
            reportTempPO.setReportData("groupName,salesVolume,guestPrice,jointRate,voucherUsedPerson");
            this.couponReportTempService.export(TokenUtils.getStageUser((HttpServletRequest)request), "", ((JSONArray)ResponseDatatoTotal.getData()).toString(), reportTempPO);
            ResponseData2.setMessage("\u5bfc\u51fa\u4e2d");
        }
        return responseDataBack;
    }

    @PostMapping(value={"storeAchievements"})
    public ResponseData<BackBitDataVO> storeAchievements(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData ResponseData2 = new ResponseData();
        JSONArray jSONArray = new JSONArray();
        JSONObject backJSONObject = new JSONObject();
        backJSONObject.put("id", (Object)"1");
        backJSONObject.put("storeName", (Object)"");
        backJSONObject.put("totalAchievements", (Object)"0");
        backJSONObject.put("useVouAchievements", (Object)"0");
        backJSONObject.put("useVouAchievementsGrowth", (Object)"0");
        backJSONObject.put("totalNum", (Object)"0");
        backJSONObject.put("useVouNum", (Object)"0");
        backJSONObject.put("useVouNumGrowth", (Object)"0");
        backJSONObject.put("discount", (Object)"0");
        backJSONObject.put("roi", (Object)"0");
        backJSONObject.put("pieceNumber", (Object)"100");
        backJSONObject.put("achievements", (Object)"2");
        backJSONObject.put("penNumber", (Object)"2");
        sendVO.setStoreIds(this.getSysStoreIdstr(request, sendVO.getStoreIdstr()));
        ResponseData responseDataBack = new ResponseData();
        BackBitDataVO backBitDataVO = new BackBitDataVO();
        ResponseData2 = this.backJSONObjectHaveID(sendVO, jSONArray, this.BaseUrl.getLoadUrl("storeAchievements"), request);
        backBitDataVO.setList(ResponseData2.getData());
        ResponseData ResponseDatatoTotal = new ResponseData();
        sendVO.setStartRecord("1");
        sendVO.setQueryNum("10000000");
        ResponseDatatoTotal = this.backJSONObjectHaveID(sendVO, jSONArray, this.BaseUrl.getLoadUrl("storeAchievements"), request);
        JSONArray JSONArray2 = (JSONArray)ResponseDatatoTotal.getData();
        backBitDataVO.setTotal(String.valueOf(JSONArray2.size()));
        responseDataBack.setData((Object)backBitDataVO);
        if (sendVO.getExport() != null) {
            ReportTempPO reportTempPO = new ReportTempPO();
            reportTempPO.setTemplateName("\u95e8\u5e97\u4e1a\u7ee9\u5bfc\u51fa");
            reportTempPO.setReportDataName("\u53c2\u4e0e\u95e8\u5e97,\u603b\u6210\u4ea4\u989d,\u5238\u6210\u4ea4\u989d,\u6210\u4ea4\u989d\u5360\u6bd4,\u603b\u8ba2\u5355\u91cf,\u7528\u5238\u8ba2\u5355\u91cf,\u7528\u5238\u8ba2\u5355\u91cf\u5360\u6bd4,\u5238\u4f18\u60e0\u91d1\u989d,\u5238ROI");
            reportTempPO.setReportData("storeName,totalAchievements,useVouAchievements,useVouAchievementsGrowth,totalNum,useVouNum,useVouNumGrowth,discount,roi");
            this.couponReportTempService.export(TokenUtils.getStageUser((HttpServletRequest)request), "", ((BackBitDataVO)responseDataBack.getData()).toString(), reportTempPO);
            ResponseData2.setMessage("\u5bfc\u51fa\u4e2d");
        }
        return responseDataBack;
    }

    @PostMapping(value={"areaAchievements"})
    public ResponseData<BackBitDataVO> areaAchievements(BitDataVO sendVO, HttpServletRequest request) {
        ResponseData ResponseData2 = new ResponseData();
        JSONArray jSONArray = new JSONArray();
        JSONObject backJSONObject = new JSONObject();
        backJSONObject.put("id", (Object)"5");
        backJSONObject.put("groupName", (Object)"\u7fa4\u4e3bID\u540d\u79f0");
        backJSONObject.put("totalAchievements", (Object)"0");
        backJSONObject.put("useVouAchievements", (Object)"0");
        backJSONObject.put("useVouAchievementsGrowth", (Object)"0");
        backJSONObject.put("totalNum", (Object)"0");
        backJSONObject.put("useVouNum", (Object)"0");
        backJSONObject.put("useVouNumGrowth", (Object)"0");
        backJSONObject.put("discount", (Object)"0");
        backJSONObject.put("roi", (Object)"0");
        List List2 = this.getStoreGroupIds(request, "");
        if (StringUtils.isBlank((CharSequence)sendVO.getStoreIdstr())) {
            sendVO.setStoreIdsInArea((Map)List2.get(0));
        } else {
            Map mapAll = (Map)List2.get(0);
            HashMap mapSend = new HashMap();
            for (String AreaId : sendVO.getStoreIdstr().split(",")) {
                mapSend.put(AreaId, mapAll.get(AreaId));
            }
            sendVO.setStoreIdsInArea(mapSend);
        }
        JSONObject jSONGroup = (JSONObject)List2.get(1);
        JSONObject jSONGroupName = new JSONObject();
        for (Object k : jSONGroup.keySet()) {
            SysStoreGroupPo sysStoreGroupPo = (SysStoreGroupPo)jSONGroup.get((Object)k.toString());
            jSONGroupName.put(k.toString(), (Object)sysStoreGroupPo.getStoreGroupName());
        }
        ResponseData responseDataBack = new ResponseData();
        BackBitDataVO backBitDataVO = new BackBitDataVO();
        ResponseData2 = this.backJSONObjectHaveGroup(sendVO, jSONGroupName, jSONArray, this.BaseUrl.getLoadUrl("areaAchievements"), request);
        backBitDataVO.setList(ResponseData2.getData());
        ResponseData ResponseDatatoTotal = new ResponseData();
        sendVO.setStartRecord("1");
        sendVO.setQueryNum("10000000");
        ResponseDatatoTotal = this.backJSONObjectHaveGroup(sendVO, jSONGroupName, jSONArray, this.BaseUrl.getLoadUrl("areaAchievements"), request);
        JSONArray JSONArray2 = (JSONArray)ResponseDatatoTotal.getData();
        backBitDataVO.setTotal(String.valueOf(JSONArray2.size()));
        responseDataBack.setData((Object)backBitDataVO);
        if (sendVO.getExport() != null) {
            ReportTempPO reportTempPO = new ReportTempPO();
            reportTempPO.setTemplateName("\u7fa4\u7ec4\u4e1a\u7ee9\u5bfc\u51fa");
            reportTempPO.setReportDataName("\u6240\u5c5e\u7fa4\u7ec4,\u603b\u6210\u4ea4\u989d,\u5238\u6210\u4ea4\u989d,\u6210\u4ea4\u989d\u5360\u6bd4,\u603b\u8ba2\u5355\u91cf,\u7528\u5238\u8ba2\u5355\u91cf,\u7528\u5238\u8ba2\u5355\u91cf\u5360\u6bd4,\u5238\u4f18\u60e0\u91d1\u989d,\u5238ROI");
            reportTempPO.setReportData("groupName,totalAchievements,useVouAchievements,useVouAchievementsGrowth,totalNum,useVouNum,useVouNumGrowth,discount,roi");
            this.couponReportTempService.export(TokenUtils.getStageUser((HttpServletRequest)request), "", ((JSONArray)ResponseData2.getData()).toString(), reportTempPO);
            ResponseData2.setMessage("\u5bfc\u51fa\u4e2d");
        }
        return responseDataBack;
    }

    public ResponseData<JSONObject> backJSONObjectTop10(BitDataVO sendVO, JSONObject backJSONObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJSONObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), request);
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData((Object)backJSONObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            backJSONObject = jobObject.getJSONObject("data");
        }
        JSONObject backJSONObjectend = new JSONObject();
        JSONArray jSONArrayAchieveMap = new JSONArray();
        JSONArray jSONArrayGuestPriceMap = new JSONArray();
        JSONArray achieveMap = backJSONObject.getJSONArray("achieveMap");
        JSONArray guestPriceMap = backJSONObject.getJSONArray("guestPriceMap");
        JSONObject jSONObjectAchieveMap = new JSONObject(true);
        JSONObject jSONObjectGuestPriceMap = new JSONObject(true);
        ArrayList<SortDataVO> listA = new ArrayList<SortDataVO>();
        for (int i = 0; i < achieveMap.size(); ++i) {
            JSONObject jobtopID = achieveMap.getJSONObject(i);
            for (Object k : jobtopID.keySet()) {
                SortDataVO testA2 = new SortDataVO();
                testA2.setNameKey(this.getStoreNameBystoreid(sysAccountPO.getSysCompanyId(), k.toString()));
                testA2.setBigDecimalVal(new BigDecimal(jobtopID.get(k).toString()));
                listA.add(testA2);
            }
        }
        ArrayList<SortDataVO> list = new ArrayList<SortDataVO>();
        for (int i = 0; i < guestPriceMap.size(); ++i) {
            JSONObject jobtopID = guestPriceMap.getJSONObject(i);
            for (Object k : jobtopID.keySet()) {
                SortDataVO testA2 = new SortDataVO();
                testA2.setNameKey(this.getStoreNameBystoreid(sysAccountPO.getSysCompanyId(), k.toString()));
                testA2.setBigDecimalVal(new BigDecimal(jobtopID.get(k).toString()));
                list.add(testA2);
            }
        }
        Collections.sort(listA, new /* Unavailable Anonymous Inner Class!! */);
        for (SortDataVO sortDataVO : listA) {
            jSONObjectAchieveMap.put(sortDataVO.getNameKey(), (Object)sortDataVO.getBigDecimalVal());
        }
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        for (SortDataVO sortDataVO : list) {
            jSONObjectGuestPriceMap.put(sortDataVO.getNameKey(), (Object)sortDataVO.getBigDecimalVal());
        }
        jSONArrayAchieveMap.add((Object)jSONObjectAchieveMap);
        jSONArrayGuestPriceMap.add((Object)jSONObjectGuestPriceMap);
        backJSONObjectend.put("achieveMap", (Object)jSONArrayAchieveMap);
        backJSONObjectend.put("guestPriceMap", (Object)jSONArrayGuestPriceMap);
        ResponseData2.setData((Object)backJSONObjectend);
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        return ResponseData2;
    }

    public ResponseData<JSONObject> backJSONObjectGroupTop10(BitDataVO sendVO, JSONObject groupJSONObject, JSONObject backJSONObject, String analysisUrl, HttpServletRequest request) {
        SortDataVO testA2;
        JSONObject jobtopID;
        int i;
        JSONObject jsonObject = this.getSendApiKeyJSONObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData((Object)backJSONObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            backJSONObject = jobObject.getJSONObject("data");
        }
        ArrayList<SortDataVO> listA = new ArrayList<SortDataVO>();
        ArrayList<SortDataVO> list = new ArrayList<SortDataVO>();
        JSONObject backJSONObjectend = new JSONObject();
        JSONArray jSONArrayAchieveMap = new JSONArray();
        JSONArray jSONArrayGuestPriceMap = new JSONArray();
        JSONArray achieveMap = backJSONObject.getJSONArray("achieveMap");
        JSONArray guestPriceMap = backJSONObject.getJSONArray("guestPriceMap");
        JSONObject jSONObjectAchieveMap = new JSONObject(true);
        JSONObject jSONObjectGuestPriceMap = new JSONObject(true);
        for (i = 0; i < achieveMap.size(); ++i) {
            jobtopID = achieveMap.getJSONObject(i);
            for (Object k : jobtopID.keySet()) {
                testA2 = new SortDataVO();
                testA2.setNameKey(groupJSONObject.getString(k.toString()));
                testA2.setBigDecimalVal(new BigDecimal(jobtopID.get(k).toString()));
                listA.add(testA2);
            }
        }
        for (i = 0; i < guestPriceMap.size(); ++i) {
            jobtopID = guestPriceMap.getJSONObject(i);
            for (Object k : jobtopID.keySet()) {
                testA2 = new SortDataVO();
                testA2.setNameKey(groupJSONObject.getString(k.toString()));
                testA2.setBigDecimalVal(new BigDecimal(jobtopID.get(k).toString()));
                list.add(testA2);
            }
        }
        Collections.sort(listA, new /* Unavailable Anonymous Inner Class!! */);
        for (SortDataVO sortDataVO : listA) {
            jSONObjectAchieveMap.put(sortDataVO.getNameKey(), (Object)sortDataVO.getBigDecimalVal());
        }
        Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        for (SortDataVO sortDataVO : list) {
            jSONObjectGuestPriceMap.put(sortDataVO.getNameKey(), (Object)sortDataVO.getBigDecimalVal());
        }
        jSONArrayAchieveMap.add((Object)jSONObjectAchieveMap);
        jSONArrayGuestPriceMap.add((Object)jSONObjectGuestPriceMap);
        backJSONObjectend.put("achieveMap", (Object)jSONArrayAchieveMap);
        backJSONObjectend.put("guestPriceMap", (Object)jSONArrayGuestPriceMap);
        ResponseData2.setData((Object)backJSONObjectend);
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        return ResponseData2;
    }

    @PostMapping(value={"findMembersList"})
    public ResponseData<PageInfo<FindMembersVO>> findMembersList(FindMembersVO findMembersVO, HttpServletRequest request) {
        List findMemberslist = null;
        ResponseData responseData = new ResponseData();
        if (findMembersVO.getExport() != null) {
            findMemberslist = this.couponEntityPOMapper.getFindMembersVo(findMembersVO);
            ReportTempPO reportTempPO = new ReportTempPO();
            reportTempPO.setTemplateName("\u4f1a\u5458\u5217\u8868\u5bfc\u51fa");
            reportTempPO.setReportDataName("\u4f7f\u7528\u65f6\u95f4,\u4f1a\u5458\u59d3\u540d,\u4f1a\u5458\u5fae\u4fe1\u6635\u79f0,\u4f1a\u5458\u5361\u53f7,\u4f1a\u5458\u624b\u673a\u53f7");
            reportTempPO.setReportData("time,membersName,nickname,cardNo,phone");
            JSONArray jSONArray = new JSONArray();
            for (FindMembersVO findMembers : findMemberslist) {
                jSONArray.add(JSONObject.toJSON((Object)findMembers));
            }
            this.couponReportTempService.export(TokenUtils.getStageUser((HttpServletRequest)request), "", jSONArray.toString(), reportTempPO);
            responseData.setMessage("\u5bfc\u51fa\u4e2d");
        } else {
            PageHelper.startPage((int)findMembersVO.getPageNumber(), (int)findMembersVO.getPageSize());
            findMemberslist = this.couponEntityPOMapper.getFindMembersVo(findMembersVO);
        }
        PageInfo pageInfoNewEntityVOList = new PageInfo(findMemberslist);
        responseData.setData((Object)pageInfoNewEntityVOList);
        return responseData;
    }

    public ResponseData<JSONArray> backJSONObjectHaveID(BitDataVO sendVO, JSONArray backJSONObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJSONObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), request);
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        ResponseEntity responseALL = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
            jsonObject.put("startRecord", (Object)"1");
            jsonObject.put("queryNum", (Object)"10000000");
            responseALL = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData((Object)backJSONObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        List JSONStringTOlist = BaseData.jsonStringToList((String)backJSONObject.toString());
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            JSONStringTOlist = BaseData.jsonStringToList((String)jobObject.getString("data"));
        }
        JSONArray backJSONObjectadd = new JSONArray();
        for (String string : JSONStringTOlist) {
            JSONObject json = JSONObject.parseObject((String)string);
            ArrayList<String> storeIds = new ArrayList<String>();
            storeIds.add(json.get((Object)"id").toString());
            List sysStorePoList = (List)this.storeServiceRpc.getCouponStoreIdList1(storeIds, sysAccountPO.getBrandId(), sysAccountPO.getSysCompanyId()).getData();
            if (CollectionUtils.isNotEmpty((Collection)sysStorePoList)) {
                json.put("storeName", (Object)((SysStorePo)sysStorePoList.get(0)).getStoreName());
            }
            if (analysisUrl.endsWith("storeAchievements")) {
                json.put("useVouAchievementsGrowth", (Object)BaseData.growthNot((String)json.getString("useVouAchievements"), (String)json.getString("totalAchievements")));
                json.put("useVouNumGrowth", (Object)BaseData.growthNot((String)json.getString("useVouNum"), (String)json.getString("totalAchievements")));
                json.put("roi", (Object)BaseData.growthNot((String)json.getString("useVouAchievements"), (String)json.getString("discount")));
            } else {
                json.put("guestPrice", (Object)BaseData.guestPrice((String)json.getString("achievements"), (String)json.getString("pieceNumber")));
                json.put("jointRate", (Object)BaseData.growthNotTow((String)json.getString("pieceNumber"), (String)json.getString("penNumber")));
            }
            for (Object k : json.keySet()) {
                if ("totalAchievements".equals(k.toString())) {
                    json.put("totalAchievements", (Object)("\u00a5" + json.get(k)));
                } else if ("useVouAchievements".equals(k.toString())) {
                    json.put("useVouAchievements", (Object)("\u00a5" + json.get(k)));
                }
                if ("discount".equals(k.toString())) {
                    json.put("discount", (Object)("\u00a5" + json.get(k)));
                }
                if (!"guestPrice".equals(k.toString())) continue;
                json.put("guestPrice", (Object)("\u00a5" + json.get(k)));
            }
            backJSONObjectadd.add((Object)json);
        }
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        ResponseData2.setData((Object)backJSONObjectadd);
        return ResponseData2;
    }

    public ResponseData<JSONArray> backJSONObjectHaveGroup(BitDataVO sendVO, JSONObject jSONGroupName, JSONArray backJSONObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJSONObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData((Object)backJSONObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        List JSONStringTOlist = BaseData.jsonStringToList((String)backJSONObject.toString());
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            JSONStringTOlist = BaseData.jsonStringToList((String)jobObject.getString("data"));
        }
        JSONArray backJSONObjectadd = new JSONArray();
        for (String string : JSONStringTOlist) {
            JSONObject json = JSONObject.parseObject((String)string);
            json.put("groupName", (Object)jSONGroupName.getString(json.getString("id")));
            if (analysisUrl.endsWith("areaAchievements")) {
                json.put("useVouAchievementsGrowth", (Object)BaseData.growthNot((String)json.getString("useVouAchievements"), (String)json.getString("totalAchievements")));
                json.put("useVouNumGrowth", (Object)BaseData.growthNot((String)json.getString("useVouNum"), (String)json.getString("totalNum")));
                json.put("roi", (Object)BaseData.growthNot((String)json.getString("useVouAchievements"), (String)json.getString("discount")));
            } else {
                json.put("guestPrice", (Object)BaseData.guestPrice((String)json.getString("achievements"), (String)json.getString("pieceNumber")));
                json.put("jointRate", (Object)BaseData.growthNotTow((String)json.getString("pieceNumber"), (String)json.getString("penNumber")));
            }
            for (Object k : json.keySet()) {
                if ("totalAchievements".equals(k.toString())) {
                    json.put("totalAchievements", (Object)("\u00a5" + json.get(k)));
                } else if ("useVouAchievements".equals(k.toString())) {
                    json.put("useVouAchievements", (Object)("\u00a5" + json.get(k)));
                }
                if ("discount".equals(k.toString())) {
                    json.put("discount", (Object)("\u00a5" + json.get(k)));
                }
                if (!"guestPrice".equals(k.toString())) continue;
                json.put("guestPrice", (Object)("\u00a5" + json.get(k)));
            }
            backJSONObjectadd.add((Object)json);
        }
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        ResponseData2.setData((Object)backJSONObjectadd);
        return ResponseData2;
    }

    public ResponseData<List<JSONObject>> backJSONObjectHaveIDVou(JSONObject jsonObjectVou, List<JSONObject> backJSONObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJSONObject(jsonObjectVou, request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData(backJSONObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            JSONObject job = jobObject.getJSONObject("data");
            for (Object k : job.keySet()) {
                JSONObject json = JSONObject.parseObject((String)job.get(k).toString());
                json.put(k.toString(), (Object)"\u5e97\u94fa\u7fa4\u4e3bTODO");
                backJSONObject.add(json);
            }
        }
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        ResponseData2.setData(backJSONObject);
        return ResponseData2;
    }

    public ResponseData<JSONObject> backJSONObject(BitDataVO sendVO, JSONObject backJSONObject, String analysisUrl, HttpServletRequest request) {
        JSONObject jsonObject = this.getSendApiKeyJSONObject(JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendVO)), request);
        ResponseData ResponseData2 = new ResponseData();
        ResponseEntity response = null;
        try {
            logger.info("\u5927\u6570\u636e\u8bf7\u6c42\u5165\u53c2BitDataController\uff1a" + analysisUrl + jsonObject.toString());
            response = this.restTemplate.postForEntity(analysisUrl, (Object)jsonObject, String.class, new Object[0]);
        }
        catch (Exception e) {
            ResponseData2.setCode(500);
            ResponseData2.setMessage("\u5927\u6570\u636e\u670d\u52a1\u5f02\u5e38" + e.getMessage());
            ResponseData2.setData((Object)backJSONObject);
            return ResponseData2;
        }
        JSONObject jobObject = JSONObject.parseObject((String)((String)response.getBody()));
        if ("1".equals(jobObject.get((Object)"successFlag"))) {
            JSONObject job = jobObject.getJSONObject("data");
            for (Object k : job.keySet()) {
                JSONObject json = JSONObject.parseObject((String)job.get(k).toString());
                for (Object kk : json.keySet()) {
                    backJSONObject.put(kk.toString(), (Object)json.get(kk).toString());
                }
            }
        }
        ResponseData2.setCode(0);
        ResponseData2.setMessage(jobObject.toString() + "\u5927\u6570\u636e\u8bf7\u6c42:" + analysisUrl + jsonObject.toString());
        ResponseData2.setData((Object)backJSONObject);
        return ResponseData2;
    }

    public String getStoreNameBystoreid(Long sysCompanyId, String storeid) {
        ArrayList<String> storellist = new ArrayList<String>();
        storellist.add(storeid);
        SysStoreVo sysStoreVo = new SysStoreVo();
        sysStoreVo.setStoreIds(storellist);
        sysStoreVo.setSysCompanyId(sysCompanyId);
        ResponseData getStore = this.storeServiceRpc.getStoreGroupNameByStoreCodes(sysStoreVo);
        Map storeVoMap = (Map)getStore.getData();
        SysStoreVo storeVo = (SysStoreVo)storeVoMap.get(storeid);
        String storeName = "";
        if (storeVo != null && storeVo.getStoreName() != null) {
            storeName = storeVo.getStoreName();
        }
        return storeName;
    }

    public List<Object> getStoreGroupIds(HttpServletRequest request, String organizationContentStr) {
        SysAccountPO vo = TokenUtils.getStageUser((HttpServletRequest)request);
        SysAccountVo sysAccountVo = new SysAccountVo();
        sysAccountVo.setSysBrandId(vo.getBrandId().toString());
        sysAccountVo.setSysAccountId(vo.getSysAccountId());
        JSONObject storeGroupJson = (JSONObject)this.storeGroupServiceRpc.getCounponStoreGroupList(sysAccountVo).getData();
        JSONObject storeGroupDataJson = new JSONObject();
        HashMap<String, List<String>> storeGroupList = new HashMap<String, List<String>>();
        if (storeGroupJson != null) {
            LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)JSON.toJSONString((Object)storeGroupJson), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            for (Map.Entry entry : jsonMap.entrySet()) {
                String[] key = ((String)entry.getKey()).split(",");
                String[] list = ((String)entry.getValue()).replace("[", "").replace("]", "").split(",");
                storeGroupList.put(key[0], Arrays.asList(list));
                SysStoreGroupPo sysStoreGroupPo = new SysStoreGroupPo();
                sysStoreGroupPo.setSysStoreGroupCode(key[1]);
                sysStoreGroupPo.setStoreGroupName(key[2]);
                storeGroupDataJson.put(key[0], (Object)sysStoreGroupPo);
            }
        }
        ArrayList<Object> List2 = new ArrayList<Object>();
        List2.add(storeGroupList);
        List2.add(storeGroupDataJson);
        return List2;
    }

    public String[] getSysStoreIdstr(HttpServletRequest request, String organizationContentStr) {
        if (StringUtils.isNotBlank((CharSequence)organizationContentStr)) {
            int i = 0;
            for (String tr : organizationContentStr.split(",")) {
                ++i;
            }
            String[] al = new String[i];
            i = 0;
            for (String trLong : organizationContentStr.split(",")) {
                al[i++] = trLong;
            }
            return al;
        }
        String[] str = new String[]{};
        try {
            SysStoreVo staffVo = new SysStoreVo();
            SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
            System.out.println("\u5f53\u524d\u7528\u6237" + JSONObject.toJSONString((Object)currentUser));
            staffVo.setSysCompanyId(currentUser.getSysCompanyId());
            staffVo.setSysBrandId(currentUser.getBrandId());
            staffVo.setSysAccountId(currentUser.getSysAccountId());
            ResponseData SysStoreVo2 = this.storeServiceRpc.getSysStoreList(staffVo);
            staffVo.setPageSize(Integer.valueOf(Integer.parseInt(String.valueOf(((PageInfo)SysStoreVo2.getData()).getTotal()))));
            ResponseData SysStoreVo22 = this.storeServiceRpc.getSysStoreList(staffVo);
            str = new String[((PageInfo)SysStoreVo22.getData()).getList().size()];
            int i = 0;
            for (SysStoreVo sysStore : ((PageInfo)SysStoreVo22.getData()).getList()) {
                str[i++] = sysStore.getStoreId();
            }
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6\u5f53\u524d\u7528\u6237\uff0c\u6240\u6709\u5e97\u94faid\u51fa\u9519" + e);
        }
        return str;
    }

    public JSONObject getSendApiKeyJSONObject(JSONObject jsonObject, HttpServletRequest request) {
        jsonObject.put("businessNum", (Object)this.BaseUrl.getBusinessNum());
        jsonObject.put("apiKey", (Object)this.BaseUrl.getApiKey());
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        SysBrandPo sysBrandPo = (SysBrandPo)this.brandServiceRpc.getBrandByID(sysAccountPO.getBrandId()).getData();
        jsonObject.put("brandId", (Object)sysBrandPo.getBrandCode());
        ResponseData SysCompanyP = this.companyServiceRpc.getCompanyById(sysAccountPO.getSysCompanyId());
        jsonObject.put("corpId", (Object)((SysCompanyPo)SysCompanyP.getData()).getCompanyCode());
        return jsonObject;
    }
}

